/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.beanshell;

import com.prosc.beanshell.FunctionParameter;
import com.prosc.shared.CollectionUtils;
import java.util.ArrayList;
import java.util.List;

public class FunctionSignature {
    private final String signature;
    private final List<FunctionParameter> parameters = new ArrayList<FunctionParameter>();

    FunctionSignature(String signature) {
        int index = signature.indexOf(40);
        if (index != -1) {
            String functionName = signature.substring(0, index).trim();
            String argList = signature.substring(index + 1, signature.length() - 1).trim();
            String[] sigParts = argList.split(";");
            FunctionParameter lastParam = null;
            for (String sigPart : sigParts) {
                FunctionParameter param = FunctionParameter.valueOf(sigPart);
                if (lastParam != null && lastParam.isVarArg()) {
                    if (param.getName().equals(lastParam.getName())) continue;
                    throw new IllegalArgumentException(lastParam.getName() + " must be the last defined parameter, as it defines a variable number of arguments.");
                }
                this.parameters.add(param);
                lastParam = param;
            }
            this.signature = functionName + "( " + this.getPrototype() + " )";
        } else {
            this.signature = signature.trim();
        }
    }

    public String getSignature() {
        return this.signature;
    }

    public String getPrototype() {
        StringBuilder sb = new StringBuilder();
        boolean optional = false;
        for (FunctionParameter parameter : this.parameters) {
            if (parameter.isOptional() || parameter.isVarArg()) {
                sb.append(" { ");
                optional = true;
            } else if (optional) {
                throw new IllegalArgumentException(parameter.getName() + " must be optional (by naming it '" + parameter.getName() + "?') if it follows other optional parameters");
            }
            if (sb.length() != 0) {
                sb.append(" ; ");
            }
            sb.append(parameter.getName());
            if (!parameter.isVarArg()) continue;
            sb.append(" ; ...");
        }
        if (optional) {
            sb.append(" }");
        }
        return sb.toString();
    }

    public List<String> getArgNames() {
        ArrayList<String> list = new ArrayList<String>(this.parameters.size());
        for (FunctionParameter parameter : this.parameters) {
            list.add(parameter.getName());
        }
        return list;
    }

    public int getMinArgs() {
        int result = 0;
        for (FunctionParameter parameter : this.parameters) {
            if (parameter.isOptional() || parameter.isVarArg()) continue;
            ++result;
        }
        return result;
    }

    public int getMaxArgs() {
        if (this.parameters.isEmpty()) {
            return 0;
        }
        if (CollectionUtils.last(this.parameters).isVarArg()) {
            return -1;
        }
        return this.parameters.size();
    }

    public String getName() {
        int index = this.signature.indexOf(40);
        return index == -1 ? this.signature : this.signature.substring(0, index).trim();
    }

    public List<FunctionParameter> getParameters() {
        return this.parameters;
    }
}

