/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.beanshell;

import com.prosc.Platform;
import com.prosc.beanshell.BeanShellFilter;
import com.prosc.beanshell.BeanShellModel;
import com.prosc.beanshell.CompiledFunction;
import com.prosc.beanshell.FMPro;
import com.prosc.beanshell.FunctionDefinition;
import com.prosc.beanshell.FunctionParameter;
import com.prosc.beanshell.FunctionSignature;
import com.prosc.beanshell.GroovyFunction;
import com.prosc.core.FeedbackException;
import com.prosc.fmkit.FMFunction;
import com.prosc.fmkit.GuiMode;
import com.prosc.fmkit.PluginBridge2;
import com.prosc.fmkit.PluginContext;
import com.prosc.fmkit.PluginException;
import com.prosc.fmkit.PluginFunction;
import com.prosc.fmkit.PluginUtils;
import com.prosc.fmkit.QuadChar;
import com.prosc.fmkit.RegisterablePlugin;
import com.prosc.fmkit.StaticFunction;
import com.prosc.fmkit.VersionInfo;
import com.prosc.fmkit.design.DesignInfo;
import com.prosc.fmkit.types.FMBinaryInterface;
import com.prosc.fmkit.types.FMData;
import com.prosc.fmkit.types.FMText;
import com.prosc.fmkit.types.FMType;
import com.prosc.license.client.ExpiredLicenseException;
import com.prosc.license.client.InvalidLicenseException;
import com.prosc.license.client.License;
import com.prosc.license.client.Registration;
import com.prosc.security.JarUtils;
import com.prosc.shared.CaseInsensitiveMap;
import com.prosc.shared.StringUtils;
import java.awt.Frame;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import org.jetbrains.annotations.NotNull;

public class BeanShellPlugin
extends RegisterablePlugin {
    private static final Logger log = Logger.getLogger(BeanShellPlugin.class.getName());
    private static String pluginName = "360Works ScriptMaster";
    private static String pluginHelpText = "Allows execution of interpreted java/groovy code.";
    private static String pluginVersionString = "5.1";
    private static String pluginPrefix;
    private static boolean isScriptMasterRuntime;
    private static Set<String> runtimeFunctionsSet;
    static boolean masqueradeAsRuntime;
    private static QuadChar quadChar;
    private Map<String, Object> vars = new LinkedHashMap<String, Object>();
    Map<String, Object> errorVars = new HashMap<String, Object>(0);
    private String lastScript;
    private BeanShellModel beanShellModel;
    private Map<String, URL> loadedJars = new HashMap<String, URL>();
    private Collection<File> tmpJars = new LinkedList<File>();
    private String userId = System.getProperty("user.name", String.valueOf(Math.random()));
    private Map<String, FunctionDefinition> registeredFunctions = new LinkedHashMap<String, FunctionDefinition>();
    private Provider originalSecurityProvider;

    @Override
    public QuadChar getShortId() {
        return quadChar;
    }

    @Override
    public String getName() {
        return pluginName;
    }

    @Override
    public short getStoreNumber() {
        return isScriptMasterRuntime ? (short)48 : 24;
    }

    @Override
    public String getProductCode() {
        return "SCRIPTMASTERPLUGIN";
    }

    @Override
    public String getHelpText() {
        return pluginHelpText;
    }

    @FMFunction(prototype="licenseKey; registeredTo", typeAheadText={"smr"}, description="The SMRegister function is used to register plugins that you generate with ScriptMaster Advanced. It will only appear when you are using plugins generated")
    public void SMRegister(String licenseKey, String registeredTo) throws InvalidLicenseException {
        super.defaultRegister(licenseKey, registeredTo);
    }

    @Override
    protected VersionInfo getVersion() {
        byte majorVersion = 4;
        return isScriptMasterRuntime ? new VersionInfo(1, 1, pluginVersionString, "7/15/2010") : new VersionInfo(majorVersion, majorVersion, pluginVersionString, "5/9/2017");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init(boolean isFirstInstance) {
        if (isFirstInstance) {
            log.info("first instance init for " + this);
            try {
                File pluginJarFile = this.getPluginBridge().getPluginJar();
                JarInputStream jarInput = new JarInputStream(new BufferedInputStream(BeanShellModel.getPluginJarStream(pluginJarFile)));
                if (jarInput.getManifest() == null) {
                    throw new IllegalStateException("Could not read manifest from jar at " + pluginJarFile);
                }
                try {
                    Attributes attributes = jarInput.getManifest().getMainAttributes();
                    if ("true".equals(attributes.getValue("is-scriptmaster-runtime"))) {
                        isScriptMasterRuntime = true;
                        VersionInfo version = this.getVersion();
                        Registration registration = new Registration(version.licenseVersion, version.minimumLicenseVersion, version.stringVersion, this.getStoreNumber(), version.majorReleaseDate, null);
                        registration.setNetworkLicenseCheckRequired(false);
                        log.info("Disabling network license checking for ScriptMaster runtime");
                        this.setRegistration(registration);
                        pluginName = attributes.getValue("plugin-name");
                        quadChar = new QuadChar(attributes.getValue("plugin-options").substring(0, 4));
                        pluginHelpText = attributes.getValue("plugin-help");
                        pluginVersionString = attributes.getValue("plugin-version");
                        pluginPrefix = attributes.getValue("plugin-prefix");
                        if (pluginPrefix == null) {
                            pluginPrefix = quadChar.toString();
                        }
                        String[] runtimeFunctions = new String[]{"SMVersion", "SMLastError", "SMRegister", "SMGetVariable", "SMSetErrorCapture"};
                        runtimeFunctionsSet = new HashSet<String>(Arrays.asList(runtimeFunctions));
                        File modulesJar = pluginJarFile;
                        if (Platform.current == Platform.mac) {
                            modulesJar = masqueradeAsRuntime ? new File("/Users/jesse/Desktop/", "scriptmaster_modules.jar") : new File(modulesJar.getParentFile(), "scriptmaster_modules.jar");
                        }
                        this.loadClassesAndRegisterModules(pluginJarFile.getName(), modulesJar.toURI().toURL(), BeanShellModel.pluginJarSkipAmount(pluginJarFile), false);
                    }
                }
                finally {
                    jarInput.close();
                }
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Problem reading functions from ScriptMaster runtime file", e);
            }
        } else {
            log.info("Non-first instance init for " + this);
            VersionInfo version = this.getVersion();
            Registration registration = new Registration(version.licenseVersion, version.minimumLicenseVersion, version.stringVersion, this.getStoreNumber(), version.majorReleaseDate, null);
            registration.setNetworkLicenseCheckRequired(false);
            log.info("Disabling network license checking for ScriptMaster runtime");
            this.setRegistration(registration);
        }
        super.init(isFirstInstance);
        if (isScriptMasterRuntime) {
            try {
                this.getRegistration().checkLicense();
            }
            catch (InvalidLicenseException version) {}
        } else {
            Registration registration1 = this.getRegistration();
            if (registration1 == null || registration1.getLicense() == null || registration1.getLicense().getVariant() == 0 || registration1.getLicense().getVariant() == 7) {
                try {
                    this.getRegistration().setCompanyName("Unregistered");
                    this.getRegistration().setLicenseKey("B79K1TT0ME47OS8ALGHLEYP");
                    this.getRegistration().checkLicense();
                    log.info("Registered with hard-coded license key");
                }
                catch (InvalidLicenseException e) {
                    log.log(Level.WARNING, "Could not set the license key to the hard-coded value. This should never happen.", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadClassesAndRegisterModules(String jarName, URL modulesJar, long streamSkipAmount, boolean isExternallyLoaded) throws IOException, FeedbackException, ClassNotFoundException, CertificateException {
        long skip;
        log.log(Level.INFO, "Loaded modules lib at {0}", modulesJar);
        this.loadedJars.put(jarName, modulesJar);
        this.beanShellModel.setAdditionalClasspathUrls(this.loadedJars.values().toArray(new URL[this.loadedJars.size()]));
        InputStream moduleStream = modulesJar.openStream();
        for (skip = streamSkipAmount; skip > 0L; skip -= moduleStream.skip(streamSkipAmount)) {
        }
        JarInputStream jarInput = new JarInputStream(new BufferedInputStream(moduleStream));
        try {
            JarEntry jarEntry;
            while ((jarEntry = jarInput.getNextJarEntry()) != null) {
                log.fine("jarEntry: " + jarEntry.getName() + " / size: " + jarEntry.getSize());
                if ("META-INF/modules.dat".equals(jarEntry.getName())) {
                    String signature;
                    int bytesRead;
                    block20: {
                        if (isExternallyLoaded) {
                            log.fine("Validating jar file certificate");
                            moduleStream = modulesJar.openStream();
                            for (skip = streamSkipAmount; skip > 0L; skip -= moduleStream.skip(streamSkipAmount)) {
                            }
                            try (JarInputStream verifyStream = new JarInputStream(new BufferedInputStream(moduleStream));){
                                Collection<X509Certificate> certs;
                                try {
                                    certs = JarUtils.verifyJar(verifyStream, true);
                                }
                                catch (GeneralSecurityException e) {
                                    throw new CertificateException("SMLoadModules can only load modules from jars that have been signed by 360Works. Please contact plugins@360works.com for assistance.");
                                }
                                if (certs.size() != 1) {
                                    throw new IllegalStateException("Expected to find exactly one certificate signer, but found " + certs.size());
                                }
                                X509Certificate signer = certs.iterator().next();
                                String certSubjectName = signer.getSubjectDN().getName();
                                if ("CN=360Works, OU=360Works, O=360Works, L=Roswell, ST=Georgia, C=US".equals(certSubjectName)) {
                                    break block20;
                                }
                                throw new CertificateException("SMLoadModules can only load modules from jars that have been signed by 360Works. Please contact plugins@360works.com for assistance.");
                            }
                        }
                    }
                    log.fine("Found serialized list of functions at " + jarEntry.getName() + "; reading and registering them");
                    int bufferSize = (int)jarEntry.getSize();
                    if (bufferSize == -1) {
                        bufferSize = 1024;
                    }
                    ByteArrayOutputStream baos = new ByteArrayOutputStream(bufferSize);
                    byte[] buffer = new byte[1024];
                    while ((bytesRead = jarInput.read(buffer)) != -1) {
                        baos.write(buffer, 0, bytesRead);
                    }
                    ObjectInputStream funcStream = new ObjectInputStream(new ByteArrayInputStream(baos.toByteArray()));
                    int functionCount = funcStream.readInt();
                    ArrayList<FunctionDefinition> definitions = new ArrayList<FunctionDefinition>(functionCount);
                    for (int n = 0; n < functionCount; ++n) {
                        String script = (String)funcStream.readObject();
                        signature = (String)funcStream.readObject();
                        boolean isGui = funcStream.readBoolean();
                        short functionIdUnused = funcStream.readShort();
                        FunctionDefinition newFunction = new FunctionDefinition(signature, script, isGui);
                        definitions.add(newFunction);
                    }
                    log.info("definitions: " + definitions);
                    funcStream.close();
                    for (FunctionDefinition eachDef : definitions) {
                        signature = eachDef.getSignature();
                        if (signature == null) {
                            throw new FeedbackException("name must not be null.");
                        }
                        signature = this.validateSignature(signature);
                        log.log(Level.INFO, "Registering module from jar file: '" + signature + "'");
                        CompiledFunction function = new CompiledFunction(this.beanShellModel.getClassLoader(), eachDef);
                        this.getPluginBridge().registerFunction(function, this.getContext(), true);
                        this.registeredFunctions.put(signature, eachDef);
                    }
                    break;
                }
                log.finest("Ignoring jar entry: " + jarEntry.getName());
                jarInput.closeEntry();
            }
        }
        finally {
            jarInput.close();
            moduleStream.close();
        }
    }

    @Override
    public boolean customizeFunction(StaticFunction eachFunction) {
        String name = eachFunction.getName();
        if (isScriptMasterRuntime) {
            if (!runtimeFunctionsSet.contains(name)) {
                log.fine("Disabling function because we are in runtime mode: " + eachFunction);
                return false;
            }
            if (name.startsWith("SM")) {
                eachFunction.setName(pluginPrefix + name.substring(2));
                return true;
            }
        } else if ("SMRegister".equals(name)) {
            return false;
        }
        return super.customizeFunction(eachFunction);
    }

    public void doIdle(int idleState) {
    }

    @Override
    public void setPluginBridge(PluginBridge2 bridge) {
        this.beanShellModel = new BeanShellModel(new FMPro(this));
    }

    @Override
    public String getSupportUrl() {
        return "http://fmforums.com/forum/118-scriptmaster-by-360-works/";
    }

    @Override
    public void shutdown() throws IOException {
        super.shutdown();
        this.deleteTempJars();
        if (Platform.isMac()) {
            log.info("Original security provider preference position: " + Security.insertProviderAt(this.originalSecurityProvider, 1));
            Security.removeProvider(Security.getProviders()[0].getName());
        }
    }

    @Override
    protected boolean isRegistrationRequired(PluginFunction whichFunction) {
        return isScriptMasterRuntime && whichFunction instanceof CompiledFunction;
    }

    @Override
    protected String licenseKeyPrefKey() {
        if (isScriptMasterRuntime) {
            return this.getShortId().toString() + "licenseKey";
        }
        return super.licenseKeyPrefKey();
    }

    @Override
    protected String companyNamePrefKey() {
        if (isScriptMasterRuntime) {
            return this.getShortId().toString() + "companyName";
        }
        return super.companyNamePrefKey();
    }

    BeanShellModel getBeanShellModel() {
        return this.beanShellModel;
    }

    @FMFunction(prototype="groovyScript", typeAheadText={"smeg", "eg"}, description="Compiles and Evaluates a Groovy script in the foreground. This is the primary method in ScriptMaster, which is responsible for executing the actual groovy script.", gui=GuiMode.Swing, resultName="Function Output")
    public FMType EvaluateGroovy(String groovyScript) throws FeedbackException {
        try {
            this.errorVars = this.vars;
            this.lastScript = groovyScript;
            if (groovyScript == null) {
                FMType fMType = null;
                return fMType;
            }
            Object result = this.beanShellModel.evaluateGroovy(groovyScript = PluginUtils.convertLineBreaksFromFilemaker(groovyScript), this.vars, this.getContext());
            if (result == null) {
                FMType fMType = null;
                return fMType;
            }
            this.errorVars = new HashMap<String, Object>();
            this.lastScript = null;
            FMType fMType = BeanShellPlugin.convertedResult(this.getContext(), result);
            return fMType;
        }
        finally {
            this.vars = new LinkedHashMap<String, Object>();
        }
    }

    static FMType convertedResult(PluginContext context, Object result) {
        if (result instanceof String) {
            String resultWithLineBreaksConverted = PluginUtils.convertLineBreaksToFileMaker((String)result);
            log.log(Level.FINE, "Returning TEXT {0}", resultWithLineBreaksConverted);
            return new FMText(context, resultWithLineBreaksConverted);
        }
        return FMType.bestTypeForJavaObject(context, result);
    }

    @FMFunction(prototype="variableName ; value", typeAheadText={"smsv"}, description="Set a variable to be used in a ScriptMaster Evaluate function call.")
    public void SMSetVariable(@NotNull String variableName, String value) throws FeedbackException {
        if (variableName == null) {
            BeanShellPlugin.$$$reportNull$$$0(0);
        }
        if (variableName == null || variableName.length() == 0) {
            throw new PluginException("variableName must not be empty.", 1552);
        }
        if ("fmpro".equals(variableName)) {
            throw new PluginException("'fmpro' is a reserved variable name.", 1553);
        }
        FunctionParameter param = FunctionParameter.valueOf(variableName);
        value = PluginUtils.convertLineBreaksFromFilemaker(value);
        if (param.isVarArg()) {
            ArrayList varArgs = this.vars.get(param.getName());
            if (!(varArgs instanceof List)) {
                varArgs = new ArrayList();
                this.vars.put(param.getName(), varArgs);
            }
            ((List)varArgs).add(value);
        } else {
            this.vars.put(param.getName(), value);
        }
        this.beanShellModel.clearOldVariables();
    }

    @FMFunction(prototype="variableName", typeAheadText={"smgv"}, description=" Returns the value of a named variable which was set in the previously executed call to EvaluateGroovy")
    public FMType SMGetVariable(String variableName) throws FeedbackException {
        try {
            Object value = this.beanShellModel.getScriptMasterVariable(variableName);
            return BeanShellPlugin.convertedResult(this.getContext(), value);
        }
        catch (IllegalStateException e) {
            throw new PluginException(e.getMessage(), (Throwable)e);
        }
    }

    @FMFunction(typeAheadText={"smv"}, description="Returns the version number of the plugin.", resultName="Plugin Version")
    public FMType SMVersion() {
        return new FMText(this.getContext(), this.getVersion().stringVersion);
    }

    @FMFunction(typeAheadText={"smle"}, description="Returns the last error set by this plugin.", resultName="Last Error", showInScriptSteps=false)
    public FMType SMLastError() {
        if (this.getLastError() == null) {
            return new FMText(this.getContext(), "");
        }
        String msg = this.getLastErrorString();
        if (this.lastScript != null) {
            msg = msg + "\n\n" + this.errorVarsDump() + "\n\n---Script---\n" + this.lastScriptDump();
        }
        return new FMText(this.getContext(), msg);
    }

    @Override
    protected void setLastError(Throwable t, Object[] parameters) {
        super.setLastError(t, this.maskParameters(parameters, new HashMap()));
        log.severe("ScriptMaster bound variables: " + this.errorVarsDump());
    }

    @Override
    protected String getLastErrorString() {
        Throwable lastError = this.getLastError();
        if (lastError == null) {
            return null;
        }
        if (lastError.getClass().getName().startsWith("com.prosc")) {
            return lastError.getLocalizedMessage();
        }
        return lastError.toString();
    }

    private String lastScriptDump() {
        if (this.lastScript == null) {
            return "<no script>";
        }
        int maxChars = 1024;
        if (this.lastScript.length() > maxChars) {
            return "Script:\n" + this.lastScript.substring(0, maxChars) + "...";
        }
        return "Script:\n" + this.lastScript;
    }

    private String errorVarsDump() {
        StringBuilder sb = new StringBuilder();
        Pattern noLogPattern = Pattern.compile(".*noLog.*", 2);
        for (Map.Entry<String, Object> entry : this.errorVars.entrySet()) {
            if (sb.length() != 0) {
                sb.append(", ");
            }
            sb.append(entry.getKey()).append("=");
            if (noLogPattern.matcher(entry.getKey()).matches()) {
                sb.append("<NOT_LOGGED>");
                continue;
            }
            sb.append(entry.getValue());
        }
        return "Parameters:\n" + sb.toString();
    }

    @FMFunction(typeAheadText={"smlst"}, description="Returns the stack trace of the last generated exception, if any.", resultName="Stack Trace", showInScriptSteps=false)
    public FMType SMLastStackTrace() {
        if (this.getLastError() == null) {
            return null;
        }
        StringWriter stringWriter = new StringWriter();
        this.getLastError().printStackTrace(new PrintWriter(stringWriter));
        String stackTrace = stringWriter.toString();
        stackTrace = PluginUtils.convertLineBreaksToFileMaker(stackTrace);
        return new FMText(this.getContext(), stackTrace);
    }

    @FMFunction(prototype="externalJar", typeAheadText={"smlj"}, description="Loads third-party java libraries and ScriptMaster modules.")
    public void SMLoadJar(FMData externalJar) throws FeedbackException {
        URL jarUrl;
        String jarName;
        if (externalJar == null) {
            throw new PluginException("SMLoadJar was called with an empty data parameter.", 1552);
        }
        PluginContext context = this.getContext();
        Object nativeType = externalJar.getFMType(context);
        if (nativeType instanceof FMBinaryInterface) {
            FMBinaryInterface binary = (FMBinaryInterface)nativeType;
            jarName = binary.getFileName(context);
            if (jarName == null) {
                throw new PluginException(".jar file does not have a name!  This may happen if you use copy & paste to insert a .jar into a container field.", 1554);
            }
            if (this.loadedJars.get(jarName) != null) {
                return;
            }
            try {
                File containerFile = this.fileForContainerData(binary);
                jarUrl = containerFile.toURI().toURL();
            }
            catch (MalformedURLException e) {
                throw new PluginException("Jar URL was invalid", 1555, (Throwable)e);
            }
            catch (IOException e) {
                throw new PluginException(e);
            }
        }
        if (nativeType instanceof FMText) {
            String s = ((FMText)nativeType).getAsString(context);
            try {
                jarUrl = new URL(s);
            }
            catch (MalformedURLException e) {
                File file = PluginUtils.fileForFMPath(s);
                if (!file.exists()) {
                    throw new PluginException("Could not locate a file at " + s, (Throwable)e);
                }
                try {
                    jarUrl = file.toURI().toURL();
                }
                catch (MalformedURLException e1) {
                    throw new PluginException("Jar URL was invalid", 1555, (Throwable)e);
                }
            }
            jarName = jarUrl.getFile();
            if (this.loadedJars.get(jarName) != null) {
                return;
            }
        } else {
            throw new PluginException("Cannot convert a " + nativeType.getClass() + " into a URL");
        }
        try {
            this.loadClassesAndRegisterModules(jarName, jarUrl, 0L, true);
        }
        catch (IOException e) {
            throw new PluginException("Couldn't load classes", 1556, (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new PluginException("Coulen't load classes", 1556, (Throwable)e);
        }
        catch (CertificateException e) {
            throw new PluginException("Invalid certificate", 1557, (Throwable)e);
        }
    }

    @FMFunction(typeAheadText={"smr"}, description="Resets any loaded jars and variables, and clears out all registered functions. This is only needed if you are reloading jar files.")
    public void SMReset() {
        this.loadedJars.clear();
        this.deleteTempJars();
        this.beanShellModel.setAdditionalClasspathUrls(this.loadedJars.values().toArray(new URL[this.loadedJars.size()]));
        this.vars.clear();
        for (FunctionDefinition function : this.registeredFunctions.values()) {
            this.getPluginBridge().unregisterFunction(new FunctionSignature(function.getSignature()).getName(), this.getContext());
        }
        this.registeredFunctions.clear();
    }

    private void deleteTempJars() {
        for (File eachJar : this.tmpJars) {
            eachJar.delete();
        }
    }

    @FMFunction(prototype="signature ; script {; isGui ; key1=value2 ; ... }", typeAheadText={"smrg", "rg"}, description="Registers a ScriptMaster script as a custom plugin function.  After calling this, you can call the function by name from any calculation dialog.")
    public void RegisterGroovy(String signature, String script, String[] paramStrings) throws FeedbackException {
        String thirdParam;
        if (signature == null) {
            throw new PluginException("name must not be null.", 1552);
        }
        if (paramStrings == null) {
            paramStrings = new String[]{};
        }
        CaseInsensitiveMap<String> params = PluginUtils.convertKeyValuesToCaseInsensitiveMap(paramStrings, true);
        boolean isGui = false;
        if (paramStrings.length > 0 && (thirdParam = paramStrings[0]) != null) {
            isGui = thirdParam.toLowerCase().contains("isgui=") || thirdParam.contains("=") ? PluginUtils.booleanForString(params.get("isGui")) : PluginUtils.booleanForString(thirdParam);
        }
        signature = this.validateSignature(signature);
        log.log(Level.INFO, "Registering function '" + signature + "'");
        GroovyFunction function = new GroovyFunction(this.beanShellModel.getClassLoader(), new FunctionSignature(signature), script, isGui);
        this.getPluginBridge().registerFunction(function, this.getContext(), true);
        this.registeredFunctions.put(function.getName(), new FunctionDefinition(signature, script, isGui));
    }

    @FMFunction(typeAheadText={"smgrm", "grm"}, description="Gets a list of all modules that have been registered with the RegisterGroovy function.", resultName="Modules")
    public FMText SMGetRegisteredModules() {
        return new FMText(this.getContext(), StringUtils.join(this.registeredFunctions.keySet(), "\r"));
    }

    @FMFunction(typeAheadText={"smglj"}, description="Gets a list of all jars that have been loaded with the SMLoadJar function", resultName="Jars")
    public FMText SMGetLoadedJars() {
        return new FMText(this.getContext(), StringUtils.join(this.loadedJars.keySet(), "\r"));
    }

    @FMFunction(prototype="pluginName; quadChar; pluginPrefix; helpText; versionString; folderToWriteTo; isCrossPlatform{; is64Bit}", typeAheadText={"smcp"}, description="Creates a new plugin that contains all of the currently registered plugin functions.", gui=GuiMode.Swing)
    public FMType SMCreatePlugin(String pluginName, String quadChar, String pluginPrefix, String helpText, String versionString, String folderToWriteTo, boolean crossPlatform, boolean is64Bit) throws InvalidLicenseException, FeedbackException {
        String registerFunction;
        this.excludeFreeLicense();
        this.expireAfterOneYear();
        if (pluginName == null) {
            throw new PluginException("pluginName must not be empty.", 1552);
        }
        if (quadChar == null || quadChar.length() != 4) {
            throw new PluginException("quadChar must be exactly 4 characters", 1553);
        }
        if (helpText == null) {
            helpText = "";
        }
        if (versionString == null) {
            throw new PluginException("versionString must not be empty.", 1554);
        }
        if (folderToWriteTo == null) {
            throw new PluginException("folderToWriteTo must not be empty.", 1555);
        }
        File macSourcePluginDir = null;
        File windowsSourcePlugin = null;
        if (Platform.current == Platform.mac) {
            macSourcePluginDir = this.getPluginBridge().getPluginFile();
            if (crossPlatform) {
                windowsSourcePlugin = is64Bit ? this.chooseFile(JOptionPane.getRootFrame(), null, "Where is the 64-bit Windows ScriptMaster plugin?", ".fmx64") : this.chooseFile(JOptionPane.getRootFrame(), null, "Where is the 32-bit Windows ScriptMaster plugin?", ".fmx");
            }
        } else {
            windowsSourcePlugin = is64Bit ? this.chooseFile(JOptionPane.getRootFrame(), null, "Where is the 64-bit Windows ScriptMaster plugin?", ".fmx64") : this.getPluginBridge().getPluginFile();
            if (crossPlatform) {
                macSourcePluginDir = this.chooseFile(JOptionPane.getRootFrame(), null, "Where is the Mac ScriptMaster.fmplugin directory?", ".fmplugin");
            }
        }
        String orderIdString = String.valueOf(this.getRegistration().getLicense().getOrderID());
        String registeredTo = this.getRegistration().getCompanyName();
        try {
            registerFunction = this.beanShellModel.generatePlugin(pluginName, quadChar, pluginPrefix, helpText, versionString, orderIdString, macSourcePluginDir, windowsSourcePlugin, new File(folderToWriteTo), registeredTo, new ArrayList<FunctionDefinition>(this.registeredFunctions.values()), this.getPluginBridge().getPluginJar());
        }
        catch (IOException e) {
            throw new PluginException("Couldn't generate plugin", 1556, (Throwable)e);
        }
        return new FMText(this.getContext(), registerFunction);
    }

    @FMFunction(prototype="emailAddress ; problemDescription", typeAheadText={"smrp"}, description="Send a problem report to 360Works.")
    public void SMReportProblem(String emailAddress, String problemDescription) throws FeedbackException, IOException {
        if (emailAddress == null || emailAddress.equals("")) {
            throw new FeedbackException("You must enter an email address");
        }
        int orderId = this.getRegistration().getLicense().getOrderID();
        String licenseInfo = this.getRegistration().getLicenseInfo();
        this.reportProblem(emailAddress, problemDescription, "", orderId, licenseInfo, true);
    }

    private String validateSignature(String signature) throws FeedbackException {
        Map<String, List<String>> functions = DesignInfo.getFunctions();
        String name = signature;
        int index = name.indexOf(40);
        if (index != -1) {
            name = name.substring(0, index);
        }
        name = name.trim();
        for (List<String> eachList : functions.values()) {
            for (String eachBuiltInFunctionName : eachList) {
                if (!eachBuiltInFunctionName.equalsIgnoreCase(name)) continue;
                throw new PluginException(eachBuiltInFunctionName + " is a built-in FileMaker function and cannot be registered.", 1553);
            }
        }
        signature = signature.replace(',', ';');
        if (!name.matches("^[a-zA-Z]\\w*$")) {
            throw new FeedbackException("Function name contains invalid characters");
        }
        return signature;
    }

    void excludeFreeLicense() throws InvalidLicenseException {
        this.checkLicense();
        if (isScriptMasterRuntime) {
            return;
        }
        License license = this.getRegistration().getLicense();
        if (license.getVariant() == 7) {
            throw new InvalidLicenseException("You must purchase an Advanced Edition or Portfolio License to use this feature", license);
        }
    }

    private void expireAfterOneYear() throws ExpiredLicenseException {
        GregorianCalendar cal = new GregorianCalendar();
        License license = this.getRegistration().getLicense();
        if (license.getExpirationDate() != 0L) {
            cal.setTimeInMillis(license.getExpirationDate());
        } else if (license.getMaxReleaseDate() != 0L) {
            cal.setTimeInMillis(license.getMaxReleaseDate());
        } else {
            cal.setTimeInMillis(license.getOrderDate());
            cal.add(1, 1);
        }
        if (cal.getTimeInMillis() < System.currentTimeMillis()) {
            throw new ExpiredLicenseException("This function expired on " + cal.getTime() + ". You must renew your annual license to continue using it.", license);
        }
    }

    private File chooseFile(Frame nativeFrame, File initialDir, String title, String fileExt) {
        BeanShellFilter ff = new BeanShellFilter(fileExt);
        JFileChooser chooser = initialDir != null ? new JFileChooser(initialDir.getAbsolutePath()) : new JFileChooser();
        chooser.setDialogTitle(title);
        chooser.setMultiSelectionEnabled(false);
        chooser.setFileSelectionMode(2);
        chooser.setFileFilter(ff);
        int choice = chooser.showDialog(nativeFrame, null);
        if (choice == 0 && chooser.getSelectedFile() != null) {
            return chooser.getSelectedFile();
        }
        return null;
    }

    public URL urlFromData(FMData data) throws IOException {
        URL result;
        if (data == null) {
            throw new IllegalArgumentException("You must supply a non-null parameter");
        }
        PluginContext context = this.getContext();
        Object nativeType = data.getFMType(context);
        if (nativeType instanceof FMBinaryInterface) {
            File containerFile = this.fileForContainerData((FMBinaryInterface)nativeType);
            return containerFile.toURI().toURL();
        }
        if (nativeType instanceof FMText) {
            String s = ((FMText)nativeType).getAsString(context);
            try {
                result = new URL(s);
            }
            catch (MalformedURLException e) {
                File file = PluginUtils.fileForFMPath(s);
                result = file.toURI().toURL();
            }
        } else {
            throw new IllegalArgumentException("Cannot convert a " + nativeType.getClass() + " into a URL");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File fileForContainerData(FMBinaryInterface fmBinary) throws IOException {
        InputStream is = null;
        FileOutputStream out = null;
        String name = fmBinary.getFileName(this.getContext());
        if (!name.toLowerCase().endsWith(".jar") && !name.toLowerCase().endsWith(".zip")) {
            throw new IllegalArgumentException("External libs must have a .jar or .zip suffix");
        }
        try {
            File jarDir = new File(System.getProperty("java.io.tmpdir"), "ScriptMaster_" + this.userId);
            if (!jarDir.exists() && !jarDir.mkdirs()) {
                throw new IOException("could not create: " + jarDir.getAbsolutePath());
            }
            File tmp = File.createTempFile("ScriptMaster", name, jarDir);
            tmp.deleteOnExit();
            is = fmBinary.getStreamForType(QuadChar.FileData, this.getContext());
            out = new FileOutputStream(tmp);
            BeanShellPlugin.writeInputToOutput(is, out, 1024);
            this.tmpJars.add(tmp);
            File file = tmp;
            return file;
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (out != null) {
                out.close();
            }
        }
    }

    private static long writeInputToOutput(InputStream in, OutputStream out, int bufferSize) throws IOException {
        int lastBytesRead;
        byte[] buffer = new byte[bufferSize];
        long totalBytesRead = 0L;
        while ((lastBytesRead = in.read(buffer)) != -1) {
            out.write(buffer, 0, lastBytesRead);
            totalBytesRead += (long)lastBytesRead;
        }
        if (out != null) {
            out.flush();
        }
        return totalBytesRead;
    }

    @FMFunction(prototype="errorCapture", typeAheadText={"smsec"}, description="Toggles error dialogs on or off.", showInScriptSteps=false)
    public void SMSetErrorCapture(boolean errorCapture) {
        super.defaultSetErrorCapture(errorCapture);
    }

    static {
        isScriptMasterRuntime = false;
        masqueradeAsRuntime = false;
        quadChar = new QuadChar(masqueradeAsRuntime ? "test" : "3BSH");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variableName", "com/prosc/beanshell/BeanShellPlugin", "SMSetVariable"));
    }
}

