/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.ws;

import java.util.List;
import java.util.logging.Logger;
import javax.xml.ws.Binding;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.handler.Handler;
import org.jetbrains.annotations.Nullable;

public class WSUtils {
    public static final Logger log = Logger.getLogger(WSUtils.class.getName());

    public static void configureBindingProvider(BindingProvider bindingProvider, @Nullable Handler[] handlers, @Nullable String username, @Nullable String password, @Nullable String url) {
        if (username != null) {
            bindingProvider.getRequestContext().put("javax.xml.ws.security.auth.username", username);
        }
        if (password != null) {
            bindingProvider.getRequestContext().put("javax.xml.ws.security.auth.password", password);
        }
        if (url != null) {
            bindingProvider.getRequestContext().put("javax.xml.ws.service.endpoint.address", url);
        }
        if (handlers != null) {
            List handlerChain = bindingProvider.getBinding().getHandlerChain();
            for (Handler handler : handlers) {
                if (handlerChain.contains(handler)) continue;
                handlerChain.add(handler);
            }
            bindingProvider.getBinding().setHandlerChain(handlerChain);
        }
    }

    public static BindingProvider addHandler(BindingProvider bindingProvider, Handler handler) {
        Binding binding = bindingProvider.getBinding();
        List chain = binding.getHandlerChain();
        if (!chain.contains(handler)) {
            chain.add(handler);
        }
        binding.setHandlerChain(chain);
        return bindingProvider;
    }

    public static BindingProvider removeHandler(BindingProvider bindingProvider, Handler handler) {
        Binding binding = bindingProvider.getBinding();
        List chain = binding.getHandlerChain();
        if (chain.contains(handler)) {
            chain.remove(handler);
        }
        binding.setHandlerChain(chain);
        return bindingProvider;
    }

    public static BindingProvider setAuthentication(BindingProvider bindingProvider, String username, String password) {
        bindingProvider.getRequestContext().put("javax.xml.ws.security.auth.username", username);
        bindingProvider.getRequestContext().put("javax.xml.ws.security.auth.password", password);
        return bindingProvider;
    }

    public static BindingProvider setEndpointUrl(BindingProvider bindingProvider, String url) {
        bindingProvider.getRequestContext().put("javax.xml.ws.service.endpoint.address", url);
        return bindingProvider;
    }

    public static BindingProvider setSoapAction(BindingProvider bindingProvider, String soapAction) {
        bindingProvider.getRequestContext().put("javax.xml.ws.soap.http.soapaction.use", Boolean.TRUE);
        bindingProvider.getRequestContext().put("javax.xml.ws.soap.http.soapaction.uri", soapAction);
        return bindingProvider;
    }
}

