/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import org.jetbrains.annotations.Nullable;

public class ProscCollections {
    public static void sort(final @Nullable Comparator comparator, List<?> ... inputs) {
        ListIterator[] iterators = new ListIterator[inputs.length];
        int inputSize = inputs[0].size();
        for (int i = 0; i < iterators.length; ++i) {
            if (inputs[i].size() != inputSize) {
                throw new IllegalArgumentException("All lists must contain the same number of elements, but the first list has " + inputSize + " elements and the current list does not: " + inputs[i]);
            }
            iterators[i] = inputs[i].listIterator();
        }
        ArrayList<Object[]> rows = new ArrayList<Object[]>(inputs[0].size());
        while (iterators[0].hasNext()) {
            Object[] row = new Object[iterators.length];
            for (int i = 0; i < iterators.length; ++i) {
                row[i] = iterators[i].next();
            }
            rows.add(row);
        }
        Collections.sort(rows, new Comparator<Object[]>(){

            @Override
            public int compare(Object[] o1, Object[] o2) {
                if (comparator == null) {
                    return ((Comparable)o1[0]).compareTo(o2[0]);
                }
                return comparator.compare(o1[0], o2[0]);
            }
        });
        iterators = new ListIterator[inputs.length];
        for (int i = 0; i < iterators.length; ++i) {
            iterators[i] = inputs[i].listIterator();
        }
        for (Object[] row : rows) {
            for (int i = 0; i < iterators.length; ++i) {
                ListIterator listIterator = iterators[i];
                listIterator.next();
                listIterator.set(row[i]);
            }
        }
    }
}

