/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.security;

import com.prosc.io.IOUtils;
import com.prosc.security.EncryptionUtils;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.jetbrains.annotations.Nullable;

public class SecurityUtils {
    public static final Logger log = Logger.getLogger(SecurityUtils.class.getName());
    private static final SecureRandom SECURE_RANDOM = new SecureRandom();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addCertificatesToStoresWithPrivateKey(@Nullable InputStream clientCertificateStream, @Nullable String privateKeyPassword, @Nullable String clientCertificatePassword, @Nullable String clientCertificateType, InputStream ... serverCertificateInputStreams) throws GeneralSecurityException, IOException {
        if (clientCertificateStream == null && serverCertificateInputStreams == null) {
            throw new IllegalArgumentException("You must provide a client certificate and/or a server certificate");
        }
        TrustManager[] trustManagers = null;
        SSLContext sslContext = SSLContext.getInstance("SSL");
        if (serverCertificateInputStreams != null && serverCertificateInputStreams.length > 0) {
            log.info("Configuring trust manager using " + serverCertificateInputStreams.length + " server-side certificate(s)");
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            KeyStore serverKeyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            serverKeyStore.load(null, null);
            for (InputStream certificateStream : serverCertificateInputStreams) {
                String alias = UUID.randomUUID().toString();
                SecurityUtils.setCertificateEntry(serverKeyStore, certificateStream, alias);
                if (serverKeyStore.isCertificateEntry(alias)) continue;
                throw new GeneralSecurityException("Certificate entry not added");
            }
            trustManagerFactory.init(serverKeyStore);
            trustManagers = trustManagerFactory.getTrustManagers();
        } else {
            log.info("No server-side certificate info provided, so trust manager will not be configured");
        }
        KeyManager[] keyManagers = null;
        if (clientCertificateStream != null) {
            log.info("Configuring key manager using client-side certificate with private key");
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            KeyStore keyStore = KeyStore.getInstance(clientCertificateType == null ? KeyStore.getDefaultType() : clientCertificateType);
            try {
                keyStore.load(null);
                byte[] certAndKey = IOUtils.inputStreamAsBytes(clientCertificateStream);
                byte[] certBytes = SecurityUtils.parseDERFromPEM(certAndKey, "-----BEGIN CERTIFICATE-----", "-----END CERTIFICATE-----");
                byte[] keyBytes = SecurityUtils.parseDERFromPEM(certAndKey, "-----BEGIN PRIVATE KEY-----", "-----END PRIVATE KEY-----");
                X509Certificate cert = SecurityUtils.generateCertificateFromDER(certBytes);
                RSAPrivateKey key = SecurityUtils.generatePrivateKeyFromDER(keyBytes);
                keyStore.setCertificateEntry("cert-alias", cert);
                keyStore.setKeyEntry("key-alias", key, privateKeyPassword != null ? privateKeyPassword.toCharArray() : "".toCharArray(), new Certificate[]{cert});
                keyManagerFactory.init(keyStore, clientCertificatePassword != null ? clientCertificatePassword.toCharArray() : "".toCharArray());
            }
            finally {
                clientCertificateStream.close();
            }
            try {
                keyManagers = keyManagerFactory.getKeyManagers();
            }
            catch (IllegalStateException e) {
                String errMsg = "An error occurred while getting key managers from a factory";
                log.log(Level.WARNING, errMsg, e);
            }
        } else {
            log.info("No client-side certificate info provided, so key manager will not be configured");
        }
        if (keyManagers != null || trustManagers != null) {
            log.info("Initializing SSL context");
            sslContext.init(keyManagers, trustManagers, null);
            HttpsURLConnection.setDefaultSSLSocketFactory(sslContext.getSocketFactory());
        } else {
            HttpsURLConnection.setDefaultSSLSocketFactory(SSLContext.getDefault().getSocketFactory());
            log.info("No server-side or client-side certificate information provided, so no SSL context will be initialized");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setCertificateEntry(KeyStore serverKeyStore, InputStream certificateStream, String alias) throws CertificateException, KeyStoreException, IOException {
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            Certificate certificate = certificateFactory.generateCertificate(certificateStream);
            serverKeyStore.setCertificateEntry(alias, certificate);
        }
        finally {
            certificateStream.close();
        }
    }

    public static void addCertificatesToStoresWithSocketFactory(@Nullable InputStream clientCertificateStream, @Nullable String clientCertificatePassword, @Nullable String clientCertificateType, SSLSocketFactory sslSocketFactory, InputStream ... serverCertificateInputStreams) throws GeneralSecurityException, IOException {
        HttpsURLConnection.setDefaultSSLSocketFactory(sslSocketFactory);
        SecurityUtils._addCertificatesToStores(clientCertificateStream, clientCertificatePassword, clientCertificateType, serverCertificateInputStreams);
    }

    public static void addCertificatesToStores(@Nullable InputStream clientCertificateStream, @Nullable String clientCertificatePassword, @Nullable String clientCertificateType, InputStream ... serverCertificateInputStreams) throws GeneralSecurityException, IOException {
        SSLSocketFactory socketFactory = SecurityUtils._addCertificatesToStores(clientCertificateStream, clientCertificatePassword, clientCertificateType, serverCertificateInputStreams);
        HttpsURLConnection.setDefaultSSLSocketFactory(socketFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SSLSocketFactory _addCertificatesToStores(@Nullable InputStream clientCertificateStream, @Nullable String clientCertificatePassword, @Nullable String clientCertificateType, @Nullable InputStream[] serverCertificateInputStreams) throws IOException, GeneralSecurityException {
        SSLSocketFactory socketFactory;
        if (clientCertificateStream == null && serverCertificateInputStreams == null) {
            throw new IllegalArgumentException("You must provide a client certificate and/or a server certificate");
        }
        TrustManager[] trustManagers = null;
        SSLContext sslContext = SSLContext.getInstance("TLS");
        if (serverCertificateInputStreams != null && serverCertificateInputStreams.length > 0) {
            log.info("Configuring trust manager using " + serverCertificateInputStreams.length + " server-side certificate(s)");
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            KeyStore serverKeyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            serverKeyStore.load(null, null);
            for (InputStream certificateStream : serverCertificateInputStreams) {
                if (certificateStream == null) continue;
                String alias = UUID.randomUUID().toString();
                SecurityUtils.setCertificateEntry(serverKeyStore, certificateStream, alias);
                if (serverKeyStore.isCertificateEntry(alias)) continue;
                throw new GeneralSecurityException("Certificate entry not added");
            }
            trustManagerFactory.init(serverKeyStore);
            trustManagers = trustManagerFactory.getTrustManagers();
        } else {
            log.info("No server-side certificate info provided, so trust manager will not be configured");
        }
        KeyManager[] keyManagers = null;
        if (clientCertificateStream != null && clientCertificatePassword != null) {
            log.info("Configuring key manager using client-side certificate");
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            KeyStore keyStore = KeyStore.getInstance(clientCertificateType == null ? KeyStore.getDefaultType() : clientCertificateType);
            try {
                keyStore.load(clientCertificateStream, clientCertificatePassword.toCharArray());
                keyManagerFactory.init(keyStore, clientCertificatePassword.toCharArray());
            }
            finally {
                clientCertificateStream.close();
            }
            try {
                keyManagers = keyManagerFactory.getKeyManagers();
            }
            catch (IllegalStateException e) {
                String errMsg = "An error occurred while getting key managers from a factory";
                log.log(Level.WARNING, errMsg, e);
            }
        } else {
            log.info("No client-side certificate info provided, so key manager will not be configured");
        }
        if (keyManagers != null || trustManagers != null) {
            log.info("Initializing SSL context");
            sslContext.init(keyManagers, trustManagers, null);
            socketFactory = sslContext.getSocketFactory();
        } else {
            socketFactory = SSLContext.getDefault().getSocketFactory();
            HttpsURLConnection.setDefaultSSLSocketFactory(socketFactory);
            log.info("No server-side or client-side certificate information provided, so no SSL context will be initialized");
        }
        return socketFactory;
    }

    public static void addCertificatesToStores(@Nullable String clientCertificatePath, @Nullable String clientCertificatePassword, @Nullable String clientCertificateType, String ... serverCertificatePaths) throws GeneralSecurityException, IOException {
        InputStream[] fileInputStreams = null;
        if (serverCertificatePaths != null && serverCertificatePaths.length > 0) {
            fileInputStreams = new FileInputStream[serverCertificatePaths.length];
            for (int i = 0; i < serverCertificatePaths.length; ++i) {
                fileInputStreams[i] = new FileInputStream(serverCertificatePaths[i]);
            }
        }
        SecurityUtils.addCertificatesToStores(clientCertificatePath == null ? null : new FileInputStream(clientCertificatePath), clientCertificatePassword, clientCertificateType, fileInputStreams);
    }

    public static void addCertificatesToStoresWithPrivateKey(@Nullable String clientCertificatePath, @Nullable String privateKeyPassword, @Nullable String clientCertificatePassword, @Nullable String clientCertificateType, String ... serverCertificatePaths) throws GeneralSecurityException, IOException {
        InputStream[] fileInputStreams = null;
        boolean hasServerCertificate = false;
        if (serverCertificatePaths != null && serverCertificatePaths.length > 0) {
            fileInputStreams = new FileInputStream[serverCertificatePaths.length];
            for (int i = 0; i < serverCertificatePaths.length; ++i) {
                String serverCertificatePath = serverCertificatePaths[i];
                if (serverCertificatePath == null) continue;
                fileInputStreams[i] = new FileInputStream(serverCertificatePath);
                hasServerCertificate = true;
            }
        }
        SecurityUtils.addCertificatesToStoresWithPrivateKey(clientCertificatePath == null ? null : new FileInputStream(clientCertificatePath), privateKeyPassword, clientCertificatePassword, clientCertificateType, (InputStream[])(hasServerCertificate ? fileInputStreams : null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SSLSocketFactory addCertificatesToStoresGetFactory(String clientCertificatePath, String clientCertificatePassword, String clientCertificateType, String ... serverCertificatePaths) throws GeneralSecurityException, IOException {
        TrustManager[] trustManagers = null;
        SSLContext sslContext = SSLContext.getInstance("SSL");
        if (serverCertificatePaths != null) {
            log.info("Configuring trust manager using " + serverCertificatePaths.length + " server-side certificate(s)");
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            KeyStore serverKeyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            serverKeyStore.load(null, null);
            for (String certificatePath : serverCertificatePaths) {
                FileInputStream certificateStream = new FileInputStream(certificatePath);
                String alias = UUID.randomUUID().toString();
                SecurityUtils.setCertificateEntry(serverKeyStore, certificateStream, alias);
                if (serverKeyStore.isCertificateEntry(alias)) continue;
                throw new GeneralSecurityException("Certificate entry not added for " + certificatePath);
            }
            trustManagerFactory.init(serverKeyStore);
            trustManagers = trustManagerFactory.getTrustManagers();
        } else {
            log.info("No server-side certificate info provided, so trust manager will not be configured");
        }
        KeyManager[] keyManagers = null;
        if (clientCertificatePath != null && clientCertificatePassword != null) {
            log.info("Configuring key manager using client-side certificate");
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            KeyStore keyStore = KeyStore.getInstance(clientCertificateType == null ? KeyStore.getDefaultType() : clientCertificateType);
            try (FileInputStream certStream = new FileInputStream(clientCertificatePath);){
                keyStore.load(certStream, clientCertificatePassword.toCharArray());
                keyManagerFactory.init(keyStore, clientCertificatePassword.toCharArray());
            }
            try {
                keyManagers = keyManagerFactory.getKeyManagers();
            }
            catch (IllegalStateException e) {
                String errMsg = "An error occurred while getting key managers from a factory";
                log.log(Level.WARNING, errMsg, e);
            }
        } else {
            log.info("No client-side certificate info provided, so key manager will not be configured");
        }
        SSLSocketFactory socketFactory = null;
        if (keyManagers != null || trustManagers != null) {
            log.info("Initializing SSL context");
            sslContext.init(keyManagers, trustManagers, null);
            socketFactory = sslContext.getSocketFactory();
            HttpsURLConnection.setDefaultSSLSocketFactory(socketFactory);
        } else {
            log.info("No server-side or client-side certificate information provided, so no SSL context will be initialized");
        }
        return socketFactory;
    }

    public static String MD5Hash(String text) {
        try {
            return EncryptionUtils.generateMD5Hash(text.getBytes("utf-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String RandomString(int bits, int radix) {
        return new BigInteger(bits, SECURE_RANDOM).toString(radix);
    }

    protected static byte[] parseDERFromPEM(byte[] pem, String beginDelimiter, String endDelimiter) {
        String data = new String(pem);
        String[] tokens = data.split(beginDelimiter);
        tokens = tokens[1].split(endDelimiter);
        return IOUtils.base64Decode(tokens[0]);
    }

    protected static RSAPrivateKey generatePrivateKeyFromDER(byte[] keyBytes) throws InvalidKeySpecException, NoSuchAlgorithmException {
        PKCS8EncodedKeySpec spec = new PKCS8EncodedKeySpec(keyBytes);
        KeyFactory factory = KeyFactory.getInstance("RSA");
        return (RSAPrivateKey)factory.generatePrivate(spec);
    }

    protected static X509Certificate generateCertificateFromDER(byte[] certBytes) throws CertificateException {
        CertificateFactory factory = CertificateFactory.getInstance("X.509");
        return (X509Certificate)factory.generateCertificate(new ByteArrayInputStream(certBytes));
    }

    public static String signAndEncode(String message, String secret, @Nullable String algorithm, boolean hexEncode) throws InvalidKeyException, NoSuchAlgorithmException {
        Mac sha256_HMAC = Mac.getInstance(algorithm == null ? "HmacSHA256" : algorithm);
        SecretKeySpec secret_key = new SecretKeySpec(secret.getBytes(), algorithm == null ? "HmacSHA256" : algorithm);
        sha256_HMAC.init(secret_key);
        if (hexEncode) {
            return IOUtils.base64Encode(EncryptionUtils.toHex(sha256_HMAC.doFinal(message.getBytes(StandardCharsets.UTF_8))).getBytes(StandardCharsets.UTF_8));
        }
        return IOUtils.base64Encode(sha256_HMAC.doFinal(message.getBytes(StandardCharsets.UTF_8)));
    }
}

