/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.net;

import com.prosc.net.IpAddressListener;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class IpAddressMonitor {
    private static final Logger log = Logger.getLogger(IpAddressMonitor.class.getName());
    private final int checkFrequency;
    private final List<IpAddressListener> listeners = new ArrayList<IpAddressListener>(1);
    private Thread monitorThread;
    Runnable checkIpAddressTask = new Runnable(){
        private InetAddress previousAddress = null;
        private String previousHostAddress = null;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                while (true) {
                    try {
                        while (true) {
                            InetAddress currentAddress;
                            String currentHostAddress;
                            if (!(currentHostAddress = (currentAddress = InetAddress.getLocalHost()).getHostAddress()).equals(this.previousHostAddress)) {
                                if (this.previousAddress != null) {
                                    log.info("IP address changed to " + currentHostAddress);
                                    IpAddressMonitor ipAddressMonitor = IpAddressMonitor.this;
                                    synchronized (ipAddressMonitor) {
                                        for (IpAddressListener listener : IpAddressMonitor.this.listeners) {
                                            listener.ipAddressChanged(this.previousAddress, currentAddress);
                                        }
                                    }
                                }
                                this.previousAddress = currentAddress;
                                this.previousHostAddress = currentHostAddress;
                            }
                            Thread.sleep(IpAddressMonitor.this.checkFrequency);
                        }
                    }
                    catch (UnknownHostException e) {
                        log.log(Level.WARNING, "Could not detect local IP address", e);
                        continue;
                    }
                    break;
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                log.info("IpAddressMonitor thread was interrupted; exiting");
                return;
            }
        }
    };

    public IpAddressMonitor(int checkFrequency) {
        this.checkFrequency = checkFrequency;
    }

    public synchronized void addListener(IpAddressListener listener) {
        boolean startThread;
        boolean bl = startThread = this.listeners.size() == 0;
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
        if (startThread) {
            this.monitorThread = new Thread(this.checkIpAddressTask, "IpAddressMonitor");
            this.monitorThread.setDaemon(true);
            this.monitorThread.start();
        }
    }

    public synchronized void removeListener(IpAddressListener listener) {
        if (this.listeners.remove(listener) && this.listeners.size() == 0) {
            this.monitorThread.interrupt();
        }
    }
}

