/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.license.client.network;

import com.prosc.deployment.DeploymentInfo;
import com.prosc.io.IOUtils;
import com.prosc.license.client.InvalidLicenseException;
import com.prosc.license.client.LicenseExceededException;
import com.prosc.license.client.Registration;
import com.prosc.license.client.network.LicenseParams;
import com.prosc.shared.StringUtils;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.BufferedSink;
import org.jetbrains.annotations.Nullable;

public class OnlineModel {
    private static final Logger log = Logger.getLogger(OnlineModel.class.getName());
    private static final String ACTION_HANDSHAKE = "handshake";
    private static final String ACTION_HEARTBEAT = "heartbeat";
    private static final String ACTION_DISCONNECT = "disconnect";
    private final URL serverBaseUrl;
    private final LicenseParams params;
    private int _heartbeat = 40000;
    public String _licenseKey;
    private String _lastResponse;
    private OkHttpClient client = new OkHttpClient.Builder().build();
    private static Set<String> callingThreads = new HashSet<String>();
    private static final AtomicInteger keepAliveThreadCount = new AtomicInteger(0);

    public OnlineModel(LicenseParams params) {
        this(params, "https://licensecheck.360works.com/WSMRegister/LicenseCheck/");
    }

    OnlineModel(LicenseParams params, String spec) {
        log.info("OnlineModel is using OkHTTP OnlineModel");
        this.params = params;
        this.serverBaseUrl = IOUtils.toUrl(spec);
    }

    public String contactServer(@Nullable String optionalSessionId) throws IOException, InvalidLicenseException {
        String result;
        Request request;
        Response httpResponse;
        String response;
        boolean doHandshake;
        block48: {
            doHandshake = true;
            response = null;
            httpResponse = null;
            request = null;
            if (optionalSessionId != null) {
                request = OnlineModel.createHttpRequest(this.serverBaseUrl, ACTION_HEARTBEAT, 6000, optionalSessionId, null, this.params.updateFromDatabaseOnEveryRequest);
                log.fine("Connecting to server URL " + request.url() + " for heartbeat request");
                try {
                    httpResponse = this.client.newCall(request).execute();
                    try (ResponseBody responseBody = httpResponse.body();){
                        String string = response = responseBody == null ? null : responseBody.string();
                        if (httpResponse.code() == 200) {
                            doHandshake = false;
                        }
                    }
                }
                catch (IOException e) {
                    if (!log.isLoggable(Level.FINE)) break block48;
                    log.log(Level.FINE, "Error sending heartbeat request; will switch to initial handshake", e);
                }
            }
        }
        if (doHandshake) {
            Registration reg = this.params.registration;
            String postArgs = "<LicenseCheck><RegisteredTo>" + reg.getCompanyName() + "</RegisteredTo><LicenseKey>" + reg.getLicenseKey() + "</LicenseKey><ProductCode>" + reg.getStoreNumber() + "</ProductCode><MajorVersion>" + reg.getMajorVersion() + "</MajorVersion><MinimumMajorVersion>" + reg.getMinimumMajorVersion() + "</MinimumMajorVersion><BuildDate>" + (reg.getBuildDate() == null ? "" : String.valueOf(reg.getBuildDate().getTime())) + "</BuildDate><MajorReleaseDate>" + (reg.getBuildDate() == null ? "" : String.valueOf(reg.getBuildDate().getTime())) + "</MajorReleaseDate><VersionString>" + reg.getVersionName() + "</VersionString><ExtraInfo>" + (this.params.extraInfo == null ? "" : this.params.extraInfo) + "</ExtraInfo><FmEnvironment>" + (this.params.fmEnvironment == null ? "" : this.params.fmEnvironment) + "</FmEnvironment></LicenseCheck>";
            request = OnlineModel.createHttpRequest(this.serverBaseUrl, ACTION_HANDSHAKE, 46000, optionalSessionId, postArgs, this.params.updateFromDatabaseOnEveryRequest);
            log.fine("Connecting to server URL " + request.url() + " to send initial license check and validate license key");
            try {
                if (httpResponse != null) {
                    httpResponse.close();
                }
                httpResponse = this.client.newCall(request).execute();
                try (ResponseBody responseBody = httpResponse.body();){
                    response = responseBody == null ? null : responseBody.string();
                }
            }
            catch (IOException e) {
                URI uri = request.url().uri();
                if ("localhost".equals(uri.getHost())) {
                    throw new IllegalStateException("This build of MirrorSync is in development mode, and cannot communicate with the license server. Please contact 360Works for a production build.", e);
                }
                throw new IOException("Error while connecting to " + uri, e);
            }
        }
        if (doHandshake || this.params.updateFromDatabaseOnEveryRequest) {
            if (httpResponse.header("LicenseSuccess") != null) {
                log.fine("Registered successfully with license server at " + this.serverBaseUrl);
                if (optionalSessionId == null) {
                    String startTag = "<replacementKey>";
                    String endTag = "</replacementKey>";
                    int from = response.indexOf(startTag) + startTag.length();
                    int to = response.indexOf(endTag, from);
                    if (from == -1 || to == -1) {
                        throw new IOException("Communication with the licensing server; got an unexpected responses: " + response);
                    }
                    String replacementLicenseKey = response.substring(from, to);
                    if (replacementLicenseKey.equals(this.params.registration.getLicenseKey())) {
                        log.info("Registration license key is " + this.params.registration.getLicenseKey() + "; replacement license key is the same");
                    } else {
                        log.info("Registration license key is " + this.params.registration.getLicenseKey() + "; replacement license key is " + replacementLicenseKey);
                    }
                    this.setLicenseKey(replacementLicenseKey);
                }
                if (response.length() > 0) {
                    this.setLastResponse(response);
                } else {
                    log.fine("Received empty response from license server");
                }
            } else if (httpResponse.header("LicenseFailure") != null) {
                this.handleLicenseFailure(response, httpResponse.header("LicenseFailure"), Boolean.valueOf(httpResponse.header("LicenseExceeded")));
            } else {
                String message = "Response from license server did not contain either a LicenseSuccess or LicenseFailure header.\nRequest URI: " + request.url() + "\nResponse body: " + response;
                throw new IOException(message);
            }
        }
        if (doHandshake) {
            String session = httpResponse.header("session");
            if (StringUtils.isEmpty(session)) {
                throw new IOException("License check was successful, but no sessionId was provided by the server");
            }
            result = session;
            log.fine("Connected to license server with session ID " + result);
        } else {
            result = optionalSessionId;
            log.fine("Heartbeat successful to license server for session ID " + result);
        }
        String heartbeat = httpResponse.header(ACTION_HEARTBEAT);
        if (heartbeat != null) {
            this.setHeartbeat(Integer.valueOf(heartbeat));
        }
        httpResponse.close();
        return result;
    }

    public synchronized int getHeartbeat() {
        return this._heartbeat;
    }

    private synchronized void setHeartbeat(int heartbeat) {
        this._heartbeat = heartbeat;
    }

    public synchronized String getLicenseKey() {
        return this._licenseKey;
    }

    private void setLicenseKey(String licenseKey) {
        this._licenseKey = licenseKey;
    }

    private synchronized void setLastResponse(String lastResponse) {
        this._lastResponse = lastResponse;
    }

    public synchronized String getLastResponse() {
        return this._lastResponse;
    }

    private void handleLicenseFailure(String responseBody, String failureMessage, Boolean licenseExceeded) throws IOException, InvalidLicenseException {
        if (failureMessage == null) {
            throw new IOException("Unknown response from License server. Make sure the registration server is running at " + this.serverBaseUrl + "\n" + responseBody);
        }
        if (Boolean.TRUE.equals(licenseExceeded)) {
            throw new LicenseExceededException("INVALID - " + failureMessage, this.params.registration.getLicense());
        }
        throw new InvalidLicenseException("INVALID - " + failureMessage, this.params.registration.getLicenseKey());
    }

    void sendServerDisconnect(String sessionId) {
        try {
            Request request = OnlineModel.createHttpRequest(this.serverBaseUrl, ACTION_DISCONNECT, 300, sessionId, null, false);
            log.config("Closing connection to license server at " + request.url());
            this.client.newCall(request).execute().close();
        }
        catch (IOException e) {
            log.log(Level.WARNING, "Error occurred while sending disconnect message to LicenseServer: " + e.toString(), e);
        }
    }

    void close(@Nullable String sessionId) {
        this.sendServerDisconnect(sessionId);
    }

    private static Request createHttpRequest(URL baseUrl, String action, int readTimeout, String optionalSessionId, final String postArgs, boolean updateFromDatabaseOnEveryRequest) throws IOException {
        String commitDate;
        String path = action;
        String productCode = "Unknown";
        try {
            DeploymentInfo deploymentInfo = DeploymentInfo.getApplicationInstance();
            try {
                productCode = deploymentInfo.getProductCode();
                commitDate = new SimpleDateFormat("yyyy-MM-dd").format(deploymentInfo.getCommitDate());
            }
            catch (Exception e) {
                log.log(Level.WARNING, "Could not get commit date (or could not format it)", e);
                commitDate = "Unknown";
            }
        }
        catch (Exception e) {
            commitDate = "Unknown";
        }
        path = path + "?commitDate=" + commitDate + "&productCode=" + productCode;
        URI uri = URI.create(baseUrl + path);
        Request.Builder builder = new Request.Builder().url(uri.toURL());
        if (postArgs == null) {
            builder.get();
        } else {
            builder.post(new RequestBody(){

                @Override
                public MediaType contentType() {
                    return MediaType.parse("text/plain");
                }

                @Override
                public void writeTo(BufferedSink sink) throws IOException {
                    sink.write(postArgs.getBytes("utf-8"));
                }
            });
        }
        if (updateFromDatabaseOnEveryRequest) {
            builder.header("readFromDatabase", "1");
        }
        if (optionalSessionId != null) {
            builder.header("session", optionalSessionId);
        }
        return builder.build();
    }
}

