/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.fx;

import com.prosc.Platform;
import com.prosc.exception.UserCanceledException;
import com.prosc.fx.NativeWindowManager;
import java.io.IOException;
import java.net.URL;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Pane;
import javafx.stage.Stage;
import javafx.stage.StageStyle;

public abstract class TransferDialog {
    public static final Logger log = Logger.getLogger(TransferDialog.class.getName());
    @FXML
    private ResourceBundle resources;
    @FXML
    private URL location;
    @FXML
    private Pane transferPane;
    @FXML
    private ProgressBar progressBar;
    @FXML
    private Label transferLabel;
    @FXML
    private Button transferCancel;
    @FXML
    private Label percentLabel;
    private Stage stage;
    private boolean shouldHide = false;

    @FXML
    public abstract void onCancel(MouseEvent var1) throws UserCanceledException;

    @FXML
    public void initialize() {
        log.info("Initializing TransferDialog");
        assert (this.transferPane != null) : "fx:id=\"transferPane\" was not injected: check your FXML file 'TransferDialog.fxml'.";
        assert (this.progressBar != null) : "fx:id=\"progressBar\" was not injected: check your FXML file 'TransferDialog.fxml'.";
        assert (this.transferLabel != null) : "fx:id=\"transferLabel\" was not injected: check your FXML file 'TransferDialog.fxml'.";
        assert (this.transferCancel != null) : "fx:id=\"transferCancel\" was not injected: check your FXML file 'TransferDialog.fxml'.";
        assert (this.percentLabel != null) : "fx:id=\"percentLabel\" was not injected: check your FXML file 'TransferDialog.fxml'.";
    }

    public TransferDialog() {
        URL resource = TransferDialog.class.getResource("TransferDialog.fxml");
        FXMLLoader fxmlLoader = new FXMLLoader(resource);
        fxmlLoader.setController((Object)this);
        try {
            fxmlLoader.load();
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
        javafx.application.Platform.runLater(() -> {
            this.stage = new Stage(Platform.isMac() ? StageStyle.UNIFIED : StageStyle.UTILITY);
            this.stage.setScene(new Scene((Parent)this.getTransferPane()));
            this.stage.setOnShowing(event -> {
                this.shouldHide = NativeWindowManager.nativeWindowShouldHide();
                log.info("Should hide native window: " + this.shouldHide);
            });
            this.stage.setOnShown(event -> {
                if (this.shouldHide) {
                    log.info("Hiding native window");
                    NativeWindowManager.nativeWindowHide(this.stage);
                } else {
                    log.info("Not hiding native window");
                }
            });
        });
    }

    public void show() {
        javafx.application.Platform.runLater(() -> {
            log.info("Showing TransferDialog");
            this.stage.show();
        });
    }

    public void hide() {
        javafx.application.Platform.runLater(() -> {
            log.info("Hiding TransferDialog");
            this.stage.hide();
        });
    }

    public ProgressBar getProgressBar() {
        return this.progressBar;
    }

    public Label getTransferLabel() {
        return this.transferLabel;
    }

    public Label getPercentLabel() {
        return this.percentLabel;
    }

    public Pane getTransferPane() {
        return this.transferPane;
    }

    public Stage getStage() {
        return this.stage;
    }
}

