/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.fx;

import com.prosc.thread.MyThreadFactory;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Logger;
import javafx.concurrent.Task;

public abstract class StartFinishTask<V>
extends Task<V>
implements AutoCloseable {
    private static final Logger log = Logger.getLogger(StartFinishTask.class.getName());
    private ReentrantLock lock;
    private Condition notDone;
    private ExecutorService executor = Executors.newSingleThreadExecutor(new MyThreadFactory("StartFinishThread"));

    public StartFinishTask() {
        this.lock = new ReentrantLock();
        this.notDone = this.lock.newCondition();
    }

    public void start() {
        try {
            boolean stillNotDone;
            log.info("Starting StartFinishTask");
            this.lock.lockInterruptibly();
            this.executor.execute((Runnable)((Object)this));
            log.info("Waiting 500 ms for StartFinishTask to run before executing onStarted");
            boolean bl = stillNotDone = !this.notDone.await(500L, TimeUnit.MILLISECONDS);
            if (!this.lock.isLocked() && !this.lock.isHeldByCurrentThread()) {
                log.warning("Unexpected lock error");
            }
            if (stillNotDone) {
                log.info("StartFinishTask wait timed out");
                this.onStarted();
            } else {
                log.info("StartFinishTask did not wait time out");
            }
        }
        catch (InterruptedException e) {
            this.setException(e);
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void done() {
        super.done();
        try {
            this.lock.lockInterruptibly();
            log.info("Signaling StartFinishTask");
            this.notDone.signal();
        }
        catch (InterruptedException e) {
            this.notDone.signal();
            this.setException(e);
        }
        finally {
            this.lock.unlock();
        }
    }

    protected abstract void onStarted();

    @Override
    public void close() throws IOException {
        log.info("Closing StartFinishTask");
        this.executor.shutdown();
    }
}

