/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.fmkit.types;

import com.prosc.fmkit.PluginContext;
import com.prosc.fmkit.PluginUtils;
import com.prosc.fmkit.types.Converter;
import com.prosc.fmkit.types.FMData;
import com.prosc.fmkit.types.FMType;
import com.prosc.io.FileType;
import com.prosc.io.IOUtils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLConnection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class InputStreamInfo {
    private InputStream stream;
    private String name;
    private long length;
    private String contentType;
    private File file;

    public InputStreamInfo(File file) throws FileNotFoundException {
        this(file.isDirectory() ? null : new FileInputStream(file), file.getName(), file.length());
        this.file = file;
    }

    public InputStreamInfo(InputStream stream, String name, long length) {
        this(stream, name, length, null);
    }

    public InputStreamInfo(InputStream stream, String name, long length, String optionalContentType) {
        FileType fileType;
        this.stream = stream;
        this.name = name;
        this.length = length;
        if (optionalContentType == null && (fileType = FileType.fileTypeForFileName(name)) != null) {
            optionalContentType = fileType.getMimeType();
        }
        if (optionalContentType == null) {
            optionalContentType = URLConnection.guessContentTypeFromName(name);
        }
        this.contentType = optionalContentType;
    }

    public InputStream getStream() {
        return this.stream;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String input) {
        this.name = input;
    }

    public long getLength() {
        return this.length;
    }

    public String getContentType() {
        return this.contentType;
    }

    @Nullable
    public File getFile() {
        return this.file;
    }

    @NotNull
    public File getFileNonNull() {
        File file;
        File file1 = this.getFile();
        if (file1 != null) {
            File file2 = file1;
            if (file2 == null) {
                InputStreamInfo.$$$reportNull$$$0(0);
            }
            return file2;
        }
        File tmpFile = new File(System.getProperty("java.io.tmpdir"), this.getName());
        tmpFile.deleteOnExit();
        BufferedOutputStream out = null;
        try {
            out = new BufferedOutputStream(new FileOutputStream(tmpFile));
            IOUtils.writeInputToOutput(this.getStream(), (OutputStream)out, 4096);
            this.file = tmpFile;
            file = tmpFile;
        }
        catch (IOException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(out);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(out);
        File file3 = file;
        if (file3 == null) {
            InputStreamInfo.$$$reportNull$$$0(1);
        }
        return file3;
    }

    public static void registerConverters() {
        FMType.addConverter(new InputStreamInfoConverter());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/prosc/fmkit/types/InputStreamInfo", "getFileNonNull"));
    }

    private static final class InputStreamInfoConverter
    implements Converter {
        private InputStreamInfoConverter() {
        }

        @Override
        public boolean canConvertTo(Class targetClass) {
            return targetClass == InputStreamInfo.class;
        }

        @Override
        public Object convertData(FMData param, Class targetClass, PluginContext context) {
            InputStreamInfo result;
            try {
                result = PluginUtils.getInputStreamInfo(param, context);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return result;
        }
    }
}

