/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.fmkit;

import com.prosc.Platform;
import com.prosc.deployment.DeploymentInfo;
import com.prosc.fmkit.FmCalculationException;
import com.prosc.fmkit.LicenseKeyEntryDialog;
import com.prosc.fmkit.PluginContext;
import com.prosc.fmkit.PluginFunction;
import com.prosc.fmkit.PluginUtils;
import com.prosc.fmkit.ProscPlugin;
import com.prosc.fmkit.RegisterDialog;
import com.prosc.fmkit.RegisterDialogPane;
import com.prosc.fmkit.VersionInfo;
import com.prosc.fmkit.types.FMText;
import com.prosc.fmkit.types.FMType;
import com.prosc.license.client.InvalidLicenseException;
import com.prosc.license.client.LicenseConflictChecker;
import com.prosc.license.client.LicenseConflictException;
import com.prosc.license.client.Registration;
import com.prosc.license.client.network.LicenseParams;
import com.prosc.license.client.network.LicensePluginModel;
import com.prosc.util.PropertiesHolder;
import java.awt.Frame;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.math.BigInteger;
import java.net.InetAddress;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javafx.stage.StageStyle;
import javax.swing.JOptionPane;

public abstract class RegisterablePlugin
extends ProscPlugin {
    private static final Logger log = Logger.getLogger(RegisterablePlugin.class.getName());
    private final String name;
    private final String shortName;
    private final String productCode;
    private Registration registration;
    private Preferences prefs = Preferences.userNodeForPackage(this.getClass());
    protected static final String LICENSE_KEY = "licenseKey";
    protected static final String COMPANY_NAME = "companyName";
    private boolean showLicenseKey = true;
    private Thread licenseCheckThread;
    private Boolean isWPE = null;
    private boolean didReadPrefs = false;
    private String lastSuccessfulLicenseKey;
    private String lastSuccessfulCompanyName;
    private String fmEnvironment;
    private LicensePluginModel licensePluginModel;

    protected RegisterablePlugin() {
        Registration newReg;
        String _name = null;
        String _shortName = null;
        String _productCode = null;
        try {
            DeploymentInfo deploymentInfo = DeploymentInfo.getForClass(this.getClass());
            _name = deploymentInfo.getName();
            _shortName = deploymentInfo.getShortName();
            _productCode = deploymentInfo.getProductCode();
            log.info(_name + " version: " + deploymentInfo.getSummary());
            log.info("Plugin instance ID " + System.identityHashCode(this));
            newReg = new Registration(deploymentInfo);
        }
        catch (IllegalStateException e) {
            log.log(Level.INFO, this.getClass() + " does not have a deployment.properties file", e);
            VersionInfo info = this.getVersion();
            newReg = new Registration(info.licenseVersion, info.licenseVersion, info.stringVersion, this.getStoreNumber(), info.majorReleaseDate, info.majorReleaseDate);
        }
        this.productCode = _productCode;
        this.shortName = _shortName;
        this.name = _name;
        this.registration = newReg;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    protected VersionInfo getVersion() {
        if (this.registration == null) {
            throw new IllegalArgumentException("RegisterablePlugin subclasses must either have a deployment.properties file or override the getVersion() function.");
        }
        return new VersionInfo(this.registration.getMajorVersion(), this.registration.getMinimumMajorVersion(), this.registration.getVersionName(), this.registration.getBuildDate() == null ? this.registration.getMajorReleaseDate() : this.registration.getBuildDate());
    }

    @Override
    public void init(boolean isFirstInstance) {
        super.init(isFirstInstance);
        this.fmEnvironment = "<Platform>" + System.getProperty("os.name") + "</Platform><JavaVersion>" + System.getProperty("java.runtime.version") + "</JavaVersion><Architecture>" + System.getProperty("os.arch") + "</Architecture><Language>" + System.getProperty("user.language") + "</Language><Country>" + System.getProperty("user.country") + "</Country><ApiVersion>" + this.getPluginBridge().getApiVersion() + "</ApiVersion><AppType>" + this.getApplicationType() + "</AppType>";
        try {
            log.fine("Checking license key at init");
            this.getRegistration().checkLicense();
        }
        catch (InvalidLicenseException invalidLicenseException) {
            // empty catch block
        }
        try {
            PluginUtils.loadFmkitProperties();
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Could not load fmkit properties", e);
        }
    }

    public boolean isFMClient() {
        return this.getApplicationType() < 3;
    }

    @Override
    public void shutdown() throws IOException {
        if (this.licensePluginModel != null && (!Platform.isWin() || this.isFMClient())) {
            log.info("Shutting down LicensePluginModel for product " + this.getName() + " (product code " + this.getStoreNumber() + ")...");
            this.licensePluginModel.close(6000);
            log.info("LicensePluginModel has been shut down.");
        }
    }

    @Override
    public FMType invokeFunction(PluginFunction whichFunction, Object[] parameters) throws Exception {
        if (this.isRegistrationRequired(whichFunction)) {
            try {
                this.checkLicense();
            }
            catch (InvalidLicenseException e) {
                if (!e.isPossibleToRetry()) {
                    throw e;
                }
                this.registrationDidChange();
                this.checkLicense();
            }
        }
        try {
            return super.invokeFunction(whichFunction, parameters);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof InvalidLicenseException) {
                throw (InvalidLicenseException)e.getCause();
            }
            throw e;
        }
    }

    @Override
    public final void initConfigureDialog() {
        RegisterDialogPane dialogPane = new RegisterDialogPane(this, this.getRegistration(), this.showLicenseKey);
        this.configureDialog = new RegisterDialog(dialogPane, "Configure " + this.getName());
        this.configureDialog.initStyle(StageStyle.UTILITY);
        this.configureDialog.setOnCloseRequest(event -> {
            block13: {
                RegisterDialogPane dialogController = (RegisterDialogPane)this.configureDialog.getDialogPane();
                if (dialogController.isSubmittingBugReport()) {
                    try {
                        dialogController.reportBug();
                    }
                    catch (IllegalArgumentException e) {
                        String errMsg = "An error occurred while completing a bug report";
                        log.log(Level.WARNING, errMsg, e);
                        dialogController.showErrorMessage(errMsg + "\n" + (e.getMessage() != null ? e.getMessage() : e.getMessage().toLowerCase()));
                        event.consume();
                    }
                    catch (Exception e) {
                        String errMsg = "An error occurred while submitting a bug report";
                        log.log(Level.WARNING, errMsg, e);
                        dialogController.showErrorMessage(errMsg + "\n" + (e.getMessage() != null ? e.getMessage() : e.getMessage().toLowerCase()));
                        event.consume();
                    }
                } else if (dialogController.isRegisteringPlugin()) {
                    try {
                        String licenseKey = dialogController.getLicenseKeyFieldValue();
                        String registeredTo = dialogController.getRegisteredToFieldValue();
                        if (licenseKey == null || licenseKey.length() == 0 && registeredTo == null || registeredTo.length() == 0) {
                            this.clearRegistration();
                            break block13;
                        }
                        this.register(licenseKey, registeredTo);
                        this.prefs.put(this.licenseKeyPrefKey(), licenseKey);
                        this.prefs.put(this.companyNamePrefKey(), registeredTo);
                        this.prefs.sync();
                    }
                    catch (InvalidLicenseException | BackingStoreException e) {
                        dialogController.showErrorMessage(e.getMessage());
                        event.consume();
                    }
                } else {
                    dialogController.setLicenseKeyFieldValue(this.getRegistration().getLicenseKey());
                    dialogController.setRegisteredToFieldValue(this.getRegistration().getCompanyName());
                }
            }
            RegisterablePlugin registerablePlugin = this;
            synchronized (registerablePlugin) {
                this.notify();
            }
        });
    }

    protected void checkLicense() throws InvalidLicenseException {
        Registration reg = this.getRegistration();
        reg.checkLicense();
        this.checkWebAccess(reg);
        this.checkPortfolioAccess(reg);
    }

    protected void checkWebAccess(Registration reg) throws InvalidLicenseException {
        switch (reg.getLicense().getVariant()) {
            case 0: 
            case 2: 
            case 4: 
            case 5: {
                break;
            }
            default: {
                if (this.getApplicationType() == 3 || this.getApplicationType() == 7) {
                    throw new InvalidLicenseException("Deployment with FileMaker Server is not allowed with Single-user, Workgroup or Developer licenses. Visit http://www.360works.com to upgrade to an Enterprise License.", this.getRegistration().getLicense());
                }
                if (this.getApplicationType() != 4 && this.getApplicationType() != 8) break;
                String webLicenseMessage = "Deployment in the Web Publishing Engine is not allowed with Single-user, Workgroup or Developer licenses. Visit http://www.360works.com to upgrade to an Enterprise License.";
                if (this.isWPE == null) {
                    try {
                        PluginContext context = this.getContext();
                        String appVersion = context.evaluateExpression("Get( ApplicationVersion )").getStringData(context);
                        this.isWPE = appVersion.contains("Web Publishing Engine");
                    }
                    catch (FmCalculationException e) {
                        log.log(Level.WARNING, "Couldn't check whether we're running in WPE - deny access.", e);
                        throw new InvalidLicenseException("Deployment in the Web Publishing Engine is not allowed with Single-user, Workgroup or Developer licenses. Visit http://www.360works.com to upgrade to an Enterprise License.", this.getRegistration().getLicense());
                    }
                }
                if (!this.isWPE.booleanValue()) break;
                throw new InvalidLicenseException("Deployment in the Web Publishing Engine is not allowed with Single-user, Workgroup or Developer licenses. Visit http://www.360works.com to upgrade to an Enterprise License.", this.getRegistration().getLicense());
            }
        }
    }

    protected void checkPortfolioAccess(Registration reg) throws InvalidLicenseException {
        if (reg.getLicense().isPortfolio() && !this.coveredByPortfolioLicense()) {
            throw new InvalidLicenseException("This product is not covered by portfolio licenses", this.getRegistration().getLicense());
        }
    }

    public boolean coveredByPortfolioLicense() {
        return true;
    }

    protected boolean showConfigurationDialog(Registration userPrefsRegistration, boolean showLicenseKey) {
        Frame owner = JOptionPane.getRootFrame();
        return new LicenseKeyEntryDialog(owner, userPrefsRegistration, this).showDialog(showLicenseKey);
    }

    protected boolean isRegistrationRequired(PluginFunction whichFunction) {
        String name = whichFunction.getName();
        return !name.endsWith("Register") && !name.endsWith("Version") && !name.endsWith("LicenseInfo") && !name.endsWith("Error") && !name.endsWith("SetErrorCapture") && !name.endsWith("ReportProblem");
    }

    public String getShortName() {
        return this.shortName;
    }

    public String getProductCode() {
        return this.productCode;
    }

    protected short getStoreNumber() {
        try {
            return DeploymentInfo.getForClass(this.getClass()).getStoreNumber();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("RegisterablePlugin subclasses must either have a deployment.properties file or override the getStoreNumber() function.");
        }
    }

    protected void defaultRegister(String licenseKey, String registeredTo) throws InvalidLicenseException {
        this.register(licenseKey, registeredTo);
        this.showLicenseKey = false;
    }

    private void clearRegistration() throws BackingStoreException, InvalidLicenseException {
        this.registration.setLicenseKey("");
        this.registration.setCompanyName("");
        this.prefs.put(this.licenseKeyPrefKey(), "");
        this.prefs.put(this.companyNamePrefKey(), "");
        this.prefs.sync();
        this.checkLicense();
    }

    private void register(String licenseKey, String registeredTo) throws InvalidLicenseException {
        if (licenseKey == null) {
            throw new InvalidLicenseException("'licenseKey' must not be empty.", licenseKey);
        }
        if (registeredTo == null) {
            throw new InvalidLicenseException("'registeredTo' must not be empty.", licenseKey);
        }
        if (this.lastSuccessfulCompanyName != null && this.lastSuccessfulCompanyName.equals(registeredTo) && this.lastSuccessfulLicenseKey != null && this.lastSuccessfulLicenseKey.equals(licenseKey)) {
            log.fine("Already registered with same license information");
        } else {
            log.fine("Checking candidate keys - Registering: " + licenseKey + " / registeredTo: " + registeredTo);
            this.getRegistration();
            Registration candidate = new Registration(this.getVersion().licenseVersion, this.getVersion().minimumLicenseVersion, this.registration.getVersionName(), this.registration.getStoreNumber(), this.getVersion().majorReleaseDate, null);
            candidate.setDemoTimeoutMillis(this.registration.getDemoTimeoutMillis());
            candidate.setInfo(registeredTo, licenseKey);
            candidate.checkLicense();
            Registration actualRegistration = this.getRegistration();
            boolean shouldReplace = actualRegistration.getLicense() == null || actualRegistration.getLicense().compareTo(candidate.getLicense()) <= 0;
            shouldReplace = true;
            if (shouldReplace && actualRegistration.setInfo(registeredTo, licenseKey)) {
                this.registrationDidChange();
            }
            actualRegistration.checkLicense();
            this.lastSuccessfulCompanyName = registeredTo;
            this.lastSuccessfulLicenseKey = licenseKey;
            log.log(Level.INFO, "Successfully registered " + this.getName() + ": " + actualRegistration.getLicenseInfo());
        }
    }

    protected FMText defaultLicenseInfo() {
        String info = this.getName() + " v" + this.getVersion().stringVersion;
        try {
            this.getRegistration().checkLicense();
            info = info + "\n" + this.getRegistration().getLicenseInfo();
        }
        catch (InvalidLicenseException e) {
            info = info + "\n*UNLICENSED*";
        }
        return new FMText(this.getContext(), PluginUtils.convertLineBreaksToFileMaker(info));
    }

    protected void setRegistration(Registration registration) {
        this.registration = registration;
    }

    public Registration getRegistration() {
        if (!this.didReadPrefs) {
            this.didReadPrefs = true;
            String licenseKey = this.prefs.get(this.licenseKeyPrefKey(), null);
            String companyName = this.prefs.get(this.companyNamePrefKey(), null);
            if (this.registration.setInfo(companyName, licenseKey)) {
                this.registrationDidChange();
            }
        }
        return this.registration;
    }

    protected void setDemoTimeoutMillis(long demoTimeoutMillis) {
        this.registration.setDemoTimeoutMillis(demoTimeoutMillis);
    }

    protected void registrationDidChange() {
        block12: {
            final Registration newReg = this.getRegistration();
            try {
                if (newReg.getLicense() == null) {
                    // empty if block
                }
                if (newReg.getLicense().getVariant() == 8) {
                    if (this.getApplicationType() == 3 || this.getApplicationType() == 4 || this.getApplicationType() == 7 || this.getApplicationType() == 8) {
                        throw new InvalidLicenseException("Cannot run single-user licenses on FileMaker Server, Web Publishing Engine, or Instant Web Publishing", newReg.getLicense());
                    }
                    newReg.checkLicense();
                    this.checkWebAccess(newReg);
                    this.checkPortfolioAccess(newReg);
                    if (this.licenseCheckThread != null && this.licenseCheckThread.isAlive()) {
                        log.info("Sending interrupt to License checker thread; will start another one");
                        this.licenseCheckThread.interrupt();
                    }
                    try {
                        byte[] pattern = BigInteger.valueOf(newReg.getLicense().getOrderID()).toByteArray();
                        int checkFrequency = 10000;
                        InetAddress randomAddress = InetAddress.getByName("232.53.88.129");
                        int randomPort = 19430 + this.getStoreNumber();
                        final LicenseConflictChecker licenseCheck = new LicenseConflictChecker(pattern, checkFrequency, randomAddress, randomPort, 1, null);
                        this.licenseCheckThread = new Thread(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    licenseCheck.checkForConflicts();
                                }
                                catch (LicenseConflictException e) {
                                    RegisterablePlugin.this.registration.storeLicenseError(new InvalidLicenseException("Too many users are using this license key. Please purchase an upgrade at http://360works.com/products. You will need to restart FileMaker to use the plugin.", RegisterablePlugin.this.registration.getLicense()));
                                }
                            }
                        }, "License check");
                        log.info("Checking for conflicting license keys...");
                        this.licenseCheckThread.start();
                    }
                    catch (IOException e) {
                        log.log(Level.WARNING, "Could not configure license checking: " + e, e);
                    }
                }
                if (!newReg.isNetworkLicenseCheckRequired()) break block12;
                String extraInfo = null;
                boolean keepConnectionOpen = true;
                boolean updateFromDatabaseOnEveryRequest = false;
                int maxDaysOffline = Integer.MAX_VALUE;
                LicenseParams licenseParams = new LicenseParams(newReg, extraInfo, keepConnectionOpen, this.fmEnvironment, Integer.MAX_VALUE, updateFromDatabaseOnEveryRequest, false, false);
                Preferences prefs = Preferences.userRoot().node("com.prosc.fmkit");
                try {
                    this.licensePluginModel = LicensePluginModel.getLicensePluginModel(licenseParams, new PropertiesHolder(prefs));
                    this.licensePluginModel.registrationDidChange();
                    Thread thread = new Thread("License check thread"){

                        @Override
                        public void run() {
                            try {
                                RegisterablePlugin.this.licensePluginModel.checkLicense();
                            }
                            catch (InvalidLicenseException e) {
                                newReg.storeLicenseError(e);
                            }
                        }
                    };
                    thread.start();
                    try {
                        thread.join(3000L);
                    }
                    catch (InterruptedException e) {
                        log.log(Level.WARNING, "Will not wait for license check response because the thread was interrupted");
                        Thread.currentThread().interrupt();
                    }
                }
                catch (BackingStoreException e) {
                    log.log(Level.WARNING, "Could not access preferences", e);
                }
            }
            catch (InvalidLicenseException e) {
                newReg.storeLicenseError(e);
            }
        }
    }

    protected String licenseKeyPrefKey() {
        return this.getClass().getName() + LICENSE_KEY;
    }

    protected String companyNamePrefKey() {
        return this.getClass().getName() + COMPANY_NAME;
    }
}

