/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.fmkit;

import com.prosc.fmkit.Configurable;
import com.prosc.fmkit.Plugin;
import com.prosc.fmkit.RegisterDialog;
import com.prosc.fmkit.RegisterDialogPane;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.stage.StageStyle;

public abstract class ProscPlugin
extends Plugin
implements Configurable {
    private static final Logger log = Logger.getLogger(ProscPlugin.class.getName());
    RegisterDialog configureDialog;

    public String getSupportUrl() {
        return null;
    }

    @Override
    public void configure() {
        this.initConfigureDialog();
        this.showConfigureDialog();
    }

    protected void initConfigureDialog() {
        RegisterDialogPane dialogPane = new RegisterDialogPane(this, null, false);
        this.configureDialog = new RegisterDialog(dialogPane, "Configure " + this.getName());
        this.configureDialog.initStyle(StageStyle.UTILITY);
        this.configureDialog.setOnCloseRequest(event -> {
            RegisterDialogPane dialogController = (RegisterDialogPane)this.configureDialog.getDialogPane();
            if (dialogController.isSubmittingBugReport()) {
                try {
                    dialogController.reportBug();
                }
                catch (IllegalArgumentException e) {
                    String errMsg = "An error occurred while completing a bug report";
                    log.log(Level.WARNING, errMsg, e);
                    dialogController.showErrorMessage(errMsg + "\n" + (e.getMessage() != null ? e.getMessage() : e.getMessage().toLowerCase()));
                    event.consume();
                }
                catch (Exception e) {
                    String errMsg = "An error occurred while submitting a bug report";
                    log.log(Level.WARNING, errMsg, e);
                    dialogController.showErrorMessage(errMsg + "\n" + (e.getMessage() != null ? e.getMessage() : e.getMessage().toLowerCase()));
                    event.consume();
                }
            }
            ProscPlugin proscPlugin = this;
            synchronized (proscPlugin) {
                this.notify();
            }
        });
    }

    protected void showConfigureDialog() {
        log.info("Showing registration dialog");
        this.configureDialog.show();
    }
}

