/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.fm;

public class FMException
extends Exception {
    private final int errorCode;

    public FMException(int errorCode) {
        super("Error code " + errorCode);
        this.errorCode = errorCode;
    }

    public FMException(int errorCode, String message, Throwable cause) {
        super(message, cause);
        this.errorCode = errorCode;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public int getHttpCode() {
        if (this.errorCode == 201) {
            return 403;
        }
        if (this.errorCode >= 100 && this.errorCode < 200) {
            return 400;
        }
        if (this.errorCode >= 200 && this.errorCode < 300) {
            return 401;
        }
        if (this.errorCode >= 300 && this.errorCode < 306) {
            return 409;
        }
        if (this.errorCode == 306) {
            return 412;
        }
        if (this.errorCode == 401) {
            return 404;
        }
        return 400;
    }
}

