/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.deployment;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jetbrains.annotations.Nullable;

public class DeploymentInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(DeploymentInfo.class.getName());
    private final Properties props;
    private static DeploymentInfo appInstance = null;

    private DeploymentInfo() throws IllegalStateException {
        this(DeploymentInfo.class.getClassLoader());
    }

    private DeploymentInfo(ClassLoader classLoader) throws IllegalStateException {
        try {
            this.props = new Properties();
            InputStream propertyStream = classLoader.getResourceAsStream("deployment.properties");
            if (propertyStream == null) {
                throw new IllegalStateException("You must have a deployment.properties file at the root of your class loader in order to use the no-arg constructor");
            }
            this.loadFromStream(propertyStream);
        }
        catch (IOException e) {
            throw new RuntimeException("Error while reading deployment.properties", e);
        }
    }

    public DeploymentInfo(InputStream propertyStream) throws IOException {
        this.props = new Properties();
        this.loadFromStream(propertyStream);
    }

    public static DeploymentInfo getApplicationInstance() throws IllegalStateException {
        return DeploymentInfo.getApplicationInstance(DeploymentInfo.class.getClassLoader());
    }

    public static DeploymentInfo getApplicationInstance(ClassLoader classLoader) throws IllegalStateException {
        if (appInstance == null) {
            appInstance = new DeploymentInfo(classLoader);
        }
        return appInstance;
    }

    public static DeploymentInfo getForClass(Class whichClass) throws IllegalStateException {
        DeploymentInfo deploymentInfo;
        InputStream stream = whichClass.getResourceAsStream("/deployment.properties");
        if (stream == null) {
            throw new IllegalStateException("There is no deployment.properties file at the root of the classpath for " + whichClass + ". The root URL is " + whichClass.getResource("/"));
        }
        try {
            deploymentInfo = new DeploymentInfo(stream);
        }
        catch (Throwable throwable) {
            try {
                stream.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException("Error while reading deployment.properties", e);
            }
        }
        stream.close();
        return deploymentInfo;
    }

    private void loadFromStream(InputStream propertyStream) throws IOException {
        try {
            this.props.load(propertyStream);
        }
        finally {
            propertyStream.close();
        }
    }

    public String getName() {
        return this.props.getProperty("name", null);
    }

    public String getShortName() {
        return this.props.getProperty("shortName", this.getName());
    }

    public String getVersion() {
        return this.props.getProperty("version", "0.00");
    }

    public boolean isMaintenance() {
        return Boolean.parseBoolean(this.props.getProperty("maintenance", "false"));
    }

    public short getStoreNumber() {
        String storeNumberString = this.props.getProperty("storeNumber");
        if (storeNumberString == null) {
            throw new IllegalStateException("storeNumber is not set in the deployment.properties file");
        }
        return Short.valueOf(storeNumberString);
    }

    public String getBuild() {
        String revision = this.props.getProperty("revision");
        revision = revision == null || !revision.startsWith("$Revision: ") ? "Unknown" : revision.replace("$", "").substring("Revision: ".length()).trim();
        return revision;
    }

    @Nullable
    public Date getCommitDate() {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z", Locale.US);
        String commitDateString = this.getCommitDateString();
        if (commitDateString == null) {
            return null;
        }
        try {
            return df.parse(commitDateString);
        }
        catch (ParseException e) {
            log.log(Level.WARNING, "Could not parse date format: " + commitDateString, e);
            return null;
        }
    }

    private String getCommitDateString() {
        int index;
        Object dateString = this.props.getProperty("commitDate");
        dateString = dateString == null || !((String)dateString).startsWith("$Date: ") ? "Unknown" : ((index = ((String)(dateString = ((String)dateString).replace("$", "").substring("Date: ".length()))).indexOf("(")) == -1 ? null : ((String)dateString).substring(0, index));
        return dateString;
    }

    public Date getMajorReleaseDate() {
        String dateString = this.props.getProperty("majorReleaseDate", null);
        SimpleDateFormat df = new SimpleDateFormat("MM/dd/yyyy");
        try {
            return df.parse(dateString);
        }
        catch (ParseException e) {
            log.log(Level.SEVERE, "couldn't parse deployment date string.");
            return null;
        }
    }

    public String getProductCode() {
        return this.props.getProperty("productCode", null);
    }

    public String getFullyQualifiedName() {
        return this.props.getProperty("fullyQualifiedName", null);
    }

    public String getURL() {
        String url = this.props.getProperty("url");
        url = url == null || !url.startsWith("$HeadURL: ") ? "Unknown URL" : url.replace("$", "").substring("HeadURL: ".length()).trim();
        return url;
    }

    public URL getInstallerImageURL() {
        String urlString = this.props.getProperty("installerImageURL");
        if (urlString == null) {
            return null;
        }
        try {
            return new URL(urlString);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(urlString + " is not a valid URL. Check the deployment.properties file and correct this.", e);
        }
    }

    public Byte getMajorVersion() {
        String majorVersion = this.props.getProperty("majorVersion", null);
        if (majorVersion == null) {
            return null;
        }
        return Byte.valueOf(majorVersion);
    }

    public byte getMinimumMajorVersion() {
        String minimumMajorVersion = this.props.getProperty("minimumMajorVersion", null);
        if (minimumMajorVersion == null) {
            return 0;
        }
        return Byte.valueOf(minimumMajorVersion);
    }

    public String getSummary() {
        DateFormat df = DateFormat.getDateInstance(3);
        Date commitDate = this.getCommitDate();
        return this.getName() + " " + this.getVersion() + ", revision " + this.getBuild() + (commitDate == null ? "" : " (" + df.format(commitDate) + ")");
    }

    public Date getLicenseCutoffDate() {
        if (this.isMaintenance()) {
            return this.getCommitDate();
        }
        Date majorReleaseDate = this.getMajorReleaseDate();
        if (majorReleaseDate == null) {
            log.log(Level.SEVERE, "Unable to parse major release date, will use commit date instead");
            return this.getCommitDate();
        }
        return majorReleaseDate;
    }
}

