/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.db;

import com.prosc.data.MultiMap;
import com.prosc.database.BlobAndMetaData2;
import com.prosc.database.JDBCUtils;
import com.prosc.io.IOUtils;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseWriter
implements AutoCloseable {
    private static final Logger log = Logger.getLogger(DatabaseWriter.class.getName());
    private final String table;
    private final MultiMap<String, StatementValue> values;
    private final MultiMap<String, StatementValue> whereClauses;
    private final String schema;
    private int updateCount;
    private String quoteCharacter;
    private DateFormat dateFormat2;
    private DateFormat timeFormat2;
    private DateFormat timestampFormat2;
    private String operationDescription;
    private final boolean isFileMakerXML;
    private boolean isFileMakerJDBC;
    private String lastSqlString;
    private OperationType operationType;
    private String[] columnsToReturn;
    private PreparedStatement statement;
    private int batchCount;
    private String filter;
    private String tableAlias;
    private static final Level SQL_LOG_LEVEL = Boolean.getBoolean("com.prosc.db.DatabaseWriter.LogSql") ? Level.INFO : Level.FINE;

    public int getUpdateCount() {
        return this.updateCount;
    }

    public DatabaseWriter setDouble(String columnName, double value) {
        return this.setDouble(columnName, value, false, null);
    }

    public DatabaseWriter setDate(String columnName, Date value) {
        return this.setDate(columnName, value, false, null);
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public void setTableAlias(String tableAlias) {
        this.tableAlias = tableAlias;
    }

    public String getTable() {
        return this.table;
    }

    public void cancelCurrentBatch() throws SQLException {
        if (this.statement != null) {
            this.statement.close();
            this.statement = null;
        }
        this.values.clear();
        this.whereClauses.clear();
    }

    public static DatabaseWriter createInsertWriterFromMetadata(DatabaseMetaData metaData, String tableName, String ... columnsToReturn) throws SQLException {
        boolean filemaker = metaData.getDatabaseProductName().toLowerCase().contains("filemaker");
        return new DatabaseWriter(metaData.getIdentifierQuoteString(), OperationType.Insert, null, tableName, filemaker, filemaker && metaData.getDriverName().toLowerCase().contains("jdbc"), columnsToReturn);
    }

    public static DatabaseWriter createUpdateWriterFromMetadata(DatabaseMetaData metaData, String tableName) throws SQLException {
        boolean filemaker = metaData.getDatabaseProductName().toLowerCase().contains("filemaker");
        boolean isJdbc = metaData.getDriverName().toLowerCase().contains("jdbc");
        return new DatabaseWriter(metaData.getIdentifierQuoteString(), OperationType.Update, null, tableName, filemaker, filemaker && isJdbc, null);
    }

    public DatabaseWriter(@NotNull String quoteCharacter, @NotNull OperationType operationType, @Nullable String schema, String tableName, boolean isFileMakerXML, boolean isFileMakerJDBC, @Nullable String[] columnsToReturn) {
        if (quoteCharacter == null) {
            DatabaseWriter.$$$reportNull$$$0(0);
        }
        if (operationType == null) {
            DatabaseWriter.$$$reportNull$$$0(1);
        }
        this.values = new MultiMap(new LinkedHashMap());
        this.whereClauses = new MultiMap(new LinkedHashMap());
        this.dateFormat2 = new SimpleDateFormat("yyyy-MM-dd");
        this.timeFormat2 = new SimpleDateFormat("HH:mm:ss");
        this.timestampFormat2 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        this.operationDescription = null;
        this.batchCount = 0;
        this.operationType = operationType;
        this.quoteCharacter = quoteCharacter;
        this.schema = schema;
        this.table = tableName;
        this.isFileMakerXML = isFileMakerXML;
        this.isFileMakerJDBC = isFileMakerJDBC;
        this.columnsToReturn = columnsToReturn;
    }

    public DatabaseWriter(@NotNull String quoteCharacter, @NotNull OperationType operationType, String schema, String tableName, boolean isFileMakerXML, @Nullable String[] columnsToReturn) {
        if (quoteCharacter == null) {
            DatabaseWriter.$$$reportNull$$$0(2);
        }
        if (operationType == null) {
            DatabaseWriter.$$$reportNull$$$0(3);
        }
        this(quoteCharacter, operationType, schema, tableName, isFileMakerXML, false, columnsToReturn);
    }

    public DatabaseWriter(String quoteCharacter, OperationType operationType, String schema, String table, @Nullable String[] columnsToReturn) {
        this(quoteCharacter, operationType, schema, table, false, columnsToReturn);
    }

    protected String quoteIdentifier(@NotNull String quoteString, @Nullable String schema, @Nullable String tableName, @Nullable String fieldName) {
        if (quoteString == null) {
            DatabaseWriter.$$$reportNull$$$0(4);
        }
        return JDBCUtils.quoteIdentifier(quoteString, schema, tableName, fieldName);
    }

    public void setFileMakerJDBC(boolean isFileMakerJDBC) {
        this.isFileMakerJDBC = isFileMakerJDBC;
    }

    public DatabaseWriter setObject(String columnName, Object value, boolean isWhereCriteria, int sqlDataType) {
        Object[] valuesToWrite;
        if (this.operationType == OperationType.Insert && isWhereCriteria) {
            throw new IllegalArgumentException("You cannot specify WHERE clauses in an INSERT statement");
        }
        boolean hasRepetitions = false;
        if (value instanceof Object[]) {
            valuesToWrite = (Object[])value;
            hasRepetitions = true;
        } else if (value instanceof List) {
            valuesToWrite = ((List)value).toArray();
            hasRepetitions = true;
        } else {
            valuesToWrite = new Object[]{value};
        }
        Integer repetition = null;
        for (Object eachValue : valuesToWrite) {
            Object valueToWrite;
            if (hasRepetitions) {
                if (repetition == null) {
                    repetition = 0;
                }
                Integer n = repetition;
                Integer n2 = repetition = Integer.valueOf(repetition + 1);
            }
            if (sqlDataType == 1 || sqlDataType == 12 || sqlDataType == -1) {
                this.setString(columnName, eachValue == null ? null : String.valueOf(eachValue), isWhereCriteria, repetition);
                continue;
            }
            if (sqlDataType == 93) {
                valueToWrite = eachValue;
                if (valueToWrite instanceof Date) {
                    valueToWrite = new Timestamp(((Date)valueToWrite).getTime());
                }
                if (valueToWrite == null || valueToWrite instanceof Timestamp) {
                    this.setTimestamp(columnName, (Timestamp)valueToWrite, isWhereCriteria, repetition);
                    continue;
                }
                throw new IllegalArgumentException("Cannot convert object '" + eachValue + "' of type " + eachValue.getClass() + " to java.sql.Timestamp for column '" + columnName + "'");
            }
            if (sqlDataType == 91) {
                if (eachValue instanceof Date) {
                    valueToWrite = (Date)eachValue;
                } else if (eachValue instanceof Timestamp) {
                    valueToWrite = new Date(((Timestamp)eachValue).getTime());
                } else if (eachValue == null) {
                    valueToWrite = null;
                } else {
                    throw new IllegalArgumentException("Cannot convert object '" + eachValue + "' of type " + eachValue.getClass() + " to java.sql.Date for column '" + columnName + "'");
                }
                this.setDate(columnName, (Date)valueToWrite, isWhereCriteria, repetition);
                continue;
            }
            if (sqlDataType == 92) {
                if (eachValue == null || eachValue instanceof Time) {
                    this.setTime(columnName, (Time)eachValue, isWhereCriteria, repetition);
                    continue;
                }
                throw new IllegalArgumentException("Cannot convert object '" + eachValue + "' of type " + eachValue.getClass() + " to java.sql.Time for column '" + columnName + "'");
            }
            String mapKey = this.columnNameWithRep(columnName, repetition);
            this.whichMap(isWhereCriteria).addValue(mapKey, new StatementValueSetObject(columnName, eachValue, sqlDataType, repetition));
        }
        return this;
    }

    private MultiMap<String, StatementValue> whichMap(boolean isWhereCriteria) {
        return isWhereCriteria ? this.whereClauses : this.values;
    }

    public String getLastSqlString() {
        return this.lastSqlString;
    }

    public DatabaseWriter setString(String columnName, String value) {
        return this.setString(columnName, value, false, null);
    }

    public void setString(String key, String value, boolean isWhereClause) {
        this.setString(key, value, isWhereClause, null);
    }

    public DatabaseWriter setString(String columnName, final String value, boolean isWhereCriteria, @Nullable Integer repetition) {
        if (this.operationType == OperationType.Insert && isWhereCriteria) {
            throw new IllegalArgumentException("You cannot specify WHERE clauses in an INSERT statement");
        }
        String mapKey = this.columnNameWithRep(columnName, repetition);
        this.whichMap(isWhereCriteria).addValue(mapKey, new StatementValue(columnName, repetition){

            @Override
            void setValueInStatement(PreparedStatement ps, int i) throws SQLException {
                if (value == null) {
                    ps.setNull(i, 12);
                } else {
                    ps.setString(i, value);
                }
            }

            @Override
            String getValueAsString() {
                if (value == null) {
                    return "''";
                }
                return "'" + value.replaceAll("'", "''") + "'";
            }
        });
        return this;
    }

    public DatabaseWriter setDate(String columnName, Date value, boolean isWhereCriteria, @Nullable Integer repetition) {
        Calendar c = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        return this.setDate(columnName, value, c, isWhereCriteria, repetition);
    }

    public DatabaseWriter setDate(String columnName, final Date value, final @Nullable Calendar cal, boolean isWhereCriteria, @Nullable Integer repetition) {
        if (this.operationType == OperationType.Insert && isWhereCriteria) {
            throw new IllegalArgumentException("You cannot specify WHERE clauses in an INSERT statement");
        }
        String mapKey = this.columnNameWithRep(columnName, repetition);
        this.whichMap(isWhereCriteria).addValue(mapKey, new StatementValue(columnName, repetition){

            @Override
            void setValueInStatement(PreparedStatement ps, int i) throws SQLException {
                if (value == null) {
                    ps.setNull(i, 91);
                } else if (cal == null) {
                    ps.setDate(i, value);
                } else if (DatabaseWriter.this.isFileMakerJDBC) {
                    long time = value.getTime();
                    TimeZone tz = cal.getTimeZone();
                    int desiredOffset = tz.getOffset(time);
                    int localOffset = TimeZone.getDefault().getOffset(time);
                    time += (long)desiredOffset;
                    Date adjustedValue = new Date(time -= (long)localOffset);
                    ps.setDate(i, adjustedValue);
                } else {
                    ps.setDate(i, value, cal);
                }
            }

            @Override
            String getValueAsString() {
                if (value == null) {
                    return "''";
                }
                if (cal != null) {
                    DatabaseWriter.this.dateFormat2.setCalendar(cal);
                }
                return "DATE '" + DatabaseWriter.this.dateFormat2.format(value) + "'";
            }
        });
        return this;
    }

    public DatabaseWriter setTime(String columnName, Time value, boolean isWhereCriteria, @Nullable Integer repetition) {
        return this.setTime(columnName, value, null, isWhereCriteria, repetition);
    }

    public DatabaseWriter setTime(String columnName, final Time value, final @Nullable Calendar cal, boolean isWhereCriteria, @Nullable Integer repetition) {
        if (this.operationType == OperationType.Insert && isWhereCriteria) {
            throw new IllegalArgumentException("You cannot specify WHERE clauses in an INSERT statement");
        }
        String mapKey = this.columnNameWithRep(columnName, repetition);
        this.whichMap(isWhereCriteria).addValue(mapKey, new StatementValue(columnName, repetition){

            @Override
            void setValueInStatement(PreparedStatement ps, int i) throws SQLException {
                if (value == null) {
                    ps.setNull(i, 92);
                } else if (cal == null) {
                    ps.setTime(i, value);
                } else {
                    ps.setTime(i, value, cal);
                }
            }

            @Override
            String getValueAsString() {
                if (value == null) {
                    return "''";
                }
                if (cal != null) {
                    DatabaseWriter.this.timeFormat2.setCalendar(cal);
                }
                return "TIME '" + DatabaseWriter.this.timeFormat2.format(value) + "'";
            }
        });
        return this;
    }

    public DatabaseWriter setTimestamp(String columnName, Timestamp value, boolean isWhereCriteria, @Nullable Integer repetition) {
        return this.setTimestamp(columnName, value, null, isWhereCriteria, repetition);
    }

    public DatabaseWriter setTimestamp(String columnName, final Timestamp value, final @Nullable Calendar cal, boolean isWhereCriteria, @Nullable Integer repetition) {
        if (this.operationType == OperationType.Insert && isWhereCriteria) {
            throw new IllegalArgumentException("You cannot specify WHERE clauses in an INSERT statement");
        }
        String mapKey = this.columnNameWithRep(columnName, repetition);
        this.whichMap(isWhereCriteria).addValue(mapKey, new StatementValue(columnName, repetition){

            @Override
            void setValueInStatement(PreparedStatement ps, int i) throws SQLException {
                if (value == null) {
                    ps.setNull(i, 93);
                } else if (cal == null) {
                    ps.setTimestamp(i, value);
                } else {
                    ps.setTimestamp(i, value, cal);
                }
            }

            @Override
            String getValueAsString() {
                if (value == null) {
                    return "''";
                }
                if (cal != null) {
                    DatabaseWriter.this.timestampFormat2.setCalendar(cal);
                }
                return "TIMESTAMP '" + DatabaseWriter.this.timestampFormat2.format(value) + "'";
            }
        });
        return this;
    }

    public DatabaseWriter setDouble(String columnName, final double value, boolean isWhereCriteria, @Nullable Integer repetition) {
        if (this.operationType == OperationType.Insert && isWhereCriteria) {
            throw new IllegalArgumentException("You cannot specify WHERE clauses in an INSERT statement");
        }
        String mapKey = this.columnNameWithRep(columnName, repetition);
        this.whichMap(isWhereCriteria).addValue(mapKey, new StatementValue(columnName, repetition){

            @Override
            void setValueInStatement(PreparedStatement ps, int i) throws SQLException {
                ps.setDouble(i, value);
            }

            @Override
            String getValueAsString() {
                return String.valueOf(value);
            }
        });
        return this;
    }

    public DatabaseWriter setFloat(String columnName, final float value, boolean isWhereCriteria, @Nullable Integer repetition) {
        if (this.operationType == OperationType.Insert && isWhereCriteria) {
            throw new IllegalArgumentException("You cannot specify WHERE clauses in an INSERT statement");
        }
        String mapKey = this.columnNameWithRep(columnName, repetition);
        this.whichMap(isWhereCriteria).addValue(mapKey, new StatementValue(columnName, repetition){

            @Override
            void setValueInStatement(PreparedStatement ps, int i) throws SQLException {
                ps.setFloat(i, value);
            }

            @Override
            String getValueAsString() {
                return String.valueOf(value);
            }
        });
        return this;
    }

    public DatabaseWriter setBoolean(String columnName, boolean value) {
        return this.setInt(columnName, value ? 1 : 0);
    }

    public DatabaseWriter setInt(String columnName, int value) {
        return this.setInt(columnName, value, false, null);
    }

    public DatabaseWriter setInt(String columnName, int value, @Nullable Integer repetition) {
        return this.setInt(columnName, value, false, repetition);
    }

    public DatabaseWriter setInt(String columnName, final int value, boolean isWhereCriteria, @Nullable Integer repetition) {
        if (this.operationType == OperationType.Insert && isWhereCriteria) {
            throw new IllegalArgumentException("You cannot specify WHERE clauses in an INSERT statement");
        }
        String mapKey = this.columnNameWithRep(columnName, repetition);
        this.whichMap(isWhereCriteria).addValue(mapKey, new StatementValue(columnName, repetition){

            @Override
            void setValueInStatement(PreparedStatement ps, int i) throws SQLException {
                ps.setInt(i, value);
            }

            @Override
            String getValueAsString() {
                return String.valueOf(value);
            }
        });
        return this;
    }

    public DatabaseWriter setLong(String columnName, final long value, boolean isWhereCriteria, @Nullable Integer repetition) {
        if (this.operationType == OperationType.Insert && isWhereCriteria) {
            throw new IllegalArgumentException("You cannot specify WHERE clauses in an INSERT statement");
        }
        String mapKey = this.columnNameWithRep(columnName, repetition);
        this.whichMap(isWhereCriteria).addValue(mapKey, new StatementValue(columnName, repetition){

            @Override
            void setValueInStatement(PreparedStatement ps, int i) throws SQLException {
                ps.setLong(i, value);
            }

            @Override
            String getValueAsString() {
                return String.valueOf(value);
            }
        });
        return this;
    }

    public void setNull(String columnName, boolean isWhereCriteria, int sqlDataType, @Nullable Integer repetition) {
        if (this.operationType == OperationType.Insert && isWhereCriteria) {
            throw new IllegalArgumentException("You cannot specify WHERE clauses in an INSERT statement");
        }
        String mapKey = this.columnNameWithRep(columnName, repetition);
        this.whichMap(isWhereCriteria).addValue(mapKey, new StatementValueSetObject(columnName, null, sqlDataType, repetition));
    }

    private String columnNameWithRep(String columnName, Integer repetition) {
        String mapKey = columnName;
        if (repetition != null) {
            mapKey = mapKey + "[" + repetition + "]";
        }
        return mapKey;
    }

    public void addBatch(Connection conn) throws SQLException {
        this._applyValues(conn, true);
        this.values.clear();
        this.whereClauses.clear();
    }

    public void setOperationDescription(String operationDescription) {
        this.operationDescription = operationDescription;
    }

    public void execute(Connection connection) throws SQLException {
        try {
            long startTime = System.currentTimeMillis();
            if (this.batchCount == 0) {
                this._applyValues(connection, false);
                this.updateCount = this.statement.executeUpdate();
            } else {
                int[] updateCounts;
                this._applyValues(connection, true);
                for (int i : updateCounts = this.statement.executeBatch()) {
                    this.updateCount += i;
                }
            }
            if (log.isLoggable(SQL_LOG_LEVEL)) {
                long duration = System.currentTimeMillis() - startTime;
                MultiMap allParams = new MultiMap(new LinkedHashMap());
                allParams.putAll(this.values);
                allParams.putAll(this.whereClauses);
                String tempDescription = this.operationDescription;
                if (tempDescription == null) {
                    tempDescription = "Executed SQL";
                }
                log.log(SQL_LOG_LEVEL, tempDescription + " for table " + this.table + " in " + duration + " milliseconds: " + this.lastSqlString + " with params " + allParams.values() + " on connection " + connection);
            }
        }
        catch (RuntimeException e) {
            this.logSqlFailure(e);
            throw e;
        }
        catch (SQLException e) {
            this.logSqlFailure(e);
            throw e;
        }
        finally {
            this.values.clear();
            this.whereClauses.clear();
        }
    }

    private void logSqlFailure(Exception e) {
        MultiMap allParams = new MultiMap(new LinkedHashMap());
        allParams.putAll(this.values);
        allParams.putAll(this.whereClauses);
        log.log(Level.INFO, "SQL execution failed. SQL command: " + this.lastSqlString + "\nParams: " + allParams.values().toString().replace("\r", " ") + "\nError message: " + e.toString());
    }

    public int getBatchCount() {
        return this.batchCount;
    }

    private void _applyValues(Connection conn, boolean addBatch) throws SQLException {
        this._getStatement(conn);
        if (!this.values.isEmpty() || !this.whereClauses.isEmpty()) {
            try {
                int i = 1;
                for (Collection<StatementValue> eachValue : this.values.values()) {
                    StatementValue statementValue = eachValue.iterator().next();
                    statementValue.setValueInStatement(this.statement, i++);
                }
                for (Collection<StatementValue> eachWhere : this.whereClauses.values()) {
                    for (StatementValue statementValue : eachWhere) {
                        statementValue.setValueInStatement(this.statement, i++);
                    }
                }
                if (addBatch) {
                    this.statement.addBatch();
                    ++this.batchCount;
                }
            }
            catch (SQLException e) {
                this.logSqlFailure(e);
                throw e;
            }
        }
    }

    public PreparedStatement getStatement() {
        return this.statement;
    }

    private void _getStatement(Connection connection) throws SQLException {
        if (this.statement == null) {
            this.generateSql();
            this.statement = this.operationType == OperationType.Insert || this.operationType == OperationType.Update ? (this.columnsToReturn == null ? connection.prepareStatement(this.lastSqlString, 2) : (connection.getClass().getName().startsWith("com.filemaker") ? connection.prepareStatement(this.lastSqlString, 1) : connection.prepareStatement(this.lastSqlString, this.columnsToReturn))) : connection.prepareStatement(this.lastSqlString);
        }
    }

    private String generateSql() {
        switch (this.operationType) {
            case Insert: {
                this.generateInsertSql();
                break;
            }
            case Update: {
                this.generateUpdateSql();
                break;
            }
            case Delete: {
                this.generateDeleteSql();
            }
        }
        return this.lastSqlString;
    }

    private void generateInsertSql() {
        if (!this.whereClauses.isEmpty()) {
            throw new IllegalArgumentException("WHERE clauses not supported for " + (Object)((Object)this.operationType) + " operations");
        }
        StringBuilder sql = new StringBuilder(100);
        sql.append("INSERT INTO ").append(this.quoteIdentifier(this.quoteCharacter, this.schema, this.table, null));
        if (this.values.size() > 0) {
            StatementValue statementValue;
            sql.append(" (");
            String delim = "";
            for (Collection<StatementValue> eachValue : this.values.values()) {
                statementValue = eachValue.iterator().next();
                sql.append(delim).append(this.quoteIdentifier(this.quoteCharacter, this.schema, null, statementValue.columnName));
                if (statementValue.repetition != null) {
                    sql.append('[').append(statementValue.repetition).append(']');
                }
                delim = ", ";
            }
            sql.append(") VALUES (");
            delim = "";
            for (Collection<StatementValue> eachValue : this.values.values()) {
                sql.append(delim);
                delim = ", ";
                statementValue = eachValue.iterator().next();
                sql.append(statementValue.insertPlaceholderOrValue());
            }
            sql.append(")");
        }
        this.lastSqlString = sql.toString();
    }

    private void generateUpdateSql() {
        if (this.whereClauses.isEmpty()) {
            throw new IllegalStateException("You must call where before doing an update or delete");
        }
        if (this.values.isEmpty()) {
            throw new IllegalStateException("UPDATE was called with no values for table " + this.table);
        }
        StringBuilder sql = new StringBuilder(100);
        sql.append("UPDATE ").append(this.quoteIdentifier(this.quoteCharacter, this.schema, this.table, null)).append(" SET ");
        String delim = "";
        for (Collection<StatementValue> eachValue : this.values.values()) {
            StatementValue statementValue = eachValue.iterator().next();
            sql.append(delim).append(this.quoteIdentifier(this.quoteCharacter, null, null, statementValue.columnName));
            if (statementValue.repetition != null) {
                sql.append('[').append(statementValue.repetition).append(']');
            }
            sql.append('=').append(statementValue.insertPlaceholderOrValue());
            delim = ", ";
        }
        this.appendWhereClauses(sql);
        this.lastSqlString = sql.toString();
    }

    private void appendWhereClauses(StringBuilder sql) {
        boolean useExists = false;
        String whereQualifier = " WHERE ";
        if ((this.operationType == OperationType.Update || this.operationType == OperationType.Delete) && this.filter != null && this.filter.trim().length() > 0) {
            if (this.filter.trim().toLowerCase().startsWith("where")) {
                whereQualifier = " AND ";
                sql.append(this.filter);
            } else {
                useExists = true;
            }
        }
        sql.append(whereQualifier);
        String delim = "";
        for (Collection<StatementValue> eachWhere : this.whereClauses.values()) {
            if (eachWhere.size() > 1) {
                sql.append('(');
            }
            for (StatementValue statementValue : eachWhere) {
                sql.append(delim).append(this.quoteIdentifier(this.quoteCharacter, null, null, statementValue.columnName));
                if (this.isFileMakerXML) {
                    sql.append("=" + statementValue.getValueAsString());
                } else {
                    sql.append("=?");
                }
                delim = " OR ";
            }
            if (eachWhere.size() > 1) {
                sql.append(')');
            }
            delim = " AND ";
        }
        if (useExists) {
            sql.append(delim);
            sql.append("EXISTS (SELECT * FROM " + this.quoteIdentifier(this.quoteCharacter, null, this.table, null) + " " + this.filter + ")");
        }
    }

    public DatabaseWriter where(String column, Object value, int sqlDataType) {
        this.setObject(column, value, true, sqlDataType);
        return this;
    }

    private void generateDeleteSql() {
        if (this.whereClauses.isEmpty()) {
            throw new IllegalStateException("You must call where before doing an update or delete");
        }
        if (!this.values.isEmpty()) {
            throw new IllegalArgumentException("VALUE clauses not supported for " + (Object)((Object)this.operationType) + " operations");
        }
        StringBuilder sql = new StringBuilder("DELETE FROM " + this.quoteIdentifier(this.quoteCharacter, this.schema, this.table, null));
        this.appendWhereClauses(sql);
        this.lastSqlString = sql.toString();
    }

    @Override
    public void close() throws SQLException {
        if (this.statement != null) {
            this.statement.close();
            this.statement = null;
        }
    }

    private void sampleUsage() throws Exception {
        Connection connection = null;
        DatabaseWriter dbWriter = new DatabaseWriter("`", OperationType.Update, null, "PERSON", false, null);
        dbWriter.setString("firstName", "Sam", false, null).setString("lastName", "Barnum", false, null).setDate("DOB", new Date(123L), false, null).setInt("numberOfChildren", 2, false, null).where("id", 42, 4).where("active", 1, 4).execute(connection);
        dbWriter.getStatement().close();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "quoteCharacter";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operationType";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "quoteString";
                break;
            }
        }
        objectArray2[1] = "com/prosc/db/DatabaseWriter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "quoteIdentifier";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private final class StatementValueSetObject
    extends StatementValue {
        private final Object value;
        private final int sqlDataType;

        public StatementValueSetObject(String column, Object value, @Nullable int sqlDataType, Integer repetition) {
            super(column, repetition);
            this.value = value;
            this.sqlDataType = sqlDataType;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void setValueInStatement(PreparedStatement ps, int columnIndex) throws SQLException {
            block25: {
                Object convertedValue = this.value;
                if (convertedValue == null) {
                    if (DatabaseWriter.this.isFileMakerJDBC && this.sqlDataType == -4) {
                        ps.setString(columnIndex, "");
                    } else {
                        ps.setNull(columnIndex, this.sqlDataType);
                    }
                } else if (convertedValue instanceof Blob && ((Blob)convertedValue).length() == 0L) {
                    log.finest("Ignored a zero-length blob, because a bug in the JDK will cause that to fail");
                    ps.setObject(columnIndex, null, this.sqlDataType);
                } else {
                    try {
                        if (convertedValue instanceof Blob && ps.getConnection().getClass().getName().contains("oracle")) {
                            Blob blob = ps.getConnection().createBlob();
                            OutputStream outputStream = blob.setBinaryStream(1L);
                            InputStream inputStream = ((Blob)convertedValue).getBinaryStream();
                            try {
                                IOUtils.writeInputToOutput(inputStream, outputStream, 8192);
                            }
                            finally {
                                inputStream.close();
                                outputStream.close();
                            }
                            ps.setBlob(columnIndex, blob);
                            break block25;
                        }
                        if (convertedValue instanceof Blob && this.sqlDataType == -3) {
                            ps.setBinaryStream(columnIndex, ((Blob)convertedValue).getBinaryStream(), ((Blob)convertedValue).length());
                        } else if (convertedValue instanceof Blob) {
                            ps.setBinaryStream(columnIndex, ((Blob)convertedValue).getBinaryStream(), (int)((Blob)convertedValue).length());
                        } else if (convertedValue instanceof Clob) {
                            ps.setCharacterStream(columnIndex, ((Clob)convertedValue).getCharacterStream(), ((Clob)convertedValue).length());
                        } else if (convertedValue instanceof Reader) {
                            try {
                                ps.setCharacterStream(columnIndex, (Reader)convertedValue);
                            }
                            catch (SQLException e) {
                                String valueAsString = IOUtils.readerAsString((Reader)convertedValue, null).toString();
                                ps.setString(columnIndex, valueAsString);
                            }
                        } else if (convertedValue instanceof Boolean) {
                            ps.setBoolean(columnIndex, (Boolean)convertedValue);
                        } else {
                            ps.setObject(columnIndex, convertedValue, this.sqlDataType);
                        }
                    }
                    catch (Exception e) {
                        SQLException rethrow = new SQLException("Could not set " + this + "; " + e.getMessage(), e);
                        log.log(Level.SEVERE, rethrow.getMessage(), rethrow);
                        throw rethrow;
                    }
                }
            }
        }

        @Override
        String getValueAsString() {
            if (this.value == null) {
                return "''";
            }
            return String.valueOf(this.value);
        }

        @Override
        public String insertPlaceholderOrValue() {
            if (this.value instanceof BlobAndMetaData2 && DatabaseWriter.this.isFileMakerJDBC) {
                String filenameForSql = ((BlobAndMetaData2)this.value).getFilename();
                filenameForSql = filenameForSql.replace("'", "''").replace("\"", "\\\"");
                return "? AS '" + filenameForSql + "'";
            }
            return super.insertPlaceholderOrValue();
        }
    }

    private abstract class StatementValue {
        private final String columnName;
        @Nullable
        private final Integer repetition;

        public StatementValue(@Nullable String columnName, Integer repetition) {
            this.columnName = columnName;
            this.repetition = repetition;
        }

        abstract void setValueInStatement(PreparedStatement var1, int var2) throws SQLException;

        abstract String getValueAsString();

        public String toString() {
            return this.columnName + "=" + this.getValueAsString();
        }

        public String insertPlaceholderOrValue() {
            if (DatabaseWriter.this.isFileMakerXML) {
                return this.getValueAsString();
            }
            return "?";
        }
    }

    public static enum OperationType {
        Update,
        Insert,
        Delete;

    }
}

