/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.database;

import com.prosc.data.BasicTypeConverter;
import com.prosc.database.InconvertibleValueException;
import com.prosc.shared.StringUtils;
import java.io.IOException;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JDBCUtils {
    private static final Logger log = Logger.getLogger(JDBCUtils.class.getName());

    public static void closeQuietly(PreparedStatement ps) {
        try {
            ps.close();
        }
        catch (Throwable e) {
            log.log(Level.WARNING, "Unable to close " + ps, e);
        }
    }

    public static void closeQuietly(Connection connection) {
        if (connection != null) {
            try {
                connection.close();
            }
            catch (SQLException e) {
                log.log(Level.WARNING, "Unable to close " + connection, e);
            }
        }
    }

    public static void closeQuietly(ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                log.log(Level.WARNING, "Unable to close " + rs, e);
            }
        }
    }

    public static void populateArgs(PreparedStatement ps, Object[] args) throws SQLException {
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                ps.setObject(i + 1, args[i]);
            }
        }
    }

    public static String quoteIdentifier(@NotNull String quoteString, @Nullable String schema, @Nullable String tableName, @Nullable String fieldName) {
        if (quoteString == null) {
            JDBCUtils.$$$reportNull$$$0(0);
        }
        StringBuilder sb = new StringBuilder();
        if (!StringUtils.isEmpty(tableName)) {
            tableName = tableName.replace(quoteString, "\\" + quoteString);
            sb.append(quoteString);
            if (!StringUtils.isEmpty(schema)) {
                schema = schema.replace(quoteString, "\\" + quoteString);
                sb.append(schema).append(quoteString).append('.').append(quoteString);
            }
            sb.append(tableName).append(quoteString);
            if (!StringUtils.isEmpty(fieldName)) {
                sb.append('.');
            }
        }
        if (!StringUtils.isEmpty(fieldName)) {
            fieldName = fieldName.replace(quoteString, "\\" + quoteString);
            sb.append(quoteString).append(fieldName).append(quoteString);
        }
        return sb.toString();
    }

    public static void dumpResultSet(ResultSet rs, @Nullable Appendable output, boolean rewindOneRow) throws SQLException {
        try {
            ResultSetMetaData meta = rs.getMetaData();
            Appendable _output = output == null ? new StringBuilder() : output;
            for (int n = 0; n < meta.getColumnCount(); ++n) {
                _output.append(meta.getColumnName(n + 1)).append("\t");
            }
            boolean skipRow = rewindOneRow;
            while (skipRow || rs.next()) {
                _output.append("\n");
                for (int n = 0; n < meta.getColumnCount(); ++n) {
                    Object value = rs.getObject(n + 1);
                    String stringValue = String.valueOf(value);
                    _output.append(stringValue).append("\t");
                }
                skipRow = false;
            }
            if (output == null) {
                log.info(_output.toString());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String dumpResultSet(ResultSet rs) throws SQLException {
        StringBuilder sb = new StringBuilder();
        JDBCUtils.dumpResultSet(rs, sb, false);
        return sb.toString();
    }

    public static Collection<? extends String> columnLabelsFor(ResultSet currentRow) throws SQLException {
        ResultSetMetaData metaData = currentRow.getMetaData();
        int columnCount = metaData.getColumnCount();
        ArrayList<String> result = new ArrayList<String>(columnCount);
        for (int i = 0; i < columnCount; ++i) {
            result.add(metaData.getColumnLabel(i + 1));
        }
        return result;
    }

    public static Object convertStringToDataType(String text, int dataType) throws InconvertibleValueException {
        return JDBCUtils.convertObjectToDataType(text, dataType, true);
    }

    public static Object convertObjectToDataType(Object input, int dataType, boolean nullable) throws InconvertibleValueException {
        try {
            switch (dataType) {
                case 2: 
                case 3: {
                    return BasicTypeConverter.convertObjectToBigDecimal(input, nullable);
                }
                case -5: {
                    return BasicTypeConverter.convertObjectToLong(input, nullable);
                }
                case -7: 
                case 16: {
                    return BasicTypeConverter.convertObjectToBoolean(input, nullable);
                }
                case -16: 
                case -9: 
                case -1: 
                case 1: 
                case 12: 
                case 2005: {
                    return BasicTypeConverter.convertObjectToString(input, nullable);
                }
                case 91: {
                    return BasicTypeConverter.convertObjectToDate(input, nullable);
                }
                case 8: {
                    return BasicTypeConverter.convertObjectToDouble(input, nullable);
                }
                case 6: 
                case 7: {
                    return BasicTypeConverter.convertObjectToFloat(input, nullable);
                }
                case 4: {
                    return BasicTypeConverter.convertObjectToInteger(input, nullable);
                }
                case 5: {
                    return BasicTypeConverter.convertObjectToShort(input, nullable);
                }
                case 92: {
                    return BasicTypeConverter.convertObjectToTime(input, nullable);
                }
                case 93: {
                    return BasicTypeConverter.convertObjectToTimestamp(input, nullable);
                }
                case -6: {
                    return BasicTypeConverter.convertObjectToByte(input, nullable);
                }
                case -2: {
                    return BasicTypeConverter.convertObjectToBinaryStream(input, nullable);
                }
            }
            throw new IllegalArgumentException("Unsupported conversion to SQL type " + dataType + "; will return null for input " + String.valueOf(input));
        }
        catch (NumberFormatException e) {
            throw new InconvertibleValueException("Could not convert '" + String.valueOf(input) + "' to desired SQL data type " + dataType, input, e);
        }
    }

    public static boolean isText(int dataType) {
        return dataType == 12 || dataType == -1 || dataType == 1 || dataType == 2005 || dataType == 2003 || dataType == -9 || dataType == -15;
    }

    public static boolean isNumber(int dataType) {
        return dataType == 3 || dataType == 8 || dataType == 4 || dataType == 6 || dataType == 7 || dataType == -5 || dataType == -7 || dataType == -6 || dataType == 5 || dataType == 2 || dataType == 16;
    }

    public static Object getObject(ResultSet rs, int columnIndex, int dataType) throws SQLException {
        switch (dataType) {
            case 2003: {
                return rs.getArray(columnIndex);
            }
            case -5: {
                return rs.getLong(columnIndex);
            }
            case -4: 
            case -3: 
            case -2: {
                return rs.getBinaryStream(columnIndex);
            }
            case -7: 
            case 16: {
                return rs.getBoolean(columnIndex);
            }
            case 2004: {
                Blob blob = rs.getBlob(columnIndex);
                try {
                    blob.length();
                }
                catch (SQLException e) {
                    blob = null;
                }
                return blob;
            }
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: {
                return rs.getString(columnIndex);
            }
            case 2005: 
            case 2011: {
                return rs.getClob(columnIndex);
            }
            case 91: {
                return rs.getDate(columnIndex);
            }
            case 3: {
                return rs.getBigDecimal(columnIndex);
            }
            case 8: {
                return rs.getDouble(columnIndex);
            }
            case 6: {
                return Float.valueOf(rs.getFloat(columnIndex));
            }
            case 4: {
                return rs.getInt(columnIndex);
            }
            case 5: {
                return rs.getShort(columnIndex);
            }
            case 92: {
                return rs.getTime(columnIndex);
            }
            case 93: {
                return rs.getTimestamp(columnIndex);
            }
            case -6: {
                return rs.getByte(columnIndex);
            }
        }
        return rs.getObject(columnIndex);
    }

    public static void insertEmptyRecord(Statement stmt, @Nullable String catalog, String tableName) throws SQLException {
        JDBCUtils.insertEmptyRecord(stmt, catalog, tableName, null);
    }

    public static void insertEmptyRecord(Statement stmt, @Nullable String catalog, String tableName, @Nullable Set<String> requiredNonAutoEntryFields) throws SQLException {
        DatabaseMetaData metaData = stmt.getConnection().getMetaData();
        String quoteString = metaData.getIdentifierQuoteString();
        LinkedList<String> requiredColumns = new LinkedList<String>();
        HashSet<String> uniqueColumnNames = new HashSet<String>();
        ResultSet columns = metaData.getIndexInfo(null, null, tableName, true, true);
        while (columns.next()) {
            if (columns.getInt(4) != 0) continue;
            uniqueColumnNames.add(columns.getString(9));
        }
        columns.close();
        HashMap<String, Integer> columnNameToDataType = new HashMap<String, Integer>();
        columns = metaData.getColumns(catalog, null, tableName, null);
        while (columns.next()) {
            boolean autoEnter;
            String columName = columns.getString(4);
            if (columName.contains("::")) continue;
            columnNameToDataType.put(columName, columns.getInt(5));
            boolean requiredValue = columns.getInt(11) == 0;
            String fieldComment = columns.getString(12);
            boolean bl = autoEnter = fieldComment != null && fieldComment.contains("autoEnter") || !StringUtils.isEmpty(columns.getString(13));
            if (uniqueColumnNames.contains(columName)) {
                autoEnter = true;
            }
            if (!requiredValue || autoEnter) continue;
            requiredColumns.add(columName);
        }
        if (requiredNonAutoEntryFields != null) {
            requiredNonAutoEntryFields.addAll(requiredColumns);
        }
        StringBuilder sql = new StringBuilder(256);
        sql.append("INSERT INTO " + quoteString + tableName + quoteString);
        String plainSql = sql.toString();
        boolean isNativeFileMakerJdbc = stmt.getConnection().getClass().getName().contains("J3Connection");
        if (requiredColumns.size() == 0 && isNativeFileMakerJdbc) {
            columns = metaData.getColumnPrivileges(null, null, tableName, null);
            while (columns.next()) {
                if (!"INSERT".equals(columns.getString(7))) continue;
                requiredColumns.add(columns.getString(4));
                break;
            }
            columns.close();
        }
        if (requiredColumns.size() > 0) {
            sql.append('(');
            String delim = "";
            for (String column : requiredColumns) {
                String quotedIdentifier = quoteString + column + quoteString;
                sql.append(delim + quotedIdentifier);
                delim = ",";
            }
            sql.append(") VALUES(");
            delim = "";
            for (String column : requiredColumns) {
                Object value = JDBCUtils.randomValueForType((Integer)columnNameToDataType.get(column));
                if (value instanceof String) {
                    sql.append(delim + "'" + value + "'");
                } else {
                    sql.append(delim + value);
                }
                delim = ",";
            }
            sql.append(")");
        }
        try {
            stmt.executeUpdate(sql.toString(), 1);
        }
        catch (SQLException e) {
            if (e.getErrorCode() == 201) {
                stmt.executeUpdate(plainSql, 1);
            }
            if (e.getErrorCode() == 303) {
                throw new SQLException("You or somebody else on the network has the database field definitions window open. This must be closed before proceeding.", e.getSQLState(), 303);
            }
            if (e.getErrorCode() == 504) {
                throw e;
            }
            throw e;
        }
    }

    public static Object randomValueForType(int dataType) {
        Object result = dataType == 91 ? "1/1/2000" : (dataType == 93 ? "1/1/2000 11:08am" : (dataType == 92 ? "11:07am" : (dataType == 2004 ? null : (JDBCUtils.isText(dataType) ? "com.prosc.jdbc.JDBCUtils test " + UUID.randomUUID().toString() : Integer.valueOf(1294817777)))));
        return result;
    }

    public static String guessPrimaryKey(DatabaseMetaData metaData, String databaseName, String schema, String jdbcTableName) throws SQLException {
        ResultSet indexes = metaData.getIndexInfo(databaseName, null, jdbcTableName, true, true);
        int indexCount = 0;
        String pkColumn = null;
        while (indexes.next()) {
            if (indexes.getInt(4) != 0) continue;
            String uniqueColumn = indexes.getString(9);
            ResultSet columnInfo = metaData.getColumns(databaseName, null, jdbcTableName, uniqueColumn);
            columnInfo.next();
            if (columnInfo.getInt(11) == 0) {
                ++indexCount;
                pkColumn = uniqueColumn;
            }
            columnInfo.close();
            if (indexCount <= 1) continue;
            break;
        }
        if (indexCount != 1) {
            pkColumn = null;
        }
        return pkColumn;
    }

    public static ResultSet fetchFullRowAfterUpdate(ResultSet currentRow, String tableName, String idQuote) throws SQLException {
        Object recid = currentRow.getObject(1);
        String recIdName = currentRow.getMetaData().getColumnName(1);
        Statement statement = currentRow.getStatement();
        currentRow.close();
        ResultSet result = statement.executeQuery("SELECT * FROM " + idQuote + tableName + idQuote + " WHERE " + recIdName + "=" + recid);
        if (!result.next()) {
            throw new SQLException("Inserted dummy row with " + recIdName + "=" + recid + ", but could not query it after creating it.");
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "quoteString", "com/prosc/database/JDBCUtils", "quoteIdentifier"));
    }
}

