/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.database;

import au.com.bytecode.opencsv.CSVWriter;
import com.prosc.database.JDBCUtils;
import com.prosc.shared.StringUtils;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.DataSource;
import javax.swing.BoundedRangeModel;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JDBCHelper {
    private static final Logger log = Logger.getLogger(JDBCHelper.class.getName());
    @NotNull
    private final DataSource dataSource;
    private Level logLevel;
    private int initialCapacity;
    @Nullable
    private Map<String, PreparedStatement> preparedStatementCache;
    @Nullable
    private BoundedRangeModel rangeModel;

    public JDBCHelper(@NotNull Connection connection) {
        if (connection == null) {
            JDBCHelper.$$$reportNull$$$0(0);
        }
        this(new NonClosingDataSource(connection));
    }

    public JDBCHelper(@NotNull DataSource dataSource) {
        if (dataSource == null) {
            JDBCHelper.$$$reportNull$$$0(1);
        }
        this.logLevel = Level.FINE;
        this.initialCapacity = 100;
        this.dataSource = dataSource;
    }

    public Level getLogLevel() {
        return this.logLevel;
    }

    public void setLogLevel(@Nullable Level logLevel) {
        this.logLevel = logLevel;
    }

    public int executeUpdate(String sql, Object ... args) throws SQLException {
        Connection connection = this.obtainConnection();
        PreparedStatement ps = this.prepareStatement(connection, sql, args);
        try {
            long startTime = System.currentTimeMillis();
            int result = ps.executeUpdate();
            if (log.isLoggable(this.logLevel)) {
                long duration = System.currentTimeMillis() - startTime;
                log.log(this.logLevel, "Executed update in " + duration + " milliseconds: " + sql + " with params " + Arrays.asList(args));
            }
            int n = result;
            return n;
        }
        catch (SQLException e) {
            SQLException sqle = new SQLException("Failed to execute SQL update " + sql + " with params " + Arrays.asList(args) + "\nError: " + e.toString(), e.getSQLState(), e.getErrorCode());
            sqle.initCause(e);
            throw sqle;
        }
        catch (Error e) {
            log.log(Level.SEVERE, "Failed to execute SQL update " + sql + " with params " + Arrays.asList(args) + "\nError: " + e.toString());
            throw e;
        }
        finally {
            this.closeQuietly(ps);
            connection.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <E> E executeUpdateWithGeneratedKeys(RowHandler<E> generatedKeysHandler, String sql, Object ... args) throws SQLException {
        Connection connection = this.obtainConnection();
        PreparedStatement ps = this.prepareStatement(connection, sql, args);
        try {
            ResultSet generatedKeys;
            block12: {
                E e;
                long startTime = System.currentTimeMillis();
                int result = ps.executeUpdate();
                if (log.isLoggable(this.logLevel)) {
                    long duration = System.currentTimeMillis() - startTime;
                    log.log(this.logLevel, "Executed update in " + duration + " milliseconds: " + sql + " with params " + Arrays.asList(args));
                }
                generatedKeys = ps.getGeneratedKeys();
                try {
                    if (!generatedKeys.next()) break block12;
                    e = generatedKeysHandler.handle(generatedKeys);
                }
                catch (Throwable throwable) {
                    try {
                        generatedKeys.close();
                        throw throwable;
                    }
                    catch (SQLException e2) {
                        SQLException sqle = new SQLException("Failed to execute SQL update " + sql + " with params " + Arrays.asList(args) + "\nError: " + e2.toString());
                        sqle.initCause(e2);
                        throw sqle;
                    }
                    catch (Error e3) {
                        log.log(Level.SEVERE, "Failed to execute SQL update " + sql + " with params " + Arrays.asList(args) + "\nError: " + e3.toString());
                        throw e3;
                    }
                }
                generatedKeys.close();
                return e;
            }
            E e = null;
            generatedKeys.close();
            return e;
        }
        finally {
            this.closeQuietly(ps);
            connection.close();
        }
    }

    public <E> List<E> executeQuery(@NotNull RowHandler<E> rowHandler, @NotNull String sql, Collection<?> args) throws SQLException {
        if (rowHandler == null) {
            JDBCHelper.$$$reportNull$$$0(2);
        }
        if (sql == null) {
            JDBCHelper.$$$reportNull$$$0(3);
        }
        return this.executeQuery(rowHandler, sql, args.toArray(new Object[args.size()]));
    }

    /*
     * Exception decompiling
     */
    @NotNull
    public <E> List<E> executeQuery(@NotNull RowHandler<E> rowHandler, @NotNull String sql, Object ... args) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void closeQuietly(PreparedStatement ps) {
        if (ps != null && this.preparedStatementCache == null) {
            try {
                ps.close();
            }
            catch (Throwable e) {
                log.log(Level.WARNING, "Unable to close " + ps, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public <E> E executeQuerySingleRow(RowHandler<E> rowHandler, String sql, Object ... args) throws SQLException, IllegalArgumentException {
        Connection connection = this.obtainConnection();
        PreparedStatement ps = this.prepareStatement(connection, sql, args);
        try {
            ResultSet resultSet;
            long startTime;
            block14: {
                E e;
                startTime = System.currentTimeMillis();
                resultSet = ps.executeQuery();
                try {
                    if (resultSet.next()) break block14;
                    if (this.logLevel.intValue() >= Level.FINE.intValue()) {
                        log.log(Level.FINE, "No rows returned for " + ps);
                    }
                    e = null;
                }
                catch (Throwable throwable) {
                    try {
                        resultSet.close();
                        throw throwable;
                    }
                    catch (SQLException e2) {
                        SQLException sqle = new SQLException("Failed to execute SQL query " + sql + " with params " + Arrays.asList(args) + " on connection " + connection + "via thread " + Thread.currentThread().getName() + "\nError: " + e2.toString());
                        sqle.initCause(e2);
                        throw sqle;
                    }
                    catch (Error e3) {
                        log.log(Level.SEVERE, "Failed to execute SQL update " + sql + " with params " + Arrays.asList(args) + "\nError: " + e3.toString());
                        throw e3;
                    }
                }
                resultSet.close();
                return e;
            }
            E result = rowHandler.handle(resultSet);
            if (resultSet.next()) {
                log.log(Level.WARNING, "More than one row returned for " + ps);
            }
            if (log.isLoggable(this.logLevel)) {
                long duration = System.currentTimeMillis() - startTime;
                log.log(this.logLevel, "Executed query in " + duration + " milliseconds: " + sql + " with params " + Arrays.asList(args) + " on connection " + connection);
            }
            E e = result;
            resultSet.close();
            return e;
        }
        finally {
            this.closeQuietly(ps);
            connection.close();
        }
    }

    private Connection obtainConnection() throws SQLException {
        return this.dataSource.getConnection();
    }

    @NotNull
    public Integer executeQuerySingleInt(String sql, Object ... args) throws SQLException, IllegalArgumentException {
        Integer result = this.executeQuerySingleRow(new IntegerRowHandler(), sql, args);
        if (result == null) {
            throw new IllegalArgumentException("Null result for SQL: " + sql + " with args: " + Arrays.asList(args));
        }
        Integer n = result;
        if (n == null) {
            JDBCHelper.$$$reportNull$$$0(7);
        }
        return n;
    }

    @Nullable
    public Integer executeQuerySingleIntNullable(String sql, Object ... args) throws SQLException {
        return this.executeQuerySingleRow(new IntegerRowHandler(), sql, args);
    }

    @Nullable
    public Long executeQuerySingleLong(String sql, Object ... args) throws SQLException {
        return this.executeQuerySingleRow(new LongRowHandler(), sql, args);
    }

    @Nullable
    public String executeQuerySingleString(String sql, Object ... args) throws SQLException {
        return this.executeQuerySingleRow(new StringRowHandler(), sql, args);
    }

    public QueryData executeQueryRows(@NotNull String sql, Object ... args) throws SQLException {
        if (sql == null) {
            JDBCHelper.$$$reportNull$$$0(8);
        }
        final String[][] columnHeaders = new String[1][1];
        List<List<Object>> rows = this.executeQuery(new RowHandler<List<Object>>(){
            int columnCount = -1;

            @Override
            public List<Object> handle(ResultSet currentRow) throws SQLException {
                int i;
                if (this.columnCount == -1) {
                    ResultSetMetaData metaData = currentRow.getMetaData();
                    this.columnCount = metaData.getColumnCount();
                    columnHeaders[0] = new String[this.columnCount];
                    for (i = 0; i < columnHeaders[0].length; ++i) {
                        columnHeaders[0][i] = metaData.getColumnLabel(i + 1);
                    }
                }
                ArrayList<Object> arrayList = new ArrayList<Object>(this.columnCount);
                for (i = 0; i < this.columnCount; ++i) {
                    arrayList.add(currentRow.getObject(i + 1));
                }
                return arrayList;
            }
        }, sql, args);
        return new QueryData(columnHeaders[0], rows);
    }

    private PreparedStatement prepareStatement(Connection connection, String sql, Object[] args) throws SQLException {
        PreparedStatement ps = this.preparedStatementFor(connection, sql);
        try {
            JDBCUtils.populateArgs(ps, args);
            return ps;
        }
        catch (SQLException e) {
            ps.close();
            throw e;
        }
        catch (RuntimeException e) {
            ps.close();
            throw new RuntimeException(e);
        }
    }

    protected PreparedStatement preparedStatementFor(Connection connection, String sql) throws SQLException {
        PreparedStatement result;
        PreparedStatement preparedStatement = result = this.preparedStatementCache == null ? null : this.preparedStatementCache.get(sql);
        if (result == null) {
            int returnKeys = sql.toLowerCase().startsWith("select ") ? 2 : 1;
            result = connection.prepareStatement(sql, returnKeys);
            if (this.preparedStatementCache != null) {
                this.preparedStatementCache.put(sql, result);
            }
        }
        return result;
    }

    @NotNull
    public JDBCHelper withRangeModel(BoundedRangeModel rangeModel) {
        this.rangeModel = rangeModel;
        JDBCHelper jDBCHelper = this;
        if (jDBCHelper == null) {
            JDBCHelper.$$$reportNull$$$0(9);
        }
        return jDBCHelper;
    }

    public JDBCHelper withInitialCapacity(int initialCapacity) {
        this.initialCapacity = initialCapacity;
        return this;
    }

    public JDBCHelper withPreparedStatementCache(Map<String, PreparedStatement> cache) {
        this.preparedStatementCache = cache;
        return this;
    }

    @Nullable
    public Map<String, PreparedStatement> getPreparedStatementCache() {
        return this.preparedStatementCache;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rowHandler";
                break;
            }
            case 3: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sql";
                break;
            }
            case 6: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/prosc/database/JDBCHelper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/prosc/database/JDBCHelper";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "executeQuery";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "executeQuerySingleInt";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "withRangeModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "executeQuery";
                break;
            }
            case 6: 
            case 7: 
            case 9: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "executeQueryRows";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class LongRowHandler
    implements RowHandler<Long> {
        @Override
        public Long handle(ResultSet currentRow) throws SQLException {
            long result = currentRow.getLong(1);
            return currentRow.wasNull() ? null : Long.valueOf(result);
        }
    }

    public static class StringRowHandler
    implements RowHandler<String> {
        @Override
        public String handle(ResultSet currentRow) throws SQLException {
            return currentRow.getString(1);
        }
    }

    public static class IntegerRowHandler
    implements RowHandler<Integer> {
        @Override
        @Nullable
        public Integer handle(ResultSet currentRow) throws SQLException {
            int result = currentRow.getInt(1);
            return currentRow.wasNull() ? null : Integer.valueOf(result);
        }
    }

    public static final class NonClosingDataSource
    implements DataSource {
        final Connection connection;
        private PrintWriter logWriter;
        private Connection cachedConnection;

        public NonClosingDataSource(Connection connection) {
            this.connection = connection;
        }

        @Override
        public Connection getConnection() throws SQLException {
            if (this.cachedConnection == null) {
                this.cachedConnection = (Connection)Proxy.newProxyInstance(JDBCHelper.class.getClassLoader(), new Class[]{Connection.class}, new InvocationHandler(){

                    @Override
                    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                        if (method.getName().equals("close")) {
                            return null;
                        }
                        try {
                            return method.invoke((Object)connection, args);
                        }
                        catch (InvocationTargetException e) {
                            if (e.getCause() instanceof SQLException || e.getCause() instanceof RuntimeException) {
                                throw e.getCause();
                            }
                            throw new RuntimeException(e);
                        }
                    }
                });
            }
            return this.cachedConnection;
        }

        @Override
        public Connection getConnection(String username, String password) throws SQLException {
            throw new AbstractMethodError();
        }

        @Override
        public int getLoginTimeout() throws SQLException {
            return 0;
        }

        @Override
        public Logger getParentLogger() {
            return log;
        }

        @Override
        public PrintWriter getLogWriter() throws SQLException {
            return this.logWriter;
        }

        @Override
        public void setLoginTimeout(int seconds) throws SQLException {
        }

        @Override
        public void setLogWriter(PrintWriter out) throws SQLException {
            this.logWriter = out;
        }

        @Override
        public boolean isWrapperFor(Class<?> iface) throws SQLException {
            return false;
        }

        @Override
        public <T> T unwrap(Class<T> iface) throws SQLException {
            throw new AbstractMethodError();
        }
    }

    public static final class QueryData
    implements Serializable {
        final String[] columnNames;
        final List<List<Object>> rows;

        public QueryData(String[] columnNames, List<List<Object>> rows) {
            for (List<Object> row : rows) {
                if (row.size() == columnNames.length) continue;
                throw new IllegalArgumentException("Row contains " + rows.size() + " values, but columnNames contains " + columnNames.length + ": " + row);
            }
            this.columnNames = columnNames;
            this.rows = rows;
        }

        public String[] getColumnNames() {
            return this.columnNames;
        }

        public List<List<Object>> getRows() {
            return this.rows;
        }

        public TableModel toTableModel() {
            return new AbstractTableModel(){

                @Override
                public int getRowCount() {
                    return rows.size();
                }

                @Override
                public int getColumnCount() {
                    return columnNames.length;
                }

                @Override
                public Object getValueAt(int rowIndex, int columnIndex) {
                    return rows.get(rowIndex).get(columnIndex);
                }

                @Override
                public String getColumnName(int column) {
                    return columnNames[column];
                }
            };
        }

        public List<Map<String, Object>> toMaps() {
            LinkedHashMap<String, Integer> indexByName = new LinkedHashMap<String, Integer>();
            for (int i = 0; i < this.columnNames.length; ++i) {
                String columnName = this.columnNames[i];
                indexByName.put(columnName, i);
            }
            ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(this.rows.size());
            for (List<Object> eachRow : this.rows) {
                result.add(new RowMap(indexByName, eachRow));
            }
            return result;
        }

        public String toAscii() {
            int width;
            int i;
            int[] widths = new int[this.rows.get(0).size()];
            Boolean[] rightAlign = new Boolean[widths.length];
            for (int i2 = 0; i2 < widths.length; ++i2) {
                widths[i2] = Math.max(widths[i2], this.columnNames[i2].length());
            }
            for (List<Object> row : this.rows) {
                for (int i3 = 0; i3 < widths.length; ++i3) {
                    Object v = row.get(i3);
                    if (v == null) continue;
                    widths[i3] = Math.max(widths[i3], v.toString().length());
                    rightAlign[i3] = v instanceof Number;
                }
            }
            StringBuilder sb = new StringBuilder();
            for (i = 0; i < widths.length; ++i) {
                width = widths[i] + 2;
                sb.append('+');
                while (width-- > 0) {
                    sb.append('-');
                }
            }
            sb.append('+').append("\n");
            for (i = 0; i < widths.length; ++i) {
                width = widths[i];
                sb.append('|').append(' ');
                sb.append(String.format("%" + (Boolean.TRUE.equals(rightAlign[i]) ? "" : "-") + width + "s", this.columnNames[i]));
                sb.append(' ');
            }
            sb.append('|').append("\n");
            for (i = 0; i < widths.length; ++i) {
                width = widths[i] + 2;
                sb.append('+');
                while (width-- > 0) {
                    sb.append('-');
                }
            }
            sb.append('+').append("\n");
            for (List<Object> row : this.rows) {
                for (int i4 = 0; i4 < widths.length; ++i4) {
                    int width2 = widths[i4];
                    sb.append('|').append(' ');
                    Object v = row.get(i4);
                    v = v == null ? "" : v.toString();
                    sb.append(String.format("%" + (Boolean.TRUE.equals(rightAlign[i4]) ? "" : "-") + width2 + "s", v));
                    sb.append(' ');
                }
                sb.append('|').append("\n");
            }
            for (int i5 = 0; i5 < widths.length; ++i5) {
                int width3 = widths[i5] + 2;
                sb.append('+');
                while (width3-- > 0) {
                    sb.append('-');
                }
            }
            sb.append('+');
            return sb.toString();
        }

        public String toHtml() {
            return this.toHtml(null, null);
        }

        public String toHtml(@Nullable String id, @Nullable String className) {
            StringBuilder sb = new StringBuilder();
            sb.append("<table");
            if (!StringUtils.isEmpty(id)) {
                sb.append(" id=\"").append(id).append("\"");
            }
            if (!StringUtils.isEmpty(className)) {
                sb.append(" class=\"").append(className).append("\"");
            }
            sb.append("><thead>\n");
            sb.append("\t<tr>");
            for (String eachName : this.columnNames) {
                sb.append("<th>");
                StringUtils.escapeXMLString(eachName, sb);
                sb.append("</th>");
            }
            sb.append("</tr>\n");
            sb.append("</thead><tbody>\n");
            for (List list : this.rows) {
                sb.append("\t<tr>");
                for (Object eachValue : list) {
                    sb.append("<td>");
                    String s = eachValue == null ? "" : eachValue.toString();
                    StringUtils.escapeXMLString(s, sb);
                    sb.append("</td>");
                }
                sb.append("</tr>\n");
            }
            sb.append("</tbody></table>");
            return sb.toString();
        }

        public int sum(int columnIndex) {
            int sum = 0;
            for (List<Object> eachRow : this.rows) {
                Object o = eachRow.get(columnIndex);
                if (o instanceof Number) {
                    sum += ((Number)o).intValue();
                    continue;
                }
                if (o == null) continue;
                throw new IllegalArgumentException("Cannot sum non-numeric value '" + o + "' at columnIndex " + columnIndex + " (" + this.columnNames[columnIndex] + ")");
            }
            return sum;
        }

        public String getCSV() throws IOException {
            StringWriter writer = new StringWriter();
            new CSVWriter(writer).writeAll(this.toTableModel(), true);
            writer.close();
            return writer.toString();
        }

        public static final class RowMap
        implements Map<String, Object> {
            private LinkedHashMap<String, Integer> indexByName;
            private List<Object> values;

            public RowMap(LinkedHashMap<String, Integer> indexByName, List<Object> values) {
                this.indexByName = indexByName;
                this.values = values;
            }

            @Override
            public int hashCode() {
                return this.values.hashCode();
            }

            @Override
            public void clear() {
                throw new UnsupportedOperationException();
            }

            @Override
            public Object put(String key, Object value) {
                throw new UnsupportedOperationException();
            }

            @Override
            public Object remove(Object key) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void putAll(Map<? extends String, ? extends Object> m) {
                throw new UnsupportedOperationException();
            }

            @Override
            public int size() {
                return this.values.size();
            }

            @Override
            public Collection<Object> values() {
                return this.values;
            }

            @Override
            public Set<String> keySet() {
                return this.indexByName.keySet();
            }

            @Override
            public boolean isEmpty() {
                return this.size() == 0;
            }

            @Override
            public boolean containsKey(Object key) {
                return this.indexByName.containsKey(key);
            }

            @Override
            public boolean containsValue(Object value) {
                return this.values.contains(value);
            }

            @Override
            public Object get(Object key) {
                Integer index = this.indexByName.get(key);
                return index == null ? null : this.values.get(index);
            }

            @Override
            public Set<Map.Entry<String, Object>> entrySet() {
                LinkedHashSet<Map.Entry<String, Object>> result = new LinkedHashSet<Map.Entry<String, Object>>(this.size());
                for (Map.Entry<String, Integer> eachIndexEntry : this.indexByName.entrySet()) {
                    result.add(new SimpleImmutableEntry(eachIndexEntry.getKey(), this.values.get(eachIndexEntry.getValue())));
                }
                return result;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                RowMap rowMap = (RowMap)o;
                if (!this.indexByName.equals(rowMap.indexByName)) {
                    return false;
                }
                return this.values.equals(rowMap.values);
            }

            private static final class SimpleImmutableEntry
            implements Map.Entry<String, Object> {
                final String string;
                final Object object;

                private SimpleImmutableEntry(String string, Object object) {
                    this.string = string;
                    this.object = object;
                }

                @Override
                public String getKey() {
                    return this.string;
                }

                @Override
                public Object getValue() {
                    return this.object;
                }

                @Override
                public Object setValue(Object value) {
                    throw new UnsupportedOperationException();
                }
            }
        }
    }

    public static interface RowHandler<E> {
        @Nullable
        public E handle(ResultSet var1) throws SQLException;
    }
}

