/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.database;

import com.prosc.database.UrlBlob;
import com.prosc.io.FileType;
import com.prosc.io.FileTypes;
import com.prosc.shared.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlobAndMetaData2
implements Blob {
    private static final Logger log = Logger.getLogger(BlobAndMetaData2.class.getName());
    private Blob delegate;
    private final String filename;
    private String _md5hash;

    public BlobAndMetaData2(@NotNull Blob blob, @Nullable String filename, @Nullable String md5Hash) {
        block7: {
            if (blob == null) {
                BlobAndMetaData2.$$$reportNull$$$0(0);
            }
            this.delegate = blob;
            if (filename == null) {
                filename = "Untitled";
                try {
                    InputStream beginningStream;
                    if (blob.length() <= 0L) break block7;
                    log.info("Received untitled BLOB; will read the first 1K of data to guess its type");
                    try {
                        beginningStream = blob.getBinaryStream(1L, 1024L);
                    }
                    catch (SQLException e) {
                        beginningStream = blob.getBinaryStream();
                    }
                    FileType fileType = FileTypes.guessTypeFromContents(beginningStream);
                    filename = "Untitled." + fileType.getPrimaryExtension();
                    log.info("Guessed file name is " + filename);
                }
                catch (SQLException e) {
                    log.log(Level.WARNING, "Could not get BLOB stream to determine filename", e);
                }
                catch (IOException e) {
                    log.log(Level.WARNING, "Error reading BLOB data to determine filename", e);
                }
            }
        }
        this.filename = filename;
        this._md5hash = md5Hash;
    }

    public String getFilename() {
        return this.filename;
    }

    public int hashCode() {
        return this.getMd5Hash().hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String getMd5Hash() {
        block13: {
            if (this._md5hash == null) {
                if (this.delegate instanceof UrlBlob) {
                    this._md5hash = ((UrlBlob)this.delegate).getMd5hash();
                }
                if (this._md5hash == null) {
                    try {
                        if (this.delegate.length() == 0L) {
                            this._md5hash = "";
                            break block13;
                        }
                        log.log(Level.INFO, "Calculating MD5 for " + this.filename + "; length " + this.delegate.length());
                        MessageDigest md = MessageDigest.getInstance("MD5");
                        try (DigestInputStream dis = new DigestInputStream(this.delegate.getBinaryStream(), md);){
                            byte[] buffer = new byte[8192];
                            while (dis.read(buffer) != -1) {
                            }
                            byte[] digest = md.digest();
                            String tmpHash = "";
                            for (byte eachByte : digest) {
                                tmpHash = tmpHash + Integer.toString((eachByte & 0xFF) + 256, 16).substring(1);
                            }
                            this._md5hash = tmpHash;
                        }
                    }
                    catch (NoSuchAlgorithmException e) {
                        throw new RuntimeException(e);
                    }
                    catch (SQLException e) {
                        log.log(Level.WARNING, "Could not calculate MD5 hash for " + this, e);
                        this._md5hash = "";
                    }
                    catch (IOException e) {
                        log.log(Level.WARNING, "Could not calculate MD5 hash for " + this, e);
                        this._md5hash = "";
                    }
                }
            }
        }
        return this._md5hash;
    }

    public String toString() {
        return "Binary object '" + this.filename + "'";
    }

    public String toAuditableString() {
        String tmpHash = this.getMd5Hash();
        if (StringUtils.isEmpty(tmpHash)) {
            return "[Empty]";
        }
        return this.filename + " (" + tmpHash.toUpperCase() + ")";
    }

    @Override
    public long length() throws SQLException {
        return this.delegate.length();
    }

    @Override
    public byte[] getBytes(long pos, int length) throws SQLException {
        return this.delegate.getBytes(pos, length);
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        return this.delegate.getBinaryStream();
    }

    @Override
    public long position(byte[] pattern, long start) throws SQLException {
        return this.delegate.position(pattern, start);
    }

    @Override
    public long position(Blob pattern, long start) throws SQLException {
        return this.delegate.position(pattern, start);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int setBytes(long pos, byte[] bytes) throws SQLException {
        BlobAndMetaData2 blobAndMetaData2 = this;
        synchronized (blobAndMetaData2) {
            this._md5hash = null;
        }
        return this.delegate.setBytes(pos, bytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int setBytes(long pos, byte[] bytes, int offset, int len) throws SQLException {
        BlobAndMetaData2 blobAndMetaData2 = this;
        synchronized (blobAndMetaData2) {
            this._md5hash = null;
        }
        return this.delegate.setBytes(pos, bytes, offset, len);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OutputStream setBinaryStream(long pos) throws SQLException {
        BlobAndMetaData2 blobAndMetaData2 = this;
        synchronized (blobAndMetaData2) {
            this._md5hash = null;
        }
        return this.delegate.setBinaryStream(pos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void truncate(long len) throws SQLException {
        BlobAndMetaData2 blobAndMetaData2 = this;
        synchronized (blobAndMetaData2) {
            this._md5hash = null;
        }
        this.delegate.truncate(len);
    }

    @Override
    public void free() throws SQLException {
        if (this.delegate == null) {
            log.log(Level.WARNING, "This BLOB has already had free() called on it: " + this, new RuntimeException("Stack trace only"));
        } else {
            try {
                this.getMd5Hash();
            }
            catch (Throwable t) {
                log.log(Level.WARNING, "Could not generate MD5 hash in free(). Will continue with the rest of the free() implementation. " + this, t);
            }
            finally {
                this.delegate.free();
                this.delegate = null;
            }
        }
    }

    @Override
    public InputStream getBinaryStream(long pos, long length) throws SQLException {
        return this.delegate.getBinaryStream(pos, length);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "blob", "com/prosc/database/BlobAndMetaData2", "<init>"));
    }
}

