/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.thread;

import com.prosc.shared.ExceptionUtils;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jetbrains.annotations.NotNull;

public class ThreadUtil {
    private static final Logger log = Logger.getLogger(ThreadUtil.class.getName());

    public static Thread getThreadByName(@NotNull String name) {
        if (name == null) {
            ThreadUtil.$$$reportNull$$$0(0);
        }
        Thread returnThread = null;
        ThreadGroup topThreadGroup = null;
        for (ThreadGroup threadGroup = Thread.currentThread().getThreadGroup(); threadGroup != null; threadGroup = threadGroup.getParent()) {
            topThreadGroup = threadGroup;
        }
        if (topThreadGroup != null) {
            Thread[] threads = new Thread[topThreadGroup.activeCount()];
            topThreadGroup.enumerate(threads, true);
            for (Thread thread : threads) {
                if (!thread.getName().equals(name)) continue;
                returnThread = thread;
            }
        }
        return returnThread;
    }

    public static <T> T get(Future<T> future, boolean cancelOnInterrupt) {
        return ThreadUtil.get(future, cancelOnInterrupt, RuntimeException.class, RuntimeException.class, RuntimeException.class, RuntimeException.class, RuntimeException.class, RuntimeException.class);
    }

    public static <T, E1 extends Throwable> T get(Future<T> future, boolean cancelOnInterrupt, @NotNull Class<E1> exceptionClass1) throws E1 {
        if (exceptionClass1 == null) {
            ThreadUtil.$$$reportNull$$$0(1);
        }
        return ThreadUtil.get(future, cancelOnInterrupt, exceptionClass1, RuntimeException.class, RuntimeException.class, RuntimeException.class, RuntimeException.class, RuntimeException.class);
    }

    public static <T, E1 extends Throwable, E2 extends Throwable> T get(Future<T> future, boolean cancelOnInterrupt, @NotNull Class<E1> exceptionClass1, @NotNull Class<E2> exceptionClass2) throws E1, E2 {
        if (exceptionClass1 == null) {
            ThreadUtil.$$$reportNull$$$0(2);
        }
        if (exceptionClass2 == null) {
            ThreadUtil.$$$reportNull$$$0(3);
        }
        return ThreadUtil.get(future, cancelOnInterrupt, exceptionClass1, exceptionClass2, RuntimeException.class, RuntimeException.class, RuntimeException.class, RuntimeException.class);
    }

    public static <T, E1 extends Throwable, E2 extends Throwable, E3 extends Throwable> T get(Future<T> future, boolean cancelOnInterrupt, @NotNull Class<E1> exceptionClass1, @NotNull Class<E2> exceptionClass2, @NotNull Class<E3> exceptionClass3) throws E1, E2, E3 {
        if (exceptionClass1 == null) {
            ThreadUtil.$$$reportNull$$$0(4);
        }
        if (exceptionClass2 == null) {
            ThreadUtil.$$$reportNull$$$0(5);
        }
        if (exceptionClass3 == null) {
            ThreadUtil.$$$reportNull$$$0(6);
        }
        return ThreadUtil.get(future, cancelOnInterrupt, exceptionClass1, exceptionClass2, exceptionClass3, RuntimeException.class, RuntimeException.class, RuntimeException.class);
    }

    public static <T, E1 extends Throwable, E2 extends Throwable, E3 extends Throwable, E4 extends Throwable, E5 extends Throwable, E6 extends Throwable> T get(Future<T> future, boolean cancelOnInterrupt, @NotNull Class<E1> exceptionClass1, @NotNull Class<E2> exceptionClass2, @NotNull Class<E3> exceptionClass3, @NotNull Class<E4> exceptionClass4, @NotNull Class<E5> exceptionClass5, @NotNull Class<E6> exceptionClass6) throws E1, E2, E3, E4, E5, E6 {
        if (exceptionClass1 == null) {
            ThreadUtil.$$$reportNull$$$0(7);
        }
        if (exceptionClass2 == null) {
            ThreadUtil.$$$reportNull$$$0(8);
        }
        if (exceptionClass3 == null) {
            ThreadUtil.$$$reportNull$$$0(9);
        }
        if (exceptionClass4 == null) {
            ThreadUtil.$$$reportNull$$$0(10);
        }
        if (exceptionClass5 == null) {
            ThreadUtil.$$$reportNull$$$0(11);
        }
        if (exceptionClass6 == null) {
            ThreadUtil.$$$reportNull$$$0(12);
        }
        boolean isInterrupted = false;
        while (true) {
            try {
                T t = ThreadUtil.getInterruptible(future, exceptionClass1, exceptionClass2, exceptionClass3, exceptionClass4, exceptionClass5, exceptionClass6);
                return t;
            }
            catch (InterruptedException e) {
                Thread.interrupted();
                isInterrupted = true;
                if (cancelOnInterrupt) {
                    future.cancel(true);
                    log.log(Level.WARNING, "Thread " + Thread.currentThread().getName() + " was interrupted, sending cancellation request");
                    continue;
                }
                log.log(Level.WARNING, "Thread " + Thread.currentThread().getName() + " was interrupted, but will be ignored until task completes");
                continue;
            }
            break;
        }
        finally {
            if (isInterrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public static <T, E1 extends Throwable> T getInterruptible(Future<T> future, Class<E1> exceptionClass1) throws E1, InterruptedException {
        return ThreadUtil.getInterruptible(future, exceptionClass1, RuntimeException.class, RuntimeException.class, RuntimeException.class, RuntimeException.class, RuntimeException.class);
    }

    public static <T, E1 extends Throwable, E2 extends Throwable> T getInterruptible(Future<T> future, Class<E1> exceptionClass1, Class<E2> exceptionClass2) throws E1, E2, InterruptedException {
        return ThreadUtil.getInterruptible(future, exceptionClass1, exceptionClass2, RuntimeException.class, RuntimeException.class, RuntimeException.class, RuntimeException.class);
    }

    public static <T, E1 extends Throwable, E2 extends Throwable, E3 extends Throwable> T getInterruptible(Future<T> future, @NotNull Class<E1> exceptionClass1, @NotNull Class<E2> exceptionClass2, @NotNull Class<E3> exceptionClass3) throws E1, E2, E3, InterruptedException {
        if (exceptionClass1 == null) {
            ThreadUtil.$$$reportNull$$$0(13);
        }
        if (exceptionClass2 == null) {
            ThreadUtil.$$$reportNull$$$0(14);
        }
        if (exceptionClass3 == null) {
            ThreadUtil.$$$reportNull$$$0(15);
        }
        return ThreadUtil.getInterruptible(future, exceptionClass1, exceptionClass2, exceptionClass3, RuntimeException.class, RuntimeException.class, RuntimeException.class);
    }

    public static <T, E1 extends Throwable, E2 extends Throwable, E3 extends Throwable, E4 extends Throwable, E5 extends Throwable, E6 extends Throwable> T getInterruptible(Future<T> future, @NotNull Class<E1> exceptionClass1, @NotNull Class<E2> exceptionClass2, @NotNull Class<E3> exceptionClass3, @NotNull Class<E4> exceptionClass4, @NotNull Class<E5> exceptionClass5, @NotNull Class<E6> exceptionClass6) throws E1, E2, E3, E4, E5, E6, InterruptedException {
        if (exceptionClass1 == null) {
            ThreadUtil.$$$reportNull$$$0(16);
        }
        if (exceptionClass2 == null) {
            ThreadUtil.$$$reportNull$$$0(17);
        }
        if (exceptionClass3 == null) {
            ThreadUtil.$$$reportNull$$$0(18);
        }
        if (exceptionClass4 == null) {
            ThreadUtil.$$$reportNull$$$0(19);
        }
        if (exceptionClass5 == null) {
            ThreadUtil.$$$reportNull$$$0(20);
        }
        if (exceptionClass6 == null) {
            ThreadUtil.$$$reportNull$$$0(21);
        }
        if (future == null) {
            throw new IllegalArgumentException("Null future object was passed to ThreadUtil.getInterruptible()");
        }
        try {
            return future.get();
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (exceptionClass1.isAssignableFrom(cause.getClass())) {
                throw cause;
            }
            if (exceptionClass2.isAssignableFrom(cause.getClass())) {
                throw cause;
            }
            if (exceptionClass3.isAssignableFrom(cause.getClass())) {
                throw cause;
            }
            if (exceptionClass4.isAssignableFrom(cause.getClass())) {
                throw cause;
            }
            if (exceptionClass5.isAssignableFrom(cause.getClass())) {
                throw cause;
            }
            if (exceptionClass6.isAssignableFrom(cause.getClass())) {
                throw cause;
            }
            throw ExceptionUtils.rethrowUnchecked(e.getCause());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptionClass1";
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptionClass2";
                break;
            }
            case 6: 
            case 9: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptionClass3";
                break;
            }
            case 10: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptionClass4";
                break;
            }
            case 11: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptionClass5";
                break;
            }
            case 12: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptionClass6";
                break;
            }
        }
        objectArray2[1] = "com/prosc/thread/ThreadUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getThreadByName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "get";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[2] = "getInterruptible";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

