/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.shared;

import com.prosc.shared.CallableWithRetry;
import java.util.logging.Logger;

public class Retry<T, E extends Exception> {
    private static final Logger log = Logger.getLogger(Retry.class.getName());
    private int maxTries;
    private int startingDelayMilliseconds;

    public Retry(int maxTries, int startingDelayMilliseconds) {
        this.maxTries = maxTries;
        this.startingDelayMilliseconds = startingDelayMilliseconds;
    }

    public final T doTask(CallableWithRetry<T> callable, Class<E> expectedExceptionType) throws E {
        int delay = 0;
        int attempt = 1;
        while (true) {
            try {
                T result = callable.call(attempt, this.maxTries);
                if (attempt > 1) {
                    String attemptName = attempt == 2 ? "2nd" : (attempt == 3 ? "3rd" : String.valueOf(attempt) + "th");
                    log.info("Task succeeded on the " + attemptName + " attempt");
                }
                return result;
            }
            catch (Exception e) {
                try {
                    if (attempt < this.maxTries && expectedExceptionType.isAssignableFrom(e.getClass()) && this.shouldRetry(e)) {
                        delay = delay == 0 ? this.startingDelayMilliseconds : (delay *= 2);
                        log.info("Task failed; attempt #" + ++attempt + " will run in " + delay + " milliseconds. Exception: " + e.toString());
                        try {
                            Thread.sleep(delay);
                        }
                        catch (InterruptedException e1) {
                            Thread.currentThread().interrupt();
                            throw e;
                        }
                        continue;
                    }
                    throw e;
                }
                catch (Exception e2) {
                    if (expectedExceptionType.isAssignableFrom(e2.getClass())) {
                        throw e2;
                    }
                    if (e2 instanceof RuntimeException) {
                        throw (RuntimeException)e2;
                    }
                    throw new RuntimeException(e2);
                }
            }
            break;
        }
    }

    protected boolean shouldRetry(E e) {
        return true;
    }
}

