/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.shared;

import com.prosc.shared.ReflectionFieldException;
import java.lang.reflect.Field;
import org.jetbrains.annotations.NotNull;

public class ReflectionUtils {
    public static <E> E getFieldValue(@NotNull Object source, String ... fieldNames) throws ReflectionFieldException {
        if (source == null) {
            ReflectionUtils.$$$reportNull$$$0(0);
        }
        if (fieldNames == null) {
            ReflectionUtils.$$$reportNull$$$0(1);
        }
        StringBuilder errorMessage = new StringBuilder();
        Object currentSource = source;
        String delimiter = "";
        for (String fieldName : fieldNames) {
            Class<?> whichClass;
            Object instance;
            if (currentSource instanceof Class) {
                instance = null;
                whichClass = (Class<?>)currentSource;
            } else {
                instance = currentSource;
                whichClass = currentSource.getClass();
            }
            errorMessage.append(delimiter).append(whichClass.getName()).append(":").append(fieldName);
            delimiter = " -> ";
            NoSuchFieldException noSuchField = null;
            Class<?> whichSubclass = whichClass;
            while (whichClass != null) {
                try {
                    Field field = whichClass.getDeclaredField(fieldName);
                    field.setAccessible(true);
                    currentSource = field.get(instance);
                    noSuchField = null;
                    break;
                }
                catch (NoSuchFieldException e) {
                    if (noSuchField == null) {
                        noSuchField = e;
                    }
                    whichClass = whichClass.getSuperclass();
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }
            if (noSuchField == null) continue;
            throw new ReflectionFieldException(errorMessage.toString(), whichSubclass, fieldName, instance, noSuchField);
        }
        return (E)currentSource;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "source";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "fieldNames";
                break;
            }
        }
        objectArray[1] = "com/prosc/shared/ReflectionUtils";
        objectArray[2] = "getFieldValue";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

