/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.io;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Logger;

public class StreamReaderThread
extends Thread {
    private static final Logger log = Logger.getLogger(StreamReaderThread.class.getName());
    private final InputStream in;
    private final ByteArrayOutputStream out = new ByteArrayOutputStream();

    public StreamReaderThread(InputStream in) {
        this.in = in;
    }

    public StreamReaderThread(InputStream in, String name) {
        super(name);
        this.in = in;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        byte[] buffer = new byte[8192];
        try {
            int readSize;
            while ((readSize = this.in.read(buffer)) > 0) {
                if (Thread.currentThread().isInterrupted()) return;
                StreamReaderThread streamReaderThread = this;
                synchronized (streamReaderThread) {
                    this.receivedChunk(buffer, readSize);
                }
            }
            return;
        }
        catch (IOException e) {
            if (Thread.currentThread().isInterrupted()) {
                log.info("StreamReaderThread was interrupted; exiting");
                return;
            }
            if (!e.getMessage().contains("Stream closed")) throw new RuntimeException(e);
            log.info("StreamReaderThread was closed normally");
            return;
        }
    }

    protected void receivedChunk(byte[] buffer, int readSize) throws IOException {
        this.out.write(buffer, 0, readSize);
    }

    public synchronized byte[] getOutput() {
        return this.out.toByteArray();
    }
}

