/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.io;

import com.prosc.Platform;
import com.prosc.io.AwsUrlEncoder;
import com.prosc.io.HttpIOException;
import com.prosc.io.ProcessUtils;
import com.prosc.shared.CallableWithRetry;
import com.prosc.shared.Retry;
import com.prosc.thread.MyThreadFactory;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.security.Provider;
import java.security.Security;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Formatter;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sun.misc.BASE64Encoder;

public class IOUtils {
    private static final Logger log = Logger.getLogger(IOUtils.class.getName());
    public static final int CHUNK_SIZE = 8192;
    private static String encodingCharset = "utf-8";
    private static volatile ExecutorService downloadQueue = null;

    public static long writeInputToOutput(InputStream in, final OutputStream out, int bufferSize) throws IOException {
        int lastBytesRead;
        if (in == null) {
            throw new IllegalArgumentException("You cannot pass a null InputStream");
        }
        if (out == null) {
            throw new IllegalArgumentException("You cannot pass a null OutputStream");
        }
        final byte[] buffer = new byte[bufferSize];
        long totalBytesRead = 0L;
        while ((lastBytesRead = in.read(buffer)) != -1) {
            final int finalLastBytesRead = lastBytesRead;
            new Retry<Void, IOException>(3, 100){

                @Override
                protected boolean shouldRetry(IOException e) {
                    boolean result = "Error writing request body to server".equals(e.getMessage());
                    return result;
                }
            }.doTask(new CallableWithRetry<Void>(){

                @Override
                public Void call(int whichAttempt, int maxAttempts) throws Exception {
                    out.write(buffer, 0, finalLastBytesRead);
                    return null;
                }
            }, IOException.class);
            totalBytesRead += (long)lastBytesRead;
        }
        out.flush();
        return totalBytesRead;
    }

    public static long writeFixedByteCount(InputStream in, OutputStream out, long size) throws IOException {
        long nextChunk;
        long totalBytesRead;
        int bytesRead;
        byte[] buffer = new byte[Math.min(8192, (int)size)];
        for (totalBytesRead = 0L; totalBytesRead < size && (bytesRead = in.read(buffer, 0, (int)(nextChunk = Math.min(size - totalBytesRead, (long)buffer.length)))) != -1; totalBytesRead += (long)bytesRead) {
            out.write(buffer, 0, bytesRead);
        }
        return totalBytesRead;
    }

    public static long writeInputToOutput(InputStream in, OutputStream out, byte[] stopSequence) throws IOException {
        int eachByte;
        int result;
        int sequenceMark = 0;
        int sequenceLength = stopSequence.length;
        for (result = 0; sequenceMark < sequenceLength && result < 1600 && (eachByte = in.read()) != -1; ++result) {
            out.write(eachByte);
            if (eachByte == stopSequence[sequenceMark]) {
                ++sequenceMark;
                continue;
            }
            sequenceMark = 0;
        }
        return result;
    }

    public static byte[] inputStreamAsBytes(InputStream stream) throws IOException {
        if (stream == null) {
            throw new IllegalArgumentException("Null stream was passed to inputStreamAsBytes");
        }
        ByteArrayOutputStream allBytes = new ByteArrayOutputStream(stream.available());
        try {
            IOUtils.writeInputToOutput(stream, (OutputStream)allBytes, 8192);
        }
        finally {
            allBytes.close();
        }
        return allBytes.toByteArray();
    }

    @NotNull
    public static String inputStreamAsString(InputStream stream) throws IOException {
        String string = IOUtils.inputStreamAsString(stream, "utf-8");
        if (string == null) {
            IOUtils.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public static String inputStreamAsString(@NotNull InputStream stream, String charset) throws IOException {
        if (stream == null) {
            IOUtils.$$$reportNull$$$0(1);
        }
        String string = new String(IOUtils.inputStreamAsBytes(stream), charset);
        if (string == null) {
            IOUtils.$$$reportNull$$$0(2);
        }
        return string;
    }

    public static <T extends Appendable> T readerAsString(@Nullable Reader reader, @Nullable T toAppendTo) throws IOException {
        int charsRead;
        if (reader == null) {
            return null;
        }
        if (toAppendTo == null) {
            toAppendTo = new StringBuilder();
        }
        char[] buffer = new char[8192];
        while ((charsRead = reader.read(buffer)) != -1) {
            toAppendTo.append(new String(buffer, 0, charsRead));
        }
        return (T)toAppendTo;
    }

    public static String urlEncoded(String formatString, Object ... values) {
        Object[] encodedArgs = new Object[values.length];
        for (int i = 0; i < encodedArgs.length; ++i) {
            Object eachValue = values[i];
            encodedArgs[i] = eachValue == null ? "" : AwsUrlEncoder.encode(eachValue.toString()).replace("+", "%20");
        }
        return new Formatter().format(formatString, encodedArgs).toString();
    }

    public static String urlDecoded(@Nullable String string) throws UnsupportedEncodingException {
        return string == null ? null : URLDecoder.decode(string, "UTF-8");
    }

    @NotNull
    public static String urlConnectionAsString(URLConnection theConnection) throws IOException {
        InputStream theStream;
        try {
            theStream = theConnection.getInputStream();
        }
        catch (IOException e) {
            if (theConnection instanceof HttpURLConnection) {
                throw IOUtils.rethrowHttpException(e, (HttpURLConnection)theConnection);
            }
            throw e;
        }
        String string = IOUtils.inputStreamAsString(theStream);
        String string2 = string;
        if (string2 == null) {
            IOUtils.$$$reportNull$$$0(3);
        }
        return string2;
        finally {
            theStream.close();
        }
    }

    public static void postDataToUrlConnection(@NotNull String postArgs, URLConnection theConnection) throws IOException {
        if (postArgs == null) {
            IOUtils.$$$reportNull$$$0(4);
        }
        if (!theConnection.getDoOutput()) {
            theConnection.setDoOutput(true);
        }
        theConnection.setRequestProperty("content-length", "" + postArgs.length());
        PrintStream out = new PrintStream(theConnection.getOutputStream(), false, "utf-8");
        try {
            out.print(postArgs);
        }
        finally {
            IOUtils.closeQuietly(out);
        }
    }

    public static String getUrlContents(String theUrl) throws IOException {
        return IOUtils.getUrlContents(theUrl, null);
    }

    public static String getUrlContents(String theUrl, String postArgs) throws IOException {
        return IOUtils.getUrlContents(theUrl, postArgs, null);
    }

    public static String getUrlContents(String theUrl, @Nullable String postArgs, Integer timeout) throws IOException {
        log.log(Level.FINE, "Reading URL contents of " + theUrl + " postArgs size = " + (postArgs == null ? 0 : postArgs.length()));
        URLConnection theConnection = new URL(theUrl).openConnection();
        if (timeout != null) {
            theConnection.setConnectTimeout(timeout);
            theConnection.setReadTimeout(timeout);
        }
        if (postArgs != null) {
            IOUtils.postDataToUrlConnection(postArgs, theConnection);
        }
        return IOUtils.urlConnectionAsString(theConnection);
    }

    public static String getUrlContents(String theUrl, @Nullable String postArgs, Integer connectTimeout, Integer readTimeout) throws IOException {
        log.log(Level.FINE, "Reading URL contents of " + theUrl + " postArgs size = " + (postArgs == null ? 0 : postArgs.length()));
        URLConnection theConnection = new URL(theUrl).openConnection();
        if (connectTimeout != null) {
            theConnection.setConnectTimeout(connectTimeout);
        }
        if (readTimeout != null) {
            theConnection.setReadTimeout(readTimeout);
        }
        if (postArgs != null) {
            IOUtils.postDataToUrlConnection(postArgs, theConnection);
        }
        return IOUtils.urlConnectionAsString(theConnection);
    }

    public static void enableSSL() {
        System.setProperty("java.protocol.handler.pkgs", "com.sun.net.ssl.internal.www.protocol");
        try {
            Security.addProvider((Provider)Class.forName("com.sun.net.ssl.internal.ssl.Provider").newInstance());
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] fileAsBytes(String whichFile) throws IOException {
        return IOUtils.fileAsBytes(new File(whichFile));
    }

    public static byte[] fileAsBytes(File whichFile) throws IOException {
        log.log(Level.FINE, "Reading file contents " + whichFile);
        byte[] data = new byte[(int)whichFile.length()];
        FileInputStream in = new FileInputStream(whichFile);
        try {
            in.read(data);
        }
        finally {
            in.close();
        }
        return data;
    }

    public static String fileAsString(File whichFile) throws IOException {
        return IOUtils.fileAsString(whichFile, "UTF-8");
    }

    public static String fileAsString(File whichFile, String charset) throws IOException {
        return new String(IOUtils.fileAsBytes(whichFile), charset);
    }

    @NotNull
    public static synchronized File ensureUniqueFilename(File whichFile) {
        File file = IOUtils.ensureUniqueFilename(whichFile, true);
        if (file == null) {
            IOUtils.$$$reportNull$$$0(5);
        }
        return file;
    }

    public static synchronized File ensureUniqueFilename(File whichFile, boolean createEmptyFile) {
        block5: {
            block4: {
                if (!whichFile.exists()) break block4;
                int suffixMarker = whichFile.getName().lastIndexOf(46);
                String suffix = "";
                String prefix = whichFile.getPath();
                if (suffixMarker != -1) {
                    suffix = whichFile.getName().substring(suffixMarker);
                    prefix = whichFile.getParent() + File.separator + whichFile.getName().substring(0, suffixMarker);
                }
                int appendInt = 1;
                while (whichFile.exists()) {
                    whichFile = new File(prefix + '-' + appendInt + suffix);
                    ++appendInt;
                }
                break block5;
            }
            if (!createEmptyFile) break block5;
            try {
                whichFile.createNewFile();
            }
            catch (IOException e) {
                log.log(Level.SEVERE, "Could not create new empty file", e);
            }
        }
        return whichFile;
    }

    public static String getMimeType(String fileName) {
        if (fileName == null) {
            return null;
        }
        String mimeType = IOUtils.getExactMimeType(fileName);
        if (mimeType == null) {
            mimeType = "untyped/binary";
        }
        return mimeType;
    }

    public static String getExactMimeType(String fileName) {
        if (fileName == null) {
            return null;
        }
        String mimeType = URLConnection.getFileNameMap().getContentTypeFor(fileName);
        if (mimeType == null) {
            try {
                String suffix = fileName.substring(fileName.lastIndexOf(".") + 1).toLowerCase();
                if ("js".equals(suffix)) {
                    mimeType = "text/javascript";
                } else if ("tgz".equals(suffix)) {
                    mimeType = "application/x-tar";
                } else if ("css".equals(suffix)) {
                    mimeType = "text/css";
                } else if ("ico".equals(suffix)) {
                    mimeType = "image/x-icon";
                } else if ("sit".equals(suffix)) {
                    mimeType = "application/x-stuffit";
                } else if ("fdx".equals(suffix)) {
                    mimeType = "application/xml";
                } else if ("mp4".equals(suffix)) {
                    mimeType = "video/quicktime";
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return mimeType;
    }

    public static String urlEncodeMap(Map<String, ?> dict) {
        String urlString = "";
        Iterator<String> iterator = dict.keySet().iterator();
        while (iterator.hasNext()) {
            String aKey = iterator.next();
            Object anObject = dict.get(aKey);
            aKey = IOUtils.encode(aKey);
            if (anObject instanceof List) {
                Iterator en = ((List)anObject).iterator();
                while (en.hasNext()) {
                    String nextElement = (String)en.next();
                    urlString = urlString + aKey + "=" + IOUtils.encode(nextElement);
                    if (!en.hasNext()) continue;
                    urlString = urlString + "&";
                }
            } else {
                if (anObject == null) {
                    anObject = "";
                }
                urlString = urlString + aKey + "=" + IOUtils.encode(String.valueOf(anObject));
            }
            if (!iterator.hasNext()) continue;
            urlString = urlString + "&";
        }
        return urlString;
    }

    public static Map<String, String> urlDecodeToMap(String query) throws UnsupportedEncodingException {
        if (query == null) {
            return Collections.emptyMap();
        }
        Matcher matcher = Pattern.compile("[\\?&]?([^=&]+)(=([^&]*))?").matcher(query);
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        while (matcher.find()) {
            result.put(IOUtils.urlDecoded(matcher.group(1)), IOUtils.urlDecoded(matcher.group(3)));
        }
        return result;
    }

    public static String systemEncoding() {
        return encodingCharset;
    }

    public static String encode(String input) {
        if (input == null) {
            throw new IllegalArgumentException("You cannot provide a null input value to encode()");
        }
        return AwsUrlEncoder.encode(input);
    }

    public static String decode(String input) {
        try {
            return URLDecoder.decode(input, encodingCharset);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static void closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException e) {
                String msg = "Failed to close " + closeable;
                log.log(Level.WARNING, msg, e);
            }
        }
    }

    public static void closeQuietly(OutputStream outputStream) {
        if (outputStream != null) {
            try {
                outputStream.close();
            }
            catch (IOException e) {
                String msg = "Failed to close outputStream " + outputStream;
                log.log(Level.WARNING, msg, e);
            }
        } else {
            log.log(Level.INFO, "Received null outputStream");
        }
    }

    public static void closeQuietly(Reader reader) {
        if (reader != null) {
            try {
                reader.close();
            }
            catch (IOException e) {
                String msg = "Failed to close reader " + reader;
                log.log(Level.WARNING, msg, e);
            }
        } else {
            log.log(Level.INFO, "Received null reader");
        }
    }

    public static void closeQuietly(InputStream inputStream) {
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException e) {
                log.log(Level.WARNING, "Failed to close inputStream " + inputStream, e);
            }
        } else {
            log.log(Level.INFO, "Received null inputStream");
        }
    }

    public static void closeQuietly(Writer writer) {
        if (writer != null) {
            try {
                writer.close();
            }
            catch (IOException e) {
                log.log(Level.WARNING, "Failed to close writer " + writer, e);
            }
        } else {
            log.log(Level.INFO, "Received null writer");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File copyFile(File src, File dest) throws IOException {
        if (dest.isDirectory()) {
            dest = new File(dest, src.getName());
        }
        FileInputStream in = new FileInputStream(src);
        FileOutputStream out = new FileOutputStream(dest);
        try {
            IOUtils.writeInputToOutput((InputStream)in, (OutputStream)out, 8192);
        }
        finally {
            ((InputStream)in).close();
            ((OutputStream)out).close();
        }
        return dest;
    }

    public static void copyDirectory(File srcDir, File dstDir) throws IOException {
        if (srcDir.isDirectory()) {
            String[] children;
            if (!dstDir.exists() && !dstDir.mkdir()) {
                throw new IOException("Directory could not be copied because a destination directory could not be created: " + dstDir.getAbsolutePath());
            }
            for (String eachChild : children = srcDir.list()) {
                IOUtils.copyDirectory(new File(srcDir, eachChild), new File(dstDir, eachChild));
            }
        } else {
            IOUtils.copyFile(srcDir, dstDir);
        }
    }

    public static void closeQuietly(Socket socket) {
        if (socket != null) {
            try {
                socket.close();
            }
            catch (IOException e) {
                log.log(Level.WARNING, "Failed to close socket " + socket, e);
            }
        } else {
            log.log(Level.INFO, "Received null socket");
        }
    }

    public static void closeQuietly(ServerSocket socket) {
        if (socket != null) {
            try {
                socket.close();
            }
            catch (IOException e) {
                log.log(Level.WARNING, "Failed to close socket " + socket, e);
            }
        } else {
            log.log(Level.INFO, "Received null socket");
        }
    }

    public static long writeReaderToWriter(Reader reader, Writer writer) throws IOException {
        return IOUtils.writeReaderToWriter(reader, writer, new char[1024]);
    }

    public static long writeReaderToWriter(Reader reader, Writer writer, char[] buffer) throws IOException {
        int charsRead;
        int len = buffer.length;
        long totalChars = 0L;
        while ((charsRead = reader.read(buffer, 0, len)) > 0) {
            writer.write(buffer, 0, charsRead);
            totalChars += (long)charsRead;
        }
        return totalChars;
    }

    public static boolean deleteRecursive(File fileToDelete) {
        log.log(Level.CONFIG, "Deleting " + fileToDelete + " recursively");
        return IOUtils._deleteRecursive(fileToDelete);
    }

    private static boolean _deleteRecursive(File fileToDelete) {
        boolean b;
        if (!fileToDelete.exists()) {
            return true;
        }
        if (fileToDelete.isDirectory()) {
            File[] children = fileToDelete.listFiles();
            if (children == null) {
                log.log(Level.WARNING, "Could not get children for directory " + fileToDelete + "; returning false");
                return false;
            }
            for (File aChildren : children) {
                if (IOUtils._deleteRecursive(aChildren)) continue;
                return false;
            }
        }
        if (!(b = fileToDelete.delete())) {
            log.log(Level.WARNING, "Could not delete " + fileToDelete);
        }
        return b;
    }

    public static void zipDir(String dir2zip, String zipFileName) throws IOException {
        ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(zipFileName));
        try {
            IOUtils._zipDir(dir2zip, zos);
        }
        finally {
            zos.close();
        }
    }

    public static void _zipDir(String dir2zip, ZipOutputStream zos) throws IOException {
        File zipDir = new File(dir2zip);
        String[] dirList = zipDir.list();
        byte[] readBuffer = new byte[8192];
        for (int i = 0; i < dirList.length; ++i) {
            int bytesIn;
            File f = new File(zipDir, dirList[i]);
            if (f.isDirectory()) {
                String filePath = f.getPath();
                IOUtils._zipDir(filePath, zos);
                continue;
            }
            FileInputStream fis = new FileInputStream(f);
            ZipEntry anEntry = new ZipEntry(f.getPath());
            zos.putNextEntry(anEntry);
            while ((bytesIn = fis.read(readBuffer)) != -1) {
                zos.write(readBuffer, 0, bytesIn);
            }
            fis.close();
        }
    }

    public static void unzipDir(String file2unzip) throws IOException {
        ZipFile zipfile = new ZipFile(file2unzip);
        Enumeration<? extends ZipEntry> e = zipfile.entries();
        while (e.hasMoreElements()) {
            int count;
            ZipEntry entry = e.nextElement();
            log.info("Extracting: " + entry);
            BufferedInputStream is = new BufferedInputStream(zipfile.getInputStream(entry));
            byte[] data = new byte[8192];
            FileOutputStream fos = new FileOutputStream(entry.getName());
            BufferedOutputStream dest = new BufferedOutputStream(fos, 8192);
            while ((count = is.read(data, 0, 8192)) != -1) {
                dest.write(data, 0, count);
            }
            dest.flush();
            dest.close();
            is.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean unzipStream(ZipInputStream stream, File dir) throws IOException {
        ZipEntry eachEntry;
        boolean hasEntries = false;
        while ((eachEntry = stream.getNextEntry()) != null) {
            hasEntries = true;
            String entryName = eachEntry.getName();
            if (File.separatorChar == '/') {
                entryName = entryName.replace('\\', File.separatorChar);
            }
            File eachFile = new File(dir, entryName);
            if (eachEntry.isDirectory()) {
                eachFile.mkdirs();
            } else {
                eachFile.getParentFile().mkdirs();
                FileOutputStream outStream = new FileOutputStream(eachFile);
                try {
                    IOUtils.writeInputToOutput((InputStream)stream, (OutputStream)outStream, 8192);
                }
                finally {
                    outStream.close();
                }
            }
            if (eachEntry.getTime() == -1L) continue;
            eachFile.setLastModified(eachEntry.getTime());
        }
        return hasEntries;
    }

    public static void moveFile(File source, File dest) throws IOException {
        IOUtils.moveFile(source, dest, false);
    }

    public static void moveFile(@NotNull File source, @NotNull File dest, boolean overwriteDest) throws IOException {
        if (source == null) {
            IOUtils.$$$reportNull$$$0(6);
        }
        if (dest == null) {
            IOUtils.$$$reportNull$$$0(7);
        }
        if (dest.exists() && !overwriteDest) {
            throw new IOException("File already exists.  " + dest.getAbsolutePath() + " already exists.");
        }
        if (source.getCanonicalPath().equals(dest.getCanonicalPath())) {
            return;
        }
        if (!source.renameTo(dest)) {
            IOUtils.copyFile(source, dest);
            source.delete();
        }
    }

    public static boolean mkdirs(File dir) throws FileNotFoundException {
        File realParent;
        if (dir.exists()) {
            return false;
        }
        for (realParent = dir; realParent != null && !realParent.exists(); realParent = realParent.getParentFile()) {
        }
        if (realParent != null && "/Volumes".equals(realParent.getPath()) && Platform.current == Platform.mac) {
            throw new FileNotFoundException("You cannot create a directory in the /Volumes folder. This is reserved for mounted volumes.");
        }
        if (!dir.mkdirs()) {
            if (realParent != null && !realParent.canWrite()) {
                throw new FileNotFoundException("Directory " + dir.getAbsolutePath() + " could not be created because the parent directory " + realParent.getAbsolutePath() + " is not writeable for user '" + System.getProperty("user.name") + "'");
            }
            throw new FileNotFoundException("Directory " + dir.getAbsolutePath() + " could not be created because of an unknown error.");
        }
        return true;
    }

    public static IOException ioExceptionWithCause(IOException ioException, Throwable e) {
        if (e != null) {
            ioException.initCause(e);
        }
        return ioException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean areInputStreamsEqual(InputStream i1, InputStream i2) throws IOException {
        byte[] buf1 = new byte[8192];
        byte[] buf2 = new byte[8192];
        try {
            int len;
            DataInputStream d2 = new DataInputStream(i2);
            while ((len = i1.read(buf1)) > 0) {
                d2.readFully(buf2, 0, len);
                for (int i = 0; i < len; ++i) {
                    if (buf1[i] == buf2[i]) continue;
                    boolean bl = false;
                    return bl;
                }
            }
            boolean bl = d2.read() < 0;
            return bl;
        }
        catch (EOFException ioe) {
            boolean bl = false;
            return bl;
        }
        finally {
            i1.close();
            i2.close();
        }
    }

    public static File findWriteableTempDirectory() throws IOException {
        File result = new File(System.getProperty("java.io.tmpdir"));
        if (result.canWrite()) {
            return result;
        }
        File file = result = Platform.current == Platform.windows ? new File("C:\\Windows\\TEMP") : new File("/tmp/");
        if (result.canWrite()) {
            return result;
        }
        return IOUtils.findWriteablePersistentDirectory(false);
    }

    public static File findWriteablePersistentDirectory(boolean preferUserDir) throws IOException {
        File result;
        if (preferUserDir) {
            result = IOUtils.findWriteablePersistentUserDirectory();
            if (result == null) {
                result = IOUtils.findWriteablePersistentSystemDirectory();
            }
        } else {
            result = IOUtils.findWriteablePersistentSystemDirectory();
            if (result == null) {
                result = IOUtils.findWriteablePersistentUserDirectory();
            }
        }
        if (result != null) {
            return result;
        }
        throw new IOException("Could not find a writeable directory");
    }

    private static File findWriteablePersistentSystemDirectory() {
        File result = null;
        if (Platform.current == Platform.mac) {
            result = new File("/Library/Application Support/360Works");
        } else if (Platform.current != Platform.windows) {
            if (Platform.current == Platform.linux) {
                result = new File("/var/lib/360Works");
            } else {
                log.log(Level.WARNING, "Unsupported platform: " + (Object)((Object)Platform.current));
            }
        }
        if (result != null) {
            try {
                IOUtils.ensureDirectoryIsReady(result);
            }
            catch (FileNotFoundException e) {
                log.log(Level.WARNING, "Could not find writeable system directory", e);
                result = null;
            }
        }
        return result;
    }

    private static File findWriteablePersistentUserDirectory() {
        File result = new File(System.getProperty("user.home"));
        if (result.canWrite()) {
            return result;
        }
        return null;
    }

    public static void ensureDirectoryIsReady(File targetDir) throws FileNotFoundException {
        IOUtils.ensureDirectoryIsReady(targetDir, false);
    }

    public static void ensureDirectoryIsReady(File targetDir, boolean writeableForAll) throws FileNotFoundException {
        block11: {
            if (targetDir == null) {
                throw new IllegalArgumentException("Null value");
            }
            while (targetDir.exists()) {
                if (targetDir.isDirectory()) {
                    if (!targetDir.canRead()) {
                        throw new FileNotFoundException("There is an existing directory at " + targetDir + ", but it is not readable.");
                    }
                    if (!targetDir.canWrite()) {
                        throw new FileNotFoundException("There is an existing directory at " + targetDir + ", but it is not writeable.");
                    }
                    break block11;
                }
                log.warning("Deleting file at " + targetDir + " to allow creation of directory at that location");
                if (targetDir.delete()) continue;
                throw new FileNotFoundException("An existing file at " + targetDir + " could not be deleted; the directory cannot be created.");
            }
            if (targetDir.mkdirs()) {
                log.log(Level.CONFIG, "successfully created '" + targetDir.getAbsolutePath() + "'");
            } else {
                String message = "The directory at " + targetDir.getAbsolutePath() + " does not exist and cannot be created.";
                File currentDir = targetDir;
                while ((currentDir = currentDir.getParentFile()) != null) {
                    if (!currentDir.exists() || currentDir.canWrite()) continue;
                    message = message + " This is because a parent directory at " + currentDir + " is not writeable.";
                    break;
                }
                throw new FileNotFoundException(message);
            }
        }
        if (writeableForAll && Platform.isMac()) {
            try {
                ProcessUtils.doShellCommand(new String[]{"/bin/chmod", "-R", "777", targetDir.getAbsolutePath()}, null, null);
            }
            catch (Exception e) {
                log.log(Level.WARNING, "Directory exists at " + targetDir.getAbsolutePath() + ", but it could not be changed to allow access for all users.", e);
            }
        }
    }

    public static void ensureFileIsReady(File file, boolean readable, boolean writeable) throws IOException {
        if (file.exists()) {
            if (file.isDirectory()) {
                throw new IOException("A directory already exists at " + file.getAbsolutePath() + " so no file can be created at that path.");
            }
            if (readable && !file.canRead()) {
                throw new IOException("File already exists at " + file.getAbsolutePath() + ", but it is not readable.");
            }
            if (writeable && !file.canWrite()) {
                throw new IOException("File already exists at " + file.getAbsolutePath() + ", but it is not writeable.");
            }
        } else if (!file.getParentFile().exists()) {
            IOUtils.ensureDirectoryIsReady(file.getParentFile());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpIOException rethrowHttpException(IOException e, HttpURLConnection connection) throws HttpIOException {
        String newMessage;
        int responseCode;
        InputStream errStream = connection.getErrorStream();
        try {
            responseCode = connection.getResponseCode();
        }
        catch (IOException e1) {
            responseCode = -1;
        }
        if (errStream == null) {
            throw new HttpIOException(e, connection.getURL(), null, responseCode, connection.getHeaderFields());
        }
        String errorString = null;
        try {
            errorString = IOUtils.inputStreamAsString(errStream);
            newMessage = e.getMessage() + ". HTTP Server message: " + errorString;
        }
        catch (IOException e1) {
            log.log(Level.SEVERE, "Could not read error stream from HTTP server", e1);
            newMessage = e.getMessage();
        }
        finally {
            IOUtils.closeQuietly(errStream);
        }
        HttpIOException rethrow = new HttpIOException(newMessage, connection.getURL(), errorString, responseCode, connection.getHeaderFields());
        rethrow.initCause(e);
        throw rethrow;
    }

    public static void setRequestAuthentication(URLConnection connection, String username, String password) {
        try {
            String encodedAuth = new BASE64Encoder().encode((username + ":" + password).getBytes("utf-8"));
            encodedAuth = encodedAuth.replace("\n", "");
            connection.addRequestProperty("Authorization", "Basic " + encodedAuth);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static URL toUrl(String url) {
        try {
            return new URL(url);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public static URL toUrl(File file) {
        try {
            return file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public static void openConnectionInterruptibly(final HttpURLConnection urlConnection) throws InterruptedException, IOException {
        if (downloadQueue == null) {
            downloadQueue = Executors.newCachedThreadPool(new MyThreadFactory("Interruptible URL connection"){

                @Override
                public Thread newThread(Runnable r) {
                    Thread result = super.newThread(r);
                    result.setDaemon(true);
                    return result;
                }
            });
        }
        Future<Void> future = downloadQueue.submit(new Callable<Void>(){

            @Override
            public Void call() throws IOException {
                urlConnection.getInputStream();
                return null;
            }
        });
        try {
            future.get();
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            if (e.getCause() instanceof Error) {
                throw (Error)e.getCause();
            }
            throw new RuntimeException(e);
        }
    }

    public static String resourceAsString(Class<?> contextClass, String resourceName) throws IOException {
        URL resource = contextClass.getResource(resourceName);
        if (resource == null) {
            throw new IllegalArgumentException("There is no resource named '" + resourceName + "' associated with class '" + contextClass.getName() + "'");
        }
        return IOUtils.urlConnectionAsString(resource.openConnection());
    }

    public static String safeFilename(String filename) {
        String result = filename.replace('/', '_').replace('\\', '_');
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/prosc/io/IOUtils";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "postArgs";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dest";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "inputStreamAsString";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/prosc/io/IOUtils";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "urlConnectionAsString";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "ensureUniqueFilename";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "inputStreamAsString";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "postDataToUrlConnection";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "moveFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

