/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Iterator;
import java.util.LinkedList;

public class DelimitedReader {
    private String quoteChar = "\"";
    private char[] rowDelimiterArray;
    private char[] columnDelimiterArray;
    private int rowDelimLength;
    private int columnDelimLength;
    private Reader source;

    public DelimitedReader(String rowDelimiter, String columnDelimiter) {
        this.rowDelimiterArray = rowDelimiter.toCharArray();
        this.rowDelimLength = this.rowDelimiterArray.length;
        if (columnDelimiter == null) {
            this.columnDelimiterArray = new char[1];
            this.columnDelimLength = -1;
        } else {
            this.columnDelimiterArray = columnDelimiter.toCharArray();
            this.columnDelimLength = this.columnDelimiterArray.length;
        }
    }

    public void setQuoteChar(String quoteChar) {
        this.quoteChar = quoteChar;
    }

    public Iterator getRows(Reader reader) {
        this.source = reader;
        if (!(this.source instanceof BufferedReader)) {
            this.source = new BufferedReader(this.source);
        }
        return new RowIterator((BufferedReader)this.source);
    }

    private class RowIterator
    implements Iterator {
        private BufferedReader source;
        private StringBuffer currentCell = new StringBuffer();
        private int rowDelimMark = 0;
        private int columnDelimMark = 0;
        private boolean reachedEnd = false;

        private RowIterator(BufferedReader source) {
            this.source = source;
        }

        @Override
        public boolean hasNext() {
            boolean result = true;
            try {
                if (this.reachedEnd) {
                    result = false;
                } else if (this.currentCell.length() == 0) {
                    int nextChar = this.source.read();
                    if (nextChar == -1) {
                        result = false;
                    } else {
                        this.currentCell.append((char)nextChar);
                        this.columnDelimMark = nextChar == DelimitedReader.this.columnDelimiterArray[this.columnDelimMark] ? ++this.columnDelimMark : 0;
                        this.rowDelimMark = nextChar == DelimitedReader.this.rowDelimiterArray[this.rowDelimMark] ? ++this.rowDelimMark : 0;
                    }
                }
                if (!result) {
                    this.source.close();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return result;
        }

        public Object next() {
            try {
                LinkedList<String> cells = new LinkedList<String>();
                while (this.rowDelimMark != DelimitedReader.this.rowDelimLength) {
                    if (this.columnDelimMark != DelimitedReader.this.columnDelimLength) {
                        int nextChar = this.source.read();
                        if (nextChar == -1) {
                            this.reachedEnd = true;
                            break;
                        }
                        this.currentCell.append((char)nextChar);
                        this.columnDelimMark = nextChar == DelimitedReader.this.columnDelimiterArray[this.columnDelimMark] ? ++this.columnDelimMark : 0;
                        if (nextChar == DelimitedReader.this.rowDelimiterArray[this.rowDelimMark]) {
                            ++this.rowDelimMark;
                            continue;
                        }
                        this.rowDelimMark = 0;
                        continue;
                    }
                    cells.add(this.currentCell.substring(0, this.currentCell.length() - DelimitedReader.this.columnDelimLength));
                    this.currentCell.delete(0, this.currentCell.length());
                    this.columnDelimMark = 0;
                    this.rowDelimMark = 0;
                }
                cells.add(this.currentCell.substring(0, this.currentCell.length() - DelimitedReader.this.rowDelimLength));
                this.currentCell.delete(0, this.currentCell.length());
                this.columnDelimMark = 0;
                this.rowDelimMark = 0;
                return cells;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("You cannot remove from this Iterator");
        }
    }
}

