/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.fmkit;

import com.prosc.fmkit.Plugin;
import com.prosc.fmkit.PluginBridge2;
import com.prosc.fmkit.PluginContext;
import com.prosc.fmkit.PluginFunction;
import com.prosc.fmkit.types.Converter;
import com.prosc.fmkit.types.FMData;
import com.prosc.fmkit.types.FMText;
import com.prosc.fmkit.types.FMType;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class StaticFunction
implements PluginFunction {
    private Method targetMethod;
    private Class<?>[] paramClasses;
    private Converter[] paramConverters;
    private int argCount;
    private String prototype;
    private String name = "";
    private int calcFunctionFlags = 65280;
    private int scriptStepFlags = 110;
    private String[] typeAheadList;
    private String description;
    private static final Logger log = Logger.getLogger(StaticFunction.class.getName());
    private Integer minArgs;
    private int maxArgs;
    private int timeoutSeconds;

    StaticFunction(Method methodToTrigger, PluginBridge2 pluginBridge) throws FMType.UnsupportedTypeConversionException {
        Class<?> lastParamType;
        this.targetMethod = methodToTrigger;
        this.paramClasses = this.targetMethod.getParameterTypes();
        this.maxArgs = this.argCount = this.paramClasses.length;
        if (this.paramClasses.length >= 1 && (lastParamType = this.paramClasses[this.paramClasses.length - 1]).isArray()) {
            this.maxArgs = -1;
            this.paramClasses[this.paramClasses.length - 1] = lastParamType.getComponentType();
        }
        this.paramConverters = new Converter[this.argCount];
        for (int n = 0; n < this.argCount; ++n) {
            Class<?> fmTypeClass = this.paramClasses[n];
            if (fmTypeClass.isArray()) {
                fmTypeClass = fmTypeClass.getComponentType();
            }
            this.paramConverters[n] = fmTypeClass.isEnum() ? new FMText.EnumConverter(fmTypeClass) : FMType.converterForClass(fmTypeClass);
        }
        this.setName(this.targetMethod.getName());
        StringBuffer buffer = new StringBuffer(30);
        for (int n = 0; n < this.argCount; ++n) {
            String className;
            int mark;
            if (n != 0) {
                buffer.append(" ; ");
            }
            if ((mark = (className = this.paramClasses[n].getName()).lastIndexOf(46)) != -1) {
                className = className.substring(mark + 1);
            }
            buffer.append(className);
        }
        this.prototype = buffer.toString();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getPrototype() {
        return this.prototype;
    }

    public final void setPrototype(String prototype) {
        this.prototype = prototype;
    }

    @Override
    public int getMinArgs() {
        return this.minArgs == null ? this.maxArgs : this.minArgs;
    }

    public void setMinArgs(Integer minArgs) {
        this.minArgs = minArgs;
    }

    @Override
    public int getMaxArgs() {
        return this.maxArgs;
    }

    @Override
    public int getCalculationFunctionFlags(PluginContext context) {
        return this.calcFunctionFlags;
    }

    @Override
    public int getScriptStepFlags(PluginContext context) {
        return this.scriptStepFlags;
    }

    @Override
    public String[] getTypeAheadList() {
        return this.typeAheadList == null ? this.getName().replace("_", "").split("(?<!(^|[A-Z]))(?=[A-Z])|(?<!^)(?=[A-Z][a-z])") : this.typeAheadList;
    }

    public void setTypeAheadList(String[] typeAheadList) {
        this.typeAheadList = typeAheadList;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public final void setCalcFunctionFlags(int calcFunctionFlags) {
        this.calcFunctionFlags = calcFunctionFlags;
    }

    public final Method getTargetMethod() {
        return this.targetMethod;
    }

    @Override
    public void setEnumStartingIndex(int whichParam, int startingIndex) {
        FMText.EnumConverter converter = (FMText.EnumConverter)this.paramConverters[whichParam];
        converter.setStartingIndex(startingIndex);
    }

    @Override
    public Object[] convertParams(FMData[] rawParams, PluginContext pluginContext) {
        Object[] parameters = new Object[this.argCount];
        if (this.maxArgs == -1) {
            Converter converter;
            Class<?> paramClass;
            int n;
            for (n = 0; n < this.argCount - 1; ++n) {
                paramClass = this.paramClasses[n];
                if (n < rawParams.length) {
                    Converter converter2;
                    FMData rawParam = rawParams[n];
                    try {
                        converter2 = this.paramConverters[n];
                    }
                    catch (IndexOutOfBoundsException e) {
                        log.log(Level.WARNING, "error in convertParams", e);
                        throw new IllegalArgumentException(this.toString() + " Expected " + this.argCount + " parameters, but received " + rawParams.length);
                    }
                    parameters[n] = converter2.convertData(rawParam, paramClass, pluginContext);
                    continue;
                }
                parameters[n] = null;
            }
            paramClass = this.paramClasses[n];
            try {
                converter = this.paramConverters[n];
            }
            catch (IndexOutOfBoundsException e) {
                log.log(Level.WARNING, "error in convertParams", e);
                throw new IllegalArgumentException(this.toString() + " Expected " + this.argCount + " parameters, but received " + rawParams.length);
            }
            int optionalParamCount = rawParams.length - n;
            if (optionalParamCount > 0) {
                Object[] optionalParams = (Object[])Array.newInstance(paramClass, optionalParamCount);
                int destIndex = 0;
                while (n < rawParams.length) {
                    FMData rawParam = rawParams[n];
                    optionalParams[destIndex] = converter.convertData(rawParam, paramClass, pluginContext);
                    ++destIndex;
                    ++n;
                }
                parameters[this.argCount - 1] = optionalParams;
            }
        } else {
            for (int n = 0; n < this.argCount; ++n) {
                Class<?> paramClass = this.paramClasses[n];
                if (n < rawParams.length) {
                    Converter converter;
                    FMData rawParam = rawParams[n];
                    try {
                        converter = this.paramConverters[n];
                    }
                    catch (IndexOutOfBoundsException e) {
                        log.log(Level.WARNING, "error in convertParams", e);
                        throw new IllegalArgumentException(this.toString() + " Expected " + this.argCount + " parameters, but received " + rawParams.length);
                    }
                    parameters[n] = converter.convertData(rawParam, paramClass, pluginContext);
                    continue;
                }
                parameters[n] = this.defaultClassValue(paramClass);
            }
        }
        return parameters;
    }

    @Override
    public Object invoke(Plugin pluginInstance, Object[] parameters) throws IllegalAccessException, InvocationTargetException {
        try {
            try {
                return this.targetMethod.invoke((Object)pluginInstance, parameters);
            }
            catch (InvocationTargetException e) {
                if (e.getCause() instanceof IllegalArgumentException) {
                    throw (IllegalArgumentException)e.getCause();
                }
                throw e;
            }
        }
        catch (IllegalArgumentException e) {
            String prefix = "Argument for @NotNull parameter '";
            if (e.getMessage().startsWith(prefix)) {
                String paramJavaName = e.getMessage().substring(prefix.length());
                paramJavaName = paramJavaName.substring(0, paramJavaName.indexOf("'"));
                throw new IllegalArgumentException("When calling the plug-in function '" + this.name + "', a non-empty value must be supplied for the parameter named '" + paramJavaName + "'");
            }
            log.log(Level.SEVERE, "Make sure that PRIMITIVE TYPES ARE NOT USED AS OPTIONAL PARAMS");
            Class<?>[] targetTypes = this.targetMethod.getParameterTypes();
            if (targetTypes.length != parameters.length) {
                log.log(Level.SEVERE, "There were " + parameters.length + " parameters; but function expects " + targetTypes.length + " values");
            }
            StringBuilder sb = new StringBuilder();
            int n = 0;
            for (Object parameter : parameters) {
                Class<?> targetClass;
                Class paramClass = parameter == null ? Void.class : parameter.getClass();
                if ((targetClass = targetTypes[n++]).isAssignableFrom(paramClass)) {
                    log.severe("param class " + n + " is " + paramClass + " (classloader " + paramClass.getClassLoader() + "), which cannot be assigned to target class " + targetClass + "(classloader " + targetClass.getClassLoader() + ")");
                }
                sb.append(paramClass).append(" / ").append(targetClass);
            }
            log.severe("Param classes / target classes:\n" + sb.toString());
            throw e;
        }
    }

    @Override
    public Method getJavaMethod() {
        return this.targetMethod;
    }

    private Object defaultClassValue(Class<?> paramClass) {
        if (!paramClass.isPrimitive()) {
            return null;
        }
        if (paramClass == Boolean.TYPE) {
            return Boolean.FALSE;
        }
        if (paramClass == Byte.TYPE) {
            return (byte)0;
        }
        if (paramClass == Character.TYPE) {
            return Character.valueOf('\u0000');
        }
        if (paramClass == Short.TYPE) {
            return (short)0;
        }
        if (paramClass == Integer.TYPE) {
            return 0;
        }
        if (paramClass == Long.TYPE) {
            return 0L;
        }
        if (paramClass == Float.TYPE) {
            return Float.valueOf(0.0f);
        }
        if (paramClass == Double.TYPE) {
            return 0.0;
        }
        throw new RuntimeException("Unknown primitive type '" + paramClass + "'");
    }

    public String toString() {
        return "PluginFunction{name='" + this.name + "'" + ", minArgs=" + this.minArgs + ", maxArgs=" + this.maxArgs + "}";
    }

    public void setTimeoutSeconds(int timeoutSeconds) {
        this.timeoutSeconds = timeoutSeconds;
    }

    public int getTimeoutSeconds() {
        return this.timeoutSeconds;
    }
}

