/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.fmkit;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class SearchAndReplace {
    public static final int PLACEHOLDER_LENGTH = 22;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addWindowsVersionInfo(File file, String pluginVersion) throws IOException {
        byte[] data = new byte[(int)file.length()];
        try (FileInputStream istream = null;){
            istream = new FileInputStream(file);
            if (((InputStream)istream).read(data) == -1) {
                throw new IOException("EOF reached while reading file.");
            }
        }
        String fileVersion = "\u0000F\u0000i\u0000l\u0000e\u0000V\u0000e\u0000r\u0000s\u0000i\u0000o\u0000n\u0000\u0000\u0000\u0000";
        int x = SearchAndReplace.indexOf(data, fileVersion.getBytes());
        if (x != -1) {
            byte[] replaceString = SearchAndReplace.toUni(pluginVersion);
            for (int i = 0; i < replaceString.length; ++i) {
                data[i + x + fileVersion.length()] = replaceString[i];
            }
            try (FileOutputStream ostream = null;){
                ostream = new FileOutputStream(file);
                ostream.write(data);
            }
        }
    }

    private static int indexOf(byte[] data, byte[] pattern) {
        int[] failure = SearchAndReplace.computeFailure(pattern);
        int j = 0;
        if (data.length == 0) {
            return -1;
        }
        for (int i = 0; i < data.length; ++i) {
            while (j > 0 && pattern[j] != data[i]) {
                j = failure[j - 1];
            }
            if (pattern[j] == data[i]) {
                ++j;
            }
            if (j != pattern.length) continue;
            return i - pattern.length + 1;
        }
        return -1;
    }

    private static int[] computeFailure(byte[] pattern) {
        int[] failure = new int[pattern.length];
        int j = 0;
        for (int i = 1; i < pattern.length; ++i) {
            while (j > 0 && pattern[j] != pattern[i]) {
                j = failure[j - 1];
            }
            if (pattern[j] == pattern[i]) {
                // empty if block
            }
            failure[i] = ++j;
        }
        return failure;
    }

    private static byte[] toUni(String str) {
        str = str.replaceAll("(?=[0-9a-zA-Z\\.])", "\u0000");
        while (str.length() < 22) {
            str = str + "\u0000";
        }
        return str.getBytes();
    }
}

