/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.fmkit;

import com.prosc.fmkit.CloseableJarFileWrapper;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Proxy;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import sun.misc.URLClassPath;
import sun.net.www.protocol.file.FileURLConnection;

public class ParentLastURLClassLoader
extends ClassLoader
implements Closeable {
    public static final Logger log = Logger.getLogger(ParentLastURLClassLoader.class.getName());
    private ChildURLClassLoader childClassLoader;

    protected void finalize() throws Throwable {
        super.finalize();
        log.info("Finalizing " + ParentLastURLClassLoader.class.getName());
    }

    @Override
    public void close() throws IOException {
        this.childClassLoader.close();
    }

    public ParentLastURLClassLoader(URL[] urls, ClassLoader parent) {
        super(parent);
        this.childClassLoader = new ChildURLClassLoader(urls, new FindClassClassLoader(this.getParent()));
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        try {
            return this.childClassLoader.findClass(name);
        }
        catch (ClassNotFoundException e) {
            return super.loadClass(name, resolve);
        }
    }

    private static class ChildURLClassLoader
    extends URLClassLoader
    implements Closeable {
        private FindClassClassLoader realParent;
        private final WeakHashMap<Closeable, Void> closeables = new WeakHashMap();

        public ChildURLClassLoader(URL[] urls, FindClassClassLoader realParent) {
            super(urls, (ClassLoader)null);
            this.realParent = realParent;
        }

        protected void finalize() throws Throwable {
            super.finalize();
            log.info("Finalizing " + ChildURLClassLoader.class.getName());
        }

        @Override
        public Class<?> findClass(String name) throws ClassNotFoundException {
            try {
                Class<?> loaded = super.findLoadedClass(name);
                if (loaded != null) {
                    return loaded;
                }
                return super.findClass(name);
            }
            catch (ClassNotFoundException e) {
                return this.realParent.loadClass(name);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public InputStream getResourceAsStream(String name) {
            log.info("Getting plugin resource " + name);
            URL url = this.getResource(name);
            try {
                if (url == null) {
                    return null;
                }
                URLConnection urlc = url.openConnection();
                InputStream is = urlc.getInputStream();
                if (urlc instanceof JarURLConnection) {
                    JarURLConnection juc = (JarURLConnection)urlc;
                    JarFile jar = juc.getJarFile();
                    CloseableJarFileWrapper closeableJarFileWrapper = new CloseableJarFileWrapper(jar);
                    WeakHashMap<Closeable, Void> weakHashMap = this.closeables;
                    synchronized (weakHashMap) {
                        if (!this.closeables.containsKey(closeableJarFileWrapper)) {
                            this.closeables.put(closeableJarFileWrapper, null);
                        }
                    }
                }
                if (urlc instanceof FileURLConnection) {
                    WeakHashMap<Closeable, Void> weakHashMap = this.closeables;
                    synchronized (weakHashMap) {
                        this.closeables.put(is, null);
                    }
                }
                return is;
            }
            catch (IOException e) {
                log.log(Level.INFO, "Unable to get resource " + name + " as stream", e);
                return null;
            }
        }

        private void removeClassLoaderFromLoaderCache() {
            String errMsg = "Unable to clear class loader from Proxy loader cache";
            try {
                Field loaderToCacheField = Proxy.class.getDeclaredField("loaderToCache");
                loaderToCacheField.setAccessible(true);
                Map loaderToCache = (Map)loaderToCacheField.get(null);
                log.info("Proxy Loader Cache: " + loaderToCache.toString());
                Object remove = loaderToCache.remove(this);
                if (remove == null) {
                    log.log(Level.SEVERE, "Unable to remove ChildURLClassLoader from Proxy loader cache");
                } else {
                    log.log(Level.INFO, "Removed ChildURLClassLoader from Proxy loader cache");
                }
            }
            catch (NoSuchFieldException e) {
                log.log(Level.SEVERE, errMsg, e);
            }
            catch (IllegalAccessException e) {
                log.log(Level.SEVERE, errMsg, e);
            }
        }

        private void removeClassLoaderFromProxyClasses() {
            String errMsg = "Unable to clear class loader from Proxy class cache";
            try {
                Field proxyClassesField = Proxy.class.getDeclaredField("proxyClasses");
                proxyClassesField.setAccessible(true);
                Map proxyClasses = (Map)proxyClassesField.get(null);
                log.info("Proxy Classes: " + proxyClasses.toString());
                proxyClasses.clear();
            }
            catch (NoSuchFieldException e) {
                log.log(Level.SEVERE, errMsg, e);
            }
            catch (IllegalAccessException e) {
                log.log(Level.SEVERE, errMsg, e);
            }
        }

        private void removeClassLoaderFromAccessControlContext() {
            String errMsg = "Unable to clear class loader from AccessControlContext";
            try {
                ProtectionDomain[] context;
                AccessControlContext accessControlContext = AccessController.getContext();
                Field contextField = accessControlContext.getClass().getDeclaredField("context");
                contextField.setAccessible(true);
                for (ProtectionDomain domain : context = (ProtectionDomain[])contextField.get(accessControlContext)) {
                    if (!this.equals(domain.getClassLoader())) continue;
                    Field classloaderField = domain.getClass().getDeclaredField("classloader");
                    classloaderField.setAccessible(true);
                    classloaderField.set(domain, null);
                }
            }
            catch (NoSuchFieldException e) {
                log.log(Level.SEVERE, errMsg, e);
            }
            catch (IllegalAccessException e) {
                log.log(Level.SEVERE, errMsg, e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            log.info("Closing " + this.getClass().getSimpleName());
            this.removeClassLoaderFromLoaderCache();
            this.removeClassLoaderFromProxyClasses();
            this.removeClassLoaderFromAccessControlContext();
            SecurityManager security = System.getSecurityManager();
            if (security != null) {
                security.checkPermission(new RuntimePermission("closeClassLoader"));
            }
            List<IOException> errors = this.closeLoaders();
            WeakHashMap<Closeable, Void> weakHashMap = this.closeables;
            synchronized (weakHashMap) {
                Set<Closeable> keys = this.closeables.keySet();
                for (Closeable c : keys) {
                    try {
                        c.close();
                    }
                    catch (IOException ioex) {
                        errors.add(ioex);
                    }
                }
                this.closeables.clear();
            }
            if (errors.isEmpty()) {
                return;
            }
            IOException firstex = errors.remove(0);
            for (IOException error : errors) {
                log.log(Level.WARNING, "An error occurred while closing a plugin-related classloader or jar file", error);
            }
            throw firstex;
        }

        private URLClassPath getUrlClassPath() {
            try {
                Field ucp = URLClassLoader.class.getDeclaredField("ucp");
                ucp.setAccessible(true);
                return (URLClassPath)ucp.get(this);
            }
            catch (IllegalAccessException e) {
                log.log(Level.SEVERE, "Unable to get 'ucp' field", e);
                throw new RuntimeException(e);
            }
            catch (NoSuchFieldException e) {
                log.log(Level.SEVERE, "Unable to get 'ucp' field", e);
                throw new RuntimeException(e);
            }
        }

        private List<IOException> closeLoaders() {
            URLClassPath urlClassPath = this.getUrlClassPath();
            ArrayList<IOException> ioExceptions = new ArrayList<IOException>();
            try {
                Field loadersField = URLClassPath.class.getDeclaredField("loaders");
                loadersField.setAccessible(true);
                List loaders = (List)loadersField.get(urlClassPath);
                for (Object loader : loaders) {
                    log.info("Closing loader " + loader.getClass().getName());
                    Field jarField = loader.getClass().getDeclaredField("jar");
                    jarField.setAccessible(true);
                    Object jarFile = jarField.get(loader);
                    if (!(jarFile instanceof JarFile)) continue;
                    try {
                        ((JarFile)jarFile).close();
                    }
                    catch (IOException e) {
                        ioExceptions.add(e);
                    }
                }
                return ioExceptions;
            }
            catch (NoSuchFieldException e) {
                log.log(Level.SEVERE, "Unable to get close plugin-related class loader", e);
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                log.log(Level.SEVERE, "Unable to get close plugin-related class loader", e);
                throw new RuntimeException(e);
            }
        }
    }

    private static class FindClassClassLoader
    extends ClassLoader {
        public FindClassClassLoader(ClassLoader parent) {
            super(parent);
        }

        @Override
        public Class<?> findClass(String name) throws ClassNotFoundException {
            return super.findClass(name);
        }

        protected void finalize() throws Throwable {
            super.finalize();
            log.info("Finalizing " + FindClassClassLoader.class.getName());
        }
    }
}

