/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.fm;

import com.prosc.fm.FMException;
import com.prosc.io.IOUtils;
import com.prosc.security.LoginFailedException;
import com.prosc.shared.CollectionUtils;
import com.prosc.shared.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class FMRestClient {
    private static final Logger log = Logger.getLogger(FMRestClient.class.getName());
    public static final String RELATEDSETS_FILTER = "-relatedsets.filter";
    public static final String RELATEDSETS_MAX = "-relatedsets.max";
    final String baseUrl;
    final String username;
    final String password;
    @Nullable
    private final FieldFilter fieldFilter;
    private HashMap<String, FieldDefinition> metadata;
    private HashMap<String, String> defaultParameters;

    public FMRestClient(@NotNull String baseUrl, String username, String password, @Nullable FieldFilter fieldFilter) {
        if (baseUrl == null) {
            FMRestClient.$$$reportNull$$$0(0);
        }
        this.defaultParameters = new HashMap();
        if (baseUrl.contains("?")) {
            throw new IllegalArgumentException("baseUrl should only contain the URL, not any arguments");
        }
        this.baseUrl = baseUrl;
        this.username = username;
        this.password = password;
        this.fieldFilter = fieldFilter;
    }

    public FMRestClient(@NotNull String host, boolean ssl, String username, String password, @Nullable FieldFilter fieldFilter) {
        if (host == null) {
            FMRestClient.$$$reportNull$$$0(1);
        }
        this.defaultParameters = new HashMap();
        String protocol = ssl ? "https" : "http";
        this.baseUrl = String.format("%s://%s/fmi/xml/fmresultset.xml", protocol, host);
        this.username = username;
        this.password = password;
        this.fieldFilter = fieldFilter;
    }

    public List<Record> get(String args) throws IOException, FMException, LoginFailedException {
        StringBuilder tmpUrl = new StringBuilder();
        tmpUrl.append(this.baseUrl);
        tmpUrl.append("?").append(args);
        if (!this.defaultParameters.isEmpty()) {
            tmpUrl.append("&").append(IOUtils.urlEncodeMap(this.defaultParameters));
        }
        URL url = new URL(tmpUrl.toString());
        URLConnection connection = url.openConnection();
        this.configureConnection(connection, true);
        InputStream inputStream = null;
        try {
            inputStream = connection.getInputStream();
            List<Record> parse = this.parse(inputStream, url, null);
            log.log(Level.INFO, "Fetched {0} record(s) from {1}", new Object[]{parse.size(), url});
            List<Record> list = parse;
            return list;
        }
        catch (IOException e) {
            if (((HttpURLConnection)connection).getResponseCode() == 401) {
                throw new LoginFailedException("Login failed for " + this.username);
            }
            throw e;
        }
        finally {
            IOUtils.closeQuietly(inputStream);
        }
    }

    private List<Record> parse(InputStream inputStream, URL url, @Nullable String postData) throws IOException, FMException {
        try {
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(inputStream);
            Element root = doc.getDocumentElement();
            Node error = root.getElementsByTagName("error").item(0);
            int errorCode = this.attributeInt(error, "code");
            if (errorCode != 0 && errorCode != 401) {
                log.log(Level.WARNING, "Error code " + errorCode + " for " + url);
                if (errorCode == 102) {
                    this.handleFieldMissingError(url, postData);
                }
                throw new FMException(errorCode);
            }
            Node metadata = root.getElementsByTagName("metadata").item(0);
            this.metadata = new HashMap();
            this.parseMetadata(metadata, this.metadata);
            int fieldCount = metadata.getChildNodes().getLength();
            Node resultSet = root.getElementsByTagName("resultset").item(0);
            return this.parseRecords(fieldCount, resultSet, null);
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    public HashMap<String, FieldDefinition> getMetadata() {
        return this.metadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleFieldMissingError(URL url, @Nullable String postData) throws FMException {
        int errorCode = 102;
        InputStream layoutStream = null;
        URL layoutURL = null;
        HashMap<String, String> params = null;
        try {
            params = new HashMap<String, String>();
            if (url.getQuery() != null) {
                params.putAll(IOUtils.urlDecodeToMap(url.getQuery()));
            }
            if (postData != null) {
                params.putAll(IOUtils.urlDecodeToMap(postData));
            }
            String layoutName = (String)params.remove("-lay");
            String dbName = (String)params.remove("-db");
            layoutURL = new URL(this.baseUrl.replace("/fmresultset.xml", "/FMPXMLLAYOUT.xml") + IOUtils.urlEncoded("?-view&-lay=%s&-db=%s", layoutName, dbName));
            log.log(Level.INFO, "Fetching layout info from " + layoutURL);
            URLConnection urlConnection = layoutURL.openConnection();
            this.configureConnection(urlConnection, false);
            layoutStream = urlConnection.getInputStream();
            Document layoutDoc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(layoutStream);
            Element layoutRoot = layoutDoc.getDocumentElement();
            Node layoutLayout = layoutRoot.getElementsByTagName("LAYOUT").item(0);
            NodeList fieldList = ((Element)layoutLayout).getElementsByTagName("FIELD");
            for (int i = 0; i < fieldList.getLength(); ++i) {
                Node eachField = fieldList.item(i);
                String fieldName = this.attributeString(eachField, "NAME");
                if (params.containsKey(fieldName)) {
                    params.remove(fieldName);
                    continue;
                }
                String portalFieldPrefix = fieldName + ".";
                Iterator iterator = params.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    if (!((String)entry.getKey()).startsWith(portalFieldPrefix)) continue;
                    iterator.remove();
                }
            }
            params.remove("-edit");
            params.remove("-find");
            params.remove("-findall");
            params.remove("-findany");
            params.remove("-recid");
            params.remove("-modid");
            IOUtils.closeQuietly(layoutStream);
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Could not determine missing fields from " + layoutURL, e);
        }
        finally {
            IOUtils.closeQuietly(layoutStream);
        }
        assert (params != null);
        throw new FMException(102, "Missing field(s): " + params.keySet(), null);
    }

    private void parseMetadata(Node metadata, Map<String, FieldDefinition> map) {
        for (int i = 0; i < metadata.getChildNodes().getLength(); ++i) {
            Node item = metadata.getChildNodes().item(i);
            if (item.getNodeName().equals("field-definition")) {
                String name = this.attributeString(item, "name");
                map.put(name, new FieldDefinition("yes".equals(this.attributeString(item, "auto-enter")), "yes".equals(this.attributeString(item, "global")), this.attributeInt(item, "max-repeat"), name, this.attributeString(item, "result").intern(), this.attributeString(item, "type").intern()));
                continue;
            }
            if (!item.getNodeName().equals("relatedset-definition")) continue;
            String relationshipName = this.attributeString(item, "table");
            this.parseMetadata(item, map);
        }
    }

    private List<Record> parseRecords(int fieldCount, Node resultSetOrRelatedSet, @Nullable String relationshipName) {
        ArrayList<Record> result = new ArrayList<Record>(this.attributeInt(resultSetOrRelatedSet, "count"));
        NodeList childNodes = resultSetOrRelatedSet.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node eachRecordNode = childNodes.item(i);
            long recid = this.attributeLong(eachRecordNode, "record-id");
            long modid = this.attributeLong(eachRecordNode, "mod-id");
            Record record = new Record(recid, modid, new LinkedHashMap<String, Object>(fieldCount));
            for (int j = 0; j < eachRecordNode.getChildNodes().getLength(); ++j) {
                Node eachAttributeNode = eachRecordNode.getChildNodes().item(j);
                if (eachAttributeNode.getNodeName().equals("field")) {
                    String textContent;
                    String fieldName = eachAttributeNode.getAttributes().getNamedItem("name").getTextContent();
                    FieldDefinition definition = this.metadata.get(fieldName);
                    if (fieldName.startsWith(relationshipName + "::")) {
                        fieldName = fieldName.substring(relationshipName.length() + 2);
                    }
                    Object objectContent = StringUtils.isEmpty(textContent = eachAttributeNode.getTextContent()) ? null : (definition != null && definition.isNumber() ? this.numberFor(textContent, fieldName) : (definition != null && "date".equals(definition.result) ? this.dateFor(textContent) : (definition != null && "time".equals(definition.result) ? this.timeFor(textContent) : (definition != null && "timestamp".equals(definition.result) ? this.timestampFor(textContent) : textContent))));
                    record.getData().put(fieldName, objectContent);
                    continue;
                }
                if (!eachAttributeNode.getNodeName().equals("relatedset")) continue;
                String portalName = this.attributeString(eachAttributeNode, "table");
                record.getData().put(portalName, this.parseRecords(16, eachAttributeNode, portalName));
            }
            result.add(record);
        }
        return result;
    }

    protected Object timestampFor(@NotNull String textContent) {
        if (textContent == null) {
            FMRestClient.$$$reportNull$$$0(2);
        }
        return textContent;
    }

    protected Object timeFor(@NotNull String textContent) {
        if (textContent == null) {
            FMRestClient.$$$reportNull$$$0(3);
        }
        return textContent;
    }

    protected Object dateFor(@NotNull String textContent) {
        if (textContent == null) {
            FMRestClient.$$$reportNull$$$0(4);
        }
        return textContent;
    }

    protected Object numberFor(@NotNull String textContent, @Nullable String fieldName) {
        if (textContent == null) {
            FMRestClient.$$$reportNull$$$0(5);
        }
        try {
            String numericString = textContent.replaceAll("[^\\-0-9.]", "");
            Number objectContent = textContent.contains(".") ? new BigDecimal(numericString) : new BigInteger(numericString);
            return objectContent;
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Unable to convert " + fieldName + " value of " + textContent + " to numeric value: " + e.toString(), e);
            return textContent;
        }
    }

    private String attributeString(Node eachAttributeNode, String attributeName) {
        return eachAttributeNode.getAttributes().getNamedItem(attributeName).getTextContent();
    }

    private int attributeInt(Node eachRecordNode, String attributeName) {
        return Integer.parseInt(eachRecordNode.getAttributes().getNamedItem(attributeName).getTextContent());
    }

    private long attributeLong(Node eachRecordNode, String attributeName) {
        return Long.parseLong(eachRecordNode.getAttributes().getNamedItem(attributeName).getTextContent());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Record> post(String data) throws IOException, FMException, LoginFailedException {
        URL url = new URL(this.baseUrl);
        URLConnection conn = url.openConnection();
        this.configureConnection(conn, true);
        log.log(Level.INFO, "POST to " + this.baseUrl + "?" + data);
        IOUtils.postDataToUrlConnection(data, conn);
        if (((HttpURLConnection)conn).getResponseCode() == 401) {
            throw new LoginFailedException("Login failed");
        }
        InputStream inputStream = conn.getInputStream();
        try {
            List<Record> list = this.parse(inputStream, url, data);
            return list;
        }
        finally {
            IOUtils.closeQuietly(inputStream);
        }
    }

    public List<Record> insert(String baseArgs, Map<String, Object> data) throws IOException, FMException, LoginFailedException {
        return this.insert(baseArgs, data, null);
    }

    public List<Record> insert(String baseArgs, Map<String, Object> data, @Nullable String extraArgs) throws IOException, FMException, LoginFailedException {
        log.log(Level.INFO, "Inserting {0} at {1} into {2} with extraArgs {3}", new Object[]{data, baseArgs, this, extraArgs});
        StringBuilder firstRequest = new StringBuilder(1024);
        firstRequest.append(baseArgs).append("&-new");
        return this._insertOrUpdate(baseArgs, data, extraArgs, firstRequest);
    }

    public List<Record> update(String baseArgs, Record updateMe) throws FMException, IOException, LoginFailedException {
        return this.update(baseArgs, updateMe, null);
    }

    public List<Record> update(String baseArgs, Record updateMe, @Nullable String extraArgs) throws FMException, IOException, LoginFailedException {
        log.log(Level.INFO, "Updating {0} at {1} in {2} with extraArgs {3}", new Object[]{updateMe, baseArgs, this, extraArgs});
        StringBuilder firstRequest = new StringBuilder(1024);
        firstRequest.append(baseArgs).append("&-edit&-recid=").append(updateMe.getRecid());
        if (updateMe.getModid() != -1L) {
            firstRequest.append("&-modid=").append(updateMe.getModid());
        }
        return this._insertOrUpdate(baseArgs, updateMe.data, extraArgs, firstRequest);
    }

    private List<Record> _insertOrUpdate(String baseArgs, Map<String, Object> data, String extraArgs, StringBuilder firstRequest) throws IOException, FMException, LoginFailedException {
        PortalSaveHelper portalSaveHelper = new PortalSaveHelper();
        for (Map.Entry<String, Object> eachEntry : data.entrySet()) {
            if (!this.shouldWrite(eachEntry.getKey(), null)) continue;
            if (eachEntry.getValue() instanceof List) {
                List recordList = (List)eachEntry.getValue();
                for (Record eachPortalRow : recordList) {
                    if (eachPortalRow.deleted && eachPortalRow.getRecid() == 0L) continue;
                    if (eachPortalRow.isDeleted()) {
                        portalSaveHelper.queueDeletion(eachEntry.getKey(), eachPortalRow.getRecid());
                        continue;
                    }
                    if (eachPortalRow.getRecid() == 0L) {
                        portalSaveHelper.queueInsertion(eachEntry.getKey(), eachPortalRow);
                        continue;
                    }
                    portalSaveHelper.addExistingRecId(eachEntry.getKey(), eachPortalRow.getRecid());
                    for (Map.Entry<String, Object> kv : eachPortalRow.getData().entrySet()) {
                        if (!this.shouldWrite(kv.getKey(), eachEntry.getKey())) continue;
                        firstRequest.append("&");
                        if (!kv.getKey().contains("::")) {
                            firstRequest.append(FMRestClient.urlEncode(eachEntry.getKey()));
                            firstRequest.append("::");
                        }
                        firstRequest.append(kv.getKey());
                        firstRequest.append(".");
                        firstRequest.append(eachPortalRow.getRecid());
                        firstRequest.append("=");
                        firstRequest.append(FMRestClient.urlEncode(kv.getValue()));
                    }
                }
                continue;
            }
            firstRequest.append("&");
            firstRequest.append(FMRestClient.urlEncode(eachEntry.getKey()));
            firstRequest.append("=");
            if (eachEntry.getValue() == null) continue;
            firstRequest.append(FMRestClient.urlEncode(eachEntry.getValue().toString()));
        }
        Iterator<QueuedRequest> queueIterator = portalSaveHelper.queuedRequests.iterator();
        QueuedRequest currentQueuedRequest = null;
        if (queueIterator.hasNext()) {
            currentQueuedRequest = queueIterator.next();
            currentQueuedRequest.appendPostDataTo(firstRequest);
        } else if (extraArgs != null) {
            firstRequest.append(extraArgs);
        }
        try {
            List<Record> newestResponse = this.post(firstRequest.toString());
            while (queueIterator.hasNext()) {
                Record mainRecord = newestResponse.get(0);
                currentQueuedRequest.parseNewRecIdsFrom(portalSaveHelper, mainRecord);
                currentQueuedRequest = queueIterator.next();
                firstRequest.setLength(baseArgs.length());
                firstRequest.append("&-edit&-recid=").append(mainRecord.getRecid()).append("&-modid=").append(mainRecord.getModid());
                currentQueuedRequest.appendPostDataTo(firstRequest);
                if (!queueIterator.hasNext() && extraArgs != null) {
                    firstRequest.append(extraArgs);
                }
                newestResponse = this.post(firstRequest.toString());
            }
            return newestResponse;
        }
        catch (FMException e) {
            if (e.getErrorCode() == 102) {
                this.get(baseArgs + "&-findany");
                for (Map.Entry<String, Object> eachPostEntry : data.entrySet()) {
                    if (eachPostEntry.getValue() instanceof List) {
                        List list = (List)eachPostEntry.getValue();
                        for (Record eachPortalRow : list) {
                            for (String eachKey : eachPortalRow.data.keySet()) {
                                if (this.metadata.containsKey(eachKey) || this.metadata.containsKey(eachPostEntry.getKey() + "::" + eachKey)) continue;
                                throw new FMException(e.getErrorCode(), "Field is missing: '" + eachKey + "' in portal '" + eachPostEntry.getKey() + "'", e);
                            }
                        }
                        continue;
                    }
                    if (this.metadata.containsKey(eachPostEntry.getKey())) continue;
                    throw new FMException(e.getErrorCode(), "Field is missing: '" + eachPostEntry.getKey() + "'", e);
                }
            }
            throw e;
        }
    }

    private List<Record> flushQueued(List<Record> post, String baseArgs, List<Iterator<String>> pendingOperations) throws FMException, IOException, LoginFailedException {
        List<Record> result = post;
        StringBuilder queueBuffer = new StringBuilder();
        do {
            Record first = result.get(0);
            queueBuffer.setLength(0);
            for (Iterator<String> eachQueue : pendingOperations) {
                if (!eachQueue.hasNext()) continue;
                queueBuffer.append(eachQueue.next());
            }
            if (queueBuffer.length() == 0) continue;
            log.log(Level.INFO, "Flushing queued insert/delete operations");
            result = this.post(baseArgs + "&-edit&-recid=" + first.getRecid() + "&-modid=" + first.getModid() + queueBuffer);
        } while (queueBuffer.length() != 0);
        return result;
    }

    public void delete(String baseArgs, long recid, long modid) throws IOException, FMException, LoginFailedException {
        if (recid < 0L) {
            throw new IllegalArgumentException();
        }
        String modidArg = modid == -1L ? "" : "&-modid=" + modid;
        this.post(baseArgs + "&-delete&-recid=" + recid + modidArg);
    }

    private List<Iterator<String>> appendEncodedRecordTo(StringBuilder sb, Map<String, Object> data, boolean isInsert) throws UnsupportedEncodingException {
        HashMap<String, List<String>> insertBatches = new HashMap<String, List<String>>();
        HashMap<String, List<String>> deleteBatches = new HashMap<String, List<String>>();
        for (Map.Entry<String, Object> eachEntry : data.entrySet()) {
            if (!this.shouldWrite(eachEntry.getKey(), null)) continue;
            if (eachEntry.getValue() instanceof List) {
                List portalRows = (List)eachEntry.getValue();
                for (Record eachPortalRow : portalRows) {
                    this.appendEncodedPortalRow(sb, eachEntry.getKey(), eachPortalRow, insertBatches, deleteBatches);
                }
                continue;
            }
            if (isInsert && (eachEntry.getValue() == null || eachEntry.getValue().equals(""))) continue;
            sb.append("&");
            sb.append(FMRestClient.urlEncode(eachEntry.getKey()));
            sb.append("=");
            if (eachEntry.getValue() == null) continue;
            sb.append(FMRestClient.urlEncode(eachEntry.getValue().toString()));
        }
        LinkedList<Iterator<String>> allQueues = new LinkedList<Iterator<String>>();
        for (List eachInsertQueue : insertBatches.values()) {
            allQueues.add(eachInsertQueue.iterator());
        }
        for (List eachDeleteQueue : deleteBatches.values()) {
            allQueues.add(eachDeleteQueue.iterator());
        }
        return allQueues;
    }

    private void appendEncodedPortalRow(StringBuilder sb, String relationshipName, Record portalRow, Map<String, List<String>> insertBatches, Map<String, List<String>> deleteBatches) throws UnsupportedEncodingException {
        if (portalRow.isDeleted()) {
            String cmd = "&-delete.related=" + relationshipName + "." + portalRow.getRecid();
            List<String> deleteQueue = deleteBatches.get(relationshipName);
            if (portalRow.getRecid() != 0L) {
                if (deleteQueue == null) {
                    deleteBatches.put(relationshipName, new LinkedList());
                    sb.append(cmd);
                } else {
                    deleteQueue.add(cmd);
                }
            }
            return;
        }
        int startingLength = sb.length();
        for (Map.Entry<String, Object> eachEntry : portalRow.getData().entrySet()) {
            if (!this.shouldWrite(eachEntry.getKey(), relationshipName)) continue;
            sb.append("&");
            String key = eachEntry.getKey();
            if (key.contains("::")) {
                sb.append(FMRestClient.urlEncode(key));
            } else {
                sb.append(FMRestClient.urlEncode(relationshipName + "::" + key));
            }
            sb.append(".");
            sb.append(portalRow.getRecid());
            sb.append("=");
            if (eachEntry.getValue() == null) continue;
            sb.append(FMRestClient.urlEncode(eachEntry.getValue().toString()));
        }
        if (portalRow.getRecid() == 0L) {
            List<String> insertQueue = insertBatches.get(relationshipName);
            if (insertQueue == null) {
                insertBatches.put(relationshipName, new LinkedList());
            } else {
                insertQueue.add(sb.substring(startingLength));
                sb.setLength(startingLength);
            }
        }
    }

    protected boolean shouldWrite(String key, @Nullable String relationshipName) {
        return this.fieldFilter == null || !this.fieldFilter.isReadOnly(key, relationshipName);
    }

    public static String urlEncode(Object o) {
        return o == null ? "" : FMRestClient.urlEncode(o.toString());
    }

    public static String urlEncode(String s) {
        try {
            return s == null ? "" : URLEncoder.encode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String urlDecode(String s) {
        try {
            return URLDecoder.decode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private void configureConnection(URLConnection connection, boolean doOuput) throws IOException, LoginFailedException {
        if (this.password != null) {
            IOUtils.setRequestAuthentication(connection, this.username, this.password);
        }
        connection.setDoOutput(doOuput);
        if (!doOuput && ((HttpURLConnection)connection).getResponseCode() == 401) {
            throw new LoginFailedException("Login failed");
        }
    }

    public String toString() {
        return "FMRestClient{" + this.username + "@" + this.baseUrl + '}';
    }

    public void setRelatedSetsFilter(boolean b) {
        this.defaultParameters.put(RELATEDSETS_FILTER, b ? "layout" : "none");
    }

    public boolean isRelatedSetsFilter() {
        return "layout".equals(this.defaultParameters.get(RELATEDSETS_FILTER));
    }

    public void setRelatedSetsMax(int maxOrNegativeOne) {
        this.defaultParameters.put(RELATEDSETS_MAX, maxOrNegativeOne < 0 ? "all" : String.valueOf(maxOrNegativeOne));
    }

    public int getRelatedSetsMax() {
        String max = this.defaultParameters.get(RELATEDSETS_MAX);
        return "all".equals(max) ? -1 : Integer.parseInt(max);
    }

    public List<Record> save(@NotNull String baseArgs, @NotNull Record record) throws FMException, IOException, LoginFailedException {
        if (baseArgs == null) {
            FMRestClient.$$$reportNull$$$0(6);
        }
        if (record == null) {
            FMRestClient.$$$reportNull$$$0(7);
        }
        return this.save(baseArgs, record, null);
    }

    public List<Record> save(@NotNull String baseArgs, @NotNull Record record, @Nullable String extraArgs) throws FMException, IOException, LoginFailedException {
        if (baseArgs == null) {
            FMRestClient.$$$reportNull$$$0(8);
        }
        if (record == null) {
            FMRestClient.$$$reportNull$$$0(9);
        }
        if (record.isDeleted()) {
            this.delete(baseArgs, record.recid, record.modid);
            return Collections.emptyList();
        }
        if (record.getRecid() == 0L) {
            return this.insert(baseArgs, record.getData(), extraArgs);
        }
        return this.update(baseArgs, record, extraArgs);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseUrl";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textContent";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseArgs";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "record";
                break;
            }
        }
        objectArray2[1] = "com/prosc/fm/FMRestClient";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "timestampFor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "timeFor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "dateFor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "numberFor";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "save";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static final class FieldDefinition {
        final boolean autoEnter;
        final boolean global;
        final int repetitions;
        final String name;
        final String result;
        final String type;

        private FieldDefinition(boolean autoEnter, boolean global, int repetitions, String name, String result, String type) {
            this.autoEnter = autoEnter;
            this.global = global;
            this.repetitions = repetitions;
            this.name = name;
            this.result = result;
            this.type = type;
        }

        public boolean isNumber() {
            return "number".equals(this.result);
        }
    }

    private class PortalSaveHelper {
        List<QueuedRequest> queuedRequests = new LinkedList<QueuedRequest>();
        private Map<String, Set<Long>> existingRecIds = new HashMap<String, Set<Long>>();

        private PortalSaveHelper() {
        }

        public void queueDeletion(String relationshipName, long recid) {
            this.firstQueuedRequestWithoutDeletionFor(relationshipName).deletedRecIdsByRelationship.put(relationshipName, recid);
        }

        @NotNull
        private QueuedRequest firstQueuedRequestWithoutDeletionFor(String relationshipName) {
            for (QueuedRequest eachQueued : this.queuedRequests) {
                if (eachQueued.deletedRecIdsByRelationship.containsKey(relationshipName)) continue;
                QueuedRequest queuedRequest = eachQueued;
                if (queuedRequest == null) {
                    PortalSaveHelper.$$$reportNull$$$0(0);
                }
                return queuedRequest;
            }
            QueuedRequest result = new QueuedRequest(relationshipName);
            this.queuedRequests.add(result);
            QueuedRequest queuedRequest = result;
            if (queuedRequest == null) {
                PortalSaveHelper.$$$reportNull$$$0(1);
            }
            return queuedRequest;
        }

        public void queueInsertion(String relationshipName, Record insertMe) {
            ListIterator<QueuedRequest> iterator = this.queuedRequests.listIterator();
            boolean didInsert = false;
            while (iterator.hasNext()) {
                QueuedRequest eachQueued = iterator.next();
                if (eachQueued.inserts.containsKey(relationshipName)) continue;
                eachQueued.inserts.put(relationshipName, insertMe);
                didInsert = true;
                break;
            }
            if (!didInsert) {
                QueuedRequest newRequest = new QueuedRequest(relationshipName);
                newRequest.inserts.put(relationshipName, insertMe);
                iterator.add(newRequest);
            }
            if (this.hasDistantValues(insertMe)) {
                QueuedRequest secondaryUpdate;
                log.log(Level.INFO, insertMe + " in " + relationshipName + " contains distant values, queueing up secondary update to write these");
                if (iterator.hasNext()) {
                    secondaryUpdate = iterator.next();
                } else {
                    secondaryUpdate = new QueuedRequest(relationshipName);
                    iterator.add(secondaryUpdate);
                }
                secondaryUpdate.distantUpdates.add(insertMe);
            }
        }

        private boolean hasDistantValues(Record record) {
            for (Map.Entry<String, Object> eachEntry : record.getData().entrySet()) {
                if (!eachEntry.getKey().contains("::") || eachEntry.getValue() == null) continue;
                return true;
            }
            return false;
        }

        public void addExistingRecId(String relationship, long recid) {
            CollectionUtils.putInMultiMapSet(this.existingRecIds, relationship, recid);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/prosc/fm/FMRestClient$PortalSaveHelper", "firstQueuedRequestWithoutDeletionFor"));
        }
    }

    private class QueuedRequest {
        private final String relationshipName;
        private Map<String, Long> deletedRecIdsByRelationship = new HashMap<String, Long>(12);
        public Map<String, Record> inserts = new HashMap<String, Record>(12);
        public List<Record> distantUpdates = new LinkedList<Record>();

        public QueuedRequest(String relationshipName) {
            this.relationshipName = relationshipName;
        }

        public void appendPostDataTo(StringBuilder sb) {
            for (Record record : this.distantUpdates) {
                this.appendDistantFields(sb, record);
            }
            for (Map.Entry entry : this.inserts.entrySet()) {
                boolean atLeastOne = false;
                for (Map.Entry<String, Object> kv : ((Record)entry.getValue()).getData().entrySet()) {
                    if (kv.getKey().contains("::") || !FMRestClient.this.shouldWrite(kv.getKey(), this.relationshipName)) continue;
                    atLeastOne = true;
                    sb.append("&");
                    sb.append(FMRestClient.urlEncode((String)entry.getKey()));
                    sb.append("::");
                    sb.append(FMRestClient.urlEncode(kv.getKey()));
                    sb.append(".");
                    sb.append(((Record)entry.getValue()).getRecid());
                    sb.append("=");
                    sb.append(FMRestClient.urlEncode(kv.getValue()));
                }
                if (atLeastOne) continue;
                throw new RuntimeException("Cannot create portal row in " + (String)entry.getKey() + " because only distant fields are specified for writing. You must specify at least one field value which is from the destination portal, so the record can be created. " + ((Record)entry.getValue()).getData());
            }
            for (Map.Entry entry : this.deletedRecIdsByRelationship.entrySet()) {
                String relationshipName = FMRestClient.urlEncode((String)entry.getKey());
                String cmd = "&-delete.related=" + relationshipName + "." + entry.getValue();
                sb.append(cmd);
            }
        }

        private void appendDistantFields(StringBuilder sb, Record record) {
            for (Map.Entry<String, Object> kv : record.getData().entrySet()) {
                if (!kv.getKey().contains("::") || !FMRestClient.this.shouldWrite(kv.getKey(), this.relationshipName)) continue;
                sb.append("&");
                sb.append(FMRestClient.urlEncode(kv.getKey()));
                sb.append(".");
                sb.append(record.getRecid());
                sb.append("=");
                sb.append(FMRestClient.urlEncode(kv.getValue()));
            }
        }

        private void parseNewRecIdsFrom(PortalSaveHelper portalSaveHelper, Record mainRecord) {
            block0: for (Map.Entry<String, Record> eachInsertEntry : this.inserts.entrySet()) {
                Record newlyInsertedPortalRow = eachInsertEntry.getValue();
                List<Record> mainPortalRecords = mainRecord.getPortal(eachInsertEntry.getKey());
                if (mainPortalRecords != null) {
                    ListIterator<Record> listIterator = mainPortalRecords.listIterator(mainPortalRecords.size());
                    while (listIterator.hasPrevious()) {
                        Record eachMainRecord = listIterator.previous();
                        Set alreadySavedRecIds = (Set)portalSaveHelper.existingRecIds.get(eachInsertEntry.getKey());
                        if (alreadySavedRecIds != null && alreadySavedRecIds.contains(eachMainRecord.getRecid())) continue;
                        newlyInsertedPortalRow.recid = eachMainRecord.getRecid();
                        portalSaveHelper.addExistingRecId(eachInsertEntry.getKey(), eachMainRecord.getRecid());
                        continue block0;
                    }
                    continue;
                }
                log.log(Level.WARNING, "No insert result for insert entry '" + eachInsertEntry.getKey() + "' " + eachInsertEntry.getValue() + ". This can happen if you try to insert an empty portal row.");
            }
        }
    }

    public static interface FieldFilter {
        public boolean isReadOnly(String var1, @Nullable String var2);
    }

    public static final class Record {
        long recid;
        final long modid;
        final Map<String, Object> data;
        private boolean deleted;

        public Record(Map<String, Object> data) {
            this(0L, -1L, data);
        }

        public Record(long recid, long modid, Map<String, Object> data) {
            this.recid = recid;
            this.modid = modid;
            this.data = data;
        }

        public long getRecid() {
            return this.recid;
        }

        public long getModid() {
            return this.modid;
        }

        public Map<String, Object> getData() {
            return this.data;
        }

        public void set(String fieldName, String value) {
            this.data.put(fieldName, value);
        }

        public void set(String fieldName, int value) {
            this.data.put(fieldName, value);
        }

        public void set(String fieldName, List<Record> value) {
            this.data.put(fieldName, value);
        }

        public Object get(String fieldName) {
            return this.data.get(fieldName);
        }

        public List<Record> getPortal(String child) {
            return (List)this.get(child);
        }

        public boolean isDeleted() {
            return this.deleted;
        }

        public void setDeleted(boolean deleted) {
            this.deleted = deleted;
        }

        public String toString() {
            return "Record{recid=" + this.recid + ", modid=" + this.modid + ", deleted=" + this.deleted + ", data.size=" + this.data.size() + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Record record = (Record)o;
            if (this.deleted != record.deleted) {
                return false;
            }
            if (this.modid != record.modid) {
                return false;
            }
            if (this.recid != record.recid) {
                return false;
            }
            return this.data.equals(record.data);
        }

        public int hashCode() {
            int result = (int)(this.recid ^ this.recid >>> 32);
            result = 31 * result + (int)(this.modid ^ this.modid >>> 32);
            result = 31 * result + this.data.hashCode();
            result = 31 * result + (this.deleted ? 1 : 0);
            return result;
        }
    }
}

