/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.database;

import com.prosc.io.IOUtils;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UrlBlob
implements Blob {
    private static final Logger log = Logger.getLogger(UrlBlob.class.getName());
    @NotNull
    private final URL url;
    @NotNull
    private final String username;
    @NotNull
    private final String password;
    private String md5hash;
    private URLConnection lastConnection;
    private List<InputStream> binaryStreams;

    protected UrlBlob(@NotNull URL url, @Nullable String username, @Nullable String password) {
        if (url == null) {
            UrlBlob.$$$reportNull$$$0(0);
        }
        this.binaryStreams = new ArrayList<InputStream>(1);
        this.url = url;
        if (username == null) {
            username = "";
        }
        if (password == null) {
            password = "";
        }
        this.username = username;
        this.password = password;
    }

    @Override
    public long length() throws SQLException {
        int contentLength;
        try {
            URLConnection connection = this.lastConnection == null ? this.openConnection() : this.lastConnection;
            contentLength = connection.getContentLength();
        }
        catch (IOException e) {
            throw new SQLException(e.getMessage(), e);
        }
        if (contentLength == -1) {
            throw new SQLException("Length is not available for this binary object");
        }
        return contentLength;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getBytes(long pos, int length) throws SQLException {
        byte[] byArray;
        long pos0 = pos - 1L;
        InputStream stream = this.openStream();
        try {
            int bytesRead;
            long skipped;
            if (pos0 > 0L && (skipped = stream.skip(pos0)) != pos0) {
                throw new IOException("Requested to read from position " + pos + ", but could only skip " + skipped + " bytes ahead in the stream");
            }
            byte[] result = new byte[length];
            for (int totalBytes = 0; totalBytes < length; totalBytes += bytesRead) {
                bytesRead = stream.read(result, totalBytes, length - totalBytes);
                if (bytesRead != -1) continue;
                throw new EOFException(length + " bytes were requested from position " + pos + ", but only " + totalBytes + " are available from that position.");
            }
            byArray = result;
        }
        catch (Throwable throwable) {
            try {
                stream.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new SQLException("Could not get " + length + " bytes from position " + pos + ": " + e.getMessage(), e);
            }
        }
        stream.close();
        return byArray;
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        InputStream in = this.openStream();
        this.binaryStreams.add(in);
        if (this.md5hash == null) {
            MessageDigest md;
            try {
                md = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException("Couldn't create MD5 digester", e);
            }
            final DigestInputStream dis = new DigestInputStream(in, md);
            return new FilterInputStream(dis){

                @Override
                public long skip(long n) throws IOException {
                    throw new IllegalStateException("You cannot call skip on this stream because that will skip MD5 generation");
                }

                @Override
                public int read() throws IOException {
                    int result = dis.read();
                    if (result == -1) {
                        UrlBlob.this.storeMD5Hash(md);
                    }
                    return result;
                }

                @Override
                public int read(byte[] b) throws IOException {
                    int result = dis.read(b);
                    if (result == -1) {
                        UrlBlob.this.storeMD5Hash(md);
                    }
                    return result;
                }

                @Override
                public int read(byte[] b, int off, int len) throws IOException {
                    int result = dis.read(b, off, len);
                    if (result == -1) {
                        UrlBlob.this.storeMD5Hash(md);
                    }
                    return result;
                }
            };
        }
        return in;
    }

    private void storeMD5Hash(MessageDigest md) {
        byte[] digest = md.digest();
        String tmpHash = "";
        for (byte eachByte : digest) {
            tmpHash = tmpHash + Integer.toString((eachByte & 0xFF) + 256, 16).substring(1);
        }
        this.md5hash = tmpHash;
    }

    public String getMd5hash() {
        return this.md5hash;
    }

    @Override
    public long position(byte[] pattern, long start) throws SQLException {
        throw new AbstractMethodError("This feature has not been implemented yet.");
    }

    @Override
    public long position(Blob pattern, long start) throws SQLException {
        throw new AbstractMethodError("This feature has not been implemented yet.");
    }

    @Override
    public int setBytes(long pos, byte[] bytes) throws SQLException {
        throw new AbstractMethodError("This feature has not been implemented yet.");
    }

    @Override
    public int setBytes(long pos, byte[] bytes, int offset, int len) throws SQLException {
        throw new AbstractMethodError("This feature has not been implemented yet.");
    }

    @Override
    public OutputStream setBinaryStream(long pos) throws SQLException {
        throw new AbstractMethodError("This feature has not been implemented yet.");
    }

    @Override
    public void truncate(long len) throws SQLException {
        throw new AbstractMethodError("This feature has not been implemented yet.");
    }

    @Override
    public void free() throws SQLException {
        try {
            for (InputStream stream : this.binaryStreams) {
                stream.close();
            }
        }
        catch (IOException e) {
            throw this.rethrowAsSQLException(e);
        }
    }

    @Override
    public InputStream getBinaryStream(long pos, long length) throws SQLException {
        throw new AbstractMethodError("This feature has not been implemented yet.");
    }

    private InputStream openStream() throws SQLException {
        try {
            URLConnection connection = this.openConnection();
            connection.setConnectTimeout(20000);
            connection.setReadTimeout(20000);
            InputStream urlStream = null;
            try {
                urlStream = connection.getInputStream();
            }
            catch (IOException e) {
                log.log(Level.WARNING, "IOException trying to access URL " + this.url + ": " + e.toString());
                if (this.url.getPath().startsWith("/fmi/xml/cnt/size%3A")) {
                    throw new SQLException("You cannot sync container fields inserted with the 'Store only a reference to the file' option selected.");
                }
                if (connection instanceof HttpURLConnection) {
                    IOUtils.rethrowHttpException(e, (HttpURLConnection)connection);
                }
                throw e;
            }
            return urlStream;
        }
        catch (IOException e) {
            throw this.rethrowAsSQLException(e);
        }
    }

    protected URLConnection openConnection() throws IOException {
        URLConnection connection = this.url.openConnection();
        log.info("Setting authorization header to username " + this.username + " and password length " + this.password.length());
        IOUtils.setRequestAuthentication(connection, this.username, this.password);
        this.lastConnection = connection;
        return connection;
    }

    private SQLException rethrowAsSQLException(IOException e) throws SQLException {
        SQLException sqle = new SQLException(e.toString());
        sqle.initCause(e);
        throw sqle;
    }

    public String toString() {
        return "UrlBlob{url=" + this.url + ", username='" + this.username + '\'' + '}';
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/prosc/database/UrlBlob", "<init>"));
    }
}

