/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.beanshell;

import com.prosc.beanshell.BeanShellPlugin;
import com.prosc.fm.FMFileUtils;
import com.prosc.fmkit.FmCalculationException;
import com.prosc.fmkit.FmScriptException;
import com.prosc.fmkit.PluginContext;
import com.prosc.fmkit.PluginUtils;
import com.prosc.fmkit.QuadChar;
import com.prosc.fmkit.ScriptCall;
import com.prosc.fmkit.types.FMBinary;
import com.prosc.fmkit.types.FMData;
import com.prosc.fmkit.types.FMType;
import com.prosc.license.client.InvalidLicenseException;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.LinkedList;
import java.util.logging.Logger;

public class FMPro {
    private static final Logger log = Logger.getLogger(FMPro.class.getName());
    private BeanShellPlugin plugin;
    private PluginContext pluginContext;

    public FMPro(BeanShellPlugin plugin) {
        this.plugin = plugin;
    }

    public Object getFieldValue(String fileName, String fieldName) throws FmCalculationException {
        return this.pluginContext.getFieldValue(fileName, fieldName);
    }

    public String evaluate(String calc) throws FmCalculationException {
        FMData fmData = this.pluginContext.evaluateExpression(calc);
        return fmData == null ? null : fmData.getStringData(this.pluginContext, false);
    }

    public InputStream getContainerStream(String containerFieldName) throws FmCalculationException, IOException {
        FMData fmData = this.pluginContext.evaluateExpression(containerFieldName);
        return fmData == null || fmData.getFMBinary(this.pluginContext) == null ? null : fmData.getFMBinary(this.pluginContext).getBestInputStream(this.pluginContext);
    }

    public String getStreamTypes(String containerFieldName) throws FmCalculationException, IOException {
        FMData fmData = this.pluginContext.evaluateExpression(containerFieldName);
        return fmData == null || fmData.getFMBinary(this.pluginContext) == null ? null : fmData.getFMBinary(this.pluginContext).getStreamTypes(this.pluginContext).toString();
    }

    public InputStream getContainerStream(String containerFieldName, String streamType) throws FmCalculationException, IOException {
        FMData fmData = this.pluginContext.evaluateExpression(containerFieldName);
        return fmData == null || fmData.getFMBinary(this.pluginContext) == null ? null : fmData.getFMBinary(this.pluginContext).getStreamForType(new QuadChar(streamType), this.pluginContext);
    }

    public FMType getFMTypeByName(String fieldName) throws FmCalculationException {
        FMData fmData = this.pluginContext.evaluateExpression(fieldName);
        return (FMType)(fmData == null ? null : fmData.getFMType(this.plugin.getContext()));
    }

    public String getContainerFileName(String containerFieldName) throws FmCalculationException {
        FMData fmData = this.pluginContext.evaluateExpression(containerFieldName);
        return fmData == null || fmData.getFMBinary(this.pluginContext) == null ? null : fmData.getFMBinary(this.pluginContext).getFileName(this.pluginContext);
    }

    public void performScript(String filename, String scriptName) throws FmCalculationException, FmScriptException {
        this.performScript(filename, scriptName, null);
    }

    public void performScript(String filename, String scriptName, String parameters) throws FmCalculationException, FmScriptException {
        this.pluginContext.triggerScript(new ScriptCall(filename, scriptName, parameters), this.plugin);
    }

    public String merge(String template) {
        return PluginUtils.mergeString(this.pluginContext, template, null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FMBinary getAsContainer(InputStream bytes, String filename) throws IOException {
        try {
            FMBinary fMBinary = FMBinary.fmBinaryForData(bytes, filename, this.plugin.getContext());
            return fMBinary;
        }
        finally {
            bytes.close();
        }
    }

    public FMBinary getAsImage(BufferedImage image, String filename) throws IOException {
        return FMBinary.fmBinaryForImage(image, filename, this.plugin.getContext());
    }

    public String convertPathToFileMaker(String file) {
        return FMFileUtils.convertToFileMaker(file);
    }

    public File fileForFMPath(String file) {
        return PluginUtils.fileForFMPath(file);
    }

    public String executeSql(String sql) throws FmCalculationException, InvalidLicenseException {
        return this.executeSql(sql, ',', '\n');
    }

    public String executeSql(String sql, String columnDelimiter, String rowDelimiter) throws FmCalculationException, InvalidLicenseException {
        if (columnDelimiter.length() != 1) {
            throw new IllegalArgumentException("columnDelimiter must be exactly 1 character long");
        }
        if (rowDelimiter.length() != 1) {
            throw new IllegalArgumentException("rowDelimiter must be exactly 1 character long");
        }
        return this.executeSql(sql, columnDelimiter.charAt(0), rowDelimiter.charAt(0));
    }

    public String executeSql(String sql, char columnDelimiter, char rowDelimiter) throws FmCalculationException, InvalidLicenseException {
        this.plugin.excludeFreeLicense();
        return this.pluginContext.executeSql(sql, columnDelimiter, rowDelimiter);
    }

    public String[][] executeSqlArray(String sql) throws FmCalculationException, InvalidLicenseException {
        char colDelim = '\ufffb';
        char rowDelim = '\ufffc';
        String rawResult = this.executeSql(sql, colDelim, rowDelim);
        String[] rowSplit = rawResult.split("" + rowDelim);
        int rowCount = rowSplit.length;
        LinkedList<String[]> result = new LinkedList<String[]>();
        for (int i = 0; i < rowCount; ++i) {
            result.add(rowSplit[i].split("" + colDelim));
        }
        return (String[][])result.toArray((T[])new String[result.size()][]);
    }

    public String getFileMakerClipboard() throws InvalidLicenseException {
        this.plugin.excludeFreeLicense();
        String format = this.plugin.getContext().getBestFileMakerClipboardFormat();
        return this.getClipboardContents(format);
    }

    public String getBestFileMakerClipboardFormat() throws InvalidLicenseException {
        this.plugin.excludeFreeLicense();
        return this.plugin.getContext().getBestFileMakerClipboardFormat();
    }

    public String getClipboardContents(String format) throws InvalidLicenseException {
        this.plugin.excludeFreeLicense();
        try {
            byte[] clipBytes = this.plugin.getContext().getClipboardData(format, true);
            if (clipBytes == null) {
                return null;
            }
            String characterEncoding = "utf-8";
            if (format.contains("utf16")) {
                characterEncoding = "UnicodeLittleUnmarked";
            } else if ("CF_UNICODETEXT".equals(format)) {
                characterEncoding = "UTF-16LE";
            }
            String clipString = new String(clipBytes, characterEncoding);
            log.info("Clipboard contents: " + clipString);
            return clipString;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public void setClipboardContents(String format, String data) throws InvalidLicenseException {
        this.setClipboardContents(format, data, true);
    }

    public void setClipboardContents(String format, String data, boolean clearExisting) throws InvalidLicenseException {
        this.plugin.excludeFreeLicense();
        this.plugin.getContext().setClipboardData(format, data.getBytes(), true, clearExisting);
    }

    public String[] getClipboardFormats() throws InvalidLicenseException {
        this.plugin.excludeFreeLicense();
        return this.plugin.getContext().getClipboardFormats();
    }

    public void setPluginContext(PluginContext pluginContext) {
        this.pluginContext = pluginContext;
    }
}

