/*
 * Decompiled with CFR 0.152.
 */
package com.prosc;

import org.jetbrains.annotations.NotNull;

public enum Platform {
    mac(true),
    windows(false),
    linux(true),
    unknown(true);

    public static final Platform current;
    public final boolean unixLike;

    private Platform(boolean unixLike) {
        this.unixLike = unixLike;
    }

    public static boolean isMac() {
        return current == mac;
    }

    public static boolean isWin() {
        return current == windows;
    }

    public static boolean isLin() {
        return current == linux;
    }

    public String pathTranslated(@NotNull String pathFromOtherPlatform) {
        if (pathFromOtherPlatform == null) {
            Platform.$$$reportNull$$$0(0);
        }
        if (pathFromOtherPlatform.startsWith("/")) {
            String backSlashed = pathFromOtherPlatform.replace("\\", ":").replace("/", "\\");
            return backSlashed.substring(1).replaceFirst("\\\\", ":\\\\");
        }
        return "/" + pathFromOtherPlatform.replace("/", ":").replace("\\", "/").replaceFirst("\\:/", "/");
    }

    static {
        String osName = System.getProperty("os.name");
        current = osName == null ? unknown : (osName.startsWith("Mac") ? mac : (osName.startsWith("Windows") ? windows : (osName.startsWith("Linux") ? linux : unknown)));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pathFromOtherPlatform", "com/prosc/Platform", "pathTranslated"));
    }
}

