/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.xml;

import com.prosc.shared.Bool;
import java.util.Collections;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSSerializer;

public class DomUtils {
    private static final Logger log = Logger.getLogger(DomUtils.class.getName());

    public static String getRecursiveChildText(Element xml, String childTag) {
        NodeList nodeList = xml.getElementsByTagName(childTag);
        if (nodeList.getLength() == 0) {
            return null;
        }
        return nodeList.item(0).getTextContent();
    }

    public static String getChildText(@Nullable Element xml, String childTag) {
        return DomUtils.getChildText(xml, childTag, true);
    }

    public static String getChildText(@Nullable Element xml, String childTag, boolean validateThatRecursiveCallMatches) {
        String recursiveResult;
        String result;
        Iterator<Element> elementsByTagName = DomUtils.getChildElements(xml, childTag).iterator();
        if (elementsByTagName.hasNext()) {
            Element next = elementsByTagName.next();
            result = next.getTextContent();
        } else {
            result = null;
        }
        if (validateThatRecursiveCallMatches && !Bool.equals(result, recursiveResult = DomUtils.getRecursiveChildText(xml, childTag))) {
            log.log(Level.INFO, "Recursive result for child tag '" + childTag + "' is not the same as shallow result. This is not generally a problem, but it could be for legacy classes that assumed that all calls are recursive." + "\nShallow result: " + result + "\nRecursive result: " + recursiveResult + "\nXML input: " + DomUtils.dumpXml(xml.getOwnerDocument(), xml), new RuntimeException("Stack trace"));
        }
        return result;
    }

    public static Iterable<Element> getChildElements(final @Nullable Node parent, final @Nullable String childName) {
        if (parent == null) {
            return Collections.emptyList();
        }
        return new Iterable<Element>(){

            @Override
            public Iterator<Element> iterator() {
                return new Iterator<Element>(){
                    Node child;
                    {
                        this.child = parent.getFirstChild();
                        if (this.child != null && !this.isValidResult(this.child)) {
                            this.readNextElement();
                        }
                    }

                    @Override
                    public boolean hasNext() {
                        return this.child != null;
                    }

                    @Override
                    public Element next() {
                        Element result = (Element)this.child;
                        this.readNextElement();
                        return result;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }

                    private boolean isValidResult(Node child) {
                        return child != null && child instanceof Element && (childName == null || childName.equals(child.getNodeName()));
                    }

                    private void readNextElement() {
                        do {
                            this.child = this.child.getNextSibling();
                        } while (this.child != null && !this.isValidResult(this.child));
                    }
                };
            }
        };
    }

    public static Iterable<Element> getChildElements(@Nullable Node parent) {
        return DomUtils.getChildElements(parent, null);
    }

    public static String dumpXml(Document document, @Nullable Element element) {
        DOMImplementationLS domImplementation = (DOMImplementationLS)((Object)document.getImplementation());
        LSSerializer lsSerializer = domImplementation.createLSSerializer();
        return lsSerializer.writeToString(element == null ? document : element);
    }
}

