/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.thread;

import java.util.concurrent.TimeoutException;

public class TimeoutTask {
    public void doWithTimeout(Runnable runnable, int timeoutMilliseconds, String threadName, boolean stopThreadOnTimeout) throws InterruptedException, TimeoutException {
        Thread worker = new Thread(runnable, threadName);
        worker.start();
        try {
            if (timeoutMilliseconds <= 0) {
                worker.join();
            } else {
                worker.join(timeoutMilliseconds);
                if (worker.isAlive()) {
                    worker.interrupt();
                    if (stopThreadOnTimeout) {
                        worker.stop();
                    }
                    throw new TimeoutException("Timeout task '" + threadName + "' did not finish within " + timeoutMilliseconds + " milliseconds.");
                }
            }
        }
        catch (InterruptedException e) {
            worker.interrupt();
            throw e;
        }
    }
}

