/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.shared;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StringUtils {
    private static final Logger log = Logger.getLogger(StringUtils.class.getName());
    private static final Pattern searchTermsPattern = Pattern.compile("\\w[\\w']*|('|\")[^'\"]+\\1");
    public static final String CR = System.getProperty("line.separator");

    public static String emptyStringForNull(Object s) {
        return s == null ? "" : s.toString();
    }

    public static String valueOf(Object o) {
        return o == null ? "" : String.valueOf(o);
    }

    public static String emptyStringForNull(String s) {
        return s == null ? "" : s.toString();
    }

    public static String nullForEmptyString(String s) {
        return StringUtils.isEmpty(s) ? null : s;
    }

    public static String escapeXMLString(String s) {
        if (s == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer((int)((double)s.length() * 1.1));
        StringUtils.escapeXMLString(s, buffer);
        return buffer.toString();
    }

    public static void escapeXMLString(String s, Appendable toAppendTo) {
        if (s == null) {
            return;
        }
        for (int i = 0; i < s.length(); ++i) {
            StringUtils.escapeXMLChar(s.charAt(i), toAppendTo);
        }
    }

    public static void escapeXMLChar(char c, Appendable toAppendTo) {
        try {
            switch (c) {
                case '<': {
                    StringUtils.escapeEntity("lt", toAppendTo);
                    return;
                }
                case '>': {
                    StringUtils.escapeEntity("gt", toAppendTo);
                    return;
                }
                case '&': {
                    StringUtils.escapeEntity("amp", toAppendTo);
                    return;
                }
                case '\"': {
                    StringUtils.escapeEntity("quot", toAppendTo);
                    return;
                }
            }
            toAppendTo.append(c);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void escapeEntity(String xmlEntity, Appendable sb) {
        try {
            sb.append('&');
            sb.append(xmlEntity);
            sb.append(';');
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String addSlashes(String in) {
        if (in == null) {
            return null;
        }
        return in.replaceAll("([\"'\\\\])", "\\\\$1");
    }

    public static String stripSlashes(String in) {
        if (in == null) {
            return null;
        }
        return in.replaceAll("\\\\([\\\\\"''])", "$1");
    }

    public static String replaceAllLiteral(String input, String searchText, String replaceText) {
        String replaceTextEscaped = replaceText == null || replaceText.length() == 0 ? "" : replaceText.replaceAll("\\\\", "\\\\\\\\").replaceAll("\\$", "\\\\\\$");
        return input.replaceAll("\\Q" + searchText + "\\E", replaceTextEscaped);
    }

    public static String join(String delimiter, Object ... parts) {
        return StringUtils.join(Arrays.asList(parts), delimiter);
    }

    public static String join(Object[] parts, String delimiter) {
        return StringUtils.join(Arrays.asList(parts), delimiter);
    }

    public static String join(String delimiter, @Nullable Integer maxLength, Iterable<?> parts) {
        if (parts == null) {
            return null;
        }
        if (delimiter == null) {
            throw new IllegalArgumentException("The delimiter cannnot be null. Use an empty string if you want no delimiter.");
        }
        StringBuilder result = new StringBuilder();
        String currentDelim = null;
        for (Object part : parts) {
            if (currentDelim == null) {
                currentDelim = delimiter;
            } else {
                result.append(currentDelim);
            }
            result.append(String.valueOf(part));
            if (maxLength == null || result.length() <= maxLength) continue;
            result.append("...");
            break;
        }
        return result.toString();
    }

    public static String join(Iterable<?> parts, String delimiter) {
        return StringUtils.join(delimiter, null, parts);
    }

    public static String unquote(String maybeQuoted) {
        if (maybeQuoted == null || maybeQuoted.length() < 2) {
            return maybeQuoted;
        }
        boolean isQuoted = false;
        int len = maybeQuoted.length();
        if (maybeQuoted.charAt(0) == '\"' && maybeQuoted.charAt(len - 1) == '\"') {
            isQuoted = true;
        } else if (maybeQuoted.charAt(0) == '\'' && maybeQuoted.charAt(len - 1) == '\'') {
            isQuoted = true;
        }
        if (isQuoted) {
            maybeQuoted = maybeQuoted.substring(1, len - 1);
        }
        return maybeQuoted;
    }

    public static String[] quotedExplode(String in, char separator) {
        int i;
        String[] out = new String[StringUtils.patternCount(in, String.valueOf(separator)) + 1];
        int arrayIndex = 0;
        int lastTokenIndex = 0;
        char quoteType = '\u0000';
        char lastChar = '\u0000';
        for (i = 0; i < in.length(); ++i) {
            char c = in.charAt(i);
            if ((c == '\'' || c == '\"') && lastChar != '\\') {
                if (quoteType == c) {
                    quoteType = '\u0000';
                    continue;
                }
                if (quoteType != '\u0000') continue;
                quoteType = c;
                continue;
            }
            if (quoteType != '\u0000' || c != separator) continue;
            if (lastChar == c) {
                lastTokenIndex = i + 1;
                continue;
            }
            String tok = in.substring(lastTokenIndex, i);
            if (tok.length() > 0) {
                out[arrayIndex++] = tok;
            }
            lastTokenIndex = i + 1;
        }
        if (i > lastTokenIndex) {
            out[arrayIndex++] = in.substring(lastTokenIndex, i);
        }
        if (arrayIndex < out.length) {
            String[] tmp = out;
            out = new String[arrayIndex];
            System.arraycopy(tmp, 0, out, 0, arrayIndex);
        }
        return out;
    }

    public static int patternCount(String string, String pattern) {
        int out = 0;
        int index = 0;
        int len = string.length();
        while (index < len && (index = string.indexOf(pattern, index) + 1) > 0) {
            ++out;
        }
        return out;
    }

    public static String encodeJS(String text) {
        text = StringUtils.addSlashes(text);
        text = text.replaceAll("\n", "\\\\n");
        return text;
    }

    public static String wrapLongHTMLLines(String result, int maxLineLength) {
        int len = 0;
        int lastAppendStartIndex = 0;
        boolean isInTag = false;
        StringBuffer wrappedResult = null;
        for (int i = 0; i < result.length(); ++i) {
            char c = result.charAt(i);
            if (isInTag) {
                if (c != '>') continue;
                isInTag = false;
            }
            if (c == '<') {
                isInTag = true;
            }
            len = Character.isWhitespace(c) ? 0 : ++len;
            if (len <= maxLineLength) continue;
            if (wrappedResult == null) {
                wrappedResult = new StringBuffer(result.length() + 10);
            }
            wrappedResult.append(result.substring(lastAppendStartIndex, i));
            wrappedResult.append(" ");
            lastAppendStartIndex = i;
            len = 0;
        }
        if (wrappedResult != null) {
            wrappedResult.append(result.substring(lastAppendStartIndex));
            return wrappedResult.toString();
        }
        return result;
    }

    public static void main(String[] args) {
        String result = StringUtils.addSlashes("this has a sing'le q\"uo\\ted block' in it.");
        log.info("Result: " + result);
        result = StringUtils.stripSlashes(result);
        log.info("Result: " + result);
        StringUtils.quotedExplode(result, ' ');
        String[] test = new String[]{null, null, "foo", "moo", "goo", "doo"};
        result = StringUtils.join(":", test);
        log.info(result);
    }

    public static Collection<String> searchTerms(String searchString) {
        LinkedList<String> result = new LinkedList<String>();
        if (searchString == null || searchString.length() == 0) {
            return result;
        }
        Matcher m = searchTermsPattern.matcher(searchString);
        while (m.find()) {
            String eachPart = m.group().trim();
            if (eachPart.length() == 0 || (eachPart.charAt(0) == '\"' || eachPart.charAt(0) == '\'') && eachPart.charAt(eachPart.length() - 1) == eachPart.charAt(0) && (eachPart.length() <= 1 || (eachPart = eachPart.substring(1, eachPart.length() - 1).trim()).length() == 0)) continue;
            result.add(eachPart);
        }
        return result;
    }

    public static String pluralize(String input) {
        String result;
        if (input.endsWith("ife")) {
            return input.substring(0, input.length() - 3) + "ives";
        }
        if (input.endsWith("s") || input.endsWith("sh") || input.endsWith("ch") || input.endsWith("x") || input.endsWith("z")) {
            result = input.concat("es");
        } else {
            if (input.endsWith("f") && !input.substring(input.length() - 2, 1).matches("[efo]")) {
                return input.substring(0, input.length() - 1) + "ves";
            }
            if (input.endsWith("o")) {
                return input + "es";
            }
            result = input.endsWith("y") && !StringUtils.isVowel(input.charAt(input.length() - 2)) ? input.substring(0, input.length() - 1).concat("ies") : input.concat("s");
        }
        return result;
    }

    public static String pluralizeIf(int count, @NotNull String word, @Nullable String pluralFormOptional) {
        if (word == null) {
            StringUtils.$$$reportNull$$$0(0);
        }
        if (count == 1) {
            return word;
        }
        return StringUtils.isEmpty(pluralFormOptional) ? StringUtils.pluralize(word) : pluralFormOptional;
    }

    private static boolean isVowel(char c) {
        char lower = Character.toLowerCase(c);
        return lower == 'a' || lower == 'e' || lower == 'i' || lower == 'o' || lower == 'u';
    }

    public static String nonConflictingName(String requestedName, Collection<String> takenNames) {
        if (StringUtils.caseInsensitiveSearch(takenNames, requestedName) == null) {
            return requestedName;
        }
        Pattern pattern = Pattern.compile("^(.*) copy ?[0-9]*$", 2);
        Matcher matcher = pattern.matcher(requestedName);
        String root = requestedName;
        if (matcher.find()) {
            root = matcher.group(1);
        }
        String result = root = root + " copy";
        int suffix = 0;
        while (StringUtils.caseInsensitiveSearch(takenNames, result) != null) {
            result = root + " " + ++suffix;
        }
        return result;
    }

    private static String caseInsensitiveSearch(Collection<String> names, String s) {
        for (String name : names) {
            String o = String.valueOf(name);
            if (!s.equalsIgnoreCase(String.valueOf(o))) continue;
            return o;
        }
        return null;
    }

    public static String camelCaseToCONSTANT_NAME(String s) {
        Pattern p = Pattern.compile("[A-Z]*[a-z0-9]*");
        Matcher m = p.matcher(s);
        StringBuilder result = new StringBuilder();
        while (m.find()) {
            if (result.length() > 0 && m.group(0).length() > 0) {
                result.append('_');
            }
            result.append(m.group(0));
        }
        return result.toString().toUpperCase();
    }

    public static String toCamelCase(String input, boolean capitalizeFirsLetter) {
        if (input == null) {
            return null;
        }
        input = input.replaceAll("[^A-Za-z0-9 ]", "").trim();
        StringBuilder result = new StringBuilder(input.length());
        char[] chars = input.toCharArray();
        for (int n = 0; n < chars.length; ++n) {
            if (n == 0) {
                result.append(capitalizeFirsLetter ? Character.toUpperCase(chars[n]) : Character.toLowerCase(chars[n]));
                continue;
            }
            if (chars[n] != ' ') {
                result.append(chars[n]);
                continue;
            }
            while (chars[n] == ' ') {
                ++n;
            }
            result.append(Character.toUpperCase(chars[n]));
        }
        return result.toString();
    }

    public static String normalizeString(String s) {
        return s.replaceAll("[^A-Za-z_0-9]", "_");
    }

    public static String beautifyAttributeName(String name) {
        if (name == null) {
            return null;
        }
        int len = name.length();
        if (len == 0) {
            return name;
        }
        StringBuilder out = new StringBuilder(len + 4);
        out.append(Character.toUpperCase(name.charAt(0)));
        for (int i = 1; i < len; ++i) {
            char c = name.charAt(i);
            if (c == '_') {
                out.append(' ');
                out.append(Character.toUpperCase(name.charAt(++i)));
                continue;
            }
            if (Character.isUpperCase(c) && !Character.isUpperCase(name.charAt(i - 1))) {
                out.append(' ');
            }
            out.append(c);
        }
        return out.toString();
    }

    public static String truncate(String input, int maxLength) throws IllegalArgumentException {
        if (input == null) {
            return null;
        }
        if (input.length() < maxLength) {
            return input;
        }
        String ellipsis = "\u2026";
        if (maxLength < ellipsis.length()) {
            throw new IllegalArgumentException("maxLength must be at least " + ellipsis.length());
        }
        return input.substring(0, maxLength - ellipsis.length()) + ellipsis;
    }

    public static String titleCase(String s) {
        if (s == null || s.length() == 0) {
            return s;
        }
        if (s.length() == 1) {
            return s.toUpperCase();
        }
        StringBuilder result = new StringBuilder(s.length());
        String delim = "";
        for (String eachPart : s.split(" ")) {
            result.append(delim);
            delim = " ";
            if (eachPart.length() < 2) {
                result.append(eachPart);
                continue;
            }
            result.append(eachPart.substring(0, 1).toUpperCase()).append(eachPart.substring(1).toLowerCase());
        }
        return result.toString();
    }

    public static boolean isEmpty(String s) {
        return s == null || s.length() == 0;
    }

    public static boolean isEmptyOrWhitespace(String s) {
        return s == null || s.length() == 0 || s.length() != 0 && StringUtils.isEmpty(s.trim());
    }

    public static String exceptionToString(Throwable e) {
        StringWriter writer = new StringWriter();
        e.printStackTrace(new PrintWriter(writer));
        return ((Object)writer).toString();
    }

    public static String textBetween(String searchString, String start, String end) {
        int endIndex;
        if (searchString == null) {
            return null;
        }
        int startIndex = searchString.indexOf(start);
        if (startIndex == -1) {
            return null;
        }
        int n = endIndex = end == null ? -1 : searchString.indexOf(end, startIndex += start.length());
        if (endIndex == -1) {
            return searchString.substring(startIndex);
        }
        return searchString.substring(startIndex, endIndex);
    }

    public static String generateMD5HashString(String theString) {
        MessageDigest digest;
        try {
            digest = MessageDigest.getInstance("MD5");
            digest.update(theString.getBytes("utf-8"));
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Something is wrong with JDK, cannot login", e);
            throw new IllegalStateException("Misconfiguration on server; cannot login.", e);
        }
        byte[] hash = digest.digest();
        return StringUtils.byteArrayToHex(hash);
    }

    public static String byteArrayToHex(byte[] array) {
        BigInteger bi = new BigInteger(1, array);
        return String.format("%0" + (array.length << 1) + "X", bi).toLowerCase();
    }

    public static int compare(@Nullable String s1, @Nullable String s2) {
        if (s1 == null) {
            return s2 == null ? 0 : -1;
        }
        if (s2 == null) {
            return 1;
        }
        return s1.compareTo(s2);
    }

    public static String valueOfCollection(Collection<?> c, int maxLength) {
        if (c == null) {
            return "";
        }
        Iterator<?> i = c.iterator();
        if (!i.hasNext()) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder((int)((double)maxLength * 1.5));
        sb.append('[');
        while (true) {
            String s;
            Object e;
            if ((e = i.next()) == c) {
                s = "(this Collection)";
            } else {
                s = String.valueOf(e);
                if (s.length() > maxLength) {
                    s = s.substring(0, maxLength - 1);
                }
            }
            sb.append(s);
            if (sb.length() >= maxLength) {
                if (sb.length() > maxLength) {
                    sb.delete(1000, sb.length() - 1);
                }
                return sb.append("<truncated...>").toString();
            }
            if (!i.hasNext()) {
                return sb.append(']').toString();
            }
            sb.append(", ");
        }
    }

    public String leftOf(String string, String delimiter) {
        if (string == null || !string.contains(delimiter)) {
            return string;
        }
        return string.substring(0, string.indexOf(delimiter));
    }

    public String rightOf(String string, String delimiter) {
        if (string == null || !string.contains(delimiter)) {
            return string;
        }
        return string.substring(string.indexOf(delimiter) + 1, string.length());
    }

    public static String repeat(String s, int times) {
        StringBuilder sb = new StringBuilder(s.length() * times);
        for (int i = 0; i < times; ++i) {
            sb.append(s);
        }
        return sb.toString();
    }

    public static byte[] getBytesUTF8(String s) {
        try {
            return s.getBytes("utf-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getSHA256(String s) {
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        md.update(s.getBytes());
        byte[] byteData = md.digest();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < byteData.length; ++i) {
            sb.append(String.format("%02x", byteData[i]));
        }
        return sb.toString();
    }

    public static String textAfter(String originalText, String searchText) {
        int mark = originalText.lastIndexOf(searchText);
        if (mark == -1) {
            return originalText;
        }
        return originalText.substring(mark + searchText.length());
    }

    public static String convertLineEndings(String string) {
        LineEnding e;
        if ("\r".equals(CR)) {
            e = LineEnding.CR;
        } else if ("\n".equals(CR)) {
            e = LineEnding.LF;
        } else if ("\r\n".equals(CR)) {
            e = LineEnding.CRLF;
        } else {
            return string;
        }
        int capacity = CR.length() == 1 ? string.length() : (int)((double)string.length() * 1.05);
        StringBuilder sb = new StringBuilder(capacity);
        char[] chars = string.toCharArray();
        for (int n = 0; n < chars.length; ++n) {
            char c = chars[n];
            if (c == '\r') {
                if (chars[n + 1] == '\n') {
                    ++n;
                }
                sb.append(e.ending);
                continue;
            }
            if (c == '\n') {
                sb.append(e.ending);
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "word", "com/prosc/shared/StringUtils", "pluralizeIf"));
    }

    private static enum LineEnding {
        CR("\r"),
        LF("\n"),
        CRLF("\r\n");

        public final String ending;

        private LineEnding(String ending) {
            this.ending = ending;
        }
    }
}

