/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.io;

import com.prosc.Platform;
import com.prosc.io.IOUtils;
import com.prosc.io.ProcessExecutionException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jetbrains.annotations.Nullable;

public class ProcessUtils {
    private static final Logger log = Logger.getLogger(ProcessUtils.class.getName());

    public static byte[] doShellCommand(String[] commandArray, @Nullable Map<String, String> env, @Nullable File workingDir) throws ProcessExecutionException, InterruptedException, IOException {
        try {
            return ProcessUtils.doShellCommand(commandArray, env, workingDir, 0);
        }
        catch (TimeoutException e) {
            throw new InterruptedException();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] doShellCommand(final String[] commandArray, final @Nullable Map<String, String> env, final @Nullable File workingDir, int timeout) throws ProcessExecutionException, InterruptedException, IOException, TimeoutException {
        Callable<byte[]> callable = new Callable<byte[]>(){

            @Override
            public byte[] call() throws IOException, ProcessExecutionException, InterruptedException {
                boolean shouldLog = false;
                for (String s : commandArray) {
                    if (s != null && !"".equals(s)) continue;
                    throw new IllegalArgumentException("None of the elements of the commandArray may be null or empty: " + Arrays.asList(commandArray));
                }
                if (shouldLog && log.isLoggable(Level.INFO)) {
                    String message = "Executing shell command with params: " + Arrays.asList(commandArray);
                    if (workingDir != null) {
                        message = message + " with directory " + workingDir.getAbsolutePath();
                    }
                    if (env != null) {
                        message = message + "\n Env variables: " + Arrays.asList(env);
                    }
                    log.log(Level.INFO, message);
                }
                LinkedHashMap<String, String> envMap = new LinkedHashMap<String, String>(System.getenv());
                if (env != null) {
                    for (Map.Entry entry : env.entrySet()) {
                        envMap.put((String)entry.getKey(), (String)entry.getValue());
                    }
                }
                ProcessBuilder builder = new ProcessBuilder(commandArray);
                if (workingDir != null) {
                    builder.directory(workingDir);
                }
                if (env != null) {
                    for (Map.Entry entry : envMap.entrySet()) {
                        builder.environment().put((String)entry.getKey(), (String)entry.getValue());
                    }
                }
                builder.redirectErrorStream(true);
                Process process = builder.start();
                InputStream inputStream = process.getInputStream();
                try {
                    int exitStatus;
                    byte[] data = IOUtils.inputStreamAsBytes(inputStream);
                    try {
                        exitStatus = process.waitFor();
                    }
                    catch (InterruptedException e) {
                        log.info("ProcessUtils was interrupted; destroying subprocess");
                        process.destroy();
                        log.info("Process " + process + " was destroyed");
                        throw e;
                    }
                    if (exitStatus == 0) {
                        byte[] e = data;
                        return e;
                    }
                    String[] commandCopy = new String[commandArray.length];
                    System.arraycopy(commandArray, 0, commandCopy, 0, commandArray.length);
                    for (int m = 0; m < commandCopy.length; ++m) {
                        if (commandCopy[m] == null || !commandCopy[m].toLowerCase().contains("pass") || m + 1 >= commandCopy.length) continue;
                        commandCopy[m + 1] = "xxxxx";
                    }
                    String errorMessage = "Command " + Arrays.asList(commandCopy) + " failed with exit status " + exitStatus;
                    if (data.length > 0) {
                        errorMessage = errorMessage + "\nCommand output: \n" + new String(data, "UTF-8");
                    }
                    throw new ProcessExecutionException(data, errorMessage, exitStatus);
                }
                finally {
                    inputStream.close();
                }
            }
        };
        try {
            if (timeout <= 0) {
                return (byte[])callable.call();
            }
            ExecutorService service = Executors.newSingleThreadExecutor();
            Future<byte[]> future = service.submit(callable);
            try {
                byte[] byArray = future.get(timeout, TimeUnit.MILLISECONDS);
                return byArray;
            }
            catch (TimeoutException e) {
                log.info("Process exceeded timeout; will cancel it.");
                future.cancel(true);
                throw e;
            }
            catch (InterruptedException e) {
                future.cancel(true);
                throw e;
            }
            finally {
                service.shutdown();
            }
        }
        catch (Throwable t) {
            if (t instanceof ExecutionException) {
                t = t.getCause();
            }
            if (t instanceof ProcessExecutionException) {
                throw (ProcessExecutionException)t;
            }
            if (t instanceof InterruptedException) {
                throw (InterruptedException)t;
            }
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            if (t instanceof TimeoutException) {
                throw (TimeoutException)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            if (!(t instanceof RuntimeException)) throw new RuntimeException(t);
            throw (RuntimeException)t;
        }
    }

    public static Collection<String> findPids(String processName, String commandSearch) throws TimeoutException {
        String[] lines;
        String[] cmd = Platform.current == Platform.windows ? new String[]{"wmic", "PROCESS", "where", "name like '%" + processName + "%'", "GET", "Processid,Caption,Commandline"} : new String[]{"ps", "axwww"};
        try {
            byte[] bytes = ProcessUtils.doShellCommand(cmd, null, null, 15000);
            String searchIn = new String(bytes, "utf-8");
            lines = searchIn.split(System.getProperty("line.separator"));
        }
        catch (TimeoutException e) {
            log.log(Level.SEVERE, "Process timed out: " + Arrays.asList(cmd), e);
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        LinkedList<String> result = new LinkedList<String>();
        for (String line : lines) {
            if (!line.contains(processName) || !line.contains(commandSearch)) continue;
            if (Platform.current == Platform.windows) {
                line = line.trim();
                result.add(line.substring(line.lastIndexOf(32) + 1));
                continue;
            }
            result.add(line.substring(0, line.indexOf(" ")));
        }
        return result;
    }

    public static int getCurrentProcessId() {
        String processName = ManagementFactory.getRuntimeMXBean().getName();
        int mark1 = processName.indexOf(64);
        if (mark1 != -1) {
            processName = processName.substring(0, mark1);
        }
        return Integer.valueOf(processName);
    }
}

