/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.io;

import java.util.Arrays;
import java.util.List;

public enum FileType {
    unknown("application/unknown", "dat"),
    png("image/png", "png"),
    jpeg("image/jpeg", "jpg", "jpeg"),
    gif("image/gif", "gif"),
    tiff("image/tiff", "tif", "tiff"),
    pdf("application/pdf", "pdf"),
    doc("application/msword", "doc"),
    docx("application/vnd.openxmlformats-officedocument.wordprocessingml.document", "docx", "docm", "dotx", "dotm"),
    xlsx("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", "xlsx"),
    pptx("application/vnd.openxmlformats-officedocument.presentationml.presentation", "pptx"),
    zip("application/zip", "zip");

    private String mimeType;
    private List<String> extensions;

    private FileType(String mimeType, String ... extensions) {
        this.mimeType = mimeType;
        this.extensions = Arrays.asList(extensions);
    }

    public String getPrimaryExtension() {
        return this.extensions.get(0);
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public static FileType fileTypeForFileName(String filename) {
        String suffix = filename.substring(filename.lastIndexOf(46) + 1);
        for (FileType fileType : FileType.values()) {
            if (!fileType.extensions.contains(suffix)) continue;
            return fileType;
        }
        return null;
    }
}

