/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.io;

import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;
import org.jetbrains.annotations.NotNull;

public class CRLFConvertingReader
extends PushbackReader {
    public static final String CRLF = "\r\n";
    private final String lineSeparator;
    private final char[] lineSeparatorChars;
    private int __length = 0;
    private char[] buf;
    private int pos;

    public final boolean isConversionRequired() {
        return !this.lineSeparator.equals(CRLF);
    }

    public CRLFConvertingReader(Reader input) {
        this(input, System.getProperty("line.separator"));
    }

    public CRLFConvertingReader(Reader input, String lineSeparator) {
        super(input, lineSeparator.toCharArray().length + 1);
        this.lineSeparator = lineSeparator;
        this.lineSeparatorChars = this.lineSeparator.toCharArray();
        this.buf = new char[this.lineSeparatorChars.length + 1];
        this.pos = this.lineSeparatorChars.length + 1;
    }

    /*
     * Enabled aggressive block sorting
     */
    private int __read() throws IOException {
        int ch = super.read();
        if (ch != 13) {
            if (ch != 10) return ch;
            return 13;
        }
        ch = super.read();
        if (ch == 10) {
            this.unread(this.lineSeparatorChars);
            ch = super.read();
            --this.__length;
            return ch;
        }
        if (ch == -1) return 13;
        this.unread(ch);
        return 13;
    }

    @Override
    public int read() throws IOException {
        if (!this.isConversionRequired()) {
            return super.read();
        }
        return this.__read();
    }

    @Override
    public int read(@NotNull char[] buffer) throws IOException {
        if (buffer == null) {
            CRLFConvertingReader.$$$reportNull$$$0(0);
        }
        return this.read(buffer, 0, buffer.length);
    }

    @Override
    public int read(char[] buffer, int offset, int length) throws IOException {
        if (!this.isConversionRequired()) {
            return super.read(buffer, offset, length);
        }
        if (length < 1) {
            return 0;
        }
        int ch = this.buf.length - this.pos;
        this.pos += ch;
        int n = this.__length = length > ch ? ch : length;
        if (!this.ready()) {
            this.__length = 1;
        }
        if ((ch = this.__read()) == -1) {
            return -1;
        }
        int off = offset;
        do {
            buffer[offset++] = (char)ch;
        } while (--this.__length > 0 && (ch = this.__read()) != -1);
        return offset - off;
    }

    @Override
    public void unread(int c) throws IOException {
        super.unread(c);
        this.buf[--this.pos] = (char)c;
    }

    @Override
    public void unread(char[] cbuf, int off, int len) throws IOException {
        super.unread(cbuf, off, len);
        this.pos -= len;
        System.arraycopy(cbuf, off, this.buf, this.pos, len);
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.buf = null;
    }

    @Override
    public long skip(long n) throws IOException {
        long skip = super.skip(n);
        int avail = this.buf.length - this.pos;
        if (avail > 0) {
            this.pos = n <= (long)avail ? (int)((long)this.pos + n) : this.buf.length;
        }
        return skip;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "com/prosc/io/CRLFConvertingReader", "read"));
    }
}

