/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.fmkit.types;

import com.prosc.fmkit.PluginContext;
import com.prosc.fmkit.types.FMText;
import java.io.IOException;
import java.io.Reader;

public class FMTextReader
extends Reader {
    private FMText textPtr;
    private long length;
    private long pointer = 0L;
    private PluginContext context;

    public FMTextReader(FMText textPtr, PluginContext context) {
        this.textPtr = textPtr;
        this.length = textPtr.getTextLength(context);
        this.context = context;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        if (len > cbuf.length) {
            len = cbuf.length;
        }
        if ((long)len > this.length - this.pointer) {
            len = (int)(this.length - this.pointer);
        }
        if (len == 0) {
            return -1;
        }
        this.textPtr.readData(cbuf, off, len, this.context);
        this.pointer += (long)len;
        return len;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public long skip(long n) throws IOException {
        long newPointer = this.pointer + n;
        if (newPointer > this.length) {
            newPointer = this.length;
        }
        long result = newPointer - this.pointer;
        this.pointer = newPointer;
        return result;
    }

    public long getLength() {
        return this.length;
    }
}

