/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.fmkit.types;

import com.prosc.fmkit.CodeToParent;
import com.prosc.fmkit.PluginContext;
import com.prosc.fmkit.PluginUtils;
import com.prosc.fmkit.types.Converter;
import com.prosc.fmkit.types.FMCharacterStyle;
import com.prosc.fmkit.types.FMData;
import com.prosc.fmkit.types.FMTextReader;
import com.prosc.fmkit.types.FMType;
import com.prosc.io.CRLFConvertingReader;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.Reader;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jetbrains.annotations.NotNull;

public class FMText
extends FMType {
    private static final Logger log = Logger.getLogger(FMText.class.getName());
    public static final int Encoding_Native = 0;
    public static final int Encoding_UTF8 = 1;
    public static final int Encoding_ASCII_DOS = 2;
    public static final int Encoding_ASCII_Windows = 3;
    public static final int Encoding_ASCII_Mac = 4;
    public static final int Encoding_ISO_8859_1 = 5;
    public static final int Encoding_ShiftJIS_Mac = 6;
    public static final int Encoding_ShiftJIS_Win = 7;
    public static final int Encoding_Korean_Mac = 8;
    public static final int Encoding_Korean_Win = 9;
    public static final int Encoding_Korean_Johab = 10;
    public static final int Encoding_ChineseTrad_Mac = 11;
    public static final int Encoding_ChineseTrad_Win = 12;
    public static final int Encoding_ChineseSimp_Mac = 13;
    public static final int Encoding_ChineseSimp_Win = 14;
    public static final int Encoding_Cyrillic_Mac = 15;
    public static final int Encoding_Cyrillic_Win = 16;
    public static final int Encoding_ISO_8859_5 = 17;
    public static final int Encoding_CentralEurope_Mac = 18;
    public static final int Encoding_EasternEurope_Win = 20;
    public static final int Encoding_ISO_8859_2 = 21;
    public static final int Encoding_Turkish_Mac = 22;
    public static final int Encoding_Turkish_Win = 23;
    public static final int Encoding_ISO_8859_3 = 24;
    public static final int Encoding_ISO_8859_9 = 25;
    public static final int Encoding_Baltic_Win = 26;
    public static final int Encoding_ISO_8859_4 = 27;
    public static final int Encoding_Arabic_Mac = 28;
    public static final int Encoding_Arabic_Win = 29;
    public static final int Encoding_ISO_8859_6 = 30;
    public static final int Encoding_Greek_Mac = 31;
    public static final int Encoding_Greek_Win = 32;
    public static final int Encoding_ISO_8859_7 = 33;
    public static final int Encoding_Hebrew_Mac = 34;
    public static final int Encoding_Hebrew_Win = 35;
    public static final int Encoding_ISO_8859_8 = 36;
    public static final int Encoding_ISO_8859_15 = 37;
    public static final int Size_Invalid = 0xFFFFFFF;
    public static final int Size_End = -1;
    private final long cToken;
    private FMData fmData;

    public FMText(PluginContext context, String value) {
        this(context, value, false);
    }

    public FMText(PluginContext context, String value, boolean convertNewlines) {
        if (convertNewlines) {
            value = PluginUtils.convertLineBreaksToFileMaker(value);
        }
        this.cToken = value == null || Objects.equals(value, "") ? this._createEmptyText(context) : this._createText(context, value);
        this.fmData = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FMText(final PluginContext context, Reader source) throws IOException {
        if (source == null) {
            throw new IllegalArgumentException("You cannot supply a null reader");
        }
        this.cToken = this._createEmptyText(context);
        log.fine("Started reading");
        char[] buffer = new char[8192];
        try (BufferedReader reader = new BufferedReader(new CRLFConvertingReader(source, "\r")){

            @Override
            public int read(@NotNull char[] cbuf, int off, int len) throws IOException {
                int read;
                if (cbuf == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((read = super.read(cbuf, off, len)) != -1) {
                    FMText.this._appendChars(FMText.this.cToken, cbuf, read, context);
                }
                return read;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cbuf", "com/prosc/fmkit/types/FMText$1", "read"));
            }
        };){
            while (reader.read(buffer) != -1) {
            }
        }
        finally {
            log.fine("Finished reading");
        }
    }

    public FMText(long cToken, FMData fmData) {
        this.cToken = cToken;
        this.fmData = fmData;
    }

    public String toString() {
        return super.toString();
    }

    @Override
    public String getAsString(PluginContext context) {
        if (this.fmData == null) {
            this.fmData = new FMData(context);
            this.writeToData(context, this.fmData);
        }
        return this.fmData.getStringData(context);
    }

    @Override
    public void writeToData(PluginContext context, FMData destination) {
        this._writeToData(context, this.cToken, destination.getCToken());
    }

    private void _appendChars(long cToken, char[] chars, int length, PluginContext context) {
        context.callback(CodeToParent.appendBytesToFmText, out -> {
            out.writeLong(cToken);
            out.writeUTF16String(new String(chars, 0, length));
        }, null);
    }

    public void readData(char[] chars, int offset, int amount, PluginContext context) {
        this._readData(this.cToken, chars, offset, amount, context);
    }

    private void _readData(long cToken, char[] chars, int offset, int amount, PluginContext context) {
        context.callback(CodeToParent.readBytesFromFmText, out -> {
            out.writeLong(cToken);
            out.writeInt(offset);
            out.writeInt(amount);
        }, in -> {
            String utf16String = in.readUTF16String();
            utf16String.getChars(0, utf16String.length(), chars, 0);
            return null;
        });
    }

    protected static void registerConverters() {
        FMType.addConverter(new FMTextConverter());
        FMType.addConverter(new StringConverter());
        FMType.addConverter(new ReaderConverter());
    }

    private long _createEmptyText(PluginContext context) {
        return context.callback(CodeToParent.createEmptyFmText, null, DataInputStream::readLong);
    }

    public char[] readCharArray(long token, int offset, int length, PluginContext context) {
        return context.callback(CodeToParent.appendBytesToFmText, out -> {
            out.writeLong(token);
            out.writeInt(offset);
            out.writeInt(length);
        }, in -> {
            char[] result = new char[length];
            for (int i = 0; i < length; ++i) {
                result[i] = in.readChar();
            }
            return result;
        });
    }

    private long _createText(PluginContext context, String initialContents) {
        return context.callback(CodeToParent.createFmText, out -> out.writeUTF16String(initialContents), DataInputStream::readLong);
    }

    private void _writeToData(PluginContext context, long textCToken, long dataCToken) {
        context.callback(CodeToParent.writeFmTextToFmData, out -> {
            out.writeLong(textCToken);
            out.writeLong(dataCToken);
        }, null);
    }

    public long getTextLength(PluginContext context) {
        return context.callback(CodeToParent.getTextLength, out -> out.writeLong(this.cToken), DataInputStream::readLong);
    }

    private void _appendText(long originalCToken, long appendCToken, PluginContext context) {
        context.callback(CodeToParent.appendText, out -> {
            out.writeLong(originalCToken);
            out.writeLong(appendCToken);
        }, null);
    }

    public void appendText(FMText text, PluginContext context) {
        this._appendText(this.cToken, text.cToken, context);
    }

    public void setStyle(FMCharacterStyle style, long position, long length, PluginContext context) {
        this._setStyle(this.cToken, style.cToken, position, length, context);
    }

    private void _setStyle(long cToken, long styleToken, long position, long length, PluginContext context) {
        context.callback(CodeToParent.setCharStyle, out -> {
            out.writeLong(cToken);
            out.writeLong(styleToken);
            out.writeLong(position);
            out.writeLong(length);
        }, null);
    }

    public FMCharacterStyle getStyle(long position, PluginContext context) {
        return new FMCharacterStyle(this._getStyle(this.cToken, position, context));
    }

    private long _getStyle(long cToken, long position, PluginContext context) {
        return context.callback(CodeToParent.getCharStyle, out -> {
            out.writeLong(cToken);
            out.writeLong(position);
        }, DataInputStream::readLong);
    }

    public FMData getFmData() {
        return this.fmData;
    }

    public FMCharacterStyle getDefaultStyle(PluginContext context) {
        return new FMCharacterStyle(this._getDefaultStyle(this.cToken, context));
    }

    private long _getDefaultStyle(long token, PluginContext context) {
        return context.callback(CodeToParent.getDefaultCharStyle, out -> out.writeLong(token), DataInputStream::readLong);
    }

    private static class ReaderConverter
    implements Converter {
        private ReaderConverter() {
        }

        @Override
        public boolean canConvertTo(Class targetClass) {
            return targetClass == Reader.class || targetClass == FMTextReader.class;
        }

        @Override
        public Object convertData(FMData param, Class targetClass, PluginContext context) {
            return new FMTextReader(param.getFMText(context), context);
        }
    }

    private static class StringConverter
    implements Converter {
        private StringConverter() {
        }

        @Override
        public boolean canConvertTo(Class targetClass) {
            return String.class == targetClass;
        }

        @Override
        public Object convertData(FMData param, Class targetClass, PluginContext context) {
            if (param == null || param.isEmpty(context)) {
                return null;
            }
            FMText fmText = param.getFMText(context);
            if (fmText != null && fmText.getTextLength(context) > 100000L) {
                if (fmText.getTextLength(context) > Integer.MAX_VALUE) {
                    throw new RuntimeException("Text is too large: " + fmText.getTextLength(context) + " chars");
                }
                try {
                    int charsRead;
                    FMTextReader reader = new FMTextReader(fmText, context);
                    char[] buffer = new char[65536];
                    StringBuffer toAppendTo = new StringBuffer((int)fmText.getTextLength(context));
                    while ((charsRead = reader.read(buffer)) != -1) {
                        for (int i = 0; i < charsRead; ++i) {
                            if (buffer[i] != '\r') continue;
                            buffer[i] = 10;
                        }
                        toAppendTo.append(buffer, 0, charsRead);
                    }
                    String stringData = toAppendTo.toString();
                    return stringData.length() == 0 ? null : stringData;
                }
                catch (IOException e) {
                    log.log(Level.SEVERE, "Could not read FMText into String", e);
                }
            }
            String stringData = param.getStringData(context);
            return (stringData = stringData.replace('\r', '\n')) == null || stringData.length() == 0 ? null : stringData;
        }
    }

    public static class EnumConverter
    implements Converter {
        private final Class<?> enumClass;
        private int startingIndex;

        public EnumConverter(Class<?> enumClass) {
            this.enumClass = enumClass;
        }

        @Override
        public boolean canConvertTo(Class targetClass) {
            return this.enumClass == targetClass;
        }

        @Override
        public Object convertData(FMData param, Class targetClass, PluginContext context) {
            if (param == null || param.isEmpty(context)) {
                return null;
            }
            if (param.getNativeType(context) == 2) {
                int fmIndex = (int)param.getLongData(context);
                if (fmIndex == 0 && this.startingIndex > 0) {
                    return null;
                }
                int javaIndex = fmIndex - this.startingIndex;
                return targetClass.getEnumConstants()[javaIndex];
            }
            String stringData = param.getStringData(context);
            if (stringData == null || stringData.length() == 0) {
                return null;
            }
            for (Object eachEnum : targetClass.getEnumConstants()) {
                if (!String.valueOf(eachEnum).equalsIgnoreCase(stringData)) continue;
                return eachEnum;
            }
            log.warning("No enumeration type matched the string value of " + stringData);
            return null;
        }

        public void setStartingIndex(int startingIndex) {
            log.info("setStartingIndex of " + this + " to " + startingIndex);
            this.startingIndex = startingIndex;
        }
    }

    private static class FMTextConverter
    implements Converter {
        private FMTextConverter() {
        }

        @Override
        public boolean canConvertTo(Class targetClass) {
            return FMText.class == targetClass;
        }

        @Override
        public Object convertData(FMData param, Class targetClass, PluginContext context) {
            return param.getFMText(context);
        }
    }
}

