/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.fmkit;

import com.prosc.deployment.DeploymentInfo;
import com.prosc.fmkit.ProscPlugin;
import com.prosc.fmkit.RegisterablePlugin;
import com.prosc.infrastructure.LogUtils;
import com.prosc.license.client.Registration;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javafx.beans.InvalidationListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.DialogPane;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;

public class RegisterDialogPane
extends DialogPane {
    @FXML
    private ResourceBundle resources;
    @FXML
    private URL location;
    @FXML
    private Label productVersionLabel;
    @FXML
    private Label licenseTypeLabel;
    @FXML
    private Label registeredToLabel;
    @FXML
    private TextField licenseKeyField;
    @FXML
    private TextField registeredToField;
    @FXML
    private TextField emailAddress;
    @FXML
    private TextField phoneNumber;
    @FXML
    private TextArea problemDescription;
    @FXML
    private CheckBox includeLogFile;
    @FXML
    private Label errorText;
    public static final Logger log = Logger.getLogger(RegisterDialogPane.class.getName());
    private Button questionButton;
    private Button registerButton;
    private Button bugButton;
    private Button cancelButton;
    private ProscPlugin plugin;
    private Registration registration;

    @FXML
    void initialize() {
        assert (this.productVersionLabel != null) : "fx:id=\"productVersionLabel\" was not injected: check your FXML file 'RegisterDialogController.fxml'.";
        assert (this.licenseTypeLabel != null) : "fx:id=\"licenseTypeLabel\" was not injected: check your FXML file 'RegisterDialogController.fxml'.";
        assert (this.registeredToLabel != null) : "fx:id=\"registeredToLabel\" was not injected: check your FXML file 'RegisterDialogController.fxml'.";
        assert (this.licenseKeyField != null) : "fx:id=\"licenseKeyField\" was not injected: check your FXML file 'RegisterDialogController.fxml'.";
        assert (this.registeredToField != null) : "fx:id=\"registeredToField\" was not injected: check your FXML file 'RegisterDialogController.fxml'.";
        assert (this.emailAddress != null) : "fx:id=\"emailAddress\" was not injected: check your FXML file 'RegisterDialogController.fxml'.";
        assert (this.phoneNumber != null) : "fx:id=\"phoneNumber\" was not injected: check your FXML file 'RegisterDialogController.fxml'.";
        assert (this.problemDescription != null) : "fx:id=\"problemDescription\" was not injected: check your FXML file 'RegisterDialogController.fxml'.";
        assert (this.includeLogFile != null) : "fx:id=\"includeLogFile\" was not injected: check your FXML file 'RegisterDialogController.fxml'.";
        assert (this.errorText != null) : "fx:id=\"errorText\" was not injected: check your FXML file 'RegisterDialogController.fxml'.";
        this.onInitialize();
    }

    RegisterDialogPane() {
        String fxmlName = RegisterDialogPane.class.getSimpleName() + ".fxml";
        URL resource = RegisterDialogPane.class.getResource(fxmlName);
        if (resource == null) {
            throw new IllegalStateException("Could not load fxml to generate user interface; no resource exists at " + fxmlName);
        }
        ResourceBundle bundle = ResourceBundle.getBundle(RegisterDialogPane.class.getCanonicalName());
        FXMLLoader fxmlLoader = new FXMLLoader(resource, bundle);
        fxmlLoader.setRoot((Object)this);
        fxmlLoader.setController((Object)this);
        try {
            fxmlLoader.load();
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
    }

    public String getLicenseKeyFieldValue() {
        return this.licenseKeyField.getText();
    }

    public String getRegisteredToFieldValue() {
        return this.registeredToField.getText();
    }

    public void setLicenseKeyFieldValue(String value) {
        this.licenseKeyField.setText(value);
    }

    public void setRegisteredToFieldValue(String value) {
        this.registeredToField.setText(value);
    }

    public void showErrorMessage(String errorMessage) {
        this.errorText.setText(errorMessage);
        this.errorText.setVisible(true);
    }

    private void hideErrorMessage() {
        this.errorText.setText(null);
        this.errorText.setVisible(false);
    }

    void askQuestion(ActionEvent event) {
        this.plugin.getPluginBridge().getFxEnv().getHostServices().showDocument(this.plugin.getSupportUrl());
    }

    public boolean isRegisteringPlugin() {
        return this.registerButton.isArmed();
    }

    public boolean isSubmittingBugReport() {
        return this.bugButton.isArmed();
    }

    public void reportBug() throws IOException, IllegalArgumentException {
        Throwable throwable;
        HttpURLConnection urlConnection;
        block40: {
            if (this.emailAddress.getText() == null || this.emailAddress.getText().length() == 0) {
                throw new IllegalArgumentException("You must include an email address");
            }
            String bugReportUrl = "http://www.360works.com/BugReporter/Plugin";
            urlConnection = (HttpURLConnection)new URL(bugReportUrl).openConnection();
            urlConnection.setConnectTimeout(10000);
            urlConnection.setReadTimeout(10000);
            urlConnection.setDoOutput(true);
            throwable = null;
            try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new BufferedOutputStream(urlConnection.getOutputStream()), "utf-8");){
                this.sendData(writer, "email", this.emailAddress.getText(), true);
                this.sendData(writer, "phone", this.phoneNumber.getText(), false);
                this.sendData(writer, "problemReport", this.problemDescription.getText(), false);
                this.sendData(writer, "pluginName", this.plugin.getName(), false);
                this.sendData(writer, "pluginVersion", this.plugin.getVersion().stringVersion, false);
                String systemEnvironment = LogUtils.getSystemInfo(true);
                try {
                    DeploymentInfo deploymentInfo = DeploymentInfo.getApplicationInstance();
                    systemEnvironment = systemEnvironment + "\n\n" + deploymentInfo.getSummary() + " " + deploymentInfo.getURL();
                }
                catch (Exception deploymentInfo) {
                    // empty catch block
                }
                String filemakerVersion = this.plugin.getPluginBridge().getVersionString();
                systemEnvironment = systemEnvironment + "\nFileMaker version:" + filemakerVersion;
                log.info("Successfully retrieved fileMaker version during configure: " + filemakerVersion);
                this.sendData(writer, "systemEnvironment", systemEnvironment, false);
                if (this.registration != null) {
                    if (this.registration.getLicense() != null) {
                        this.sendData(writer, "orderId", "" + this.registration.getLicense().getOrderID(), false);
                    }
                    this.sendData(writer, "licenseInfo", this.registration.getLicenseInfo(), false);
                }
                File logFile = this.plugin.getPluginBridge().getLogFile();
                if (!this.includeLogFile.isSelected() || !logFile.exists()) break block40;
                writer.write("&log=");
                char[] buff = new char[8192];
                try (FileReader logReader = new FileReader(logFile);){
                    int charsRead;
                    while ((charsRead = logReader.read(buff)) != -1) {
                        String logChunk = new String(buff, 0, charsRead);
                        writer.write(URLEncoder.encode(logChunk, "utf-8"));
                    }
                }
            }
            catch (Throwable systemEnvironment) {
                throwable = systemEnvironment;
                throw systemEnvironment;
            }
        }
        if (urlConnection.getResponseCode() < 200 || urlConnection.getResponseCode() >= 300) {
            InputStream err = urlConnection.getErrorStream();
            throwable = null;
            try {
                try {
                    byte[] errBytes = new byte[err.available()];
                    int count = err.read(errBytes);
                    String errString = new String(errBytes, 0, count);
                    throw new IOException(errString);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (Throwable throwable3) {
                if (err != null) {
                    if (throwable != null) {
                        try {
                            err.close();
                        }
                        catch (Throwable throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                    } else {
                        err.close();
                    }
                }
                throw throwable3;
            }
        }
    }

    private void sendData(Writer writer, String key, String value, boolean isFirst) throws IOException {
        if (!isFirst) {
            writer.write("&");
        }
        writer.write(URLEncoder.encode(key, "utf-8") + "=" + URLEncoder.encode(value, "utf-8"));
    }

    private void onInitialize() {
        ButtonType ok = new ButtonType("Register", ButtonBar.ButtonData.OK_DONE);
        ButtonType cancel = new ButtonType("Cancel", ButtonBar.ButtonData.CANCEL_CLOSE);
        ButtonType ask = new ButtonType("Help", ButtonBar.ButtonData.HELP);
        ButtonType bug = new ButtonType("Submit Bug Report", ButtonBar.ButtonData.OTHER);
        this.getButtonTypes().addAll((Object[])new ButtonType[]{ok, cancel, ask, bug});
        this.bugButton = (Button)this.lookupButton(bug);
        this.registerButton = (Button)this.lookupButton(ok);
        this.questionButton = (Button)this.lookupButton(ask);
        this.cancelButton = (Button)this.lookupButton(cancel);
        this.questionButton.setOnAction(this::askQuestion);
        this.bugButton.visibleProperty().bind((ObservableValue)this.expandedProperty());
        ButtonBar.setButtonUniformSize((Node)this.registerButton, (boolean)false);
        ButtonBar.setButtonUniformSize((Node)this.cancelButton, (boolean)false);
        ButtonBar.setButtonUniformSize((Node)this.questionButton, (boolean)false);
        ButtonBar.setButtonUniformSize((Node)this.bugButton, (boolean)false);
        this.errorText.setVisible(false);
        this.errorText.setText("");
    }

    public void setPluginAndRegistration(ProscPlugin plugin, Registration registration, boolean displayLicenseKey) {
        this.hideErrorMessage();
        this.emailAddress.setText("");
        this.phoneNumber.setText("");
        this.problemDescription.setText("");
        this.questionButton.setVisible(plugin.getSupportUrl() != null);
        this.setExpanded(false);
        if (plugin instanceof RegisterablePlugin) {
            this.plugin = plugin;
            this.registration = registration;
            this.productVersionLabel.setText(plugin.getVersion().stringVersion);
            this.licenseKeyField.setText(displayLicenseKey ? registration.getLicenseKey() : "");
            this.licenseTypeLabel.setText(registration.getLicense().getVariantName());
            this.registeredToField.setText(registration.getCompanyName());
            this.registeredToLabel.setText(registration.getCompanyName());
            this.includeLogFile.setSelected(true);
        } else {
            this.licenseKeyField.getParent().setVisible(false);
        }
    }

    protected Node createDetailsButton() {
        Hyperlink detailsButton = new Hyperlink();
        ResourceBundle bundle = ResourceBundle.getBundle(RegisterDialogPane.class.getCanonicalName());
        String moreText = bundle.getString("Dialog.detail.button.more");
        String lessText = bundle.getString("Dialog.detail.button.less");
        InvalidationListener expandedListener = o -> {
            boolean isExpanded = this.isExpanded();
            detailsButton.setText(isExpanded ? lessText : moreText);
            detailsButton.getStyleClass().setAll((Object[])new String[]{"details-button", isExpanded ? "less" : "more"});
        };
        expandedListener.invalidated(null);
        this.expandedProperty().addListener(expandedListener);
        detailsButton.setOnAction(ae -> this.setExpanded(!this.isExpanded()));
        return detailsButton;
    }
}

