/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.fmkit;

import com.prosc.fm.ClipboardType;
import com.prosc.fmkit.CodeToParent;
import com.prosc.fmkit.FileMakerOperation;
import com.prosc.fmkit.FmCalculationException;
import com.prosc.fmkit.FmScriptException;
import com.prosc.fmkit.JackInputStream;
import com.prosc.fmkit.PipeMessageReader;
import com.prosc.fmkit.PipeMessageSource;
import com.prosc.fmkit.Plugin;
import com.prosc.fmkit.PluginBridge2;
import com.prosc.fmkit.PluginFunction;
import com.prosc.fmkit.ScriptCall;
import com.prosc.fmkit.types.FMData;
import com.prosc.fmkit.types.FMDataVect;
import com.prosc.fmkit.types.FMRowVect;
import com.prosc.fmkit.types.FMText;
import com.prosc.fmkit.types.FMType;
import java.io.DataInputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jetbrains.annotations.NotNull;

public class PluginContext {
    private static final Logger log = Logger.getLogger(PluginContext.class.getName());
    private final boolean unsafeCalls;
    private final PluginBridge2 theBridge;
    private final Thread filemakerThread;
    private final PluginFunction whichFunction;
    private final long parentThreadId;
    private final long sessionId;
    private final long fileId;
    private final boolean isScriptStep;
    private FMType _functionResult;

    PluginContext(PluginBridge2 theBridge, boolean unsafeCalls, Thread filemakerThread, long parentThreadId, long sessionId, long fileId, PluginFunction whichFunction, boolean isScriptStep) {
        this.theBridge = theBridge;
        this.unsafeCalls = unsafeCalls;
        this.filemakerThread = filemakerThread;
        this.parentThreadId = parentThreadId;
        this.whichFunction = whichFunction;
        this.sessionId = sessionId;
        this.fileId = fileId;
        this.isScriptStep = isScriptStep;
    }

    public short getFileMakerAPIVersion() {
        return this.theBridge.getApiVersion();
    }

    public boolean isUnsafeCalls() {
        return this.unsafeCalls;
    }

    public Thread getFilemakerThread() {
        return this.filemakerThread;
    }

    public long getParentThreadId() {
        return this.parentThreadId;
    }

    public long getSessionId() {
        return this.sessionId;
    }

    public long getFileId() {
        return this.fileId;
    }

    public boolean isScriptStep() {
        return this.isScriptStep;
    }

    PluginFunction getWhichFunction() {
        return this.whichFunction;
    }

    public <E> E callback(CodeToParent codeToParent, PipeMessageSource messageToParent, PipeMessageReader<E> receiver) {
        return this.theBridge.getPipe().callback(codeToParent, this.parentThreadId, messageToParent, receiver);
    }

    public void triggerScript(ScriptCall script, Plugin whichPlugin) throws FmScriptException {
        try {
            this.triggerScript(script.getFilename(), script.getScriptName(), script.getScriptControl(), script.getParams(), whichPlugin);
        }
        catch (FmScriptException e) {
            script.setExecutionException(e);
            throw e;
        }
    }

    private void triggerScript(final String filename, final String scriptname, final int currentScriptSettings, final String parameter, final Plugin whichPlugin) throws FmScriptException {
        if (filename == null) {
            throw new IllegalArgumentException("filename must not be null.");
        }
        if (this.getFilemakerThread() == Thread.currentThread()) {
            long paramToken = 0L;
            if (parameter != null && parameter.length() > 0) {
                FMData fmParam = new FMData(this);
                new FMText(this, parameter).writeToData(this, fmParam);
                paramToken = fmParam.getCToken();
            }
            log.fine("Queuing script " + scriptname + " in file " + filename + " from thread " + Thread.currentThread().getName());
            short errorCode = this._triggerScript(filename, scriptname, currentScriptSettings, paramToken);
            log.fine("Script queued");
            if (errorCode != 0) {
                throw new FmScriptException(errorCode, filename, scriptname);
            }
        } else {
            log.fine("Current Thread is " + Thread.currentThread().getName() + "; queueing triggerScript to happen on main thread");
            try {
                this.theBridge.queueFileMakerOperation(new FileMakerOperation(){

                    @Override
                    public void run(PluginContext context) {
                        try {
                            log.fine("Triggering script from main thread: " + Thread.currentThread().getName());
                            PluginContext.this.triggerScript(filename, scriptname, currentScriptSettings, parameter, whichPlugin);
                        }
                        catch (FmScriptException e) {
                            log.log(Level.SEVERE, "An error occurred while executing script " + scriptname + " in file " + filename + ": " + e.toString(), e);
                        }
                    }
                }, whichPlugin, false);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private short _triggerScript(String filename, String scriptname, int currentScriptSettings, long parameterToken) {
        return this.theBridge.getPipe().callback(CodeToParent.triggerScript, this.parentThreadId, out -> {
            out.writeUTF16String(filename);
            out.writeUTF16String(scriptname);
            out.writeInt(currentScriptSettings);
            out.writeLong(parameterToken);
        }, DataInputStream::readShort);
    }

    public FMData evaluateExpression(String expression) throws FmCalculationException {
        if (Thread.currentThread() != this.filemakerThread) {
            log.warning("evaluateExpression called from non-FileMaker thread: " + Thread.currentThread());
        }
        log.fine("evaluateExpression: " + expression);
        if (expression == null) {
            throw new IllegalArgumentException("null value passed to evaluateExpression");
        }
        ExpressionResult expressionResult = this._evaluateExpression(expression);
        short errorCode = expressionResult.errorCode;
        if (errorCode != 0) {
            throw new FmCalculationException(errorCode);
        }
        long dataToken = expressionResult.expressionResult;
        log.finer("dataToken = " + dataToken);
        FMData result = new FMData(dataToken, this.filemakerThread);
        log.fine("result is " + result);
        return result;
    }

    public String getFontName(FMText text, short fontId) {
        throw new AbstractMethodError("This feature has not been implemented yet.");
    }

    private native String _getFontName(long var1, short var3, long var4, long var6, boolean var8);

    public String executeSql(String sql, char columnDelimiter, char rowDelimiter) throws FmCalculationException {
        if (this.theBridge.getApiVersion() >= 54) {
            return this.executeSql13(sql, this.evaluateExpression("Get ( FileName )").getStringData(this), columnDelimiter, rowDelimiter, new String[0]);
        }
        if (this.theBridge.getApiVersion() >= 52) {
            StringBuilder sb = new StringBuilder();
            FMRowVect rowVect = this.executeSql11(sql, this.evaluateExpression("Get ( FileName )").getStringData(this), new String[0]);
            String rDelim = "";
            for (FMDataVect dataVect : rowVect) {
                sb.append(rDelim);
                String cDelim = "";
                for (FMData data : dataVect) {
                    sb.append(cDelim);
                    sb.append(data.getStringData(this, false));
                    cDelim = String.valueOf(columnDelimiter);
                }
                rDelim = String.valueOf(rowDelimiter);
            }
            return sb.toString();
        }
        if (this.theBridge.getApiVersion() < 52) {
            return this.executeSql8(sql, columnDelimiter, rowDelimiter).getStringData(this, false);
        }
        String message = "Could not call executeSql because the optional SQL library is not loaded.";
        throw new RuntimeException(message);
    }

    public FMData executeSql8(@NotNull String sql, char columnDelimiter, char rowDelimiter) throws FmCalculationException {
        if (sql == null) {
            PluginContext.$$$reportNull$$$0(0);
        }
        throw new AbstractMethodError("executeSql8 is no longer supported.");
    }

    public FMRowVect executeSql11(@NotNull String sql, @NotNull String filename, @NotNull String[] params) throws FmCalculationException {
        if (sql == null) {
            PluginContext.$$$reportNull$$$0(1);
        }
        if (filename == null) {
            PluginContext.$$$reportNull$$$0(2);
        }
        if (params == null) {
            PluginContext.$$$reportNull$$$0(3);
        }
        if (sql == null) {
            throw new IllegalArgumentException("A null value was passed to executeSql");
        }
        log.config("executeSql with FileMaker 11 API: " + sql);
        ExpressionResult sqlResult = this._executeSql11(sql, filename, params);
        short errorCode = sqlResult.errorCode;
        if (errorCode != 0) {
            throw new FmCalculationException(errorCode);
        }
        long dataToken = sqlResult.expressionResult;
        log.finer("dataToken = " + dataToken);
        FMRowVect result = new FMRowVect(this, dataToken, this.filemakerThread);
        log.fine("result is " + result);
        return result;
    }

    public String executeSql13(@NotNull String sql, @NotNull String filename, char columnDelimiter, char rowDelimiter, @NotNull String[] params) throws FmCalculationException {
        if (sql == null) {
            PluginContext.$$$reportNull$$$0(4);
        }
        if (filename == null) {
            PluginContext.$$$reportNull$$$0(5);
        }
        if (params == null) {
            PluginContext.$$$reportNull$$$0(6);
        }
        if (sql == null) {
            throw new IllegalArgumentException("A null value was passed to executeSql");
        }
        log.config("executeSql with FileMaker 13 API: " + sql);
        ExpressionResult sqlResult = this._executeSql13(sql, filename, columnDelimiter, rowDelimiter, params);
        short errorCode = sqlResult.errorCode;
        if (errorCode != 0) {
            throw new FmCalculationException(errorCode);
        }
        long dataToken = sqlResult.expressionResult;
        log.finer("dataToken = " + dataToken);
        String result = this.callback(CodeToParent.getFmDataAsString, out -> out.writeLong(dataToken), JackInputStream::readUTF16String);
        log.fine("result is " + result);
        return result;
    }

    public Object getFieldValue(String filename, String fieldName) throws FmCalculationException {
        String typeInfo;
        if (filename == null) {
            throw new IllegalArgumentException("filename must not be null.");
        }
        log.log(Level.INFO, "Getting field value for filename " + filename + ", fieldname " + fieldName);
        try {
            typeInfo = this.evaluateExpression("FieldType(\"" + filename + "\" ; \"" + fieldName + "\")").getStringData(this);
            log.log(Level.INFO, typeInfo);
        }
        catch (FmCalculationException e) {
            throw new RuntimeException("Unknown field '" + fieldName + "'.  You must pass a \"table::field\" fieldname to the FMPro.getFieldValue function", e);
        }
        FMData value = this.evaluateExpression(fieldName);
        int firstSpaceIndex = typeInfo.indexOf(32);
        int secondSpace = typeInfo.indexOf(32, firstSpaceIndex + 1);
        String typeName = typeInfo.substring(firstSpaceIndex + 1, secondSpace);
        Class targetClass = FMType.classForFMType(typeName);
        try {
            return FMType.converterForClass(targetClass).convertData(value, targetClass, this);
        }
        catch (FMType.UnsupportedTypeConversionException e) {
            log.log(Level.WARNING, "Unable to convert " + value + " to " + targetClass, e);
            return value.getStringData(this);
        }
    }

    private ExpressionResult _evaluateExpression(String expression) {
        return this.theBridge.getPipe().callback(CodeToParent.evaluateExpression, this.parentThreadId, out -> out.writeUTF16String(expression), in -> new ExpressionResult(in.readShort(), in.readLong()));
    }

    protected ExpressionResult _executeSql11(String sql, String filename, String[] params) {
        return this.theBridge.getPipe().callback(CodeToParent.executeSql11, this.parentThreadId, out -> {
            out.writeUTF16String(sql);
            out.writeUTF16String(filename);
            out.writeInt(params.length);
            for (String param : params) {
                out.writeUTF16String(param);
            }
        }, in -> new ExpressionResult(in.readShort(), in.readLong()));
    }

    protected ExpressionResult _executeSql13(String sql, String filename, char columnDelimiter, char rowDelimiter, String[] params) {
        return this.theBridge.getPipe().callback(CodeToParent.executeSql13, this.parentThreadId, out -> {
            out.writeUTF16String(sql);
            out.writeUTF16String(filename);
            out.writeChar(columnDelimiter);
            out.writeChar(rowDelimiter);
            out.writeInt(params.length);
            for (String param : params) {
                out.writeUTF16String(param);
            }
        }, in -> new ExpressionResult(in.readShort(), in.readLong()));
    }

    public String toString() {
        return "PluginContext{theBridge=" + this.theBridge + '}';
    }

    synchronized void setFunctionResult(FMType functionResult) {
        this._functionResult = functionResult;
    }

    synchronized FMType getFunctionResult() {
        return this._functionResult;
    }

    public byte[] getClipboardData(String whichFormat, boolean isFileMaker) {
        return this.theBridge.getPipe().callback(CodeToParent.getClipboardData, this.getParentThreadId(), out -> out.writeUTF16String(whichFormat == null ? "" : whichFormat), JackInputStream::readByteArray);
    }

    public String[] getClipboardFormats() {
        return this.theBridge.getPipe().callback(CodeToParent.getClipboardFormats, this.getParentThreadId(), null, in -> {
            String[] result = new String[in.readInt()];
            for (int n = 0; n < result.length; ++n) {
                result[n] = in.readUTF16String();
            }
            return result;
        });
    }

    public String getBestFileMakerClipboardFormat() {
        HashSet<String> availableFormats = new HashSet<String>(Arrays.asList(this.getClipboardFormats()));
        for (ClipboardType eachType : ClipboardType.values()) {
            String fmFormat = eachType.getFormatCode(this.theBridge.majorVersion, null);
            if (!availableFormats.contains(fmFormat)) continue;
            return fmFormat;
        }
        throw new IllegalStateException("The clipboard does not contain data in any recognizable format");
    }

    public void setClipboardData(String whichFormat, byte[] data, boolean isFileMaker, boolean clearExisting) {
        this.theBridge.getPipe().callback(CodeToParent.setClipboardData, this.getParentThreadId(), out -> {
            out.writeUTF16String(whichFormat);
            out.writeByteArray(data);
        }, null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sql";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filename";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
        }
        objectArray2[1] = "com/prosc/fmkit/PluginContext";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "executeSql8";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "executeSql11";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "executeSql13";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    class ExpressionResult {
        short errorCode;
        long expressionResult;

        public ExpressionResult(short errorCode, long expressionResult) {
            this.errorCode = errorCode;
            this.expressionResult = expressionResult;
        }
    }
}

