/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.fmkit;

import com.prosc.Platform;
import com.prosc.fmkit.BadApiVersionException;
import com.prosc.fmkit.CodeToChild;
import com.prosc.fmkit.CodeToParent;
import com.prosc.fmkit.JackInputStream;
import com.prosc.fmkit.JackOutputStream;
import com.prosc.fmkit.PipeMessageReader;
import com.prosc.fmkit.PipeMessageSource;
import com.prosc.fmkit.PluginBridge2;
import com.prosc.fmkit.QuadChar;
import com.prosc.infrastructure.LogUtils;
import com.prosc.thread.MyThreadFactory;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jetbrains.annotations.Nullable;

class PipeChild {
    private static Logger log;
    private static final short BAD_VERSION = -1;
    private static final float THIS_VERSION = 0.06f;
    final JackInputStream in;
    private final JackOutputStream out;
    private final ReentrantLock inputLock = new ReentrantLock();
    private PluginBridge2 pluginBridge;
    private ExecutorService pluginThread = Executors.newFixedThreadPool(1, new MyThreadFactory("PluginBridge worker"));
    private final Map<Long, Object> threadsWaitingForCallback = new HashMap<Long, Object>();
    private final Map<Long, MessageFromParent> activeCallbackResponses = new HashMap<Long, MessageFromParent>();
    private LifeCycle lifeCycle;

    public static void main(String[] args) throws InterruptedException {
        Thread mainThread = new Thread("Message dispatch thread"){

            @Override
            public void run() {
                new PipeChild().run();
            }
        };
        mainThread.setUncaughtExceptionHandler((thread, e) -> log.log(Level.SEVERE, "An uncaught exception occurred in thread " + thread.getName(), e));
        mainThread.start();
    }

    private PipeChild() {
        this.in = new JackInputStream(System.in);
        this.out = new JackOutputStream(System.out);
        System.setOut(System.err);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run() {
        try {
            this.lifeCycle = LifeCycle.running;
            while (this.lifeCycle != LifeCycle.shutdown) {
                boolean expectMessage;
                if (this.lifeCycle == LifeCycle.running) {
                    expectMessage = true;
                } else {
                    Map<Long, Object> map = this.threadsWaitingForCallback;
                    synchronized (map) {
                        while (this.lifeCycle == LifeCycle.closing && this.threadsWaitingForCallback.isEmpty()) {
                            try {
                                this.threadsWaitingForCallback.wait();
                            }
                            catch (InterruptedException e) {
                                System.exit(0);
                            }
                        }
                        expectMessage = !this.threadsWaitingForCallback.isEmpty();
                    }
                }
                if (!expectMessage) continue;
                this.obtainInputLock();
                MessageFromParent messageFromParent = this.receiveCommand();
                long threadId = messageFromParent.threadId;
                if (messageFromParent.codeToChild == CodeToChild.shutdown) {
                    boolean unsafeCalls = this.in.readBoolean();
                    log.info("Shutting down plug-in " + messageFromParent.quadChar.toString() + " on thread " + Thread.currentThread().getName());
                    this.consumeSeparator();
                    this.releaseInputLock();
                    this.doShutdown(unsafeCalls, threadId);
                    continue;
                }
                if (messageFromParent.codeToChild == CodeToChild.sessionEnded) {
                    log.info("Shutting down session " + messageFromParent.sessionId + " on thread " + Thread.currentThread().getName());
                    this.consumeSeparator();
                    this.releaseInputLock();
                    this.pluginThread.submit(() -> this.pluginBridge.onSessionEnd(messageFromParent.sessionId));
                    continue;
                }
                if (messageFromParent.codeToChild == CodeToChild.fileShutdown) {
                    log.info("Shutting down file " + messageFromParent.fileId + " / session " + messageFromParent.sessionId + " on thread " + Thread.currentThread().getName());
                    this.consumeSeparator();
                    this.releaseInputLock();
                    this.pluginThread.submit(() -> this.pluginBridge.onFileClose(messageFromParent.sessionId, messageFromParent.fileId));
                    continue;
                }
                if (messageFromParent.codeToChild == CodeToChild.threadEnded) {
                    long thread_that_ended = this.in.readLong();
                    log.fine("Shutting down thread " + thread_that_ended + " on thread " + Thread.currentThread().getName());
                    this.consumeSeparator();
                    this.releaseInputLock();
                    this.pluginThread.submit(() -> this.pluginBridge.onThreadEnd(thread_that_ended));
                    continue;
                }
                if (messageFromParent.codeToChild == CodeToChild.callbackResult) {
                    log.info("Handling callback for threadId " + threadId + " / session " + messageFromParent.sessionId + " on thread " + Thread.currentThread().getName());
                    this.handleCallback(messageFromParent);
                    continue;
                }
                this.handleMessage(messageFromParent);
            }
            this.pluginThread.shutdownNow();
        }
        catch (IOException e) {
            String message = "Could not read from stdin; process will exit";
            log.log(Level.SEVERE, message, e);
            throw new IllegalStateException(message);
        }
    }

    private void obtainInputLock() {
        this.inputLock.lock();
    }

    private void releaseInputLock() {
        this.inputLock.unlock();
    }

    private MessageFromParent receiveCommand() throws IOException {
        long parentThreadId;
        MessageFromParent result = new MessageFromParent();
        result.threadId = parentThreadId = this.in.readLong();
        log.fine("Parent thread id: " + parentThreadId);
        log.fine("Reading session id");
        result.sessionId = this.in.readLong();
        log.fine("Session id: " + result.sessionId);
        log.fine("Reading file id");
        result.fileId = this.in.readLong();
        log.fine("File id: " + result.fileId);
        log.fine("Reading code to child");
        short codeToChild = this.in.readShort();
        result.codeToChild = CodeToChild.values()[codeToChild];
        log.fine("Command: " + result.codeToChild.name());
        log.fine("Reading QuadChar");
        result.quadChar = new QuadChar(this.in.readUTF16String());
        log.fine("QuadChar: " + result.quadChar.toString());
        log.fine("Received message from PipeParent: " + result);
        return result;
    }

    private void doShutdown(boolean unsafeCalls, long parentThreadId) throws IOException {
        this.lifeCycle = LifeCycle.closing;
        this.pluginThread.submit(() -> {
            System.err.print(LogUtils.dumpThreadStackTrace());
            log.info("End of PipeChild run loop");
            this.pluginBridge.fmxShutdown(unsafeCalls, parentThreadId);
            try {
                this.sendMessage(CodeToParent.finished, parentThreadId, out1 -> out1.writeInt(0), Level.INFO);
            }
            catch (IOException e) {
                log.log(Level.SEVERE, "Could not send finished message back to PipeParent", e);
            }
            this.lifeCycle = LifeCycle.shutdown;
            Map<Long, Object> map = this.threadsWaitingForCallback;
            synchronized (map) {
                this.threadsWaitingForCallback.notifyAll();
            }
            if (Platform.isWin()) {
                System.exit(0);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <E> E callback(CodeToParent codeToParent, long parentThreadId, PipeMessageSource messageToParent, PipeMessageReader<E> receiver) {
        try {
            Object lockObject = new Object();
            Map<Long, Object> map = this.threadsWaitingForCallback;
            synchronized (map) {
                this.threadsWaitingForCallback.put(parentThreadId, lockObject);
                this.threadsWaitingForCallback.notifyAll();
            }
            Object object = lockObject;
            synchronized (object) {
                this.activeCallbackResponses.remove(parentThreadId);
                this.sendMessage(codeToParent, parentThreadId, messageToParent, Level.INFO);
                log.fine("Sent callback message to parent: " + (Object)((Object)codeToParent));
                while (!this.activeCallbackResponses.containsKey(parentThreadId)) {
                    try {
                        lockObject.wait();
                    }
                    catch (InterruptedException e) {
                        log.warning("Waiting for callback; ignoring interruption on thread " + Thread.currentThread().getName());
                    }
                }
                MessageFromParent messageFromParent = this.activeCallbackResponses.remove(parentThreadId);
                if (messageFromParent.codeToChild != CodeToChild.callbackResult) {
                    throw new IllegalStateException("Expected a callbackResult message from parent for message " + (Object)((Object)codeToParent) + ", but received " + messageFromParent + ". This error is fatal.");
                }
                E result = null;
                if (receiver != null) {
                    result = receiver.readMessage(this.in);
                }
                this.consumeSeparator();
                Map<Long, Object> map2 = this.threadsWaitingForCallback;
                synchronized (map2) {
                    this.threadsWaitingForCallback.remove(parentThreadId);
                    this.threadsWaitingForCallback.notifyAll();
                }
                lockObject.notifyAll();
                return result;
            }
        }
        catch (IOException e) {
            throw new RuntimeException("IOException while reading/writing pipe to parent process. This is a fatal error.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleCallback(MessageFromParent messageFromParent) {
        Object lockObject;
        Object object = lockObject = this.threadsWaitingForCallback.get(messageFromParent.threadId);
        synchronized (object) {
            this.activeCallbackResponses.put(messageFromParent.threadId, messageFromParent);
            lockObject.notifyAll();
            while (this.activeCallbackResponses.containsKey(messageFromParent.threadId)) {
                try {
                    lockObject.wait();
                }
                catch (InterruptedException e) {
                    log.warning("Handling callback; ignoring interruption on thread " + Thread.currentThread().getName());
                }
            }
            this.releaseInputLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleMessage(MessageFromParent message) throws IOException {
        CodeToChild codeToChild = message.codeToChild;
        long threadId = message.threadId;
        if (codeToChild == CodeToChild.doIdle) {
            short idleState = this.in.readByte();
            boolean unsafeCalls = this.in.readBoolean();
            this.consumeSeparator();
            this.releaseInputLock();
            this.pluginThread.submit(() -> {
                this.pluginBridge.fmxIdle(idleState, unsafeCalls, threadId, message.sessionId);
                try {
                    this.sendMessage(CodeToParent.finished, threadId, out1 -> out1.writeInt(0), Level.FINEST);
                }
                catch (IOException e) {
                    log.log(Level.SEVERE, "Could not send finished message after doIdle", e);
                }
            });
        } else if (codeToChild == CodeToChild.doFunction) {
            boolean unsafeCalls;
            long resultHolderToken;
            long[] params;
            short functionId;
            log.info("-> doFunction started on thread " + Thread.currentThread().getName());
            PipeChild pipeChild = this;
            synchronized (pipeChild) {
                functionId = this.in.readShort();
                log.fine("functionId: " + functionId);
                params = new long[this.in.readInt()];
                for (int n = 0; n < params.length; ++n) {
                    params[n] = this.in.readLong();
                }
                resultHolderToken = this.in.readLong();
                log.fine("resultHolderToken: " + resultHolderToken);
                unsafeCalls = this.in.readBoolean();
                log.fine("unsafeCalls: " + unsafeCalls);
                this.consumeSeparator();
                this.releaseInputLock();
            }
            this.pluginThread.submit(() -> {
                short resultCode = this.pluginBridge.doFunction(functionId, params, resultHolderToken, unsafeCalls, threadId, message.sessionId, message.fileId);
                log.info("<- doFunction finished on thread " + Thread.currentThread().getName());
                try {
                    this.sendMessage(CodeToParent.finished, threadId, out1 -> out1.writeInt(resultCode), Level.INFO);
                }
                catch (IOException e) {
                    log.log(Level.SEVERE, "Could not send finished message after doFunction", e);
                }
            });
        } else if (codeToChild == CodeToChild.configure) {
            log.info("Configure called on thread " + Thread.currentThread().getName());
            boolean unsafeCalls = this.in.readBoolean();
            this.consumeSeparator();
            this.releaseInputLock();
            this.pluginThread.submit(() -> {
                this.pluginBridge.fmxDoAppPreferences(unsafeCalls, threadId);
                try {
                    this.sendMessage(CodeToParent.finished, threadId, out1 -> out1.writeInt(0), Level.INFO);
                }
                catch (IOException e) {
                    log.log(Level.SEVERE, "Could not send finished message after doAppPreferences", e);
                }
            });
        } else if (codeToChild == CodeToChild.init) {
            log.info("Init called on thread " + Thread.currentThread().getName());
            log.info("Reading api version");
            short apiVersion = this.in.readShort();
            log.info("API version: " + apiVersion);
            log.info("Reading version string");
            String versionString = this.in.readUTF16String();
            log.info("Version string: " + versionString);
            log.info("Reading instance id");
            long instanceId = this.in.readLong();
            log.info("Instance ID: " + instanceId);
            log.info("Reading unsafe calls");
            boolean unsafeCalls = this.in.readBoolean();
            log.info("Unsafe calls: " + unsafeCalls);
            log.info("Reading path info");
            String pathInfo = this.in.readUTF16String();
            log.info("Path info: " + pathInfo);
            String logPath = this.in.readUTF16String();
            log.info("Reading application type");
            short applicationType = this.in.readShort();
            log.info("Application type: " + applicationType);
            this.consumeSeparator();
            this.releaseInputLock();
            log.info("Init called with sessionId " + message.sessionId);
            this.pluginThread.submit(() -> {
                short resultCode;
                try {
                    this.pluginBridge = new PluginBridge2(this, pathInfo, logPath, applicationType, apiVersion, versionString, instanceId, unsafeCalls, threadId);
                    resultCode = apiVersion;
                }
                catch (BadApiVersionException e) {
                    resultCode = -1;
                }
                catch (Throwable t) {
                    log.log(Level.SEVERE, "Unexpected error while creating PluginBridge", t);
                    resultCode = -1;
                }
                short finalResultCode = resultCode;
                try {
                    this.sendMessage(CodeToParent.finished, threadId, out1 -> out1.writeInt(finalResultCode), Level.INFO);
                }
                catch (IOException e) {
                    log.log(Level.SEVERE, "Could not send finished message after fmxInit", e);
                }
            });
        } else {
            throw new IllegalStateException("No child handler for code: " + (Object)((Object)codeToChild));
        }
    }

    private void consumeSeparator() throws IOException {
        byte separator = this.in.readByte();
        if (separator != -1) {
            throw new IllegalStateException("Expected a -1 separator byte, but received " + separator + ". This probably indicates that the child did not consume the entire message.");
        }
    }

    private synchronized void sendMessage(CodeToParent codeToParent, long parentThreadId, @Nullable PipeMessageSource source, Level logLevel) throws IOException {
        log.fine("Writing parent thread ID " + parentThreadId);
        this.out.writeLong(parentThreadId);
        log.fine("Writing separator after the parent thread ID");
        this.out.writeByte(-1);
        log.log(logLevel, "Sending message to parent: " + (Object)((Object)codeToParent) + ", parent thread ID " + parentThreadId + " from thread " + Thread.currentThread().getName());
        this.out.writeShort((short)codeToParent.ordinal());
        if (source != null) {
            source.writeTo(this.out);
        }
        log.fine("Writing separator for " + codeToParent.name() + " command");
        this.out.writeByte(-1);
        this.out.flush();
    }

    static {
        DataOutputStream out = new DataOutputStream(System.out);
        try {
            out.writeBytes("IMALIVE");
            out.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Logger.getLogger("").setLevel(Level.ALL);
        log = Logger.getLogger(PipeChild.class.getName());
        log.info("Configured console logging for version 0.06");
    }

    class MessageFromParent {
        CodeToChild codeToChild;
        QuadChar quadChar;
        long sessionId;
        long fileId;
        long threadId;

        MessageFromParent() {
        }

        public String toString() {
            return "MessageFromParent{ threadId=" + this.threadId + ", codeToChild=" + (Object)((Object)this.codeToChild) + ", quadChar=" + this.quadChar + ", sessionId=" + this.sessionId + ", fileId=" + this.fileId + '}';
        }
    }

    private static enum LifeCycle {
        running,
        closing,
        shutdown;

    }
}

