/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.fm;

import com.prosc.fm.BaseTableInfo;
import com.prosc.fm.DatabaseInfo;
import com.prosc.fm.FieldInfo;
import com.prosc.fm.TableOccurrenceInfo;
import java.util.HashMap;
import java.util.StringTokenizer;

public class TableAndFieldParser {
    public DatabaseInfo parse(String filename, String tableInfoString, String fieldInfoString) {
        String[] fieldInfos;
        DatabaseInfo result = new DatabaseInfo();
        result.name = filename;
        String[] tableInfos = tableInfoString.replace("\n", "\r").split("\r");
        HashMap<String, BaseTableInfo> baseTableNameToBaseTableInfo = new HashMap<String, BaseTableInfo>(tableInfos.length);
        HashMap<String, BaseTableInfo> tableOccurrenceNameToBaseTableInfo = new HashMap<String, BaseTableInfo>(tableInfos.length);
        for (String tableInfoRow : tableInfos) {
            BaseTableInfo baseTableInfo;
            TableOccurrenceInfo toInfo = new TableOccurrenceInfo();
            StringTokenizer st = new StringTokenizer(tableInfoRow, ",");
            toInfo.name = st.nextToken();
            toInfo.id = Long.valueOf(st.nextToken());
            String baseTableName = st.nextToken();
            String baseFileFullname = st.nextToken();
            toInfo.modCount = Integer.valueOf(st.nextToken());
            String baseFileStripped = baseFileFullname;
            int mark1 = baseFileStripped.indexOf(" (", 0);
            if (mark1 != -1) {
                baseFileStripped = baseFileStripped.substring(0, mark1);
            }
            if ((baseTableInfo = (BaseTableInfo)baseTableNameToBaseTableInfo.get(baseTableName)) == null) {
                baseTableInfo = new BaseTableInfo();
                result.baseTables.add(baseTableInfo);
                baseTableInfo.baseTableName = baseTableName;
                baseTableNameToBaseTableInfo.put(baseTableName, baseTableInfo);
                baseTableInfo.filename = baseFileStripped;
                baseTableInfo.isExternal = !filename.equals(baseTableInfo.filename);
            }
            toInfo.baseTable = baseTableInfo;
            result.tableOccurrenceInfos.add(toInfo);
            tableOccurrenceNameToBaseTableInfo.put(toInfo.name, baseTableInfo);
            baseTableInfo.tableOccurrenceNames.add(toInfo.name);
        }
        for (String fieldInfoRow : fieldInfos = fieldInfoString.replace("\n", "\r").split("\r")) {
            FieldInfo fieldInfo = new FieldInfo();
            StringTokenizer st = new StringTokenizer(fieldInfoRow, ",");
            String toName = st.nextToken();
            fieldInfo.name = st.nextToken();
            fieldInfo.dataType = st.nextToken();
            fieldInfo.id = Long.valueOf(st.nextToken());
            fieldInfo.fieldType = st.nextToken();
            fieldInfo.modCount = Integer.valueOf(st.nextToken());
            BaseTableInfo baseTableInfo = (BaseTableInfo)tableOccurrenceNameToBaseTableInfo.get(toName);
            if (baseTableInfo == null || !baseTableInfo.tableOccurrenceNames.get(0).equals(toName)) continue;
            baseTableInfo.fields.add(fieldInfo);
        }
        return result;
    }
}

