/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.fm;

import com.prosc.Platform;
import com.prosc.fm.ClipboardType;
import com.prosc.fm.InvalidClipboardException;
import com.prosc.io.IOUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class FMClipboard {
    private static final Logger log = Logger.getLogger(FMClipboard.class.getName());
    private static final Object threadLock = new Object();
    private static boolean didLoadJniLib;
    private final int majorVersion;
    private static final boolean is64bit;
    private EnumMap<ClipboardType, String> clipboardFormatMap;

    public FMClipboard(int majorVersion) throws IOException {
        FMClipboard.loadJniLib();
        this.majorVersion = majorVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadJniLib() throws IOException {
        Object object = threadLock;
        synchronized (object) {
            if (!didLoadJniLib) {
                File destFile;
                int suffix = 0;
                while (true) {
                    String filename = "clipfunctions";
                    if (suffix > 0) {
                        filename = filename + String.valueOf(suffix);
                    }
                    if (!(destFile = Platform.current == Platform.mac ? new File(System.getProperty("java.io.tmpdir"), filename + ".jnilib") : new File(System.getProperty("java.io.tmpdir"), filename + (is64bit ? "_64" : "") + ".dll")).exists() || destFile.delete()) break;
                    ++suffix;
                }
                try {
                    InputStream stream = Platform.current == Platform.mac ? FMClipboard.class.getResourceAsStream("clipfunctions.jnilib") : FMClipboard.class.getResourceAsStream(is64bit ? "clipfunctions_64.dll" : "clipfunctions.dll");
                    if (stream == null) {
                        throw new IllegalStateException("clipfunctions native library could not be loaded; it is missing from the jar");
                    }
                    FileOutputStream out = new FileOutputStream(destFile);
                    try {
                        IOUtils.writeInputToOutput(stream, (OutputStream)out, 8192);
                    }
                    finally {
                        stream.close();
                        out.close();
                    }
                    System.load(destFile.getAbsolutePath());
                }
                catch (IOException e) {
                    IOException ioe = new IOException("Could not load clipboard native library: " + e.toString());
                    ioe.initCause(e);
                    throw ioe;
                }
                didLoadJniLib = true;
            }
        }
    }

    public String[] getClipboardFormats() {
        String[] result;
        if (Platform.current == Platform.mac) {
            result = (String[])FMClipboard._getClipboardFormatsMac();
        } else {
            int[] formats = FMClipboard._getClipboardFormatsWin();
            result = new String[formats.length];
            for (int i = 0; i < formats.length; ++i) {
                result[i] = String.valueOf(formats[i]);
            }
        }
        return result;
    }

    public String getBestFileMakerClipboardFormat() {
        HashSet<String> availableFormats = new HashSet<String>(Arrays.asList(this.getClipboardFormats()));
        for (String fmFormat : this.getClipboardFormatMap().values()) {
            if (!availableFormats.contains(fmFormat)) continue;
            return fmFormat;
        }
        throw new IllegalStateException("The clipboard does not contain data in any recognizable format");
    }

    private EnumMap<ClipboardType, String> getClipboardFormatMap() {
        if (this.clipboardFormatMap == null) {
            this.clipboardFormatMap = new EnumMap(ClipboardType.class);
            if (Platform.current == Platform.mac) {
                this.clipboardFormatMap.put(ClipboardType.table, "dyn.agk8zuxnykk");
                this.clipboardFormatMap.put(ClipboardType.field, "dyn.agk8zuxngku");
                if (this.majorVersion < 12) {
                    this.clipboardFormatMap.put(ClipboardType.layout, "dyn.agk8zuxnqm6");
                } else {
                    this.clipboardFormatMap.put(ClipboardType.layout, "dyn.ah62d4rv4gk8zuxnqgk");
                }
                this.clipboardFormatMap.put(ClipboardType.script, "dyn.agk8zuxnxkq");
                this.clipboardFormatMap.put(ClipboardType.scriptStep, "dyn.agk8zuxnxnq");
                this.clipboardFormatMap.put(ClipboardType.customFunction, "dyn.agk8zuxngm2");
                this.clipboardFormatMap.put(ClipboardType.plainText, "com.apple.traditional-mac-plain-text");
            } else {
                int[] intFormats = FMClipboard._getAllClipboardFormatsWin(this.majorVersion);
                int n = -1;
                this.clipboardFormatMap.put(ClipboardType.script, String.valueOf(intFormats[++n]));
                this.clipboardFormatMap.put(ClipboardType.scriptStep, String.valueOf(intFormats[++n]));
                this.clipboardFormatMap.put(ClipboardType.field, String.valueOf(intFormats[++n]));
                this.clipboardFormatMap.put(ClipboardType.table, String.valueOf(intFormats[++n]));
                this.clipboardFormatMap.put(ClipboardType.layout, String.valueOf(intFormats[++n]));
                this.clipboardFormatMap.put(ClipboardType.plainText, "1");
            }
        }
        return this.clipboardFormatMap;
    }

    public byte[] getClipboardData(String whichFormat, boolean isFileMaker) {
        byte[] result;
        if (Platform.current == Platform.mac) {
            result = FMClipboard._getClipboardDataMac(whichFormat);
        } else {
            byte[] tempResult = FMClipboard._getClipboardData(Integer.valueOf(whichFormat));
            if (isFileMaker && tempResult.length > 4 && !"1".equals(whichFormat)) {
                result = new byte[tempResult.length - 4];
                System.arraycopy(tempResult, 4, result, 0, result.length);
            } else {
                result = tempResult;
            }
        }
        return result;
    }

    public ClipboardType getClipboardType(String xmlData) throws InvalidClipboardException {
        try {
            SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
            DefaultHandler handler = new DefaultHandler(){

                @Override
                public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                    if ("Layout".equals(qName)) {
                        throw new StopParseException(ClipboardType.layout);
                    }
                    if ("Field".equals(qName)) {
                        throw new StopParseException(ClipboardType.field);
                    }
                    if ("Script".equals(qName)) {
                        throw new StopParseException(ClipboardType.script);
                    }
                    if ("Step".equals(qName)) {
                        throw new StopParseException(ClipboardType.scriptStep);
                    }
                    if ("BaseTable".equals(qName)) {
                        throw new StopParseException(ClipboardType.table);
                    }
                    if ("CustomFunction".equals(qName)) {
                        throw new StopParseException(ClipboardType.customFunction);
                    }
                }
            };
            ByteArrayInputStream bais = new ByteArrayInputStream(xmlData.getBytes());
            parser.parse((InputStream)bais, handler);
            throw new InvalidClipboardException("The provided XML data contains valid XML, but it is not a recognized FileMaker type");
        }
        catch (StopParseException e) {
            return e.getType();
        }
        catch (SAXException e) {
            log.warning("The clipboard does not contain valid XML");
            return ClipboardType.plainText;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    public String getClipboardFormatString(ClipboardType whichType) {
        return this.getClipboardFormatMap().get((Object)whichType);
    }

    public void setClipboardData(String whichFormat, byte[] data, boolean isFileMaker, boolean clearExisting) {
        if (Platform.current == Platform.mac) {
            FMClipboard._setClipboardDataMac(whichFormat, data);
        } else {
            if (isFileMaker && !"1".equals(whichFormat)) {
                byte[] newData = new byte[data.length + 4];
                byte b1 = (byte)data.length;
                byte b2 = (byte)(data.length >> 8);
                byte b3 = (byte)(data.length >> 16);
                byte b4 = (byte)(data.length >> 24);
                System.arraycopy(new byte[]{b1, b2, b3, b4}, 0, newData, 0, 4);
                System.arraycopy(data, 0, newData, 4, data.length);
                data = newData;
            }
            FMClipboard._setClipboardData(Integer.valueOf(whichFormat), data, clearExisting);
            if (clearExisting && Platform.current == Platform.windows && !"2".equals(whichFormat)) {
                this.setClipboardData("2", new byte[0], false, false);
            }
        }
    }

    private static native int[] _getAllClipboardFormatsWin(int var0);

    private static native int[] _getClipboardFormatsWin();

    private static native Object[] _getClipboardFormatsMac();

    private static native byte[] _getClipboardData(int var0);

    private static native byte[] _getClipboardDataMac(String var0);

    private static native void _setClipboardDataMac(String var0, byte[] var1);

    private static native void _setClipboardData(int var0, byte[] var1, boolean var2);

    static {
        is64bit = "64".equals(System.getProperty("sun.arch.data.model"));
    }

    private static class StopParseException
    extends SAXException {
        private ClipboardType type;

        private StopParseException(ClipboardType type) {
            this.type = type;
        }

        public ClipboardType getType() {
            return this.type;
        }
    }
}

