/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.fm;

import com.prosc.Platform;
import com.prosc.fm.InvalidClipboardException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public enum ClipboardType {
    layout,
    script,
    scriptStep,
    field,
    table,
    customFunction,
    plainText;

    private static final Logger log;

    public static ClipboardType forXml(@NotNull String xml) throws InvalidClipboardException {
        if (xml == null) {
            ClipboardType.$$$reportNull$$$0(0);
        }
        try {
            SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
            DefaultHandler handler = new DefaultHandler(){

                @Override
                public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                    if ("Layout".equals(qName)) {
                        throw new StopParseException(layout);
                    }
                    if ("Field".equals(qName)) {
                        throw new StopParseException(field);
                    }
                    if ("Script".equals(qName)) {
                        throw new StopParseException(script);
                    }
                    if ("Step".equals(qName)) {
                        throw new StopParseException(scriptStep);
                    }
                    if ("BaseTable".equals(qName)) {
                        throw new StopParseException(table);
                    }
                    if ("CustomFunction".equals(qName)) {
                        throw new StopParseException(customFunction);
                    }
                }
            };
            ByteArrayInputStream bais = new ByteArrayInputStream(xml.getBytes());
            parser.parse((InputStream)bais, handler);
            throw new InvalidClipboardException("The provided XML data contains valid XML, but it is not a recognized FileMaker type");
        }
        catch (StopParseException e) {
            return e.getType();
        }
        catch (SAXException e) {
            log.warning("The clipboard does not contain valid XML");
            return plainText;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    public String getFormatCode(int majorVersion, @Nullable Boolean isMac) {
        boolean mac;
        boolean bl = mac = isMac == null ? Platform.isMac() : isMac;
        if (mac) {
            if (majorVersion >= 12) {
                return this.mac12FormatCode();
            }
            return this.mac11FormatCode();
        }
        return this.winFormatCode();
    }

    private String mac12FormatCode() {
        switch (this) {
            case table: {
                return "dyn.ah62d4rv4gk8zuxnykk";
            }
            case field: {
                return "dyn.ah62d4rv4gk8zuxngku";
            }
            case layout: {
                return "dyn.ah62d4rv4gk8zuxnqgk";
            }
            case script: {
                return "dyn.ah62d4rv4gk8zuxnxkq";
            }
            case scriptStep: {
                return "dyn.ah62d4rv4gk8zuxnxnq";
            }
            case customFunction: {
                return "dyn.ah62d4rv4gk8zuxngm2";
            }
            case plainText: {
                return "com.apple.traditional-mac-plain-text";
            }
        }
        throw new IllegalStateException("No clipboard format available for " + (Object)((Object)this));
    }

    private String mac11FormatCode() {
        switch (this) {
            case table: {
                return "dyn.agk8zuxnykk";
            }
            case field: {
                return "dyn.agk8zuxngku";
            }
            case layout: {
                return "dyn.agk8zuxnqm6";
            }
            case script: {
                return "dyn.agk8zuxnxkq";
            }
            case scriptStep: {
                return "dyn.agk8zuxnxnq";
            }
            case customFunction: {
                return "dyn.agk8zuxngm2";
            }
            case plainText: {
                return "com.apple.traditional-mac-plain-text";
            }
        }
        throw new IllegalStateException("No clipboard format available for " + (Object)((Object)this));
    }

    private String winFormatCode() {
        switch (this) {
            case script: {
                return "Mac-XMSC";
            }
            case scriptStep: {
                return "Mac-XMSS";
            }
            case field: {
                return "Mac-XMFD";
            }
            case table: {
                return "Mac-XMTB";
            }
            case layout: {
                return "Mac-XML2";
            }
            case customFunction: {
                return "Mac-XMFN";
            }
            case plainText: {
                return "CF_TEXT";
            }
        }
        throw new IllegalStateException("No clipboard format available for " + (Object)((Object)this));
    }

    static {
        log = Logger.getLogger(ClipboardType.class.getName());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xml", "com/prosc/fm/ClipboardType", "forXml"));
    }

    private static class StopParseException
    extends SAXException {
        private ClipboardType type;

        private StopParseException(ClipboardType type) {
            this.type = type;
        }

        public ClipboardType getType() {
            return this.type;
        }
    }
}

