/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.beanshell.sql;

import com.prosc.shared.CaseInsensitiveMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class Row
implements Map<Object, Object> {
    private final CaseInsensitiveMap<Integer> meta;
    private final Object[] cols;

    public Row(CaseInsensitiveMap<Integer> meta, Object[] cols) {
        this.meta = meta;
        this.cols = cols;
    }

    @Override
    public int size() {
        return this.cols.length;
    }

    @Override
    public boolean isEmpty() {
        return this.cols.length == 0;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.meta.containsKey(key);
    }

    @Override
    public Object get(Object key) {
        if (key == null) {
            return null;
        }
        Integer integer = this.meta.get(key);
        if (integer == null) {
            return null;
        }
        return this.cols[integer];
    }

    @Override
    public Object put(Object key, Object value) {
        throw new UnsupportedOperationException("Rows are read-only");
    }

    @Override
    public Object remove(Object key) {
        throw new UnsupportedOperationException("Rows are read-only");
    }

    @Override
    public void putAll(Map<?, ?> t) {
        throw new UnsupportedOperationException("Rows are read-only");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("Rows are read-only");
    }

    @Override
    public Set<Object> keySet() {
        HashSet<Object> result = new HashSet<Object>();
        for (String eachKey : this.meta.keySet()) {
            if (this.isNumeric(eachKey)) continue;
            result.add(eachKey);
        }
        return result;
    }

    @Override
    public Collection<Object> values() {
        return Arrays.asList(this.cols);
    }

    @Override
    public Set<Map.Entry<Object, Object>> entrySet() {
        HashSet<Map.Entry<Object, Object>> result = new HashSet<Map.Entry<Object, Object>>();
        for (Map.Entry<String, Integer> eachEntry : this.meta.entrySet()) {
            if (this.isNumeric(eachEntry.getKey())) continue;
            Object value = this.cols[eachEntry.getValue()];
            result.add(new ImmutableEntry(eachEntry.getKey(), value));
        }
        return result;
    }

    @Override
    public boolean containsValue(Object value) {
        for (Object eachValue : this.cols) {
            if ((eachValue != null || value != null) && (eachValue == null || !eachValue.equals(value))) continue;
            return true;
        }
        return false;
    }

    private boolean isNumeric(String key) {
        for (int i = 0; i < key.length(); ++i) {
            if (Character.isDigit(key.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static class ImmutableEntry
    implements Map.Entry<Object, Object> {
        private final Object key;
        private final Object value;

        private ImmutableEntry(Object key, Object value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public Object getKey() {
            return this.key;
        }

        @Override
        public Object getValue() {
            return this.value;
        }

        @Override
        public Object setValue(Object value) {
            throw new UnsupportedOperationException("Rows are read-only");
        }
    }
}

