/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.beanshell;

import com.prosc.beanshell.BeanShellModel;
import com.prosc.beanshell.BeanShellPlugin;
import com.prosc.beanshell.FMPro;
import com.prosc.beanshell.FunctionSignature;
import com.prosc.fmkit.Plugin;
import com.prosc.fmkit.PluginContext;
import com.prosc.fmkit.PluginFunction;
import com.prosc.fmkit.types.Converter;
import com.prosc.fmkit.types.FMData;
import com.prosc.fmkit.types.FMType;
import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import groovy.lang.Script;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.Nullable;

public class GroovyFunction
implements PluginFunction,
Serializable {
    private Script compiledScript;
    private static Converter paramConverter;
    private boolean isGuiFunction;
    private FunctionSignature functionSignature;

    GroovyFunction(ClassLoader classLoader, FunctionSignature signature, String script, boolean isGui) {
        this.functionSignature = signature;
        GroovyShell shell = new GroovyShell(classLoader, new Binding(new HashMap(this.functionSignature.getArgNames().size())));
        this.compiledScript = shell.parse(script);
        if (this.compiledScript.getClass().getPackage() != null) {
            throw new IllegalArgumentException("You cannot specify a package for ScriptMaster modules. Please remove the first line of your script with the package statement and try again.");
        }
        this.isGuiFunction = isGui;
    }

    GroovyFunction(FunctionSignature functionSignature, Script compiledScript, boolean isGui) {
        this.functionSignature = functionSignature;
        this.compiledScript = compiledScript;
        this.isGuiFunction = isGui;
    }

    @Override
    public String getName() {
        return this.functionSignature.getName();
    }

    @Override
    public String getPrototype() {
        return this.functionSignature.getPrototype();
    }

    @Override
    public int getMinArgs() {
        return this.functionSignature.getMinArgs();
    }

    @Override
    public int getMaxArgs() {
        return this.functionSignature.getMaxArgs();
    }

    @Override
    public int getCalculationFunctionFlags(PluginContext context) {
        return 65281;
    }

    @Override
    public int getScriptStepFlags(PluginContext context) {
        return 126;
    }

    @Override
    public String[] getTypeAheadList() {
        return new String[0];
    }

    @Override
    public String getDescription() {
        return null;
    }

    @Override
    public Object[] convertParams(FMData[] rawParams, PluginContext pluginContext) {
        Object[] result = new Object[this.functionSignature.getParameters().size()];
        ArrayList<String> varArgs = null;
        for (int i = 0; i < rawParams.length; ++i) {
            String s;
            FMData eachRaw = rawParams[i];
            String string = s = eachRaw == null ? null : (String)paramConverter.convertData(eachRaw, String.class, pluginContext);
            if (varArgs != null || this.functionSignature.getParameters().get(i).isVarArg()) {
                if (varArgs == null) {
                    result[i] = varArgs = new ArrayList<String>(rawParams.length - i);
                }
                varArgs.add(s);
                continue;
            }
            result[i] = s;
        }
        return result;
    }

    @Override
    public Object invoke(Plugin pluginInstance, Object[] parameters) throws IllegalAccessException, InvocationTargetException {
        if (this.isGuiFunction) {
            try {
                FutureTask<Object> groovyScript = new FutureTask<Object>(() -> this._invoke(pluginInstance, parameters));
                SwingUtilities.invokeLater(groovyScript);
                return groovyScript.get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
        return this._invoke(pluginInstance, parameters);
    }

    private Object _invoke(Plugin pluginInstance, Object[] parameters) {
        BeanShellPlugin plugin = (BeanShellPlugin)pluginInstance;
        BeanShellModel model = plugin.getBeanShellModel();
        Thread.currentThread().setContextClassLoader(model.getClassLoader());
        model.clearOldVariables();
        plugin.errorVars = new HashMap<String, Object>();
        Binding binding = this.compiledScript.getBinding();
        for (int i = 0; i < parameters.length; ++i) {
            binding.setVariable(this.functionSignature.getArgNames().get(i), parameters[i]);
        }
        FMPro fmpro = model.getFmpro();
        fmpro.setPluginContext(pluginInstance.getContext());
        binding.setVariable("fmpro", fmpro);
        FMType result = BeanShellPlugin.convertedResult(pluginInstance.getContext(), this.compiledScript.run());
        model.setBinding(binding);
        return result;
    }

    public String toString() {
        return "PluginFunction{name='" + this.getName() + "'" + "}";
    }

    @Override
    @Nullable
    public Method getJavaMethod() {
        return null;
    }

    @Override
    public void setEnumStartingIndex(int whichParam, int startingIndex) {
        throw new AbstractMethodError("This feature has not been implemented yet.");
    }

    static {
        try {
            paramConverter = FMType.converterForClass(String.class);
        }
        catch (FMType.UnsupportedTypeConversionException e) {
            throw new RuntimeException(e);
        }
    }
}

