/*
 * Decompiled with CFR 0.152.
 */
package pGraph;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import pGraph.Chart;
import pGraph.Scatter;
import pGraph.VirtualSpace;

class Axes2
extends Chart {
    private final int tickWidth = 2;
    private int graphXMagnitude;
    private int graphYMagnitude;
    private Scatter chart;
    private Font axesTitleFont;
    private Font axesFont;
    private double graphXStep;
    private double graphYStep;
    private String xTitle;
    private String yTitle;
    private Rectangle2D.Float valueBounds;

    protected String doubleToString(double d, int n) {
        if (n < 0) {
            String string = Integer.toString((int)((d - (double)((int)d)) * Math.pow(10.0, -n) + 0.5));
            while (string.length() < -n) {
                string = "0" + string;
            }
            return Integer.toString((int)d) + "." + string;
        }
        return Integer.toString((int)d);
    }

    public Axes2(Font font, Font font2, String string, String string2, Scatter scatter) {
        this.axesTitleFont = font;
        this.axesFont = font2;
        this.chart = scatter;
        this.xTitle = string;
        this.yTitle = string2;
        this.graphXMagnitude = (int)(Math.log(Math.max(Math.abs(scatter.valueBounds.x + scatter.valueBounds.width), Math.abs(scatter.valueBounds.x))) / Math.log(10.0));
        this.graphXStep = Math.pow(10.0, this.graphXMagnitude);
        double d = Math.ceil((double)scatter.valueBounds.x + (double)scatter.valueBounds.width / this.graphXStep) * this.graphXStep;
        double d2 = Math.floor((double)scatter.valueBounds.x / this.graphXStep) * this.graphXStep;
        this.graphYMagnitude = (int)(Math.log(Math.max(Math.abs(scatter.valueBounds.y + scatter.valueBounds.height), Math.abs(scatter.valueBounds.y))) / Math.log(10.0));
        this.graphYStep = Math.pow(10.0, this.graphYMagnitude);
        double d3 = Math.ceil((double)scatter.valueBounds.y + (double)scatter.valueBounds.height / this.graphYStep) * this.graphYStep;
        double d4 = Math.floor((double)scatter.valueBounds.y / this.graphYStep) * this.graphYStep;
        this.valueBounds = new Rectangle2D.Float((float)d2, (float)d4, (float)(d - d2), (float)(d3 - d4));
    }

    private void drawDelta(Graphics2D graphics2D, double d, double d2, double d3, double d4) {
        graphics2D.draw(new Line2D.Double(d, d2, d + d3, d2 + d4));
    }

    public void paint(Graphics2D graphics2D, Rectangle2D.Float float_) {
        Rectangle2D.Float float_2;
        String string;
        float f;
        int n;
        FontMetrics fontMetrics = graphics2D.getFontMetrics(this.axesFont);
        Rectangle2D.Float float_3 = null;
        Rectangle2D.Float float_4 = null;
        Rectangle2D.Float float_5 = (Rectangle2D.Float)fontMetrics.getStringBounds(this.doubleToString(this.doubleToString(this.valueBounds.y + this.valueBounds.height, this.graphYMagnitude).length() > this.doubleToString(this.valueBounds.y, this.graphYMagnitude).length() ? (double)(this.valueBounds.y + this.valueBounds.height) : (double)this.valueBounds.y, this.graphYMagnitude), graphics2D);
        Rectangle2D.Float float_6 = new Rectangle2D.Float(float_.x + float_5.width + 2.0f, float_.y, 4.0f, float_.height - (float)fontMetrics.getHeight() - 4.0f);
        if (this.yTitle != null) {
            float_4 = (Rectangle2D.Float)graphics2D.getFontMetrics(this.axesTitleFont).getStringBounds(this.yTitle, graphics2D);
            float_6.x += float_4.height + 5.0f;
        }
        if (this.xTitle != null) {
            float_3 = (Rectangle2D.Float)graphics2D.getFontMetrics(this.axesTitleFont).getStringBounds(this.xTitle, graphics2D);
            float_6.height -= float_3.height + 5.0f;
        }
        if (this.chart.groups.length > 0) {
            float_6.height -= float_5.height + 2.0f + 5.0f;
        }
        Rectangle2D.Float float_7 = new Rectangle2D.Float(float_6.x + 2.0f, float_6.y + 2.0f, float_.width - float_6.x, float_6.height - 4.0f);
        if (this.valueBounds.x < -1.4E-45f) {
            float_7.width -= 4.0f;
            float_7.x += 4.0f;
        }
        if (this.valueBounds.x + this.valueBounds.width > Float.MIN_VALUE) {
            float_7.width -= 4.0f;
        }
        if (this.valueBounds.y + this.valueBounds.height > Float.MIN_VALUE) {
            float_7.height -= 4.0f;
            float_7.y += 4.0f;
        }
        if (this.valueBounds.y < -1.4E-45f) {
            float_7.height -= 4.0f;
        }
        if (this.chart.inset) {
            // empty if block
        }
        VirtualSpace virtualSpace = new VirtualSpace(float_7, this.valueBounds);
        this.chart.paint(graphics2D, virtualSpace);
        graphics2D.setPaint(Color.black);
        Point2D.Float float_8 = virtualSpace.getPoint(0.0f, 0.0f);
        graphics2D.draw(new Line2D.Float(float_8.x, float_6.y, float_8.x, float_6.y + float_6.height));
        graphics2D.draw(new Line2D.Float(float_6.x, float_8.y, float_.x + float_.width, float_8.y));
        if (this.valueBounds.x < -1.4E-45f) {
            this.drawDelta(graphics2D, float_6.x, float_8.y, 4.0, 2.0);
            this.drawDelta(graphics2D, float_6.x, float_8.y, 4.0, -2.0);
        }
        if (this.valueBounds.x + this.valueBounds.width > Float.MIN_VALUE) {
            this.drawDelta(graphics2D, float_.x + float_.width, float_8.y, -4.0, 2.0);
            this.drawDelta(graphics2D, float_.x + float_.width, float_8.y, -4.0, -2.0);
        }
        if (this.valueBounds.y + this.valueBounds.height > Float.MIN_VALUE) {
            this.drawDelta(graphics2D, float_8.x, float_6.y, -2.0, 4.0);
            this.drawDelta(graphics2D, float_8.x, float_6.y, 2.0, 4.0);
        }
        if (this.valueBounds.y < -1.4E-45f) {
            this.drawDelta(graphics2D, float_8.x, float_6.y + float_6.height, -2.0, -4.0);
            this.drawDelta(graphics2D, float_8.x, float_6.y + float_6.height, 2.0, -4.0);
        }
        graphics2D.setFont(this.axesFont);
        float f2 = virtualSpace.getY((float)((double)(this.valueBounds.y + this.valueBounds.height) + 2.0 * this.graphYStep));
        for (n = (int)((double)this.valueBounds.height / this.graphYStep); n > -1; --n) {
            f = virtualSpace.getY((float)((double)this.valueBounds.y + (double)n * this.graphYStep));
            string = this.doubleToString((double)this.valueBounds.y + (double)n * this.graphYStep, this.graphYMagnitude);
            float_2 = (Rectangle2D.Float)fontMetrics.getStringBounds(string, graphics2D);
            if (!(f - float_2.height > f2)) continue;
            this.drawDelta(graphics2D, float_8.x - 2.0f, f, 4.0, 0.0);
            graphics2D.drawString(string, float_8.x - 4.0f - float_2.width, virtualSpace.getY((float)((double)this.valueBounds.y + (double)n * this.graphYStep)) + float_2.height / 2.0f);
            f2 = f;
        }
        f2 = virtualSpace.getX((float)((double)(this.valueBounds.x + this.valueBounds.width) + 2.0 * this.graphXStep));
        for (n = (int)((double)this.valueBounds.width / this.graphXStep); n > -1; --n) {
            f = virtualSpace.getX((float)((double)this.valueBounds.x + (double)n * this.graphXStep));
            string = this.doubleToString((double)this.valueBounds.x + (double)n * this.graphXStep, this.graphXMagnitude);
            float_2 = (Rectangle2D.Float)fontMetrics.getStringBounds(string, graphics2D);
            if (!(f + float_2.width < f2)) continue;
            this.drawDelta(graphics2D, virtualSpace.getX((float)((double)this.valueBounds.x + (double)n * this.graphXStep)), float_8.y - 2.0f, 0.0, 4.0);
            graphics2D.drawString(string, virtualSpace.getX((float)((double)this.valueBounds.x + (double)n * this.graphXStep)) - float_2.width / 2.0f, float_8.y + 2.0f + float_2.height);
            f2 = f;
        }
        if (this.xTitle != null) {
            graphics2D.setFont(this.axesTitleFont);
            graphics2D.drawString(this.xTitle, float_7.x + (float_7.width - float_3.width) / 2.0f, float_.y + float_.height - 5.0f);
        }
        if (this.yTitle != null) {
            AffineTransform affineTransform = graphics2D.getTransform();
            graphics2D.rotate(Math.toRadians(-90.0));
            graphics2D.setFont(this.axesTitleFont);
            graphics2D.drawString(this.yTitle, -float_6.y - (float_6.height + float_4.width) / 2.0f, float_.x - float_4.y);
            graphics2D.setTransform(affineTransform);
        }
    }
}

