<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
	<xsl:template match="/*">
		
		<FMPXMLRESULT xmlns="http://www.filemaker.com/fmpxmlresult">
			<ERRORCODE>0</ERRORCODE>
			<PRODUCT BUILD="" NAME="" VERSION=""/>
			<DATABASE DATEFORMAT="" LAYOUT="" NAME="" RECORDS="{count(/DataSet/diffgr/NewDataSet/Rooms)}" TIMEFORMAT=""/>
			
			<METADATA>
				<FIELD EMPTYOK="YES" MAXREPEAT="1" NAME="ReservationID" TYPE="TEXT" />
				<FIELD EMPTYOK="YES" MAXREPEAT="1" NAME="Ref" TYPE="TEXT" />
                <FIELD EMPTYOK="YES" MAXREPEAT="1" NAME="ReservationDateTime" TYPE="TEXT" />
                <FIELD EMPTYOK="YES" MAXREPEAT="1" NAME="IsCommissionableBooking" TYPE="TEXT" />
                <FIELD EMPTYOK="YES" MAXREPEAT="1" NAME="AgentOrganisation" TYPE="TEXT" />
                <FIELD EMPTYOK="YES" MAXREPEAT="1" NAME="AgentFirstName" TYPE="TEXT" />
                <FIELD EMPTYOK="YES" MAXREPEAT="1" NAME="AgentSurname" TYPE="TEXT" />
                <FIELD EMPTYOK="YES" MAXREPEAT="1" NAME="AgentTelephone" TYPE="TEXT" />
                <FIELD EMPTYOK="YES" MAXREPEAT="1" NAME="AgentFax" TYPE="TEXT" />
                <FIELD EMPTYOK="YES" MAXREPEAT="1" NAME="AgentEmail" TYPE="TEXT" />
                <FIELD EMPTYOK="YES" MAXREPEAT="1" NAME="AgentAddress" TYPE="TEXT" />
                <FIELD EMPTYOK="YES" MAXREPEAT="1" NAME="AgentIATANumber" TYPE="TEXT" />
                <FIELD EMPTYOK="YES" MAXREPEAT="1" NAME="RoomID" TYPE="TEXT" />
                <FIELD EMPTYOK="YES" MAXREPEAT="1" NAME="RoomNumber" TYPE="TEXT" />
                <FIELD EMPTYOK="YES" MAXREPEAT="1" NAME="DateIn" TYPE="DATE" />
                <FIELD EMPTYOK="YES" MAXREPEAT="1" NAME="DateOut" TYPE="DATE" />
                <FIELD EMPTYOK="YES" MAXREPEAT="1" NAME="NoNights" TYPE="NUMBER" />
                <FIELD EMPTYOK="YES" MAXREPEAT="1" NAME="NoGuests" TYPE="NUMBER" />
                <FIELD EMPTYOK="YES" MAXREPEAT="1" NAME="QuotedPrice" TYPE="NUMBER" />
                <FIELD EMPTYOK="YES" MAXREPEAT="1" NAME="PaymentRequired" TYPE="NUMBER" />
                <FIELD EMPTYOK="YES" MAXREPEAT="1" NAME="DepositAuthorised" TYPE="TEXT" />
                <FIELD EMPTYOK="YES" MAXREPEAT="1" NAME="CustomerFirstName" TYPE="TEXT" />
                <FIELD EMPTYOK="YES" MAXREPEAT="1" NAME="CustomerSurname" TYPE="TEXT" />
                <FIELD EMPTYOK="YES" MAXREPEAT="1" NAME="CustomerTelephone" TYPE="TEXT" />
                <FIELD EMPTYOK="YES" MAXREPEAT="1" NAME="CustomerFax" TYPE="TEXT" />
                <FIELD EMPTYOK="YES" MAXREPEAT="1" NAME="CustomerEmail" TYPE="TEXT" />
                <FIELD EMPTYOK="YES" MAXREPEAT="1" NAME="CustomerAddress" TYPE="TEXT" />
                <FIELD EMPTYOK="YES" MAXREPEAT="1" NAME="CustomerFax1" TYPE="TEXT" />
                <FIELD EMPTYOK="YES" MAXREPEAT="1" NAME="CreditCardName" TYPE="TEXT" />
                <FIELD EMPTYOK="YES" MAXREPEAT="1" NAME="CreditCardNumber" TYPE="TEXT" />
                <FIELD EMPTYOK="YES" MAXREPEAT="1" NAME="CreditCardExpiryMonth" TYPE="TEXT" />
                <FIELD EMPTYOK="YES" MAXREPEAT="1" NAME="CreditCardExpiryYear" TYPE="TEXT" />
                <FIELD EMPTYOK="YES" MAXREPEAT="1" NAME="BookingSource" TYPE="TEXT" />
                <FIELD EMPTYOK="YES" MAXREPEAT="1" NAME="CustomerCountryName" TYPE="TEXT" />
                <FIELD EMPTYOK="YES" MAXREPEAT="1" NAME="ArrivalDateTime" TYPE="TEXT" />
                <FIELD EMPTYOK="YES" MAXREPEAT="1" NAME="SpecialRequest" TYPE="TEXT" />
                <FIELD EMPTYOK="YES" MAXREPEAT="1" NAME="NoChildren" TYPE="NUMBER" />

			</METADATA>
			
			<RESULTSET>
			<xsl:attribute name="FOUND"><xsl:value-of select="count(/DataSet/diffgr/NewDataSet/Rooms)"/></xsl:attribute>
			<xsl:for-each select="//Rooms">
				<ROW MODID="0" RECORDID="0">
					<xsl:for-each select=".">

					<!-- NOTE: ReservationDateTime, DateIn, DateOut
						 are formatted into FileMaker's preferred timestamp format (dd/MM/yyyy HH:mm:ss for AU/NZ)
						 using string manipulation functions -->	
						 
					<COL><DATA><xsl:value-of select="ReservationID"/></DATA></COL>
					<COL><DATA><xsl:value-of select="Ref"/></DATA></COL>
					<COL><DATA><xsl:call-template name="normaliseDateTime"><xsl:with-param name="hgDate" select="ReservationDateTime"/></xsl:call-template></DATA></COL>
					<COL><DATA><xsl:value-of select="IsCommissionableBooking"/></DATA></COL>
					<COL><DATA><xsl:value-of select="AgentOrganisation"/></DATA></COL>
					<COL><DATA><xsl:value-of select="AgentFirstName"/></DATA></COL>
					<COL><DATA><xsl:value-of select="AgentSurname"/></DATA></COL>
					<COL><DATA><xsl:value-of select="AgentTelephone"/></DATA></COL>
					<COL><DATA><xsl:value-of select="AgentFax"/></DATA></COL>
					<COL><DATA><xsl:value-of select="AgentEmail"/></DATA></COL>
					<COL><DATA><xsl:value-of select="AgentAddress"/></DATA></COL>
					<COL><DATA><xsl:value-of select="AgentIATANumber"/></DATA></COL>
					<COL><DATA><xsl:value-of select="RoomID"/></DATA></COL>
					<COL><DATA><xsl:value-of select="RoomNumber"/></DATA></COL>
					<COL><DATA><xsl:call-template name="normaliseDateTime"><xsl:with-param name="hgDate" select="DateIn"/></xsl:call-template></DATA></COL>
					<COL><DATA><xsl:call-template name="normaliseDateTime"><xsl:with-param name="hgDate" select="DateOut"/></xsl:call-template></DATA></COL>
					<COL><DATA><xsl:value-of select="NoNights"/></DATA></COL>
					<COL><DATA><xsl:value-of select="NoGuests"/></DATA></COL>
					<COL><DATA><xsl:value-of select="QuotedPrice"/></DATA></COL>
					<COL><DATA><xsl:value-of select="PaymentRequired"/></DATA></COL>
					<COL><DATA><xsl:value-of select="DepositAuthorised"/></DATA></COL>
					<COL><DATA><xsl:value-of select="CustomerFirstName" /></DATA></COL>
					<COL><DATA><xsl:value-of select="CustomerSurname"/></DATA></COL>
					<COL><DATA><xsl:value-of select="CustomerTelephone"/></DATA></COL>
					<COL><DATA><xsl:value-of select="CustomerFax"/></DATA></COL>
					<COL><DATA><xsl:value-of select="CustomerEmail"/></DATA></COL>
					<COL><DATA><xsl:value-of select="CustomerAddress"/></DATA></COL>
					<COL><DATA><xsl:value-of select="CustomerFax1"/></DATA></COL>
					<COL><DATA><xsl:value-of select="CreditCardName"/></DATA></COL>
					<COL><DATA><xsl:value-of select="CreditCardNumber"/></DATA></COL>
					<COL><DATA><xsl:value-of select="CreditCardExpiryMonth"/></DATA></COL>
					<COL><DATA><xsl:value-of select="CreditCardExpiryYear"/></DATA></COL>
					<COL><DATA><xsl:value-of select="BookingSource"/></DATA></COL>
					<COL><DATA><xsl:value-of select="CustomerCountryName"/></DATA></COL>
					<COL><DATA><xsl:call-template name="normaliseDateTime"><xsl:with-param name="hgDate" select="ArrivalDateTime"/></xsl:call-template></DATA></COL>
					<COL><DATA><xsl:value-of select="SpecialRequest"/></DATA></COL>
					<COL><DATA><xsl:value-of select="NoChildren"/></DATA></COL>

					</xsl:for-each>
				</ROW>
			</xsl:for-each>
			</RESULTSET>
			
		</FMPXMLRESULT>
		
	</xsl:template>
	

<xsl:template name="normaliseDateTime">
	<xsl:param name="hgDate"/>
	<xsl:variable name="day0"><xsl:if test="substring($hgDate,2,1) ='/'">0</xsl:if><xsl:value-of select="$hgDate" /></xsl:variable>
	<xsl:variable name="hour0"><xsl:value-of select="substring($day0,1,11)" /><xsl:if test="substring($day0,13,1) =':'">0</xsl:if><xsl:value-of select="substring($day0,12)" /></xsl:variable>
	<xsl:variable name="hour" select="substring($hour0,12,2)" />
	<xsl:value-of select="substring($hour0,1,2)"/>-<xsl:value-of select="substring($hour0,4,2)" />-<xsl:value-of select="substring($hour0,7,4)" /><xsl:text> </xsl:text><xsl:choose>
		<xsl:when test="substring($hour0,21,1) = 'p' and $hour &lt; 12"><xsl:value-of select="$hour + 12" /></xsl:when>
		<xsl:when test="substring($hour0,21,1) = 'a' and $hour = 12">00</xsl:when>
		<xsl:otherwise><xsl:value-of select="$hour" /></xsl:otherwise>
	</xsl:choose><xsl:value-of select="substring($hour0,14,6)" />
</xsl:template>

<xsl:template name="normaliseDate">
	<xsl:param name="hgDate"/>
	<xsl:variable name="normDate">
		<xsl:call-template name="normaliseDateTime">
			<xsl:with-param name="hgDate" select="$hgDate"/>
		</xsl:call-template>
	</xsl:variable>
	<xsl:value-of select="substring($normDate,1,10)" />
</xsl:template>

</xsl:stylesheet>