/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.shared;

import java.io.IOException;
import java.util.Date;
import java.util.logging.Logger;

public class DebugTimer {
    protected String lastMessage = null;
    protected Date startTime;
    protected Date lastMark;
    protected Date currentTime;
    protected StringBuffer progressMessage = new StringBuffer();
    protected boolean enabled;
    private static final Logger log = Logger.getLogger(DebugTimer.class.getName());

    public DebugTimer(String debugMessage) {
        this(debugMessage, true);
    }

    public DebugTimer(String debugMessage, boolean enabled) {
        this.startTime = new Date();
        this.enabled = enabled;
        this.markTime("Starting timer: " + debugMessage);
    }

    public void markTime(String markMessage) {
        this.currentTime = new Date();
        if (this.lastMessage != null) {
            long markTime = this.currentTime.getTime() - this.lastMark.getTime();
            long totalTime = this.currentTime.getTime() - this.startTime.getTime();
            this.progressMessage.append(markTime + "ms / " + totalTime + "ms: " + this.lastMessage + "\n");
        }
        this.lastMessage = markMessage;
        this.lastMark = this.currentTime;
    }

    public void stop() {
        this.markTime(null);
        if (this.enabled) {
            log.info(this.progressMessage.toString());
            log.info("Finished");
        }
    }

    public static void main(String[] args) throws IOException {
        int counter;
        DebugTimer testTimer = new DebugTimer("Counting to 5,000,000");
        for (counter = 0; counter < 5000000; ++counter) {
        }
        testTimer.markTime("Counting to 100,000");
        for (counter = 0; counter < 100000; ++counter) {
        }
        testTimer.markTime("Counting  to 20,000,000");
        for (counter = 0; counter < 20000000; ++counter) {
        }
        testTimer.stop();
    }
}

